/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager;

import com.android.tools.idea.ui.resourcemanager.ResourceExplorer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/MyFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "resourceExplorer", "Lcom/android/tools/idea/ui/resourcemanager/ResourceExplorer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;Lcom/android/tools/idea/ui/resourcemanager/ResourceExplorer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "getResourceExplorer", "()Lcom/android/tools/idea/ui/resourcemanager/ResourceExplorer;", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "fileOpened", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorFocused", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.android.core"})
final class MyFileEditorListener
implements FileEditorManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    @Nullable
    private final ResourceExplorer resourceExplorer;

    public MyFileEditorListener(@NotNull Project project, @NotNull ToolWindow toolWindow, @Nullable ResourceExplorer resourceExplorer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.project = project;
        this.toolWindow = toolWindow;
        this.resourceExplorer = resourceExplorer;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ToolWindow getToolWindow() {
        return this.toolWindow;
    }

    @Nullable
    public final ResourceExplorer getResourceExplorer() {
        return this.resourceExplorer;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileEditor fileEditor = event.getNewEditor();
        if (fileEditor == null) {
            return;
        }
        FileEditor editor = fileEditor;
        this.editorFocused(editor, this.project, this.resourceExplorer);
    }

    public void fileOpened(@NotNull FileEditorManager source2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditor fileEditor = source2.getSelectedEditor(file);
        if (fileEditor == null) {
            return;
        }
        this.editorFocused(fileEditor, this.project, this.resourceExplorer);
    }

    private final void editorFocused(FileEditor editor, Project project, ResourceExplorer resourceExplorer) {
        block9: {
            VirtualFile virtualFile;
            block8: {
                block7: {
                    virtualFile = editor.getFile();
                    if (virtualFile == null) break block7;
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    Module module = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project);
                    virtualFile = module;
                    if (module != null) break block8;
                }
                return;
            }
            VirtualFile module = virtualFile;
            Content content2 = this.toolWindow.getContentManager().getContent(0);
            if (content2 != null) {
                content2.setDisplayName(module.getName());
            }
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null) break block9;
            ResourceExplorer resourceExplorer2 = resourceExplorer;
            if (!Intrinsics.areEqual((Object)facet, (Object)(resourceExplorer2 != null ? resourceExplorer2.getFacet() : null))) {
                ResourceExplorer resourceExplorer3 = resourceExplorer;
                if (resourceExplorer3 != null) {
                    resourceExplorer3.setFacet(facet);
                }
            }
        }
    }
}

