/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.stats.Distribution;
import com.android.tools.idea.stats.DistributionService;
import com.android.tools.idea.ui.DistributionChartComponent;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseApiLevelDialog
extends DialogWrapper
implements DistributionChartComponent.SelectionChangedListener {
    private static final String LAST_UPDATED_DATE_PREFIX = "Last updated:";
    private JPanel myPanel;
    private DistributionChartComponent myDistributionChart;
    private JPanel myChartPanel;
    private JBLabel myDescriptionLeft;
    private JBScrollPane myScrollPane;
    private JBLabel myDescriptionRight;
    private JBLabel myIntroducedLabel;
    private JBLabel myLearnMoreLinkLabel;
    private JBLabel myLastUpdatedLabel;
    private int mySelectedApiLevel = -1;

    public ChooseApiLevelDialog(@Nullable Project project, int selectedApiLevel) {
        super(project);
        this.mySelectedApiLevel = selectedApiLevel;
        try {
            this.setupUI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Window window2 = this.getWindow();
        if (window2 != null) {
            window2.setMinimumSize((Dimension)JBUI.size((int)400, (int)680));
            window2.setPreferredSize((Dimension)JBUI.size((int)1100, (int)750));
            window2.setMaximumSize((Dimension)JBUI.size((int)1100, (int)800));
        } else assert (ApplicationManager.getApplication().isUnitTestMode());
        this.setTitle("Android Platform/API Version Distribution");
        String lastUpdated = ChooseApiLevelDialog.getLastUpdatedDate();
        if (lastUpdated != null) {
            this.myLastUpdatedLabel.setText(ChooseApiLevelDialog.getLastUpdatedDate());
        }
        this.init();
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)this.myChartPanel, new GridConstraints(0, 0, 2, 1, 8, 3, 4, 3, null, null, null, 0, false));
        this.myScrollPane = new JBScrollPane();
        this.myScrollPane.setBackground(new Color(-1118482));
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myScrollPane.setOpaque(false);
        this.myPanel.add((Component)this.myScrollPane, new GridConstraints(1, 2, 1, 1, 8, 2, 1, 3, new Dimension(500, -1), new Dimension(500, 504), new Dimension(500, -1), 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myScrollPane.setViewportView((Component)panel1);
        this.myDescriptionLeft = new JBLabel();
        this.myDescriptionLeft.setForeground(new Color(-12566464));
        this.myDescriptionLeft.setText("<html>The minimum SDK version determines the lowest level of Android that your app will run on. <br><br> You typically want to target as many users as possible, so you would ideally want to support everyone -- with a minimum SDK version of 1. However, that has some disadvantages, such as lack of features, and very few people use devices that old anymore. <br><br> Your choice of minimum SDK level should be a tradeoff between the distribution of users you wish to target and the features that your application will need. <br><br> <b>Click each Android Version/API level for more information.</b> </html>");
        this.myDescriptionLeft.setVerticalAlignment(1);
        this.myDescriptionLeft.setVerticalTextPosition(1);
        panel1.add((Component)this.myDescriptionLeft, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDescriptionRight = new JBLabel();
        this.myDescriptionRight.setForeground(new Color(-12566464));
        this.myDescriptionRight.setHorizontalAlignment(10);
        this.myDescriptionRight.setText("");
        this.myDescriptionRight.setVerticalAlignment(1);
        this.myDescriptionRight.setVerticalTextPosition(1);
        panel1.add((Component)this.myDescriptionRight, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(1, 1, 1, 1, 0, 0, 2, 1, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1), 0, false));
        this.myIntroducedLabel = new JBLabel();
        Font myIntroducedLabelFont = this.getFont(null, -1, 20, this.myIntroducedLabel.getFont());
        if (myIntroducedLabelFont != null) {
            this.myIntroducedLabel.setFont(myIntroducedLabelFont);
        }
        this.myIntroducedLabel.setHorizontalAlignment(2);
        this.myIntroducedLabel.setText("");
        this.myPanel.add((Component)this.myIntroducedLabel, new GridConstraints(0, 2, 1, 2, 8, 0, 0, 0, null, new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.myLearnMoreLinkLabel = new JBLabel();
        this.myLearnMoreLinkLabel.setHorizontalTextPosition(0);
        this.myPanel.add((Component)this.myLearnMoreLinkLabel, new GridConstraints(2, 2, 1, 2, 0, 3, 0, 0, null, new Dimension(308, 0), null, 0, false));
        this.myLastUpdatedLabel = new JBLabel();
        this.myLastUpdatedLabel.setHorizontalTextPosition(0);
        this.myPanel.add((Component)this.myLastUpdatedLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(308, 0), null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent getRootComponent() {
        return this.myPanel;
    }

    @Nullable
    private static String getLastUpdatedDate() {
        List<Distribution> distributions = DistributionService.getInstance().getDistributions();
        if (distributions == null) {
            return null;
        }
        return distributions.stream().flatMap(distribution -> distribution.getDescriptionBlocks().stream()).map(block -> block.body).filter(ChooseApiLevelDialog::isLastUpdatedBlock).findFirst().orElse(null);
    }

    private static Boolean isLastUpdatedBlock(String body) {
        return body != null && body.startsWith(LAST_UPDATED_DATE_PREFIX);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myDistributionChart.registerDistributionSelectionChangedListener(this);
        this.myDistributionChart.init();
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.setBorder(null);
        this.myDescriptionLeft.setForeground(JBColor.foreground());
        this.myDescriptionLeft.setBackground(JBColor.background());
        this.myDescriptionRight.setForeground(JBColor.foreground());
        this.myDescriptionRight.setBackground(JBColor.background());
        this.myLastUpdatedLabel.setForeground(JBColor.foreground());
        this.myLastUpdatedLabel.setBackground(JBColor.background());
        this.myLearnMoreLinkLabel.setForeground((Color)JBColor.blue);
        this.myLearnMoreLinkLabel.setCursor(Cursor.getPredefinedCursor(12));
        ImmutableMap attributes = ImmutableMap.of((Object)TextAttribute.UNDERLINE, (Object)TextAttribute.UNDERLINE_ON);
        this.myLearnMoreLinkLabel.setFont(this.myLearnMoreLinkLabel.getFont().deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)attributes));
        this.myLearnMoreLinkLabel.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserUtil.browse((URL)new URL(ChooseApiLevelDialog.this.myLearnMoreLinkLabel.getText()));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
        if (this.mySelectedApiLevel >= 0) {
            this.myDistributionChart.selectDistributionApiLevel(this.mySelectedApiLevel);
        }
        return this.myPanel;
    }

    @Override
    public void onDistributionSelected(@NotNull Distribution d) {
        List<Distribution.TextBlock> blocks = d.getDescriptionBlocks();
        blocks.removeIf(block -> ChooseApiLevelDialog.isLastUpdatedBlock(block.body));
        int halfwayIndex = blocks.size() / 2;
        this.myDescriptionLeft.setText(ChooseApiLevelDialog.getHtmlFromBlocks(blocks.subList(0, halfwayIndex + 1)));
        this.myDescriptionRight.setText(ChooseApiLevelDialog.getHtmlFromBlocks(blocks.subList(halfwayIndex + 1, blocks.size())));
        this.mySelectedApiLevel = d.getApiLevel();
        this.myIntroducedLabel.setText(d.getName());
        this.myLearnMoreLinkLabel.setText(d.getUrl());
    }

    private static String getHtmlFromBlocks(List<Distribution.TextBlock> blocks) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (Distribution.TextBlock block : blocks) {
            sb.append("<h3>").append(block.title).append("</h3>");
            sb.append(block.body).append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public int getSelectedApiLevel() {
        return this.mySelectedApiLevel;
    }

    private void createUIComponents() {
        this.myDistributionChart = new DistributionChartComponent();
        this.myChartPanel = this.myDistributionChart;
    }
}

