/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport.poller;

import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.idea.transport.poller.TransportEventPoller;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/transport/poller/TransportEventPoller;", "", "transportClient", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "sortOrder", "Ljava/util/Comparator;", "Lcom/android/tools/profiler/proto/Common$Event;", "Lkotlin/Comparator;", "<init>", "(Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;Ljava/util/Comparator;)V", "writeLock", "Ljava/lang/Object;", "eventListeners", "", "Lcom/android/tools/idea/transport/poller/TransportEventListener;", "listenersToLastTimestamp", "Ljava/util/concurrent/ConcurrentHashMap;", "", "registerListener", "", "listener", "unregisterListener", "poll", "Companion", "intellij.android.transport"})
@SourceDebugExtension(value={"SMAP\nTransportEventPoller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportEventPoller.kt\ncom/android/tools/idea/transport/poller/TransportEventPoller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1374#3:158\n1460#3,5:159\n774#3:164\n865#3,2:165\n1869#3,2:167\n1999#3,14:169\n*S KotlinDebug\n*F\n+ 1 TransportEventPoller.kt\ncom/android/tools/idea/transport/poller/TransportEventPoller\n*L\n86#1:158\n86#1:159,5\n88#1:164\n88#1:165,2\n89#1:167,2\n99#1:169,14\n*E\n"})
public final class TransportEventPoller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub transportClient;
    @NotNull
    private final Comparator<Common.Event> sortOrder;
    @NotNull
    private final Object writeLock;
    @NotNull
    private final List<TransportEventListener> eventListeners;
    @NotNull
    private final ConcurrentHashMap<TransportEventListener, Long> listenersToLastTimestamp;
    @NotNull
    private static final ScheduledExecutorService myExecutorService;
    @NotNull
    private static final Map<TransportEventPoller, ScheduledFuture<?>> myScheduledFutures;

    public TransportEventPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, @NotNull Comparator<Common.Event> sortOrder) {
        Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
        Intrinsics.checkNotNullParameter(sortOrder, (String)"sortOrder");
        this.transportClient = transportClient;
        this.sortOrder = sortOrder;
        this.writeLock = new Object();
        this.eventListeners = new CopyOnWriteArrayList();
        this.listenersToLastTimestamp = new ConcurrentHashMap();
    }

    public /* synthetic */ TransportEventPoller(TransportServiceGrpc.TransportServiceBlockingStub transportServiceBlockingStub, Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> TransportEventPoller._init_$lambda$0(1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing(...)");
            comparator = comparator2;
        }
        this(transportServiceBlockingStub, (Comparator<Common.Event>)comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerListener(@NotNull TransportEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl = false;
            this.eventListeners.add(listener2);
            ((Map)this.listenersToLastTimestamp).put(listener2, Long.MIN_VALUE);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterListener(@NotNull TransportEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl = false;
            this.eventListeners.remove(listener2);
            Long l = this.listenersToLastTimestamp.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void poll() {
        var2_1 = new ArrayList<E>();
        $this$poll_u24lambda_u240 = var2_1;
        $i$a$-apply-TransportEventPoller$poll$listeners$1 = false;
        $this$poll_u24lambda_u240.addAll((Collection)this.eventListeners);
        listeners = var2_1;
        for (TransportEventListener eventListener : listeners) {
            v0 = this.listenersToLastTimestamp.get(eventListener);
            var6_6 = v0 != null ? v0 : -9223372036854775808L;
            v1 = eventListener.getStartTime();
            var8_8 = v1 != null ? ((Number)v1.invoke()).longValue() : -9223372036854775808L;
            startTimestamp = Math.max(var6_6, var8_8);
            endTimestamp = ((Number)eventListener.getEndTime().invoke()).longValue();
            builder = Transport.GetEventGroupsRequest.newBuilder().setKind(eventListener.getEventKind()).setFromTimestamp(startTimestamp).setToTimestamp(endTimestamp);
            v2 = eventListener.getStreamId();
            if (v2 != null) {
                it = ((Number)v2.invoke()).longValue();
                $i$a$-let-TransportEventPoller$poll$1 = false;
                builder.setStreamId(it);
            }
            v3 = eventListener.getProcessId();
            if (v3 != null) {
                it = ((Number)v3.invoke()).intValue();
                $i$a$-let-TransportEventPoller$poll$2 = false;
                builder.setPid(it);
            }
            v4 = eventListener.getGroupId();
            if (v4 != null) {
                it = ((Number)v4.invoke()).longValue();
                $i$a$-let-TransportEventPoller$poll$3 = false;
                builder.setGroupId(it);
            }
            if (Intrinsics.areEqual((Object)(response = this.transportClient.getEventGroups(request = builder.build())), (Object)Transport.GetEventGroupsResponse.getDefaultInstance())) continue;
            v5 = response.getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getGroupsList(...)");
            it = v5;
            $i$f$flatMap = false;
            var14_19 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                group = (Transport.EventGroup)element$iv$iv;
                $i$a$-flatMap-TransportEventPoller$poll$filtered$1 = false;
                v6 = group.getEventsList();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getEventsList(...)");
                list$iv$iv = v6;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), this.sortOrder);
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var17_29 = $this$filterTo$iv$iv.iterator();
            while (var17_29.hasNext()) {
                element$iv$iv = var17_29.next();
                event = (Common.Event)element$iv$iv;
                $i$a$-filter-TransportEventPoller$poll$filtered$2 = false;
                if (event.getTimestamp() < startTimestamp) ** GOTO lbl-1000
                v7 = eventListener.getFilter();
                Intrinsics.checkNotNull((Object)event);
                if (((Boolean)v7.invoke((Object)event)).booleanValue()) {
                    v8 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v8 = false;
                }
                if (!v8) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            filtered = (List)destination$iv$iv;
            $this$forEach$iv = filtered;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                event = (Common.Event)element$iv;
                $i$a$-forEach-TransportEventPoller$poll$4 = false;
                eventListener.getExecutor().execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, poll$lambda$6$0(com.android.tools.idea.transport.poller.TransportEventListener com.android.tools.profiler.proto.Common$Event com.android.tools.idea.transport.poller.TransportEventPoller ), ()V)((TransportEventListener)eventListener, (Common.Event)event, (TransportEventPoller)this));
            }
            $this$maxByOrNull$iv = filtered;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v9 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v9 = maxElem$iv;
                } else {
                    it = (Common.Event)maxElem$iv;
                    $i$a$-maxByOrNull-TransportEventPoller$poll$maxTimeEvent$1 = false;
                    maxValue$iv = it.getTimestamp();
                    do {
                        e$iv = iterator$iv.next();
                        it = (Common.Event)e$iv;
                        $i$a$-maxByOrNull-TransportEventPoller$poll$maxTimeEvent$1 = false;
                        v$iv = it.getTimestamp();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v9 = maxElem$iv;
                }
            }
            maxTimeEvent = v9;
            var14_19 = this.writeLock;
            synchronized (var14_19) {
                $i$a$-synchronized-TransportEventPoller$poll$5 = false;
                if (maxTimeEvent != null && this.listenersToLastTimestamp.containsKey(eventListener)) {
                    ((Map)this.listenersToLastTimestamp).put(eventListener, Math.max(startTimestamp, maxTimeEvent.getTimestamp() + 1L));
                }
                var15_24 = Unit.INSTANCE;
            }
        }
    }

    private static final Long _init_$lambda$0(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }

    private static final void poll$lambda$6$0(TransportEventListener $eventListener, Common.Event $event, TransportEventPoller this$0) {
        Function1<Common.Event, Boolean> function1 = $eventListener.getCallback();
        Intrinsics.checkNotNull((Object)$event);
        if (((Boolean)function1.invoke((Object)$event)).booleanValue()) {
            this$0.unregisterListener($eventListener);
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder, @Nullable ScheduledExecutorService executorServiceForTest) {
        return Companion.createStartedPoller(transportClient, pollPeriodNs, sortOrder, executorServiceForTest);
    }

    @JvmStatic
    public static final void startPoller(@NotNull TransportEventPoller poller, long pollPeriodNs, @Nullable ScheduledExecutorService executorServiceForTest) {
        Companion.startPoller(poller, pollPeriodNs, executorServiceForTest);
    }

    @JvmStatic
    public static final void stopPoller(@NotNull TransportEventPoller poller) {
        Companion.stopPoller(poller);
    }

    @JvmStatic
    public static final boolean isPollerRunning(@NotNull TransportEventPoller poller) {
        return Companion.isPollerRunning(poller);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder) {
        return Companion.createStartedPoller(transportClient, pollPeriodNs, sortOrder);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs) {
        return Companion.createStartedPoller(transportClient, pollPeriodNs);
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        myExecutorService = scheduledExecutorService;
        myScheduledFutures = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0007J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/transport/poller/TransportEventPoller$Companion;", "", "<init>", "()V", "myExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "myScheduledFutures", "", "Lcom/android/tools/idea/transport/poller/TransportEventPoller;", "Ljava/util/concurrent/ScheduledFuture;", "createStartedPoller", "transportClient", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "pollPeriodNs", "", "sortOrder", "Ljava/util/Comparator;", "Lcom/android/tools/profiler/proto/Common$Event;", "executorServiceForTest", "startPoller", "", "poller", "stopPoller", "isPollerRunning", "", "intellij.android.transport"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder, @Nullable ScheduledExecutorService executorServiceForTest) {
            Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
            Intrinsics.checkNotNullParameter(sortOrder, (String)"sortOrder");
            TransportEventPoller poller = new TransportEventPoller(transportClient, sortOrder);
            this.startPoller(poller, pollPeriodNs, executorServiceForTest);
            return poller;
        }

        public static /* synthetic */ TransportEventPoller createStartedPoller$default(Companion companion, TransportServiceGrpc.TransportServiceBlockingStub transportServiceBlockingStub, long l, Comparator comparator, ScheduledExecutorService scheduledExecutorService, int n, Object object) {
            if ((n & 4) != 0) {
                Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> Companion.createStartedPoller$lambda$0(createStartedPoller.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing(...)");
                comparator = comparator2;
            }
            if ((n & 8) != 0) {
                scheduledExecutorService = null;
            }
            return companion.createStartedPoller(transportServiceBlockingStub, l, comparator, scheduledExecutorService);
        }

        @JvmStatic
        public final void startPoller(@NotNull TransportEventPoller poller, long pollPeriodNs, @Nullable ScheduledExecutorService executorServiceForTest) {
            Intrinsics.checkNotNullParameter((Object)poller, (String)"poller");
            ScheduledExecutorService scheduledExecutorService = executorServiceForTest;
            if (scheduledExecutorService == null) {
                scheduledExecutorService = myExecutorService;
            }
            ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(() -> Companion.startPoller$lambda$0(poller), 0L, pollPeriodNs, TimeUnit.NANOSECONDS);
            myScheduledFutures.put(poller, scheduledFuture);
        }

        public static /* synthetic */ void startPoller$default(Companion companion, TransportEventPoller transportEventPoller, long l, ScheduledExecutorService scheduledExecutorService, int n, Object object) {
            if ((n & 4) != 0) {
                scheduledExecutorService = null;
            }
            companion.startPoller(transportEventPoller, l, scheduledExecutorService);
        }

        @JvmStatic
        public final void stopPoller(@NotNull TransportEventPoller poller) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)poller, (String)"poller");
                ScheduledFuture scheduledFuture = (ScheduledFuture)myScheduledFutures.remove(poller);
                if (scheduledFuture == null) break block0;
                scheduledFuture.cancel(false);
            }
        }

        @JvmStatic
        public final boolean isPollerRunning(@NotNull TransportEventPoller poller) {
            Intrinsics.checkNotNullParameter((Object)poller, (String)"poller");
            return myScheduledFutures.containsKey(poller);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder) {
            Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
            Intrinsics.checkNotNullParameter(sortOrder, (String)"sortOrder");
            return com.android.tools.idea.transport.poller.TransportEventPoller$Companion.createStartedPoller$default(this, transportClient, pollPeriodNs, sortOrder, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs) {
            Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
            return com.android.tools.idea.transport.poller.TransportEventPoller$Companion.createStartedPoller$default(this, transportClient, pollPeriodNs, null, null, 12, null);
        }

        private static final Long createStartedPoller$lambda$0(Function1 $tmp0, Object p0) {
            return (Long)$tmp0.invoke(p0);
        }

        private static final void startPoller$lambda$0(TransportEventPoller $poller) {
            try {
                $poller.poll();
            }
            catch (Throwable t) {
                Logger.getInstance(TransportEventPoller.class).warn(t.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

