/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.testsuite.temp;

import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteView;
import com.android.tools.idea.testartifacts.testsuite.temp.AndroidTestSuiteViewAdaptor;
import com.android.tools.idea.testartifacts.testsuite.temp.TestSuiteViewAdaptor;
import com.android.tools.idea.testartifacts.testsuite.temp.TestSuiteViewAdaptorProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXPPXmlView;

public final class GradleAndroidTestsExecutionConsoleOutputProcessor {
    private static final Logger LOG = Logger.getInstance(GradleAndroidTestsExecutionConsoleOutputProcessor.class);
    private static final String LOG_EOL = "<ijLogEol/>";
    private static final String LOG_START = "<ijLog>";
    private static final String LOG_END = "</ijLog>";
    private static final Key<StringBuilder> STRING_BUFFER_KEY = new Key("com.android.tools.idea.testartifacts.testsuite.jetbrains.STRING_BUFFER_KEY");
    @VisibleForTesting
    public static final Key<TestSuiteViewAdaptor> ADAPTOR_KEY = new Key("com.android.tools.idea.testartifacts.testsuite.jetbrains.ADAPTOR_KEY");

    public static void onOutput(@NotNull AndroidTestSuiteView executionConsole, @NotNull String text2, @NotNull Key<?> processOutputType) {
        String eventMessage = GradleAndroidTestsExecutionConsoleOutputProcessor.getEventMessage(executionConsole, text2, processOutputType);
        if (eventMessage == null) {
            return;
        }
        try {
            TestSuiteViewAdaptor adaptor = (TestSuiteViewAdaptor)executionConsole.putUserDataIfAbsent(ADAPTOR_KEY, GradleAndroidTestsExecutionConsoleOutputProcessor.getAdaptor(executionConsole));
            TestEventXPPXmlView xml = new TestEventXPPXmlView(eventMessage);
            adaptor.processEvent(xml, executionConsole);
        }
        catch (NumberFormatException e) {
            LOG.error("Gradle test events parser error", (Throwable)e);
        }
    }

    private static TestSuiteViewAdaptor getAdaptor(@NotNull AndroidTestSuiteView executionConsole) {
        TestSuiteViewAdaptor existing = (TestSuiteViewAdaptor)executionConsole.getUserData(ADAPTOR_KEY);
        if (existing != null) {
            return existing;
        }
        RunConfiguration runConfiguration = executionConsole.getRunConfiguration();
        TestSuiteViewAdaptor adaptor = TestSuiteViewAdaptorProvider.firstNonNullAdaptor(runConfiguration);
        if (adaptor != null) {
            return adaptor;
        }
        return new AndroidTestSuiteViewAdaptor(runConfiguration);
    }

    private static StringBuilder getBuffer(@NotNull AndroidTestSuiteView executionConsole) {
        StringBuilder buffer = (StringBuilder)executionConsole.getUserData(STRING_BUFFER_KEY);
        if (buffer != null) {
            return buffer;
        }
        return (StringBuilder)executionConsole.putUserDataIfAbsent(STRING_BUFFER_KEY, new StringBuilder());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static String getEventMessage(@NotNull AndroidTestSuiteView executionConsole, @NotNull String text2, @NotNull Key<?> processOutputType) {
        StringBuilder consoleBuffer;
        String eventMessage;
        block8: {
            eventMessage = null;
            consoleBuffer = GradleAndroidTestsExecutionConsoleOutputProcessor.getBuffer(executionConsole);
            String trimmedText = text2.trim();
            if (StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)LOG_EOL)) {
                consoleBuffer.append(StringUtil.trimEnd((String)trimmedText, (String)LOG_EOL));
                return null;
            }
            if (consoleBuffer.isEmpty()) {
                if (StringUtil.startsWith((CharSequence)trimmedText, (CharSequence)LOG_START) && StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)LOG_END)) {
                    eventMessage = text2;
                    break block8;
                } else {
                    executionConsole.print(text2, ConsoleViewContentType.getConsoleViewType(processOutputType));
                    return null;
                }
            }
            consoleBuffer.append(text2);
            if (trimmedText.isEmpty()) {
                return null;
            }
        }
        if (eventMessage == null) {
            String bufferText = consoleBuffer.toString().trim();
            consoleBuffer.setLength(0);
            if (!StringUtil.startsWith((CharSequence)bufferText, (CharSequence)LOG_START) || !StringUtil.endsWith((CharSequence)bufferText, (CharSequence)LOG_END)) {
                executionConsole.print(bufferText, ConsoleViewContentType.getConsoleViewType(processOutputType));
                return null;
            }
            eventMessage = bufferText;
        }
        assert (consoleBuffer.isEmpty());
        return eventMessage;
    }
}

