/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.testsuite.runconfiguration;

import com.android.tools.idea.gradle.model.IdeTestSuite;
import com.android.tools.idea.gradle.model.IdeTestSuiteSource;
import com.android.tools.idea.gradle.model.IdeTestSuiteTarget;
import com.android.tools.idea.gradle.model.IdeTestSuiteVariantTarget;
import com.android.tools.idea.gradle.model.IdeVariantCore;
import com.android.tools.idea.gradle.model.impl.FileImpl;
import com.android.tools.idea.gradle.model.impl.IdeCustomSourceDirectoryImpl;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.android.tools.idea.testartifacts.testsuite.runconfiguration.TestSuiteRunConfiguration;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\u0004\u0018\u00010\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u0010\u001f\u001a\u00020\u0010H\u0002\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/testartifacts/testsuite/runconfiguration/TestSuiteUtils;", "", "<init>", "()V", "getTestSuiteContainingFile", "Lcom/android/tools/idea/gradle/model/IdeTestSuite;", "testSuites", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTestSuiteAtRoot", "getTestSuiteTargets", "Lcom/android/tools/idea/testartifacts/testsuite/runconfiguration/TestSuiteUtils$TestSuiteTarget;", "selectedVariant", "Lcom/android/tools/idea/gradle/model/IdeVariantCore;", "testSuiteName", "", "isFileInTestSuite", "", "file", "Ljava/io/File;", "testSuite", "getTestSuiteRoot", "testSuiteModule", "Lcom/intellij/openapi/module/Module;", "getTestSuiteNameFromModule", "getTestSuiteModule", "runConfiguration", "Lcom/android/tools/idea/testartifacts/testsuite/runconfiguration/TestSuiteRunConfiguration;", "getTestSuiteNameWithTestTaskName", "variants", "testTaskName", "TestSuiteTarget", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nTestSuiteUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestSuiteUtils.kt\ncom/android/tools/idea/testartifacts/testsuite/runconfiguration/TestSuiteUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n295#2,2:201\n295#2,2:203\n774#2:206\n865#2,2:207\n1563#2:209\n1634#2,3:210\n1#3:205\n*S KotlinDebug\n*F\n+ 1 TestSuiteUtils.kt\ncom/android/tools/idea/testartifacts/testsuite/runconfiguration/TestSuiteUtils\n*L\n53#1:201,2\n67#1:203,2\n90#1:206\n90#1:207,2\n91#1:209\n91#1:210,3\n*E\n"})
public final class TestSuiteUtils {
    @NotNull
    public static final TestSuiteUtils INSTANCE = new TestSuiteUtils();

    private TestSuiteUtils() {
    }

    @Nullable
    public final IdeTestSuite getTestSuiteContainingFile(@NotNull List<? extends IdeTestSuite> testSuites, @NotNull VirtualFile virtualFile) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter(testSuites, (String)"testSuites");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            if (!Intrinsics.areEqual((Object)virtualFile.getFileSystem(), (Object)LocalFileSystem.getInstance())) {
                return null;
            }
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
            File file2 = file;
            Iterable $this$firstOrNull$iv = testSuites;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdeTestSuite it = (IdeTestSuite)element$iv;
                boolean bl = false;
                if (!INSTANCE.isFileInTestSuite(file2, it)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final IdeTestSuite getTestSuiteAtRoot(@NotNull List<? extends IdeTestSuite> testSuites, @NotNull VirtualFile virtualFile) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter(testSuites, (String)"testSuites");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            if (!Intrinsics.areEqual((Object)virtualFile.getFileSystem(), (Object)LocalFileSystem.getInstance())) {
                return null;
            }
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
            File file2 = file;
            Iterable $this$firstOrNull$iv = testSuites;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdeTestSuite it = (IdeTestSuite)element$iv;
                boolean bl = false;
                if (!FileUtil.filesEqual((File)INSTANCE.getTestSuiteRoot(it), (File)file2)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestSuiteTarget> getTestSuiteTargets(@NotNull IdeVariantCore selectedVariant, @NotNull String testSuiteName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IdeTestSuiteTarget it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object v0;
        Iterable iterable;
        block4: {
            Intrinsics.checkNotNullParameter((Object)selectedVariant, (String)"selectedVariant");
            Intrinsics.checkNotNullParameter((Object)testSuiteName, (String)"testSuiteName");
            iterable = selectedVariant.getTestSuiteArtifacts();
            for (Object t : iterable) {
                IdeTestSuiteVariantTarget it2 = (IdeTestSuiteVariantTarget)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getSuiteName(), (Object)testSuiteName)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        IdeTestSuiteVariantTarget ideTestSuiteVariantTarget = v0;
        if (ideTestSuiteVariantTarget == null) {
            return CollectionsKt.emptyList();
        }
        IdeTestSuiteVariantTarget testSuiteVariantTarget = ideTestSuiteVariantTarget;
        Iterable iterable2 = testSuiteVariantTarget.getTargets();
        boolean $i$f$filter = false;
        iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeTestSuiteTarget)element$iv$iv;
            boolean bl = false;
            if (!it.getTargetedDevices().isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeTestSuiteTarget)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new TestSuiteTarget(it.getTargetName(), it.getTestTaskName()));
        }
        return (List)destination$iv$iv;
    }

    private final boolean isFileInTestSuite(File file, IdeTestSuite testSuite) {
        List sources = testSuite.getSources();
        block4: for (IdeTestSuiteSource source2 : sources) {
            switch (WhenMappings.$EnumSwitchMapping$0[source2.getType().ordinal()]) {
                case 1: {
                    for (IdeCustomSourceDirectoryImpl customSourceDirectory : source2.getSourceProvider().getCustomSourceDirectories()) {
                        if (!FileUtil.isAncestor((File)((File)customSourceDirectory.getDirectory()), (File)file, (boolean)true)) continue;
                        return true;
                    }
                    continue block4;
                }
                case 2: {
                    for (FileImpl javaSourceDirectory : source2.getSourceProvider().getJavaDirectories()) {
                        if (!FileUtil.isAncestor((File)((File)javaSourceDirectory), (File)file, (boolean)true)) continue;
                        return true;
                    }
                    for (FileImpl kotlinSourceDirectory : source2.getSourceProvider().getKotlinDirectories()) {
                        if (!FileUtil.isAncestor((File)((File)kotlinSourceDirectory), (File)file, (boolean)true)) continue;
                        return true;
                    }
                    continue block4;
                }
            }
            Logger.getInstance(GradleAndroidModel.class).warn("Unsupported source type: " + source2.getType());
        }
        return false;
    }

    @Nullable
    public final File getTestSuiteRoot(@NotNull IdeTestSuite testSuite) {
        Intrinsics.checkNotNullParameter((Object)testSuite, (String)"testSuite");
        for (IdeTestSuiteSource source2 : testSuite.getSources()) {
            Object v2;
            Object it;
            IdeCustomSourceDirectoryImpl ideCustomSourceDirectoryImpl;
            block8: {
                Object v1;
                IdeCustomSourceDirectoryImpl it2;
                Object t2;
                block7: {
                    Object v0;
                    block6: {
                        Iterable iterable = source2.getSourceProvider().getCustomSourceDirectories();
                        for (Object t2 : iterable) {
                            it2 = (IdeCustomSourceDirectoryImpl)t2;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it2.getSourceTypeName(), (Object)"assets (test suite)") && it2.getDirectory().isDirectory() && Intrinsics.areEqual((Object)it2.getDirectory().getName(), (Object)testSuite.getName()))) continue;
                            v0 = t2;
                            break block6;
                        }
                        v0 = null;
                    }
                    ideCustomSourceDirectoryImpl = v0;
                    if (ideCustomSourceDirectoryImpl != null) {
                        it = ideCustomSourceDirectoryImpl;
                        boolean bl = false;
                        return (File)it.getDirectory();
                    }
                    it = source2.getSourceProvider().getJavaDirectories();
                    Iterator bl = it.iterator();
                    while (bl.hasNext()) {
                        t2 = bl.next();
                        it2 = (FileImpl)t2;
                        boolean bl2 = false;
                        if (!(it2.getParentFile().isDirectory() && Intrinsics.areEqual((Object)it2.getParentFile().getName(), (Object)testSuite.getName()))) continue;
                        v1 = t2;
                        break block7;
                    }
                    v1 = null;
                }
                ideCustomSourceDirectoryImpl = v1;
                if (ideCustomSourceDirectoryImpl != null) {
                    it = ideCustomSourceDirectoryImpl;
                    boolean bl = false;
                    return it.getParentFile();
                }
                it = source2.getSourceProvider().getKotlinDirectories();
                Iterator bl = it.iterator();
                while (bl.hasNext()) {
                    t2 = bl.next();
                    it2 = (FileImpl)t2;
                    boolean bl3 = false;
                    if (!(it2.getParentFile().isDirectory() && Intrinsics.areEqual((Object)it2.getParentFile().getName(), (Object)testSuite.getName()))) continue;
                    v2 = t2;
                    break block8;
                }
                v2 = null;
            }
            if ((ideCustomSourceDirectoryImpl = (FileImpl)v2) == null) continue;
            it = ideCustomSourceDirectoryImpl;
            boolean bl = false;
            return it.getParentFile();
        }
        return null;
    }

    @Nullable
    public final File getTestSuiteRoot(@NotNull Module testSuiteModule) {
        Object object;
        block7: {
            block6: {
                Object v1;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)testSuiteModule, (String)"testSuiteModule");
                    if (!LinkedAndroidModuleGroupUtilsKt.isTestSuiteModule(testSuiteModule)) {
                        return null;
                    }
                    String testSuiteName = this.getTestSuiteNameFromModule(testSuiteModule);
                    object = GradleAndroidModel.Companion.get(testSuiteModule);
                    if (object == null || (object = object.getTestSuites()) == null) break block6;
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        IdeTestSuite it = (IdeTestSuite)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)testSuiteName)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object = (IdeTestSuite)v1) != null) break block7;
            }
            return null;
        }
        Object testSuite = object;
        return this.getTestSuiteRoot((IdeTestSuite)testSuite);
    }

    @NotNull
    public final String getTestSuiteNameFromModule(@NotNull Module testSuiteModule) {
        Intrinsics.checkNotNullParameter((Object)testSuiteModule, (String)"testSuiteModule");
        Module appModule = LinkedAndroidModuleGroupUtilsKt.getHolderModule(testSuiteModule);
        String string = testSuiteModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.substringAfterLast$default((String)string, (String)(appModule.getName() + "."), null, (int)2, null);
    }

    @Nullable
    public final Module getTestSuiteModule(@NotNull TestSuiteRunConfiguration runConfiguration) {
        Object v3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
            Module module = (Module)ActionsKt.runReadAction(() -> TestSuiteUtils.getTestSuiteModule$lambda$0(runConfiguration));
            if (module == null) {
                return null;
            }
            Module appModule = module;
            String string = (String)CollectionsKt.firstOrNull(runConfiguration.getTaskNames());
            if (string == null) {
                return null;
            }
            String testTaskName = string;
            GradleAndroidModel gradleAndroidModel = GradleAndroidModel.Companion.get(appModule);
            if (gradleAndroidModel == null) {
                return null;
            }
            GradleAndroidModel androidModel = gradleAndroidModel;
            String testSuiteName = this.getTestSuiteNameWithTestTaskName(androidModel.getVariants(), testTaskName);
            Iterable iterable = LinkedAndroidModuleGroupUtilsKt.getTestSuiteModules(appModule);
            for (Object t : iterable) {
                Module it = (Module)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)(appModule.getName() + "." + testSuiteName))) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    private final String getTestSuiteNameWithTestTaskName(List<? extends IdeVariantCore> variants, String testTaskName) {
        for (IdeVariantCore ideVariantCore : variants) {
            for (IdeTestSuiteVariantTarget testSuiteArtifact : ideVariantCore.getTestSuiteArtifacts()) {
                for (IdeTestSuiteTarget target2 : testSuiteArtifact.getTargets()) {
                    if (!Intrinsics.areEqual((Object)target2.getTestTaskName(), (Object)testTaskName)) continue;
                    return testSuiteArtifact.getSuiteName();
                }
            }
        }
        return null;
    }

    private static final Module getTestSuiteModule$lambda$0(TestSuiteRunConfiguration $runConfiguration) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File($runConfiguration.getSettings().getExternalProjectPath()), (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return ProjectFileIndex.getInstance((Project)$runConfiguration.getProject()).getModuleForFile(file, false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/testartifacts/testsuite/runconfiguration/TestSuiteUtils$TestSuiteTarget;", "", "targetName", "", "testTaskName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getTargetName", "()Ljava/lang/String;", "getTestTaskName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.projectSystem.gradle"})
    public static final class TestSuiteTarget {
        @NotNull
        private final String targetName;
        @NotNull
        private final String testTaskName;

        public TestSuiteTarget(@NotNull String targetName, @NotNull String testTaskName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            Intrinsics.checkNotNullParameter((Object)testTaskName, (String)"testTaskName");
            this.targetName = targetName;
            this.testTaskName = testTaskName;
        }

        @NotNull
        public final String getTargetName() {
            return this.targetName;
        }

        @NotNull
        public final String getTestTaskName() {
            return this.testTaskName;
        }

        @NotNull
        public final String component1() {
            return this.targetName;
        }

        @NotNull
        public final String component2() {
            return this.testTaskName;
        }

        @NotNull
        public final TestSuiteTarget copy(@NotNull String targetName, @NotNull String testTaskName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            Intrinsics.checkNotNullParameter((Object)testTaskName, (String)"testTaskName");
            return new TestSuiteTarget(targetName, testTaskName);
        }

        public static /* synthetic */ TestSuiteTarget copy$default(TestSuiteTarget testSuiteTarget, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = testSuiteTarget.targetName;
            }
            if ((n & 2) != 0) {
                string2 = testSuiteTarget.testTaskName;
            }
            return testSuiteTarget.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "TestSuiteTarget(targetName=" + this.targetName + ", testTaskName=" + this.testTaskName + ")";
        }

        public int hashCode() {
            int result2 = this.targetName.hashCode();
            result2 = result2 * 31 + this.testTaskName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestSuiteTarget)) {
                return false;
            }
            TestSuiteTarget testSuiteTarget = (TestSuiteTarget)other;
            if (!Intrinsics.areEqual((Object)this.targetName, (Object)testSuiteTarget.targetName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.testTaskName, (Object)testSuiteTarget.testTaskName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdeTestSuiteSource.SourceType.values().length];
            try {
                nArray[IdeTestSuiteSource.SourceType.ASSETS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeTestSuiteSource.SourceType.HOST_JAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

