/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view.state;

import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.state.AndroidTestResultsTableState;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.state.AndroidTestResultsUserPreferences;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/state/AndroidTestResultsUserPreferencesManager;", "", "runConfiguration", "Lcom/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration;", "deviceIds", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration;Ljava/util/HashSet;)V", "getUserPreferredColumnWidth", "", "columnName", "defaultWidth", "setUserPreferredColumnWidth", "", "width", "intellij.android.core"})
public final class AndroidTestResultsUserPreferencesManager {
    @NotNull
    private final AndroidTestRunConfiguration runConfiguration;
    @NotNull
    private final HashSet<String> deviceIds;

    public AndroidTestResultsUserPreferencesManager(@NotNull AndroidTestRunConfiguration runConfiguration, @NotNull HashSet<String> deviceIds) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(deviceIds, (String)"deviceIds");
        this.runConfiguration = runConfiguration;
        this.deviceIds = deviceIds;
    }

    public final int getUserPreferredColumnWidth(@NotNull String columnName, int defaultWidth) {
        int n;
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        Project project = this.runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HashMap<Integer, AndroidTestResultsTableState> androidTestResultsTableState = AndroidTestResultsUserPreferences.Companion.getInstance((Project)project).androidTestResultsTableState;
        Object[] objectArray = new Object[]{this.runConfiguration.TESTING_TYPE, this.runConfiguration.PACKAGE_NAME, this.runConfiguration.CLASS_NAME, this.runConfiguration.METHOD_NAME, this.deviceIds};
        int key = Objects.hash(objectArray);
        if (androidTestResultsTableState.containsKey(key)) {
            AndroidTestResultsTableState androidTestResultsTableState2 = androidTestResultsTableState.get(key);
            Intrinsics.checkNotNull((Object)androidTestResultsTableState2);
            HashMap<String, Integer> columnPreferences = androidTestResultsTableState2.getPreferredColumnWidths();
            if (columnPreferences.containsKey(columnName)) {
                Integer n2 = columnPreferences.get(columnName);
                Intrinsics.checkNotNull((Object)n2);
                n = ((Number)n2).intValue();
            } else {
                ((Map)columnPreferences).put(columnName, defaultWidth);
                n = defaultWidth;
            }
        } else {
            HashMap<String, Integer> preferredWidths = new HashMap<String, Integer>();
            ((Map)preferredWidths).put(columnName, defaultWidth);
            ((Map)androidTestResultsTableState).put(key, new AndroidTestResultsTableState(preferredWidths));
            n = defaultWidth;
        }
        return n;
    }

    public final void setUserPreferredColumnWidth(@NotNull String columnName, int width) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        Project project = this.runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HashMap<Integer, AndroidTestResultsTableState> androidTestResultsTableState = AndroidTestResultsUserPreferences.Companion.getInstance((Project)project).androidTestResultsTableState;
        Object[] objectArray = new Object[]{this.runConfiguration.TESTING_TYPE, this.runConfiguration.PACKAGE_NAME, this.runConfiguration.CLASS_NAME, this.runConfiguration.METHOD_NAME, this.deviceIds};
        int key = Objects.hash(objectArray);
        if (androidTestResultsTableState.containsKey(key)) {
            AndroidTestResultsTableState androidTestResultsTableState2 = androidTestResultsTableState.get(key);
            Intrinsics.checkNotNull((Object)androidTestResultsTableState2);
            preferredWidths = androidTestResultsTableState2.getPreferredColumnWidths();
            ((Map)preferredWidths).put(columnName, width);
        } else {
            preferredWidths = new HashMap();
            ((Map)preferredWidths).put(columnName, width);
            ((Map)androidTestResultsTableState).put(key, new AndroidTestResultsTableState(preferredWidths));
        }
    }
}

