/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDeviceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0003\u00a8\u0006\b"}, d2={"convertIDeviceToAndroidDevice", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "device", "Lcom/android/ddmlib/IDevice;", "executeShellCommandAndProcessOutput", "", "", "command", "intellij.android.testartifacts"})
@SourceDebugExtension(value={"SMAP\nDdmlibUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DdmlibUtils.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/DdmlibUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1563#2:102\n1634#2,3:103\n1617#2,9:106\n1869#2:115\n1870#2:117\n1626#2:118\n1#3:116\n1#3:119\n*S KotlinDebug\n*F\n+ 1 DdmlibUtils.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/DdmlibUtilsKt\n*L\n45#1:102\n45#1:103,3\n64#1:106,9\n64#1:115\n64#1:117\n64#1:118\n64#1:116\n*E\n"})
public final class DdmlibUtilsKt {
    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public static final AndroidDevice convertIDeviceToAndroidDevice(@NotNull IDevice device2) {
        AndroidDevice androidDevice;
        block13: {
            String it;
            void $this$mapNotNullTo$iv$iv;
            Object ramSize;
            List list2;
            Object object;
            void $this$mapTo$iv$iv;
            String string;
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String string2 = device2.getSerialNumber();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSerialNumber(...)");
            String string3 = device2.getAvdName();
            if (string3 == null) {
                string3 = "";
            }
            if ((string = device2.getAvdName()) == null) {
                string = "";
            }
            AndroidDeviceType androidDeviceType = device2.isEmulator() ? AndroidDeviceType.LOCAL_EMULATOR : AndroidDeviceType.LOCAL_PHYSICAL_DEVICE;
            AndroidVersion androidVersion = device2.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"getVersion(...)");
            Map<String, String> map2 = Collections.synchronizedMap(new LinkedHashMap());
            Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(...)");
            AndroidDevice $this$convertIDeviceToAndroidDevice_u24lambda_u240 = androidDevice = new AndroidDevice(string2, string3, string, androidDeviceType, androidVersion, map2);
            boolean bl = false;
            $this$convertIDeviceToAndroidDevice_u24lambda_u240.getAdditionalInfo().put("SerialNumber", device2.getSerialNumber());
            List<String> output = DdmlibUtilsKt.executeShellCommandAndProcessOutput(device2, "cat /proc/meminfo");
            boolean bl2 = false;
            Iterable $this$map$iv = output;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string4;
                void it2;
                object = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                Object[] objectArray = new char[]{':'};
                Collection collection3 = StringsKt.split((CharSequence)((CharSequence)it2), (char[])objectArray, (boolean)true, (int)2);
                objectArray = new String[2];
                objectArray[0] = (char)"";
                objectArray[1] = (char)"";
                List list3 = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                String key = (String)list3.get(0);
                String value2 = (String)list3.get(1);
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)key)).toString(), (Object)"MemTotal")) {
                    char[] cArray = new char[]{' '};
                    list2 = StringsKt.split((CharSequence)((Object)StringsKt.trim((CharSequence)value2)).toString(), (char[])cArray, (boolean)true, (int)2);
                    ramSize = (String)list2.get(0);
                    String unit = (String)list2.get(1);
                    Float f = StringsKt.toFloatOrNull((String)ramSize);
                    if (f == null) {
                        string4 = null;
                    } else {
                        float ramSizeFloat = f.floatValue();
                        if (Intrinsics.areEqual((Object)unit, (Object)"kB")) {
                            Locale locale = Locale.ROOT;
                            String string5 = "%.1f GB";
                            Object[] objectArray2 = new Object[]{Float.valueOf(ramSizeFloat / (float)1000 / (float)1000)};
                            String string6 = String.format(locale, string5, Arrays.copyOf(objectArray2, objectArray2.length));
                            string4 = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                        } else {
                            string4 = null;
                        }
                    }
                } else {
                    string4 = null;
                }
                collection2.add(string4);
            }
            String string7 = (String)CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
            if (string7 != null) {
                String it3 = string7;
                boolean bl4 = false;
                $this$convertIDeviceToAndroidDevice_u24lambda_u240.getAdditionalInfo().put("RAM", it3);
            }
            output = DdmlibUtilsKt.executeShellCommandAndProcessOutput(device2, "cat /proc/cpuinfo");
            boolean bl5 = false;
            Iterable $this$mapNotNull$iv = output;
            boolean $i$f$mapNotNull = false;
            Iterable bl4 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl6 = false;
                String it4 = (String)element$iv$iv;
                boolean bl7 = false;
                ramSize = new char[]{':'};
                Collection collection4 = StringsKt.split((CharSequence)it4, (char[])ramSize, (boolean)true, (int)2);
                ramSize = new String[2];
                ramSize[0] = (char)"";
                ramSize[1] = (char)"";
                list2 = CollectionsKt.plus((Collection)collection4, (Iterable)CollectionsKt.listOf((Object[])ramSize));
                String key = (String)list2.get(0);
                String value3 = (String)list2.get(1);
                if ((Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)key)).toString(), (Object)"model name") ? ((Object)StringsKt.trim((CharSequence)value3)).toString() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set cpus = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (!((Collection)cpus).isEmpty()) {
                $this$convertIDeviceToAndroidDevice_u24lambda_u240.getAdditionalInfo().put("Processor", CollectionsKt.joinToString$default((Iterable)cpus, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            List<String> it5 = DdmlibUtilsKt.executeShellCommandAndProcessOutput(device2, "getprop ro.product.manufacturer");
            boolean bl9 = false;
            String string8 = (String)CollectionsKt.getOrNull(it5, (int)0);
            if (string8 != null) {
                it = string8;
                boolean bl10 = false;
                $this$convertIDeviceToAndroidDevice_u24lambda_u240.getAdditionalInfo().put("Manufacturer", it);
            }
            it5 = DdmlibUtilsKt.executeShellCommandAndProcessOutput(device2, "getprop ro.product.model");
            boolean bl11 = false;
            String string9 = (String)CollectionsKt.getOrNull(it5, (int)0);
            if (string9 == null) break block13;
            it = string9;
            boolean bl12 = false;
            $this$convertIDeviceToAndroidDevice_u24lambda_u240.getAdditionalInfo().put("Model", it);
        }
        return androidDevice;
    }

    @WorkerThread
    private static final List<String> executeShellCommandAndProcessOutput(IDevice device2, String command) {
        var receiver2 = new MultiLineReceiver(){
            private final List<String> output;
            {
                this.output = new ArrayList<E>();
            }

            public final List<String> getOutput() {
                return this.output;
            }

            public boolean isCancelled() {
                return false;
            }

            public void processNewLines(String[] lines) {
                Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
                CollectionsKt.addAll((Collection)this.output, (Object[])lines);
            }
        };
        device2.executeShellCommand(command, (IShellOutputReceiver)receiver2, 10L, TimeUnit.SECONDS);
        return receiver2.getOutput();
    }
}

