/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.ArtifactFileResolver;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDeviceType;
import com.android.tools.utp.plugins.host.device.info.proto.AndroidTestDeviceInfoProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/AndroidDeviceResolver;", "", "artifactFileResolver", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;)V", "deviceMap", "", "Ljava/io/File;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "getAndroidDevice", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "createAndroidDevice", "deviceInfo", "Lcom/android/tools/utp/plugins/host/device/info/proto/AndroidTestDeviceInfoProto$AndroidTestDeviceInfo;", "displayName", "", "Companion", "intellij.android.testartifacts"})
final class AndroidDeviceResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArtifactFileResolver artifactFileResolver;
    @NotNull
    private final Map<File, AndroidDevice> deviceMap;
    @NotNull
    private static final String DEFAULT_DEVICE_NAME = "Unknown device";
    @NotNull
    private static final AndroidDeviceType DEFAULT_DEVICE_TYPE = AndroidDeviceType.LOCAL_PHYSICAL_DEVICE;
    @NotNull
    private static final AndroidDevice DEFAULT_ANDROID_DEVICE;

    public AndroidDeviceResolver(@NotNull ArtifactFileResolver artifactFileResolver) {
        Intrinsics.checkNotNullParameter((Object)artifactFileResolver, (String)"artifactFileResolver");
        this.artifactFileResolver = artifactFileResolver;
        this.deviceMap = new LinkedHashMap();
    }

    @NotNull
    public final AndroidDevice getAndroidDevice(@NotNull TestResultProto.TestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        File file = ArtifactFileResolver.getArtifactFile$default(this.artifactFileResolver, testResult, "device-info", null, 4, null);
        if (file == null) {
            return DEFAULT_ANDROID_DEVICE;
        }
        File resolvedFile = file;
        AndroidDevice androidDevice = this.deviceMap.computeIfAbsent(resolvedFile, arg_0 -> AndroidDeviceResolver.getAndroidDevice$lambda$1(arg_0 -> AndroidDeviceResolver.getAndroidDevice$lambda$0(resolvedFile, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)androidDevice, (String)"computeIfAbsent(...)");
        return androidDevice;
    }

    private final AndroidDevice createAndroidDevice(AndroidTestDeviceInfoProto.AndroidTestDeviceInfo deviceInfo2) {
        String string;
        String string2;
        Map<String, String> map2;
        AndroidDeviceType androidDeviceType;
        String string3 = deviceInfo2.getAvdName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAvdName(...)");
        if (((CharSequence)string3).length() == 0) {
            androidDeviceType = AndroidDeviceType.LOCAL_PHYSICAL_DEVICE;
        } else {
            String string4 = deviceInfo2.getGradleDslDeviceName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getGradleDslDeviceName(...)");
            androidDeviceType = ((CharSequence)string4).length() == 0 ? AndroidDeviceType.LOCAL_EMULATOR : AndroidDeviceType.LOCAL_GRADLE_MANAGED_EMULATOR;
        }
        AndroidDeviceType deviceType = androidDeviceType;
        String string5 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        String string6 = this.displayName(deviceInfo2);
        String string7 = deviceInfo2.getAvdName();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAvdName(...)");
        AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)deviceInfo2.getApiLevel(), null);
        if (androidVersion == null) {
            androidVersion = AndroidVersion.DEFAULT;
        }
        Object object = androidVersion;
        Intrinsics.checkNotNull((Object)object);
        Object $this$createAndroidDevice_u24lambda_u240 = object = new AndroidDevice(string5, string6, string7, deviceType, (AndroidVersion)object, null, 32, null);
        boolean bl = false;
        String string8 = deviceInfo2.getManufacturer();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getManufacturer(...)");
        if (!StringsKt.isBlank((CharSequence)string8)) {
            ((AndroidDevice)$this$createAndroidDevice_u24lambda_u240).getAdditionalInfo().put("Manufacturer", deviceInfo2.getManufacturer());
        }
        String string9 = deviceInfo2.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getModel(...)");
        if (!StringsKt.isBlank((CharSequence)string9)) {
            ((AndroidDevice)$this$createAndroidDevice_u24lambda_u240).getAdditionalInfo().put("Model", deviceInfo2.getModel());
        }
        if (deviceInfo2.getProcessorsCount() > 0) {
            map2 = ((AndroidDevice)$this$createAndroidDevice_u24lambda_u240).getAdditionalInfo();
            string2 = "Processor";
            ProtocolStringList protocolStringList = deviceInfo2.getProcessorsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getProcessorsList(...)");
            string = CollectionsKt.joinToString$default((Iterable)((Iterable)protocolStringList), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            map2.put(string2, string);
        }
        if (deviceInfo2.getRamInBytes() > 0L) {
            map2 = ((AndroidDevice)$this$createAndroidDevice_u24lambda_u240).getAdditionalInfo();
            string2 = "RAM";
            Locale locale = Locale.ROOT;
            String string10 = "%.1f GB";
            Object[] objectArray = new Object[]{Float.valueOf((float)deviceInfo2.getRamInBytes() / (float)1000 / (float)1000 / (float)1000)};
            String string11 = String.format(locale, string10, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
            string = string11;
            map2.put(string2, string);
        }
        return object;
    }

    private final String displayName(AndroidTestDeviceInfoProto.AndroidTestDeviceInfo $this$displayName) {
        Object object;
        String string = $this$displayName.getGradleDslDeviceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGradleDslDeviceName(...)");
        if (((CharSequence)string).length() > 0) {
            object = "Gradle:" + $this$displayName.getGradleDslDeviceName();
        } else {
            String string2 = $this$displayName.getName();
            Intrinsics.checkNotNull((Object)string2);
            object = string2;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AndroidDevice getAndroidDevice$lambda$0(File $resolvedFile, AndroidDeviceResolver this$0, File it) {
        AndroidTestDeviceInfoProto.AndroidTestDeviceInfo androidTestDeviceInfo;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Closeable closeable = new FileInputStream($resolvedFile);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            androidTestDeviceInfo = AndroidTestDeviceInfoProto.AndroidTestDeviceInfo.parseFrom((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        AndroidTestDeviceInfoProto.AndroidTestDeviceInfo deviceInfo2 = androidTestDeviceInfo;
        Intrinsics.checkNotNull((Object)deviceInfo2);
        return this$0.createAndroidDevice(deviceInfo2);
    }

    private static final AndroidDevice getAndroidDevice$lambda$1(Function1 $tmp0, Object p0) {
        return (AndroidDevice)$tmp0.invoke(p0);
    }

    static {
        AndroidVersion androidVersion = AndroidVersion.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"DEFAULT");
        DEFAULT_ANDROID_DEVICE = new AndroidDevice(DEFAULT_DEVICE_NAME, DEFAULT_DEVICE_NAME, DEFAULT_DEVICE_NAME, DEFAULT_DEVICE_TYPE, androidVersion, null, 32, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/AndroidDeviceResolver$Companion;", "", "<init>", "()V", "DEFAULT_DEVICE_NAME", "", "DEFAULT_DEVICE_TYPE", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDeviceType;", "DEFAULT_ANDROID_DEVICE", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "intellij.android.testartifacts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

