/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.actions;

import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.DeviceType;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.ImportUtpResultAction;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.ImportUtpResultActionFromFile;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.ImportUtpResultActionKt;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\rH\u0002\u001a\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a$\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"TEST_RESULT_PB_FILE_NAME", "", "DEVICE_INFO_PB_FILE_NAME", "FLAVOR_DIRECTORY_NAME", "createImportUtpResultActionFromAndroidGradlePluginOutput", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/actions/ImportUtpResultActionFromFile;", "project", "Lcom/intellij/openapi/project/Project;", "createImportGradleManagedDeviceUtpResults", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "level", "", "findTestResultProtoAndCreateImportActions", "dir", "deviceType", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/actions/DeviceType;", "getFlavorName", "layer", "findTestResultProto", "Lkotlin/sequences/Sequence;", "createImportUtpResultsFromProto", "file", "flavorName", "getDefaultAndroidGradlePluginTestDirectory", "getDefaultAndroidGradlePluginDevicesTestDirectory", "findFileByRelativePathToContentRoot", "relativePath", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nImportUtpResultAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportUtpResultAction.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/actions/ImportUtpResultActionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1#2:300\n*E\n"})
public final class ImportUtpResultActionKt {
    @NotNull
    private static final String TEST_RESULT_PB_FILE_NAME = "test-result.pb";
    @NotNull
    private static final String DEVICE_INFO_PB_FILE_NAME = "device-info.pb";
    @NotNull
    private static final String FLAVOR_DIRECTORY_NAME = "flavors";

    @NotNull
    public static final List<ImportUtpResultActionFromFile> createImportUtpResultActionFromAndroidGradlePluginOutput(@Nullable Project project) {
        VirtualFile virtualFile = ImportUtpResultActionKt.getDefaultAndroidGradlePluginTestDirectory(project);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile testDirectory = virtualFile;
        return ImportUtpResultActionKt.findTestResultProtoAndCreateImportActions(testDirectory, DeviceType.CONNECTED);
    }

    @NotNull
    public static final List<ImportUtpResultActionFromFile> createImportGradleManagedDeviceUtpResults(@Nullable Project project) {
        VirtualFile virtualFile = ImportUtpResultActionKt.getDefaultAndroidGradlePluginDevicesTestDirectory(project);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile deviceFolder = virtualFile;
        return ImportUtpResultActionKt.findTestResultProtoAndCreateImportActions(deviceFolder, DeviceType.MANAGED);
    }

    private static final VirtualFile parent(VirtualFile $this$parent, int level) {
        VirtualFile targetDir = null;
        targetDir = $this$parent;
        int n = 0;
        while (n < level) {
            int it = n++;
            boolean bl = false;
            if (targetDir.getParent() != null) continue;
            return targetDir;
        }
        return targetDir;
    }

    private static final List<ImportUtpResultActionFromFile> findTestResultProtoAndCreateImportActions(VirtualFile dir, DeviceType deviceType) {
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map(ImportUtpResultActionKt.findTestResultProto(dir, deviceType), arg_0 -> ImportUtpResultActionKt.findTestResultProtoAndCreateImportActions$lambda$0(deviceType, arg_0))));
    }

    private static final String getFlavorName(VirtualFile dir, int layer) {
        if (layer < 2) {
            return null;
        }
        return Intrinsics.areEqual((Object)ImportUtpResultActionKt.parent(dir, layer).getName(), (Object)FLAVOR_DIRECTORY_NAME) ? ImportUtpResultActionKt.parent(dir, layer - 1).getName() : ImportUtpResultActionKt.getFlavorName(dir, layer - 1);
    }

    private static final Sequence<VirtualFile> findTestResultProto(VirtualFile dir, DeviceType deviceType) {
        VirtualFile resultPbFile = dir.findChild(TEST_RESULT_PB_FILE_NAME);
        if (resultPbFile != null && (deviceType != DeviceType.MANAGED || dir.findChild(DEVICE_INFO_PB_FILE_NAME) != null)) {
            Object[] objectArray = new VirtualFile[]{resultPbFile};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }
        VirtualFile[] virtualFileArray = dir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        return SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), (Function1)findTestResultProto.1.INSTANCE), arg_0 -> ImportUtpResultActionKt.findTestResultProto$lambda$0(deviceType, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ImportUtpResultActionFromFile createImportUtpResultsFromProto(VirtualFile file, String flavorName, DeviceType deviceType) {
        StringBuilder stringBuilder;
        Closeable closeable;
        try {
            InputStream it;
            closeable = file.getInputStream();
            Throwable throwable = null;
            try {
                it = (InputStream)closeable;
                boolean bl = false;
                it = TestSuiteResultProto.TestSuiteResult.parseFrom((InputStream)it);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = it;
        }
        catch (IOException e) {
            closeable = null;
        }
        Closeable closeable2 = closeable;
        if (closeable2 == null) {
            return null;
        }
        Closeable resultProto = closeable2;
        List list2 = resultProto.getTestResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTestResultList(...)");
        Pair pair = (Pair)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), ImportUtpResultActionKt::createImportUtpResultsFromProto$lambda$1), ImportUtpResultActionKt::createImportUtpResultsFromProto$lambda$2));
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        long startTimeMillis = ((Number)pair2.component1()).longValue();
        String testName = (String)pair2.component2();
        StringBuilder $this$createImportUtpResultsFromProto_u24lambda_u243 = stringBuilder = new StringBuilder(testName);
        boolean bl = false;
        String string = flavorName;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$createImportUtpResultsFromProto_u24lambda_u243.append(" - " + it);
        }
        $this$createImportUtpResultsFromProto_u24lambda_u243.append(" - " + deviceType.getDeviceType());
        $this$createImportUtpResultsFromProto_u24lambda_u243.append(" (" + DateFormatUtil.formatDateTime((Date)new Date(startTimeMillis)) + ")");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String actionText = string2;
        return new ImportUtpResultActionFromFile(startTimeMillis, new ImportUtpResultAction(null, actionText, actionText, file, 1, null));
    }

    private static final VirtualFile getDefaultAndroidGradlePluginTestDirectory(Project project) {
        return ImportUtpResultActionKt.findFileByRelativePathToContentRoot(project, "build/outputs/androidTest-results/connected");
    }

    private static final VirtualFile getDefaultAndroidGradlePluginDevicesTestDirectory(Project project) {
        return ImportUtpResultActionKt.findFileByRelativePathToContentRoot(project, "build/outputs/androidTest-results/managedDevice");
    }

    private static final VirtualFile findFileByRelativePathToContentRoot(Project project, String relativePath) {
        if (project == null) {
            return null;
        }
        return (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])ModuleManager.Companion.getInstance(project).getModules()), arg_0 -> ImportUtpResultActionKt.findFileByRelativePathToContentRoot$lambda$0(relativePath, arg_0))));
    }

    private static final ImportUtpResultActionFromFile findTestResultProtoAndCreateImportActions$lambda$0(DeviceType $deviceType, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String currentFlavor = ImportUtpResultActionKt.getFlavorName(it, 3);
        return ImportUtpResultActionKt.createImportUtpResultsFromProto(it, currentFlavor, $deviceType);
    }

    private static final Sequence findTestResultProto$lambda$0(DeviceType $deviceType, VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        return ImportUtpResultActionKt.findTestResultProto(it, $deviceType);
    }

    private static final Pair createImportUtpResultsFromProto$lambda$1(TestResultProto.TestResult it) {
        long startTimeMillis = it.getTestCase().getStartTime().getSeconds() * (long)1000 + (long)(it.getTestCase().getStartTime().getNanos() / 1000000);
        return new Pair((Object)startTimeMillis, (Object)it.getTestCase().getTestClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createImportUtpResultsFromProto$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (((Number)it.getFirst()).longValue() <= 0L) return false;
        Object object = it.getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-second>(...)");
        if (StringsKt.isBlank((CharSequence)((CharSequence)object))) return false;
        return true;
    }

    private static final VirtualFile findFileByRelativePathToContentRoot$lambda$0(String $relativePath, Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        return (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), arg_0 -> ImportUtpResultActionKt.findFileByRelativePathToContentRoot$lambda$0$0($relativePath, arg_0))));
    }

    private static final VirtualFile findFileByRelativePathToContentRoot$lambda$0$0(String $relativePath, VirtualFile it) {
        return it.findFileByRelativePath($relativePath);
    }

    public static final /* synthetic */ VirtualFile access$getDefaultAndroidGradlePluginTestDirectory(Project project) {
        return ImportUtpResultActionKt.getDefaultAndroidGradlePluginTestDirectory(project);
    }

    public static final /* synthetic */ Sequence access$findTestResultProto(VirtualFile dir, DeviceType deviceType) {
        return ImportUtpResultActionKt.findTestResultProto(dir, deviceType);
    }
}

