/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.dialogs;

import com.android.annotations.concurrency.Slow;
import com.android.emulator.control.SnapshotDetails;
import com.android.emulator.control.SnapshotFilter;
import com.android.emulator.control.SnapshotList;
import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.KeyValueFiles;
import com.android.tools.idea.streaming.emulator.dialogs.BootMode;
import com.android.tools.idea.streaming.emulator.dialogs.BootType;
import com.android.tools.idea.streaming.emulator.dialogs.SnapshotInfo;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0003J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u000fH\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020 H\u0007J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotManager;", "", "emulatorController", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "getEmulatorController", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "snapshotsFolder", "Ljava/nio/file/Path;", "getSnapshotsFolder", "()Ljava/nio/file/Path;", "avdFolder", "getAvdFolder", "avdId", "", "getAvdId", "()Ljava/lang/String;", "fetchSnapshotList", "", "Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "readSnapshotInfo", "snapshotFolder", "snapshotFolderName", "saveSnapshotProto", "", "snapshotProto", "Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;", "folderSize", "", "folder", "readBootMode", "Lcom/android/tools/idea/streaming/emulator/dialogs/BootMode;", "saveBootMode", "bootMode", "toYesNo", "value", "", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nSnapshotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotManager.kt\ncom/android/tools/idea/streaming/emulator/dialogs/SnapshotManager\n+ 2 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,197:1\n214#2,13:198\n214#2,13:212\n214#2,13:226\n24#3:211\n24#3:225\n*S KotlinDebug\n*F\n+ 1 SnapshotManager.kt\ncom/android/tools/idea/streaming/emulator/dialogs/SnapshotManager\n*L\n87#1:198,13\n115#1:212,13\n125#1:226,13\n95#1:211\n119#1:225\n*E\n"})
public final class SnapshotManager {
    @NotNull
    private final EmulatorController emulatorController;
    @NotNull
    private final Path snapshotsFolder;

    public SnapshotManager(@NotNull EmulatorController emulatorController) {
        Intrinsics.checkNotNullParameter((Object)((Object)emulatorController), (String)"emulatorController");
        this.emulatorController = emulatorController;
        Path path = this.getAvdFolder().resolve("snapshots");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.snapshotsFolder = path;
    }

    @NotNull
    public final EmulatorController getEmulatorController() {
        return this.emulatorController;
    }

    @NotNull
    public final Path getSnapshotsFolder() {
        return this.snapshotsFolder;
    }

    @NotNull
    public final Path getAvdFolder() {
        return this.emulatorController.getEmulatorId().getAvdFolder();
    }

    private final String getAvdId() {
        return this.emulatorController.getEmulatorId().getAvdId();
    }

    @Slow
    @NotNull
    public final List<SnapshotInfo> fetchSnapshotList() {
        SettableFuture snapshotsFuture = SettableFuture.create();
        SnapshotFilter snapshotFilter = SnapshotFilter.newBuilder().setStatusFilter(SnapshotFilter.LoadStatus.All).build();
        Intrinsics.checkNotNull((Object)snapshotFilter);
        this.emulatorController.listSnapshots(snapshotFilter, (StreamObserver<SnapshotList>)new EmptyStreamObserver<SnapshotList>((SettableFuture<List<SnapshotInfo>>)snapshotsFuture, this){
            final /* synthetic */ SettableFuture<List<SnapshotInfo>> $snapshotsFuture;
            final /* synthetic */ SnapshotManager this$0;
            {
                this.$snapshotsFuture = $snapshotsFuture;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onNext(SnapshotList message) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                List list2 = message.getSnapshotsList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSnapshotsList(...)");
                Iterable iterable = list2;
                SnapshotManager snapshotManager = this.this$0;
                boolean $i$f$map = false;
                void var6_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SnapshotDetails snapshotDetails = (SnapshotDetails)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    Path path = snapshotManager.getSnapshotsFolder();
                    Intrinsics.checkNotNull((Object)it);
                    collection2.add(new SnapshotInfo(path, (SnapshotDetails)it));
                }
                List snapshots = (List)destination$iv$iv;
                this.$snapshotsFuture.set((Object)snapshots);
            }

            public void onError(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$snapshotsFuture.setException(t);
            }
        });
        try {
            Object object = snapshotsFuture.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (List)object;
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    private final SnapshotInfo readSnapshotInfo(Path snapshotFolder) {
        Path snapshotProtoFile = snapshotFolder.resolve("snapshot.pb");
        try {
            InputStream it;
            AutoCloseable $this$use$iv = Files.newInputStream(snapshotProtoFile, new OpenOption[0]);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                it = (InputStream)$this$use$iv;
                boolean bl = false;
                it = SnapshotOuterClass.Snapshot.parseFrom((InputStream)it);
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $this$use$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            InputStream snapshot = it;
            Intrinsics.checkNotNull((Object)snapshot);
            return new SnapshotInfo(snapshotFolder, (SnapshotOuterClass.Snapshot)snapshot, this.folderSize(snapshotFolder), true, false);
        }
        catch (NoSuchFileException snapshot) {
        }
        catch (IOException e) {
            SnapshotManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SnapshotManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error reading " + snapshotProtoFile + " - " + e.getLocalizedMessage());
        }
        return null;
    }

    @Slow
    @Nullable
    public final SnapshotInfo readSnapshotInfo(@NotNull String snapshotFolderName) {
        Intrinsics.checkNotNullParameter((Object)snapshotFolderName, (String)"snapshotFolderName");
        Path path = this.snapshotsFolder.resolve(snapshotFolderName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.readSnapshotInfo(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public final void saveSnapshotProto(@NotNull Path snapshotFolder, @NotNull SnapshotOuterClass.Snapshot snapshotProto) {
        Intrinsics.checkNotNullParameter((Object)snapshotFolder, (String)"snapshotFolder");
        Intrinsics.checkNotNullParameter((Object)snapshotProto, (String)"snapshotProto");
        Path protoFile = snapshotFolder.resolve("snapshot.pb");
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            AutoCloseable $this$use$iv = Files.newOutputStream(protoFile, openOptionArray);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                OutputStream stream = (OutputStream)$this$use$iv;
                boolean bl = false;
                snapshotProto.writeTo(stream);
                stream = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $this$use$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (IOException e) {
            SnapshotManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SnapshotManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error writing " + protoFile + " - " + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long folderSize(Path folder) {
        Ref.LongRef size = new Ref.LongRef();
        AutoCloseable $this$use$iv = Files.list(folder);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Stream stream = (Stream)$this$use$iv;
            boolean bl = false;
            stream.forEach(arg_0 -> SnapshotManager.folderSize$lambda$0$1(arg_0 -> SnapshotManager.folderSize$lambda$0$0(size, this, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return size.element;
    }

    @Slow
    @Nullable
    public final BootMode readBootMode() {
        Object[] objectArray = new String[]{"fastboot.chosenSnapshotFile", "fastboot.forceChosenSnapshotBoot", "fastboot.forceColdBoot", "fastboot.forceFastBoot"};
        Set keysToExtract = SetsKt.setOf((Object[])objectArray);
        Path path = this.getAvdFolder().resolve("config.ini");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Map<String, String> map2 = KeyValueFiles.readKeyValueFile(path, keysToExtract);
        if (map2 == null) {
            return null;
        }
        Map<String, String> map3 = map2;
        BootType bootType = Intrinsics.areEqual((Object)map3.get("fastboot.forceFastBoot"), (Object)"yes") ? BootType.QUICK : (Intrinsics.areEqual((Object)map3.get("fastboot.forceChosenSnapshotBoot"), (Object)"yes") ? BootType.SNAPSHOT : BootType.COLD);
        return new BootMode(bootType, map3.get("fastboot.chosenSnapshotFile"));
    }

    @Slow
    public final void saveBootMode(@NotNull BootMode bootMode) {
        Intrinsics.checkNotNullParameter((Object)bootMode, (String)"bootMode");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"fastboot.forceColdBoot", (Object)this.toYesNo(bootMode.getBootType() == BootType.COLD)), TuplesKt.to((Object)"fastboot.forceFastBoot", (Object)this.toYesNo(bootMode.getBootType() == BootType.QUICK)), TuplesKt.to((Object)"fastboot.forceChosenSnapshotBoot", (Object)this.toYesNo(bootMode.getBootType() == BootType.SNAPSHOT)), TuplesKt.to((Object)"fastboot.chosenSnapshotFile", (Object)bootMode.getBootSnapshotId())};
        Map updates = MapsKt.mapOf((Pair[])pairArray);
        Path path = this.getAvdFolder().resolve("config.ini");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        KeyValueFiles.updateKeyValueFile(path, updates);
        AvdManagerConnection avdManagerConnection = AvdManagerConnection.Companion.getDefaultAvdManagerConnection();
        avdManagerConnection.reloadAvd(this.getAvdFolder());
    }

    private final String toYesNo(boolean value2) {
        return value2 ? "yes" : "no";
    }

    private static final Unit folderSize$lambda$0$0(Ref.LongRef $size, SnapshotManager this$0, Path file) {
        try {
            long l;
            long l2 = $size.element;
            if (Files.isDirectory(file, new LinkOption[0])) {
                Intrinsics.checkNotNull((Object)file);
                l = this$0.folderSize(file);
            } else {
                l = Files.size(file);
            }
            $size.element = l2 + l;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final void folderSize$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

