/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.emulator.control.InputEvent;
import com.android.emulator.control.Touch;
import com.android.emulator.control.TouchpadEvent;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u0002=>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010 \u001a\u00020\u0005H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020$H\u0002J \u00101\u001a\u00020$2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\tH\u0002J(\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020,2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,2\u0006\u00107\u001a\u00020,H\u0002J(\u00108\u001a\u00020$2\u0006\u00106\u001a\u00020,2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,2\u0006\u00107\u001a\u00020,H\u0002J\b\u00109\u001a\u00020$H\u0002J\u0018\u0010:\u001a\u00020\t2\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020,H\u0002J\u0010\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0012\u0010\fR\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0016\u0010\u001a\u001a\n \u0018*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u0018*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/streaming/emulator/TouchpadPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "touchpadSize", "Ljava/awt/Dimension;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Ljava/awt/Dimension;)V", "value", "", "multiTouchMode", "setMultiTouchMode", "(Z)V", "Ljava/awt/Point;", "lastMouseCoordinates", "setLastMouseCoordinates", "(Ljava/awt/Point;)V", "mouseButtonPressed", "setMouseButtonPressed", "mouseListener", "Lcom/android/tools/idea/streaming/emulator/TouchpadPanel$MyMouseListener;", "touches", "", "Lcom/android/emulator/control/Touch$Builder;", "kotlin.jvm.PlatformType", "[Lcom/android/emulator/control/Touch$Builder;", "inputEvent", "Lcom/android/emulator/control/InputEvent$Builder;", "touchpadEvent", "Lcom/android/emulator/control/TouchpadEvent$Builder;", "lastSentInputEvent", "Lcom/android/emulator/control/InputEvent;", "getPreferredSize", "getMinimumSize", "getMaximumSize", "paintComponent", "", "graphics", "Ljava/awt/Graphics;", "drawTouchFeedback", "g", "Ljava/awt/Graphics2D;", "point", "radius", "", "updateMouseState", "event", "Ljava/awt/event/MouseEvent;", "terminateDragging", "sendMouseEvent", "x", "y", "withPressure", "addTouchWithAdjustments", "id", "pressure", "addTouch", "sendTouchpadEventIfNotEmpty", "isInsideTouchpad", "createTouch", "identifier", "MyMouseListener", "MyKeyListener", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nTouchpadPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TouchpadPanel.kt\ncom/android/tools/idea/streaming/emulator/TouchpadPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
public final class TouchpadPanel
extends BorderLayoutPanel {
    @NotNull
    private final EmulatorController emulator;
    @NotNull
    private final Dimension touchpadSize;
    private boolean multiTouchMode;
    @Nullable
    private Point lastMouseCoordinates;
    private boolean mouseButtonPressed;
    @NotNull
    private final MyMouseListener mouseListener;
    @NotNull
    private final Touch.Builder[] touches;
    private final InputEvent.Builder inputEvent;
    private final TouchpadEvent.Builder touchpadEvent;
    @Nullable
    private InputEvent lastSentInputEvent;

    /*
     * WARNING - void declaration
     */
    public TouchpadPanel(@NotNull EmulatorController emulator, @NotNull Dimension touchpadSize) {
        void $this$_init__u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)touchpadSize, (String)"touchpadSize");
        this.emulator = emulator;
        this.touchpadSize = touchpadSize;
        this.mouseListener = new MyMouseListener();
        int n = 0;
        JBLabel jBLabel = new Touch.Builder[2];
        TouchpadPanel touchpadPanel = this;
        while (n < 2) {
            int n2 = n++;
            jBLabel[n2] = Touch.newBuilder().setIdentifier(n2).setExpiration(Touch.EventExpiration.NEVER_EXPIRE);
        }
        touchpadPanel.touches = jBLabel;
        this.inputEvent = InputEvent.newBuilder();
        this.touchpadEvent = this.inputEvent.getTouchpadEventBuilder();
        this.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        this.setBackground((Color)new JBColor(16382718, 3750720));
        Color color = JBUI.CurrentTheme.Tooltip.grayedForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"grayedForeground(...)");
        Color color2 = color;
        JBLabel jBLabel2 = jBLabel = new JBLabel("Hold shift for two-finger mode", 0);
        touchpadPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setForeground(color2);
        touchpadPanel.addToCenter((Component)jBLabel);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addKeyListener(new MyKeyListener());
    }

    private final void setMultiTouchMode(boolean value2) {
        if (value2 != this.multiTouchMode) {
            this.terminateDragging();
            this.multiTouchMode = value2;
            this.repaint();
        }
    }

    private final void setLastMouseCoordinates(Point value2) {
        if (!Intrinsics.areEqual((Object)value2, (Object)this.lastMouseCoordinates)) {
            this.lastMouseCoordinates = value2;
            this.repaint();
        }
    }

    private final void setMouseButtonPressed(boolean value2) {
        if (value2 != this.mouseButtonPressed) {
            this.mouseButtonPressed = value2;
            this.repaint();
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = JBUIScale.scale((int)AwtUtilsKt.scaled((int)40, (int)this.touchpadSize.width, (int)this.touchpadSize.height));
        Intrinsics.checkNotNull((Object)insets);
        return new Dimension(n + UiSizeUtilKt.getWidth((Insets)insets), JBUIScale.scale((int)40) + UiSizeUtilKt.getHeight((Insets)insets));
    }

    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @NotNull
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(@NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        super.paintComponent(graphics);
        this.drawTouchFeedback(graphics);
    }

    private final void drawTouchFeedback(Graphics graphics) {
        Point point = this.lastMouseCoordinates;
        if (point == null) {
            return;
        }
        Point point2 = point;
        Insets insets = this.getInsets();
        int n = this.getWidth();
        Intrinsics.checkNotNull((Object)insets);
        int w = n - UiSizeUtilKt.getWidth((Insets)insets);
        int h = this.getHeight() - UiSizeUtilKt.getHeight((Insets)insets);
        Rectangle touchpadRectangle = new Rectangle(insets.left, insets.top, w, h);
        if (!touchpadRectangle.contains(point2)) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON), TuplesKt.to((Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY)};
        g.setRenderingHints(new RenderingHints(MapsKt.mapOf((Pair[])pairArray)));
        g.setClip(touchpadRectangle);
        g.setColor(JBUI.CurrentTheme.Tooltip.grayedForeground());
        double scale = (double)w / (double)this.touchpadSize.width;
        int radius = AwtUtilsKt.scaled((int)100, (double)scale);
        if (this.multiTouchMode) {
            int fingerDistance = AwtUtilsKt.scaled((int)260, (double)scale);
            point2.x -= fingerDistance / 2;
            this.drawTouchFeedback(g, point2, radius);
            point2.x += fingerDistance;
            this.drawTouchFeedback(g, point2, radius);
        } else {
            this.drawTouchFeedback(g, point2, radius);
        }
    }

    private final void drawTouchFeedback(Graphics2D g, Point point, int radius) {
        if (this.mouseButtonPressed) {
            StreamingUtilsKt.fillCircle(g, point, radius);
        } else {
            StreamingUtilsKt.drawCircle(g, point, radius);
        }
    }

    private final void updateMouseState(MouseEvent event) {
        int modifiers = event.getModifiersEx();
        this.setLastMouseCoordinates(new Point(event.getX(), event.getY()));
        this.setMultiTouchMode((modifiers & 0x40) != 0);
        this.setMouseButtonPressed((modifiers & 0x400) != 0);
    }

    private final void terminateDragging() {
        this.touchpadEvent.clearTouches();
        for (Touch.Builder touch : this.touches) {
            if (touch.getPressure() == 0) continue;
            touch.setPressure(0);
            this.touchpadEvent.addTouches(touch);
        }
        this.sendTouchpadEventIfNotEmpty();
    }

    private final void sendMouseEvent(int x, int y, boolean withPressure) {
        int n = this.getWidth();
        Insets insets = this.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        int w = n - UiSizeUtilKt.getWidth((Insets)insets);
        int n2 = this.getHeight();
        Insets insets2 = this.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
        int h = n2 - UiSizeUtilKt.getHeight((Insets)insets2);
        int pressure = withPressure ? 1024 : 0;
        int touchpadX = StreamingUtilsKt.scaledUnbiased(x - this.getInsets().left, w, this.touchpadSize.width);
        int touchpadY = StreamingUtilsKt.scaledUnbiased(y - this.getInsets().top, h, this.touchpadSize.height);
        this.touchpadEvent.clearTouches();
        if (this.multiTouchMode) {
            this.addTouchWithAdjustments(0, touchpadX - 260, touchpadY, pressure);
            this.addTouchWithAdjustments(1, touchpadX + 260, touchpadY, pressure);
        } else {
            this.addTouchWithAdjustments(0, touchpadX, touchpadY, pressure);
        }
        this.sendTouchpadEventIfNotEmpty();
    }

    private final void addTouchWithAdjustments(int id2, int x, int y, int pressure) {
        if (this.isInsideTouchpad(x, y)) {
            this.addTouch(id2, x, y, pressure);
        } else if (this.touches[id2].getPressure() != 0) {
            this.addTouch(id2, RangesKt.coerceIn((int)x, (int)0, (int)(this.touchpadSize.width - 1)), RangesKt.coerceIn((int)y, (int)0, (int)(this.touchpadSize.height - 1)), 0);
        }
    }

    private final void addTouch(int id2, int x, int y, int pressure) {
        Touch.Builder touch = this.touches[id2];
        touch.setX(x);
        touch.setY(y);
        touch.setPressure(pressure);
        this.touchpadEvent.addTouches(touch);
    }

    private final void sendTouchpadEventIfNotEmpty() {
        InputEvent inputEvent;
        if (this.touchpadEvent.getTouchesCount() > 0 && !Intrinsics.areEqual((Object)(inputEvent = this.inputEvent.build()), (Object)this.lastSentInputEvent)) {
            this.emulator.getOrCreateInputEventSender().onNext((Object)inputEvent);
            this.lastSentInputEvent = inputEvent;
        }
    }

    private final boolean isInsideTouchpad(int x, int y) {
        return 0 <= x && x < this.touchpadSize.width && 0 <= y && y < this.touchpadSize.height;
    }

    private final Touch.Builder createTouch(int identifier) {
        Touch.Builder builder = Touch.newBuilder().setIdentifier(identifier).setExpiration(Touch.EventExpiration.NEVER_EXPIRE);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setExpiration(...)");
        return builder;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/emulator/TouchpadPanel$MyKeyListener;", "Ljava/awt/event/KeyAdapter;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/TouchpadPanel;)V", "keyPressed", "", "event", "Ljava/awt/event/KeyEvent;", "keyReleased", "updateMultiTouchMode", "intellij.android.streaming"})
    private final class MyKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
        }

        private final void updateMultiTouchMode(KeyEvent event) {
            TouchpadPanel.this.setMultiTouchMode((event.getModifiersEx() & 0x40) != 0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/streaming/emulator/TouchpadPanel$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/TouchpadPanel;)V", "mousePressed", "", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseExited", "mouseDragged", "mouseMoved", "intellij.android.streaming"})
    private final class MyMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TouchpadPanel.this.requestFocusInWindow();
            TouchpadPanel.this.updateMouseState(event);
            if (TouchpadPanel.this.mouseButtonPressed) {
                TouchpadPanel.this.sendMouseEvent(event.getX(), event.getY(), true);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TouchpadPanel.this.updateMouseState(event);
            if (event.getButton() == 1) {
                TouchpadPanel.this.sendMouseEvent(event.getX(), event.getY(), false);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (TouchpadPanel.this.mouseButtonPressed) {
                TouchpadPanel.this.sendMouseEvent(event.getX(), event.getY(), false);
            }
            TouchpadPanel.this.setLastMouseCoordinates(null);
            TouchpadPanel.this.setMouseButtonPressed(false);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TouchpadPanel.this.updateMouseState(event);
            if (TouchpadPanel.this.mouseButtonPressed) {
                TouchpadPanel.this.sendMouseEvent(event.getX(), event.getY(), true);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TouchpadPanel.this.updateMouseState(event);
        }
    }
}

