/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device.xr;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.streaming.core.MouseWheelUtilsKt;
import com.android.tools.idea.streaming.device.ControlMessage;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.XrAngularVelocityMessage;
import com.android.tools.idea.streaming.device.XrRotationMessage;
import com.android.tools.idea.streaming.device.XrSetPassthroughCoefficientMessage;
import com.android.tools.idea.streaming.device.XrTranslationMessage;
import com.android.tools.idea.streaming.device.XrVelocityMessage;
import com.android.tools.idea.streaming.device.xr.DeviceXrInputControllerService;
import com.android.tools.idea.streaming.xr.AbstractXrInputController;
import com.android.tools.idea.streaming.xr.XrEnvironment;
import com.android.tools.idea.streaming.xr.XrInputMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J \u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0014J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputController;", "Lcom/android/tools/idea/streaming/xr/AbstractXrInputController;", "Lcom/android/tools/idea/streaming/device/DeviceController$XrEnvironmentListener;", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "<init>", "(Lcom/android/tools/idea/streaming/device/DeviceClient;)V", "isPassthroughSupported", "", "()Z", "setPassthrough", "", "passthroughCoefficient", "", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendTranslation", "x", "y", "z", "mouseDragged", "event", "Ljava/awt/event/MouseEvent;", "deviceDisplaySize", "Ljava/awt/Dimension;", "scaleFactor", "", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "sendVelocityUpdate", "newMask", "", "oldMask", "onXrPassthroughCoefficientChanged", "onXrEnvironmentChanged", "environment", "Lcom/android/tools/idea/streaming/xr/XrEnvironment;", "dispose", "Companion", "intellij.android.streaming"})
public final class DeviceXrInputController
extends AbstractXrInputController
implements DeviceController.XrEnvironmentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceClient deviceClient;

    public DeviceXrInputController(@NotNull DeviceClient deviceClient) {
        Intrinsics.checkNotNullParameter((Object)deviceClient, (String)"deviceClient");
        this.deviceClient = deviceClient;
        Disposer.register((Disposable)this.deviceClient, (Disposable)this);
    }

    @Override
    public boolean isPassthroughSupported() {
        Object t = StudioFlags.DEVICE_MIRRORING_XR_SIMULATED_PASSTHROUGH.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Boolean)t;
    }

    @Override
    @Nullable
    public Object setPassthrough(float passthroughCoefficient, @NotNull Continuation<? super Unit> $completion) {
        block0: {
            DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
            if (deviceController == null) break block0;
            deviceController.sendControlMessage(new XrSetPassthroughCoefficientMessage(passthroughCoefficient));
        }
        return Unit.INSTANCE;
    }

    @Override
    public void sendTranslation(float x, float y, float z) {
        block0: {
            DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
            if (deviceController == null) break block0;
            deviceController.sendControlMessage(new XrTranslationMessage(x, y, z));
        }
    }

    @Override
    @UiThread
    public boolean mouseDragged(@NotNull MouseEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        Point referencePoint = this.getMouseDragReferencePoint();
        if (referencePoint != null) {
            float movementScale = this.getInputMode() == XrInputMode.VIEW_DIRECTION ? (float)Math.PI : 4.0f;
            float scale = (float)((double)(movementScale / (float)Math.min(deviceDisplaySize.width, deviceDisplaySize.height)) * scaleFactor);
            int deltaX = event.getX() - referencePoint.x;
            int deltaY = event.getY() - referencePoint.y;
            this.setMouseDragReferencePoint(event.getPoint());
            if (deltaX != 0 || deltaY != 0) {
                ControlMessage controlMessage = switch (WhenMappings.$EnumSwitchMapping$0[this.getInputMode().ordinal()]) {
                    case 1 -> new XrTranslationMessage((float)(-deltaX) * scale, (float)deltaY * scale, 0.0f);
                    case 2 -> new XrTranslationMessage(0.0f, 0.0f, (float)deltaY * scale);
                    case 3 -> new XrRotationMessage((float)(-deltaY) * scale, (float)(-deltaX) * scale);
                    default -> throw new Error("Internal error");
                };
                DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
                if (deviceController != null) {
                    deviceController.sendControlMessage(controlMessage);
                }
            }
        }
        event.consume();
        return true;
    }

    @Override
    @UiThread
    public boolean mouseWheelMoved(@NotNull MouseWheelEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        float deltaZ = (float)MouseWheelUtilsKt.getNormalizedScrollAmount(event, scaleFactor) * 0.25f;
        XrTranslationMessage controlMessage = new XrTranslationMessage(0.0f, 0.0f, deltaZ);
        DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
        if (deviceController != null) {
            deviceController.sendControlMessage(controlMessage);
        }
        event.consume();
        return true;
    }

    @Override
    protected void sendVelocityUpdate(int newMask, int oldMask) {
        block25: {
            ControlMessage controlMessage;
            float vX = 0.0f;
            float vY = 0.0f;
            float vZ = 0.0f;
            float omegaX = 0.0f;
            float omegaY = 0.0f;
            int mask = newMask;
            int key = 0;
            while (mask != 0) {
                if ((mask & 1) != 0) {
                    if (key < AbstractXrInputController.NavigationKey.ROTATE_RIGHT.ordinal()) {
                        var10_10 = key;
                        if (var10_10 == AbstractXrInputController.NavigationKey.MOVE_RIGHT.ordinal()) {
                            vX = 1.0f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.MOVE_LEFT.ordinal()) {
                            vX = -1.0f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.MOVE_UP.ordinal()) {
                            vY = 1.0f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.MOVE_DOWN.ordinal()) {
                            vY = -1.0f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.MOVE_FORWARD.ordinal()) {
                            vZ = -1.0f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.MOVE_BACKWARD.ordinal()) {
                            vZ = 1.0f;
                        }
                    } else {
                        var10_10 = key;
                        if (var10_10 == AbstractXrInputController.NavigationKey.ROTATE_RIGHT.ordinal()) {
                            omegaY = -0.5235988f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.ROTATE_LEFT.ordinal()) {
                            omegaY = 0.5235988f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.ROTATE_UP.ordinal()) {
                            omegaX = 0.5235988f;
                        } else if (var10_10 == AbstractXrInputController.NavigationKey.ROTATE_DOWN.ordinal()) {
                            omegaX = -0.5235988f;
                        }
                    }
                }
                mask >>>= 1;
                ++key;
            }
            int differences = newMask ^ oldMask;
            if ((differences & AbstractXrInputController.NavigationKey.Companion.getTRANSLATION_MASK()) != 0) {
                controlMessage = new XrVelocityMessage(vX, vY, vZ);
                DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
                if (deviceController != null) {
                    deviceController.sendControlMessage(controlMessage);
                }
            }
            if ((differences & AbstractXrInputController.NavigationKey.Companion.getROTATION_MASK()) == 0) break block25;
            controlMessage = new XrAngularVelocityMessage(omegaX, omegaY);
            DeviceController deviceController = this.deviceClient.getDeviceController$intellij_android_streaming();
            if (deviceController != null) {
                deviceController.sendControlMessage(controlMessage);
            }
        }
    }

    @Override
    public void onXrPassthroughCoefficientChanged(float passthroughCoefficient) {
        this.setPassthroughCoefficient(passthroughCoefficient);
    }

    @Override
    public void onXrEnvironmentChanged(@NotNull XrEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        this.setEnvironment(environment);
    }

    public void dispose() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputController$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputController;", "project", "Lcom/intellij/openapi/project/Project;", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nDeviceXrInputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceXrInputController.kt\ncom/android/tools/idea/streaming/device/xr/DeviceXrInputController$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,191:1\n30#2,2:192\n*S KotlinDebug\n*F\n+ 1 DeviceXrInputController.kt\ncom/android/tools/idea/streaming/device/xr/DeviceXrInputController$Companion\n*L\n168#1:192,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeviceXrInputController getInstance(@NotNull Project project, @NotNull DeviceClient deviceClient) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)deviceClient, (String)"deviceClient");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DeviceXrInputControllerService> serviceClass$iv = DeviceXrInputControllerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((DeviceXrInputControllerService)object).getXrInputController(deviceClient);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XrInputMode.values().length];
            try {
                nArray[XrInputMode.LOCATION_IN_SPACE_XY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrInputMode.LOCATION_IN_SPACE_Z.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrInputMode.VIEW_DIRECTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

