/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.AudioDecoder;
import com.android.tools.idea.streaming.device.AudioDecoderException;
import com.android.tools.idea.streaming.device.AudioDecoderKt;
import com.android.tools.idea.streaming.device.AudioSystemService;
import com.android.tools.idea.streaming.device.SuspendingSocketChannel;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParserContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVChannelLayout;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swresample;
import org.bytedeco.ffmpeg.swresample.SwrContext;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0018\u00010\nR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/streaming/device/AudioDecoder;", "", "audioChannel", "Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;", "decoderScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;Lkotlinx/coroutines/CoroutineScope;)V", "decodingContext", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/streaming/device/AudioDecoder$DecodingContext;", "endOfAudioStream", "", "mute", "unmute", "start", "", "playAudio", "PacketReader", "DecodingContext", "AudioPlayer", "AudioPacketHeader", "intellij.android.streaming"})
public final class AudioDecoder {
    @NotNull
    private final SuspendingSocketChannel audioChannel;
    @NotNull
    private final CoroutineScope decoderScope;
    @NotNull
    private final AtomicReference<DecodingContext> decodingContext;
    private volatile boolean endOfAudioStream;

    public AudioDecoder(@NotNull SuspendingSocketChannel audioChannel, @NotNull CoroutineScope decoderScope) {
        Intrinsics.checkNotNullParameter((Object)audioChannel, (String)"audioChannel");
        Intrinsics.checkNotNullParameter((Object)decoderScope, (String)"decoderScope");
        this.audioChannel = audioChannel;
        this.decoderScope = decoderScope;
        this.decodingContext = new AtomicReference();
    }

    public final boolean mute() {
        Unit unit;
        DecodingContext decodingContext = this.decodingContext.getAndSet(null);
        if (decodingContext != null) {
            decodingContext.closeAsynchronously();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit != null;
    }

    public final boolean unmute() {
        return this.decodingContext.getAndUpdate(arg_0 -> AudioDecoder.unmute$lambda$0(this, arg_0)) == null;
    }

    public final void start(boolean playAudio) {
        if (playAudio) {
            this.decodingContext.set(new DecodingContext());
        }
        BuildersKt.launch$default((CoroutineScope)this.decoderScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ AudioDecoder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        packetReader = this.this$0.new PacketReader();
                        try {
                        }
                        catch (ClosedChannelException var3_4) {
                            AudioDecoder.access$setEndOfAudioStream$p(this.this$0, true);
                            v0 = AudioDecoder.access$getDecodingContext$p(this.this$0).getAndSet(null);
                            if (v0 != null) {
                                v0.close();
                            }
                            packetReader.close();
                            return Unit.INSTANCE;
                        }
                        catch (EOFException var3_5) {
                            AudioDecoder.access$setEndOfAudioStream$p(this.this$0, true);
                            v1 = AudioDecoder.access$getDecodingContext$p(this.this$0).getAndSet(null);
                            if (v1 != null) {
                                v1.close();
                            }
                            packetReader.close();
                            return Unit.INSTANCE;
                            catch (Throwable var3_6) {
                                AudioDecoder.access$setEndOfAudioStream$p(this.this$0, true);
                                v2 = AudioDecoder.access$getDecodingContext$p(this.this$0).getAndSet(null);
                                if (v2 != null) {
                                    v2.close();
                                }
                                packetReader.close();
                                throw var3_6;
                            }
                        }
lbl31:
                        // 2 sources

                        while (true) {
                            this.L$0 = packetReader;
                            this.label = 1;
                            v3 = packetReader.readAndProcessPacket((Continuation<? super Unit>)((Continuation)this));
                            if (v3 != var4_2) continue;
                            return var4_2;
                        }
                    }
                    case 1: {
                        packetReader = (PacketReader)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** continue;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final DecodingContext unmute$lambda$0(AudioDecoder this$0, DecodingContext context) {
        DecodingContext decodingContext = context;
        if (decodingContext == null) {
            decodingContext = this$0.new DecodingContext();
        }
        return decodingContext;
    }

    public static final /* synthetic */ void access$setEndOfAudioStream$p(AudioDecoder $this, boolean bl) {
        $this.endOfAudioStream = bl;
    }

    public static final /* synthetic */ AtomicReference access$getDecodingContext$p(AudioDecoder $this) {
        return $this.decodingContext;
    }

    public static final /* synthetic */ SuspendingSocketChannel access$getAudioChannel$p(AudioDecoder $this) {
        return $this.audioChannel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/device/AudioDecoder$AudioPacketHeader;", "", "encodedPacketSize", "", "<init>", "(I)V", "isConfig", "", "()Z", "packetSize", "getPacketSize", "()I", "toString", "", "Companion", "intellij.android.streaming"})
    private static final class AudioPacketHeader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int encodedPacketSize;
        private static final int WIRE_SIZE = 4;

        private AudioPacketHeader(int encodedPacketSize) {
            this.encodedPacketSize = encodedPacketSize;
        }

        public final boolean isConfig() {
            return this.encodedPacketSize < 0;
        }

        public final int getPacketSize() {
            return this.encodedPacketSize & Integer.MAX_VALUE;
        }

        @NotNull
        public String toString() {
            return "AudioPacketHeader(isConfig=" + this.isConfig() + ", packetSize=" + this.getPacketSize() + ")";
        }

        public /* synthetic */ AudioPacketHeader(int encodedPacketSize, DefaultConstructorMarker $constructor_marker) {
            this(encodedPacketSize);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/device/AudioDecoder$AudioPacketHeader$Companion;", "", "<init>", "()V", "WIRE_SIZE", "", "deserialize", "Lcom/android/tools/idea/streaming/device/AudioDecoder$AudioPacketHeader;", "buffer", "Ljava/nio/ByteBuffer;", "createBuffer", "intellij.android.streaming"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AudioPacketHeader deserialize(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                int encodedPacketSize = buffer.getInt();
                return new AudioPacketHeader(encodedPacketSize, null);
            }

            @NotNull
            public final ByteBuffer createBuffer() {
                ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
                return byteBuffer;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u000eJ\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/streaming/device/AudioDecoder$AudioPlayer;", "Ljava/lang/Runnable;", "numChannels", "", "sampleRate", "bufferSize", "<init>", "(III)V", "getNumChannels", "()I", "getSampleRate", "getBufferSize", "playQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "", "recycleBin", "stopped", "", "getStopped", "()Z", "setStopped", "(Z)V", "start", "", "play", "data", "stop", "getBuffer", "run", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nAudioDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioDecoder.kt\ncom/android/tools/idea/streaming/device/AudioDecoder$AudioPlayer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,423:1\n40#2,3:424\n*S KotlinDebug\n*F\n+ 1 AudioDecoder.kt\ncom/android/tools/idea/streaming/device/AudioDecoder$AudioPlayer\n*L\n373#1:424,3\n*E\n"})
    private static final class AudioPlayer
    implements Runnable {
        private final int numChannels;
        private final int sampleRate;
        private final int bufferSize;
        @NotNull
        private final ArrayBlockingQueue<byte[]> playQueue;
        @NotNull
        private final ArrayBlockingQueue<byte[]> recycleBin;
        private volatile boolean stopped;

        public AudioPlayer(int numChannels, int sampleRate, int bufferSize) {
            this.numChannels = numChannels;
            this.sampleRate = sampleRate;
            this.bufferSize = bufferSize;
            this.playQueue = new ArrayBlockingQueue(2);
            this.recycleBin = new ArrayBlockingQueue(2);
            for (int i = 0; i < 2; ++i) {
                this.recycleBin.put(new byte[this.bufferSize]);
            }
        }

        public final int getNumChannels() {
            return this.numChannels;
        }

        public final int getSampleRate() {
            return this.sampleRate;
        }

        public final int getBufferSize() {
            return this.bufferSize;
        }

        public final boolean getStopped() {
            return this.stopped;
        }

        public final void setStopped(boolean bl) {
            this.stopped = bl;
        }

        public final void start() {
            new Thread((Runnable)this, this.getClass().getSimpleName()).start();
        }

        public final void play(@NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.playQueue.put(data2);
        }

        public final void stop() {
            this.stopped = true;
            this.playQueue.drainTo((Collection<byte[]>)this.recycleBin);
        }

        @NotNull
        public final byte[] getBuffer() {
            byte[] byArray = this.recycleBin.take();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"take(...)");
            return byArray;
        }

        @Override
        public void run() {
            AudioFormat audioFormat = new AudioFormat(this.sampleRate, 16, this.numChannels, true, false);
            boolean $i$f$service = false;
            Class<AudioSystemService> serviceClass$iv = AudioSystemService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            SourceDataLine sourceLine = ((AudioSystemService)object).getSourceDataLine(audioFormat);
            sourceLine.open(audioFormat);
            sourceLine.start();
            while (!this.stopped) {
                byte[] buffer = this.playQueue.take();
                sourceLine.write(buffer, 0, buffer.length);
                this.recycleBin.put(buffer);
            }
            sourceLine.flush();
            sourceLine.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rH\u0002J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/streaming/device/AudioDecoder$DecodingContext;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "(Lcom/android/tools/idea/streaming/device/AudioDecoder;)V", "codecContext", "Lorg/bytedeco/ffmpeg/avcodec/AVCodecContext;", "decodingFrame", "Lorg/bytedeco/ffmpeg/avutil/AVFrame;", "outFrame", "parserContext", "Lorg/bytedeco/ffmpeg/avcodec/AVCodecParserContext;", "pendingPacket", "Lorg/bytedeco/ffmpeg/avcodec/AVPacket;", "hasPendingPacket", "", "swrContext", "Lorg/bytedeco/ffmpeg/swresample/SwrContext;", "player", "Lcom/android/tools/idea/streaming/device/AudioDecoder$AudioPlayer;", "closeAsynchronously", "", "close", "processPacket", "packet", "processDataPacket", "processFrame", "createSwrContext", "channelLayout", "Lorg/bytedeco/ffmpeg/avutil/AVChannelLayout;", "sampleFormat", "", "sampleRate", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nAudioDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioDecoder.kt\ncom/android/tools/idea/streaming/device/AudioDecoder$DecodingContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n1#2:424\n*E\n"})
    private final class DecodingContext
    implements AutoCloseable {
        @NotNull
        private AVCodecContext codecContext;
        @NotNull
        private final AVFrame decodingFrame;
        @NotNull
        private final AVFrame outFrame;
        @NotNull
        private AVCodecParserContext parserContext;
        @NotNull
        private final AVPacket pendingPacket;
        private boolean hasPendingPacket;
        @NotNull
        private SwrContext swrContext;
        @Nullable
        private AudioPlayer player;

        public DecodingContext() {
            AVFrame aVFrame = avutil.av_frame_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVFrame, (String)"av_frame_alloc(...)");
            this.decodingFrame = aVFrame;
            AVFrame aVFrame2 = avutil.av_frame_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVFrame2, (String)"av_frame_alloc(...)");
            this.outFrame = aVFrame2;
            AVPacket aVPacket = avcodec.av_packet_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVPacket, (String)"av_packet_alloc(...)");
            this.pendingPacket = aVPacket;
            this.swrContext = new SwrContext();
            AVCodec aVCodec = avcodec.avcodec_find_decoder((int)86076);
            if (aVCodec == null) {
                throw new AudioDecoderException("Opus decoder not found");
            }
            AVCodec codec = aVCodec;
            AVCodecContext codecContext = null;
            AVCodecParserContext parserContext = null;
            try {
                AVCodecParserContext aVCodecParserContext;
                AVCodecContext aVCodecContext = avcodec.avcodec_alloc_context3((AVCodec)codec);
                if (aVCodecContext == null) {
                    throw new AudioDecoderException("Could not allocate decoder context");
                }
                codecContext = aVCodecContext;
                AVCodecParserContext aVCodecParserContext2 = avcodec.av_parser_init((int)codec.id());
                if (aVCodecParserContext2 == null) {
                    throw new AudioDecoderException("Could not initialize parser");
                }
                AVCodecParserContext $this$_init__u24lambda_u240 = aVCodecParserContext = aVCodecParserContext2;
                boolean bl = false;
                $this$_init__u24lambda_u240.flags($this$_init__u24lambda_u240.flags() | 1);
                parserContext = aVCodecParserContext;
                if (avcodec.avcodec_open2((AVCodecContext)codecContext, (AVCodec)codec, null) < 0) {
                    throw new AudioDecoderException("Could not open codec " + codec.name());
                }
            }
            catch (AudioDecoderException e) {
                avcodec.av_parser_close(parserContext);
                avcodec.avcodec_free_context((AVCodecContext)codecContext);
                throw e;
            }
            this.codecContext = codecContext;
            this.parserContext = parserContext;
        }

        public final void closeAsynchronously() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> DecodingContext.closeAsynchronously$lambda$0(this));
        }

        @Override
        public synchronized void close() {
            AudioPlayer audioPlayer = this.player;
            if (audioPlayer != null) {
                audioPlayer.stop();
            }
            if (!this.swrContext.isNull()) {
                swresample.swr_close((SwrContext)this.swrContext);
            }
            avcodec.av_parser_close((AVCodecParserContext)this.parserContext);
            avcodec.avcodec_close((AVCodecContext)this.codecContext);
            avcodec.avcodec_free_context((AVCodecContext)this.codecContext);
            avutil.av_frame_free((AVFrame)this.decodingFrame);
            avutil.av_frame_free((AVFrame)this.outFrame);
            avcodec.av_packet_free((AVPacket)this.pendingPacket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void processPacket(@NotNull AVPacket packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            boolean isConfig = packet.pts() == avutil.AV_NOPTS_VALUE;
            AVPacket packetToProcess = packet;
            if (this.hasPendingPacket || isConfig) {
                int offset = 0;
                if (this.hasPendingPacket) {
                    offset = this.pendingPacket.size();
                    if (avcodec.av_grow_packet((AVPacket)this.pendingPacket, (int)packet.size()) != 0) {
                        throw new AudioDecoderException("Could not grow packet");
                    }
                } else {
                    offset = 0;
                    if (avcodec.av_new_packet((AVPacket)this.pendingPacket, (int)packet.size()) != 0) {
                        throw new AudioDecoderException("Could not create audio packet");
                    }
                    this.hasPendingPacket = true;
                }
                Pointer.memcpy((Pointer)((Pointer)this.pendingPacket.data().position((long)offset)), (Pointer)((Pointer)packet.data()), (long)packet.size());
                if (!isConfig) {
                    this.pendingPacket.pts(packet.pts());
                    this.pendingPacket.dts(packet.dts());
                    this.pendingPacket.flags(packet.flags());
                    packetToProcess = this.pendingPacket;
                }
            }
            if (!isConfig) {
                try {
                    this.processDataPacket(packetToProcess);
                }
                finally {
                    if (this.hasPendingPacket) {
                        this.hasPendingPacket = false;
                        if (!Intrinsics.areEqual((Object)this.pendingPacket, (Object)packet)) {
                            avcodec.av_packet_unref((AVPacket)this.pendingPacket);
                        }
                    }
                }
            }
        }

        private final void processDataPacket(AVPacket packet) {
            BytePointer outData = new BytePointer();
            int[] nArray = new int[]{0};
            IntPointer outLen = new IntPointer(nArray);
            int ret = avcodec.av_parser_parse2((AVCodecParserContext)this.parserContext, (AVCodecContext)this.codecContext, (BytePointer)outData, (IntPointer)outLen, (BytePointer)packet.data(), (int)packet.size(), (long)avutil.AV_NOPTS_VALUE, (long)avutil.AV_NOPTS_VALUE, (long)-1L);
            if (outLen.get() > 0) {
                boolean bl;
                boolean bl2 = bl = ret == packet.size();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl3 = bl = outLen.get() == packet.size();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (this.parserContext.key_frame() == 1) {
                    packet.flags(packet.flags() | 1);
                }
                this.processFrame(packet);
            }
        }

        private final void processFrame(AVPacket packet) {
            int r;
            int ret = avcodec.avcodec_send_packet((AVCodecContext)this.codecContext, (AVPacket)packet);
            if (ret < 0) {
                throw new AudioDecoderException("Audio packet was rejected by the decoder: " + ret + " " + AudioDecoderKt.access$toDebugString(packet));
            }
            if (avcodec.avcodec_receive_frame((AVCodecContext)this.codecContext, (AVFrame)this.decodingFrame) != 0) {
                throw new AudioDecoderException("Could not receive audio frame");
            }
            AVChannelLayout channelLayout = this.decodingFrame.ch_layout();
            int sampleFormat = this.decodingFrame.format();
            int sampleRate = this.decodingFrame.sample_rate();
            this.outFrame.ch_layout(channelLayout);
            this.outFrame.sample_rate(sampleRate);
            this.outFrame.format(1);
            if (this.swrContext.isNull()) {
                Intrinsics.checkNotNull((Object)channelLayout);
                this.swrContext = this.createSwrContext(channelLayout, sampleFormat, sampleRate);
            }
            if ((r = swresample.swr_convert_frame((SwrContext)this.swrContext, (AVFrame)this.outFrame, (AVFrame)this.decodingFrame)) < 0) {
                throw new AudioDecoderException("Could not convert audio frame to 16-bit format");
            }
            int numChannels = channelLayout.nb_channels();
            int bufferSize = this.outFrame.nb_samples() * 2 * numChannels;
            AudioPlayer player = this.player;
            if (player == null || numChannels != player.getNumChannels() || sampleRate != player.getSampleRate() || bufferSize != player.getBufferSize()) {
                AudioPlayer audioPlayer;
                AudioPlayer audioPlayer2 = player;
                if (audioPlayer2 != null) {
                    audioPlayer2.stop();
                }
                AudioPlayer it = audioPlayer = new AudioPlayer(numChannels, sampleRate, bufferSize);
                boolean bl = false;
                this.player = it;
                player = audioPlayer;
                player.start();
            }
            byte[] buffer = player.getBuffer();
            this.outFrame.extended_data(0).get(buffer);
            player.play(buffer);
        }

        private final SwrContext createSwrContext(AVChannelLayout channelLayout, int sampleFormat, int sampleRate) {
            SwrContext context = swresample.swr_alloc();
            long channelLayoutMask = channelLayout.u_mask();
            avutil.av_opt_set_int((Pointer)((Pointer)context), (String)"in_channel_layout", (long)channelLayoutMask, (int)0);
            avutil.av_opt_set_int((Pointer)((Pointer)context), (String)"out_channel_layout", (long)channelLayoutMask, (int)0);
            long longSampleRate = sampleRate;
            avutil.av_opt_set_int((Pointer)((Pointer)context), (String)"in_sample_rate", (long)longSampleRate, (int)0);
            avutil.av_opt_set_int((Pointer)((Pointer)context), (String)"out_sample_rate", (long)longSampleRate, (int)0);
            avutil.av_opt_set_sample_fmt((Pointer)((Pointer)context), (String)"in_sample_fmt", (int)sampleFormat, (int)0);
            avutil.av_opt_set_sample_fmt((Pointer)((Pointer)context), (String)"out_sample_fmt", (int)1, (int)0);
            swresample.swr_init((SwrContext)context);
            Intrinsics.checkNotNull((Object)context);
            return context;
        }

        private static final void closeAsynchronously$lambda$0(DecodingContext this$0) {
            this$0.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\t\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/device/AudioDecoder$PacketReader;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "(Lcom/android/tools/idea/streaming/device/AudioDecoder;)V", "headerBuffer", "Ljava/nio/ByteBuffer;", "packet", "Lorg/bytedeco/ffmpeg/avcodec/AVPacket;", "readAndProcessPacket", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nAudioDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioDecoder.kt\ncom/android/tools/idea/streaming/device/AudioDecoder$PacketReader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,423:1\n24#2:424\n*S KotlinDebug\n*F\n+ 1 AudioDecoder.kt\ncom/android/tools/idea/streaming/device/AudioDecoder$PacketReader\n*L\n145#1:424\n*E\n"})
    private final class PacketReader
    implements AutoCloseable {
        @NotNull
        private final ByteBuffer headerBuffer = AudioPacketHeader.Companion.createBuffer();
        @NotNull
        private final AVPacket packet;

        public PacketReader() {
            AVPacket aVPacket = avcodec.av_packet_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVPacket, (String)"av_packet_alloc(...)");
            this.packet = aVPacket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object readAndProcessPacket(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof readAndProcessPacket.1)) ** GOTO lbl-1000
            var7_2 = $completion;
            if ((var7_2.label & -2147483648) != 0) {
                var7_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ PacketReader this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.readAndProcessPacket((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = SuspendingSocketChannel.readFully$default(AudioDecoder.access$getAudioChannel$p(AudioDecoder.this), this.headerBuffer, 0L, null, (Continuation)$continuation, 6, null);
                    if (v0 == var8_4) {
                        return var8_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    this.headerBuffer.rewind();
                    header = AudioPacketHeader.Companion.deserialize(this.headerBuffer);
                    packetSize = header.getPacketSize();
                    this.headerBuffer.clear();
                    if (avcodec.av_new_packet((AVPacket)this.packet, (int)packetSize) != 0) {
                        throw new AudioDecoderException("Could not allocate packet of " + packetSize + " bytes");
                    }
                    v1 = AudioDecoder.access$getAudioChannel$p(AudioDecoder.this);
                    v2 = this.packet.data();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"data(...)");
                    $continuation.L$0 = header;
                    $continuation.label = 2;
                    v3 = SuspendingSocketChannel.readFully$default(v1, AudioDecoderKt.access$asByteBufferOfSize((Pointer)v2, packetSize), 0L, null, (Continuation)$continuation, 6, null);
                    ** if (v3 != var8_4) goto lbl38
lbl37:
                    // 1 sources

                    return var8_4;
lbl38:
                    // 1 sources

                    ** GOTO lbl45
                }
                case 2: {
                    header = (AudioPacketHeader)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl45:
                        // 2 sources

                        this.packet.pts(header.isConfig() != false ? avutil.AV_NOPTS_VALUE : 0L);
                        v4 = (DecodingContext)AudioDecoder.access$getDecodingContext$p(AudioDecoder.this).get();
                        if (v4 == null) ** GOTO lbl50
                        v4.processPacket(this.packet);
                    }
                    catch (AudioDecoderException e) {
                        $i$f$thisLogger = false;
                        v5 = Logger.getInstance(PacketReader.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                        v5.error((Throwable)e);
                        ** GOTO lbl64
                    }
lbl50:
                    // 2 sources

                    avcodec.av_packet_unref((AVPacket)this.packet);
                    ** GOTO lbl64
                }
                {
                    finally {
                        avcodec.av_packet_unref((AVPacket)this.packet);
                    }
                }
lbl64:
                // 2 sources

                return Unit.INSTANCE;
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        public void close() {
            avcodec.av_packet_free((AVPacket)this.packet);
        }
    }
}

