/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.DeviceMirroringSettingsListener;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.EmulatorSettingsListener;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.settings.DeviceMirroringSettingsPage;
import com.android.tools.idea.streaming.emulator.settings.EmulatorSettingsPage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import icons.StudioIllustrations;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/streaming/core/EmptyStatePanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "disposableParent", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "emulatorLaunchesInToolWindow", "", "getEmulatorLaunchesInToolWindow", "()Z", "activateOnConnection", "getActivateOnConnection", "createContent", "", "createSpacer", "updateContent", "updateUI", "dispose", "Companion", "intellij.android.streaming"})
public final class EmptyStatePanel
extends JBPanel<EmptyStatePanel>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @TestOnly
    @Nullable
    private static final AtomicInteger asyncActivityCount = ApplicationManager.getApplication().isUnitTestMode() ? new AtomicInteger() : null;

    public EmptyStatePanel(@NotNull Project project, @NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        super((LayoutManager)new GridBagLayout());
        this.project = project;
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.setOpaque(true);
        this.setBorder((Border)JBUI.Borders.empty());
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_B458422581_LOGGING.get()).booleanValue()) {
                    EmptyStatePanel $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(EmptyStatePanel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("EmptyStatePanel.mousePressed: requesting focus");
                }
                this.requestFocusInWindow();
            }
        });
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic<EmulatorSettingsListener> topic = EmulatorSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> EmptyStatePanel._init_$lambda$0(this, arg_0));
        Topic<DeviceMirroringSettingsListener> topic2 = DeviceMirroringSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, arg_0 -> EmptyStatePanel._init_$lambda$1(this, arg_0));
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(EmptyStatePanel.class);
        Disposer.register((Disposable)this, () -> EmptyStatePanel._init_$lambda$2(progress2));
        this.updateContent();
    }

    private final boolean getEmulatorLaunchesInToolWindow() {
        return EmulatorSettings.Companion.getInstance().getLaunchInToolWindow();
    }

    private final boolean getActivateOnConnection() {
        return DeviceMirroringSettings.Companion.getInstance().getActivateOnConnection();
    }

    private final void createContent() {
        Object object;
        JEditorPane jEditorPane;
        String string = Integer.toString(JBUI.CurrentTheme.Link.Foreground.ENABLED.getRGB() & 0xFFFFFF, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String linkColorString = string;
        String string2 = Integer.toString(AdtUiUtils.INSTANCE.getTITLE_COLOR().getRGB() & 0xFFFFFF, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String titleColorString = string2;
        String plusSign = "<font color = " + titleColorString + " size=\"+1\"><b>&#xFF0B;</b></font>";
        String virtualFragment = this.getEmulatorLaunchesInToolWindow() ? "To launch a&nbsp;virtual device, click " + plusSign + " and select the device from the list, or use the&nbsp;<font color = " + linkColorString + "><a href='DeviceManager'>Device&nbsp;Manager</a></font>." : "To launch a&nbsp;virtual device, click " + plusSign + " and select a virtual device, or select the&nbsp;<b>Launch in the&nbsp;Running&nbsp;Devices tool window</b> option in&nbsp;the&nbsp;<font color = " + linkColorString + "><a href='EmulatorSettings'>Emulator&nbsp;settings</a></font> and use the&nbsp;<font color = " + linkColorString + "><a href='DeviceManager'>Device&nbsp;Manager</a></font>.";
        String physicalFragment = this.getActivateOnConnection() ? "To mirror a&nbsp;physical device, connect it via USB cable or over WiFi." : "To mirror a&nbsp;physical device, connect it via USB cable or over WiFi, click " + plusSign + " and select the&nbsp;device from the&nbsp;list. You may also select the&nbsp;<b>Activate mirroring when a&nbsp;new physical device is connected</b> option in&nbsp;the&nbsp;<font color = " + linkColorString + "><a href='DeviceMirroringSettings'>Device&nbsp;Mirroring&nbsp;settings</a></font>.";
        String html = StringsKt.trimIndent((String)("\n      <center>\n      <p>" + physicalFragment + "</p>\n      <p/>\n      <p>" + virtualFragment + "</p>\n      </center>\n      "));
        HyperlinkEventAction hyperlinkAction = arg_0 -> EmptyStatePanel.createContent$lambda$0(this, arg_0);
        Serializable $this$createContent_u24lambda_u241 = jEditorPane = StreamingUtilsKt.textComponent$default(html, 0, hyperlinkAction, 2, null);
        boolean bl = false;
        $this$createContent_u24lambda_u241.setFont((Font)AdtUiUtils.EMPTY_TOOL_WINDOW_FONT);
        $this$createContent_u24lambda_u241.setForeground(StandardColors.PLACEHOLDER_TEXT_COLOR);
        JEditorPane textComponent = jEditorPane;
        Serializable $this$createContent_u24lambda_u242 = $this$createContent_u24lambda_u241 = new GridBagConstraints();
        boolean bl2 = false;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).fill = 1;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).gridx = 1;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).gridy = 0;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).weightx = 0.7;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).weighty = 0.45;
        Serializable c = $this$createContent_u24lambda_u241;
        JBLabel $this$createContent_u24lambda_u243 = object = new JBLabel(StudioIllustrations.Common.DEVICES_LINEUP);
        boolean bl3 = false;
        $this$createContent_u24lambda_u243.setHorizontalAlignment(0);
        $this$createContent_u24lambda_u243.setVerticalAlignment(3);
        $this$createContent_u24lambda_u243.setBorder((Border)JBUI.Borders.emptyBottom((int)16));
        JBLabel icon = object;
        this.add((Component)icon, c);
        Object $this$createContent_u24lambda_u244 = object = c;
        boolean bl4 = false;
        $this$createContent_u24lambda_u244.gridx = 1;
        $this$createContent_u24lambda_u244.gridy = 1;
        $this$createContent_u24lambda_u244.weighty = 0.55;
        this.add(textComponent, c);
        Object $this$createContent_u24lambda_u245 = object = c;
        boolean bl5 = false;
        $this$createContent_u24lambda_u245.gridx = 0;
        $this$createContent_u24lambda_u245.weightx = 0.15;
        this.add((Component)this.createSpacer(), c);
        Object $this$createContent_u24lambda_u246 = object = c;
        boolean bl6 = false;
        $this$createContent_u24lambda_u246.gridx = 2;
        this.add((Component)this.createSpacer(), c);
    }

    private final JBPanel<?> createSpacer() {
        JBPanel jBPanel = new JBPanel().withBorder((Border)JBUI.Borders.empty()).withMinimumWidth(0).withMinimumHeight(0).withPreferredSize(JBUI.scale((int)24), 0).andTransparent();
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"andTransparent(...)");
        return jBPanel;
    }

    private final void updateContent() {
        this.removeAll();
        this.createContent();
        this.validate();
    }

    public void updateUI() {
        super.updateUI();
        this.updateContent();
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(EmptyStatePanel this$0, EmulatorSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateContent();
    }

    private static final void _init_$lambda$1(EmptyStatePanel this$0, DeviceMirroringSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateContent();
    }

    private static final void _init_$lambda$2(StudioLoggerProgressIndicator $progress) {
        $progress.cancel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void createContent$lambda$0(EmptyStatePanel this$0, HyperlinkEvent event) {
        block6: {
            String string;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) || (string = event.getDescription()) == null) return;
            switch (string.hashCode()) {
                case -254444240: {
                    if (!string.equals("DeviceMirroringSettings")) {
                        return;
                    }
                    break block6;
                }
                case -1778371976: {
                    if (string.equals("EmulatorSettings")) break;
                    return;
                }
                case 515705943: {
                    if (!string.equals("DeviceManager")) return;
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Device Manager 2");
                    if (toolWindow == null) return;
                    toolWindow.show(null);
                    return;
                }
            }
            ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, EmulatorSettingsPage.class);
            return;
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, DeviceMirroringSettingsPage.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/core/EmptyStatePanel$Companion;", "", "<init>", "()V", "asyncActivityCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAsyncActivityCount$intellij_android_streaming", "()Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AtomicInteger getAsyncActivityCount$intellij_android_streaming() {
            return asyncActivityCount;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

