/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.streaming.core.AndroidInputEvent;
import com.android.tools.idea.streaming.core.DeviceInputListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\u0016JF\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R:\u0010\b\u001a.\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\r\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/streaming/core/DeviceInputListenerDispatcher;", "", "deviceSerialNumber", "", "<init>", "(Ljava/lang/String;)V", "getDeviceSerialNumber", "()Ljava/lang/String;", "listeners", "", "Lcom/android/tools/idea/streaming/core/DeviceInputListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "draggingOnDisplays", "Lit/unimi/dsi/fastutil/ints/IntArraySet;", "addListener", "", "listener", "removeListener", "", "hasListeners", "notifyListenersOfTouchEvent", "displayId", "", "displayWidth", "displayHeight", "displayOrientation", "x", "y", "endOfTouch", "multiTouch", "intellij.android.streaming"})
final class DeviceInputListenerDispatcher {
    @NotNull
    private final String deviceSerialNumber;
    @NotNull
    private final List<DeviceInputListener> listeners;
    @NotNull
    private final ExecutorService backgroundExecutor;
    @NotNull
    private final IntArraySet draggingOnDisplays;

    public DeviceInputListenerDispatcher(@NotNull String deviceSerialNumber) {
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        this.deviceSerialNumber = deviceSerialNumber;
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list2;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)("DeviceInputListenerDispatcher(" + this.deviceSerialNumber + ")"), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.backgroundExecutor = executorService;
        this.draggingOnDisplays = new IntArraySet();
    }

    @NotNull
    public final String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public final void addListener(@NotNull DeviceInputListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final boolean removeListener(@NotNull DeviceInputListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.listeners.remove(listener2);
    }

    public final boolean hasListeners() {
        return !((Collection)this.listeners).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void notifyListenersOfTouchEvent(int displayId, int displayWidth, int displayHeight, int displayOrientation, int x, int y, boolean endOfTouch, boolean multiTouch) {
        List list2;
        long timestamp = System.currentTimeMillis();
        AndroidInputEvent.DisplayInfo display = new AndroidInputEvent.DisplayInfo(displayId, displayWidth, displayHeight, displayOrientation);
        if (endOfTouch) {
            if (!this.draggingOnDisplays.remove(displayId)) return;
            list2 = CollectionsKt.emptyList();
        } else if (multiTouch) {
            this.draggingOnDisplays.add(displayId);
            Object[] objectArray = new AndroidInputEvent.TouchEvent.Touch[]{new AndroidInputEvent.TouchEvent.Touch(x, y, 0), new AndroidInputEvent.TouchEvent.Touch(displayWidth - 1 - x, displayHeight - 1 - y, 1)};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            this.draggingOnDisplays.add(displayId);
            list2 = CollectionsKt.listOf((Object)new AndroidInputEvent.TouchEvent.Touch(x, y, 0));
        }
        List touches = list2;
        AndroidInputEvent.TouchEvent event = new AndroidInputEvent.TouchEvent(this.deviceSerialNumber, display, timestamp, touches);
        this.backgroundExecutor.submit(() -> DeviceInputListenerDispatcher.notifyListenersOfTouchEvent$lambda$0(this, event));
    }

    private static final void notifyListenersOfTouchEvent$lambda$0(DeviceInputListenerDispatcher this$0, AndroidInputEvent.TouchEvent $event) {
        for (DeviceInputListener listener2 : this$0.listeners) {
            listener2.eventSent($event);
        }
    }
}

