/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.actions;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.idea.streaming.actions.ZoomLevelIndicatorKt;
import com.android.tools.idea.streaming.core.FloatingToolbarContainer;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/streaming/actions/ZoomLevelIndicator;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "MyActionButton", "TextPainter", "intellij.android.streaming"})
public final class ZoomLevelIndicator
extends DumbAwareAction
implements CustomComponentAction {
    public ZoomLevelIndicator() {
        super(EmptyIcon.ICON_16);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Zoomable zoomable = (Zoomable)event.getData(ZoomableKt.ZOOMABLE_KEY);
        presentation2.setEnabledAndVisible(zoomable != null);
        if (zoomable != null) {
            double scale = zoomable.getScale();
            Locale locale = Locale.ROOT;
            String string = "%d%%";
            Object[] objectArray = new Object[]{MathKt.roundToInt((double)(scale * (double)100))};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String scaleText = string2;
            presentation2.setText("Zoom Level: " + scaleText);
            presentation2.setDescription(scaleText);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FloatingToolbarContainer.Companion.toggleActiveState(event);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return (JComponent)((Object)new MyActionButton((AnAction)this, presentation, place));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/streaming/actions/ZoomLevelIndicator$MyActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;)V", "myCachedTextPainter", "Lcom/android/tools/idea/streaming/actions/ZoomLevelIndicator$TextPainter;", "textPainter", "getTextPainter", "()Lcom/android/tools/idea/streaming/actions/ZoomLevelIndicator$TextPainter;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nZoomLevelIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZoomLevelIndicator.kt\ncom/android/tools/idea/streaming/actions/ZoomLevelIndicator$MyActionButton\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
    private static final class MyActionButton
    extends ActionButton {
        @Nullable
        private TextPainter myCachedTextPainter;

        public MyActionButton(@NotNull AnAction action2, @NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            super(action2, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        }

        private final TextPainter getTextPainter() {
            TextPainter textPainter;
            String text2;
            block6: {
                block5: {
                    String string = this.getPresentation().getDescription();
                    if (string == null) {
                        string = "";
                    }
                    text2 = string;
                    TextPainter textPainter2 = this.myCachedTextPainter;
                    if (!Intrinsics.areEqual((Object)(textPainter2 != null ? textPainter2.getBaseFont() : null), (Object)this.getFont())) break block5;
                    TextPainter textPainter3 = this.myCachedTextPainter;
                    if (Intrinsics.areEqual((Object)(textPainter3 != null ? textPainter3.getText() : null), (Object)text2)) break block6;
                }
                this.myCachedTextPainter = null;
            }
            if ((textPainter = this.myCachedTextPainter) == null) {
                TextPainter textPainter4;
                Font font = this.getFont();
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
                TextPainter it = textPainter4 = new TextPainter(font, text2, this.getWidth());
                boolean bl = false;
                this.myCachedTextPainter = it;
                textPainter = textPainter4;
            }
            return textPainter;
        }

        public void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2 = (Graphics2D)graphics;
            g2.setColor(this.getForeground());
            this.getTextPainter().paintText(g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012J\u001c\u0010\u0018\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/streaming/actions/ZoomLevelIndicator$TextPainter;", "", "baseFont", "Ljava/awt/Font;", "text", "", "maxWidth", "", "<init>", "(Ljava/awt/Font;Ljava/lang/String;I)V", "getBaseFont", "()Ljava/awt/Font;", "getText", "()Ljava/lang/String;", "fontRenderContext", "Ljava/awt/font/FontRenderContext;", "adjustedFont", "textBounds", "Ljava/awt/Rectangle;", "paintText", "", "g", "Ljava/awt/Graphics2D;", "centerIn", "squeezeToFit", "computeTextWidth", "font", "scale", "", "computeTextBounds", "intellij.android.streaming"})
    private static final class TextPainter {
        @NotNull
        private final Font baseFont;
        @NotNull
        private final String text;
        @NotNull
        private final FontRenderContext fontRenderContext;
        @NotNull
        private final Font adjustedFont;
        @NotNull
        private final Rectangle textBounds;

        public TextPainter(@NotNull Font baseFont, @NotNull String text2, int maxWidth) {
            Intrinsics.checkNotNullParameter((Object)baseFont, (String)"baseFont");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.baseFont = baseFont;
            this.text = text2;
            this.fontRenderContext = ZoomLevelIndicatorKt.access$createFontRenderContext();
            this.adjustedFont = this.squeezeToFit(this.baseFont, this.text, maxWidth);
            this.textBounds = this.computeTextBounds(this.adjustedFont, this.text);
        }

        @NotNull
        public final Font getBaseFont() {
            return this.baseFont;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void paintText(@NotNull Graphics2D g, @NotNull Rectangle centerIn) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)centerIn, (String)"centerIn");
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.fontRenderContext.getAntiAliasingHint());
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.fontRenderContext.getFractionalMetricsHint());
            Object object = UIManager.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
            if (object == null) {
                object = UIUtil.getLcdContrastValue();
            }
            Object textLcdContrast = object;
            g.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, textLcdContrast);
            g.setFont(this.adjustedFont);
            Rectangle textBounds = this.textBounds;
            int textX = centerIn.x - textBounds.x + (centerIn.width - textBounds.width) / 2;
            int textY = centerIn.y - textBounds.y + (centerIn.height - textBounds.height) / 2;
            g.drawString(this.text, textX, textY);
        }

        private final Font squeezeToFit(Font $this$squeezeToFit, String text2, int maxWidth) {
            double scale = 1.0;
            int textWidth = this.computeTextWidth(text2, $this$squeezeToFit, scale);
            while (textWidth > maxWidth) {
                textWidth = this.computeTextWidth(text2, $this$squeezeToFit, scale /= (double)2);
            }
            if (textWidth < maxWidth) {
                double newScale;
                double minScale = scale;
                double maxScale = 1.0;
                while (!((newScale = (minScale + maxScale) / (double)2) == scale)) {
                    scale = newScale;
                    textWidth = this.computeTextWidth(text2, $this$squeezeToFit, scale);
                    if (textWidth < maxWidth) {
                        minScale = scale;
                        continue;
                    }
                    if (textWidth <= maxWidth) break;
                    maxScale = scale;
                }
                if (textWidth > maxWidth) {
                    scale = minScale;
                }
            }
            return ZoomLevelIndicatorKt.access$scaled($this$squeezeToFit, scale);
        }

        private final int computeTextWidth(String text2, Font font, double scale) {
            return this.computeTextBounds((Font)ZoomLevelIndicatorKt.access$scaled((Font)font, (double)scale), (String)text2).width;
        }

        private final Rectangle computeTextBounds(Font font, String text2) {
            return ZoomLevelIndicatorKt.access$computePixelBounds(font, text2, this.fontRenderContext);
        }
    }
}

