/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.jdbc;

import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSetKt;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcSqliteResultSet;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteQueryResult;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.google.common.util.concurrent.ListenableFuture;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/LazyJdbcSqliteResultSet;", "Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcSqliteResultSet;", "taskExecutor", "Ljava/util/concurrent/Executor;", "connection", "Ljava/sql/Connection;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "<init>", "(Ljava/util/concurrent/Executor;Ljava/sql/Connection;Lcom/android/tools/idea/sqlite/model/SqliteStatement;)V", "totalRowCount", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "getTotalRowCount", "()Lcom/google/common/util/concurrent/ListenableFuture;", "getRowBatch", "Lcom/android/tools/idea/sqlite/model/SqliteQueryResult;", "rowOffset", "rowBatchSize", "app-inspection.inspectors.database"})
public final class LazyJdbcSqliteResultSet
extends JdbcSqliteResultSet {
    @NotNull
    private final SqliteStatement sqliteStatement;

    public LazyJdbcSqliteResultSet(@NotNull Executor taskExecutor, @NotNull Connection connection2, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        super(taskExecutor, connection2, sqliteStatement);
        this.sqliteStatement = sqliteStatement;
    }

    @Override
    @NotNull
    public ListenableFuture<Integer> getTotalRowCount() {
        return this.getRowCount(this.sqliteStatement, (Function1<? super ResultSet, Integer>)((Function1)LazyJdbcSqliteResultSet::_get_totalRowCount_$lambda$0));
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteQueryResult> getRowBatch(int rowOffset, int rowBatchSize) {
        SqliteResultSetKt.checkOffsetAndSize(rowOffset, rowBatchSize);
        return this.getRowBatch(this.sqliteStatement, (Function2<? super ResultSet, ? super List<ResultSetSqliteColumn>, ? extends List<SqliteRow>>)((Function2)(arg_0, arg_1) -> LazyJdbcSqliteResultSet.getRowBatch$lambda$0(this, rowOffset, rowBatchSize, arg_0, arg_1)));
    }

    private static final int _get_totalRowCount_$lambda$0(ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int rowCount = 0;
        while (it.next()) {
            ++rowCount;
        }
        return rowCount;
    }

    private static final List getRowBatch$lambda$0(LazyJdbcSqliteResultSet this$0, int $rowOffset, int $rowBatchSize, ResultSet resultSet, List columns2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        ArrayList<SqliteRow> rows = new ArrayList<SqliteRow>();
        while (resultSet.next()) {
            rows.add(this$0.createCurrentRow(resultSet, columns2));
        }
        List list2 = rows.subList($rowOffset, Math.min($rowOffset + $rowBatchSize, rows.size()));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"subList(...)");
        return list2;
    }
}

