/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionConnectionException;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorController;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.model.ExportDialogParams;
import com.android.tools.idea.sqlite.model.ModelKt;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteQueryResult;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.android.tools.idea.sqlite.repository.DatabaseRepository;
import com.android.tools.idea.sqlite.ui.tableView.OrderBy;
import com.android.tools.idea.sqlite.ui.tableView.RowDiffOperation;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.android.tools.idea.sqlite.ui.tableView.ViewColumn;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001FB\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120/J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120/H\u0016J\b\u00102\u001a\u00020\u0012H\u0016J\b\u00103\u001a\u00020\u0012H\u0016J\b\u00104\u001a\u00020\u001aH\u0016J\b\u00105\u001a\u00020\u0005H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00120/H\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00120/H\u0002J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120/H\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00120/H\u0002J&\u0010:\u001a\b\u0012\u0004\u0012\u00020;0*2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020\u0005H\u0002J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00120/2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00120/H\u0002J\b\u0010A\u001a\u00020\u001aH\u0002J$\u0010B\u001a\b\u0012\u0004\u0012\u00020C0**\b\u0012\u0004\u0012\u00020+0*2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010E\u001a\u00020C*\u00020+2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00060#R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/android/tools/idea/sqlite/controllers/TableController;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$TabController;", "project", "Lcom/intellij/openapi/project/Project;", "rowBatchSize", "", "view", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "tableSupplier", "Lkotlin/Function0;", "Lcom/android/tools/idea/sqlite/model/SqliteTable;", "databaseRepository", "Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "closeTabInvoked", "", "showExportDialog", "Lkotlin/Function1;", "Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "edtExecutor", "Ljava/util/concurrent/Executor;", "taskExecutor", "liveUpdatesEnabled", "", "<init>", "(Lcom/intellij/openapi/project/Project;ILcom/android/tools/idea/sqlite/ui/tableView/TableView;Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;Lkotlin/jvm/functions/Function0;Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;Lcom/android/tools/idea/sqlite/model/SqliteStatement;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Z)V", "getCloseTabInvoked", "()Lkotlin/jvm/functions/Function0;", "isDisposed", "resultSet", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "listener", "Lcom/android/tools/idea/sqlite/controllers/TableController$TableViewListenerImpl;", "orderBy", "Lcom/android/tools/idea/sqlite/ui/tableView/OrderBy;", "rowOffset", "databaseInspectorAnalyticsTracker", "Lcom/android/tools/idea/sqlite/DatabaseInspectorAnalyticsTracker;", "currentCols", "", "Lcom/android/tools/idea/sqlite/model/ResultSetSqliteColumn;", "currentRows", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "refreshDataFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "setUp", "refreshData", "notifyDataMightBeStale", "dispose", "isLiveUpdateEnabled", "getRowBatchSize", "fetchAndDisplayTableData", "updateDataAndButtons", "updateDataAndButtonsWithLoadingScreens", "fetchAndDisplayRows", "performRowsDiff", "Lcom/android/tools/idea/sqlite/ui/tableView/RowDiffOperation$UpdateCell;", "oldRow", "newRow", "rowIndex", "handleFetchRowsError", "future", "isEditable", "toViewColumns", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "table", "toViewColumn", "TableViewListenerImpl", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nTableController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableController.kt\ncom/android/tools/idea/sqlite/controllers/TableController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,455:1\n1563#2:456\n1634#2,3:457\n295#2,2:460\n774#2:462\n865#2,2:463\n1563#2:465\n1634#2,3:466\n*S KotlinDebug\n*F\n+ 1 TableController.kt\ncom/android/tools/idea/sqlite/controllers/TableController\n*L\n438#1:456\n438#1:457,3\n447#1:460,2\n168#1:462\n168#1:463,2\n234#1:465\n234#1:466,3\n*E\n"})
public final class TableController
implements DatabaseInspectorController.TabController {
    private int rowBatchSize;
    @NotNull
    private final TableView view;
    @NotNull
    private final SqliteDatabaseId databaseId;
    @NotNull
    private final Function0<SqliteTable> tableSupplier;
    @NotNull
    private final DatabaseRepository databaseRepository;
    @NotNull
    private final SqliteStatement sqliteStatement;
    @NotNull
    private final Function0<Unit> closeTabInvoked;
    @NotNull
    private final Function1<ExportDialogParams, Unit> showExportDialog;
    @NotNull
    private final Executor edtExecutor;
    @NotNull
    private final Executor taskExecutor;
    private boolean liveUpdatesEnabled;
    private boolean isDisposed;
    private SqliteResultSet resultSet;
    @NotNull
    private final TableViewListenerImpl listener;
    @NotNull
    private OrderBy orderBy;
    private int rowOffset;
    @NotNull
    private final DatabaseInspectorAnalyticsTracker databaseInspectorAnalyticsTracker;
    @NotNull
    private List<ResultSetSqliteColumn> currentCols;
    @NotNull
    private List<SqliteRow> currentRows;
    @NotNull
    private ListenableFuture<Unit> refreshDataFuture;

    public TableController(@NotNull Project project, int rowBatchSize, @NotNull TableView view, @NotNull SqliteDatabaseId databaseId, @NotNull Function0<SqliteTable> tableSupplier, @NotNull DatabaseRepository databaseRepository, @NotNull SqliteStatement sqliteStatement, @NotNull Function0<Unit> closeTabInvoked, @NotNull Function1<? super ExportDialogParams, Unit> showExportDialog2, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor, boolean liveUpdatesEnabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Intrinsics.checkNotNullParameter(tableSupplier, (String)"tableSupplier");
        Intrinsics.checkNotNullParameter((Object)databaseRepository, (String)"databaseRepository");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Intrinsics.checkNotNullParameter(closeTabInvoked, (String)"closeTabInvoked");
        Intrinsics.checkNotNullParameter(showExportDialog2, (String)"showExportDialog");
        Intrinsics.checkNotNullParameter((Object)edtExecutor, (String)"edtExecutor");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.rowBatchSize = rowBatchSize;
        this.view = view;
        this.databaseId = databaseId;
        this.tableSupplier = tableSupplier;
        this.databaseRepository = databaseRepository;
        this.sqliteStatement = sqliteStatement;
        this.closeTabInvoked = closeTabInvoked;
        this.showExportDialog = showExportDialog2;
        this.edtExecutor = edtExecutor;
        this.taskExecutor = taskExecutor;
        this.liveUpdatesEnabled = liveUpdatesEnabled;
        this.listener = new TableViewListenerImpl();
        this.orderBy = OrderBy.NotOrdered.INSTANCE;
        this.databaseInspectorAnalyticsTracker = DatabaseInspectorAnalyticsTracker.Companion.getInstance(project);
        this.currentCols = CollectionsKt.emptyList();
        this.currentRows = CollectionsKt.emptyList();
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        this.refreshDataFuture = listenableFuture;
    }

    public /* synthetic */ TableController(Project project, int n, TableView tableView, SqliteDatabaseId sqliteDatabaseId, Function0 function0, DatabaseRepository databaseRepository, SqliteStatement sqliteStatement, Function0 function02, Function1 function1, Executor executor, Executor executor2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = DatabaseInspectorController.Companion.getDEFAULT_ROW_BATCH_SIZE();
        }
        if ((n2 & 0x800) != 0) {
            bl = false;
        }
        this(project, n, tableView, sqliteDatabaseId, (Function0<SqliteTable>)function0, databaseRepository, sqliteStatement, (Function0<Unit>)function02, (Function1<? super ExportDialogParams, Unit>)function1, executor, executor2, bl);
    }

    @Override
    @NotNull
    public Function0<Unit> getCloseTabInvoked() {
        return this.closeTabInvoked;
    }

    @NotNull
    public final ListenableFuture<Unit> setUp() {
        if (!(this.databaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId)) {
            this.view.setLiveUpdatesButtonState(false);
            this.view.setRefreshButtonState(false);
        }
        this.view.startTableLoading();
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.transformAsync(this.databaseRepository.runQuery(this.databaseId, this.sqliteStatement), (Executor)this.edtExecutor, arg_0 -> TableController.setUp$lambda$0(this, arg_0)), (Disposable)this);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> refreshData() {
        if (!this.refreshDataFuture.isDone()) {
            return this.refreshDataFuture;
        }
        this.view.startTableLoading();
        this.refreshDataFuture = this.fetchAndDisplayTableData();
        return this.refreshDataFuture;
    }

    @Override
    public void notifyDataMightBeStale() {
        if (this.liveUpdatesEnabled && this.refreshDataFuture.isDone()) {
            this.refreshDataFuture = this.fetchAndDisplayTableData();
        }
    }

    public void dispose() {
        this.isDisposed = true;
        this.view.stopTableLoading();
        this.view.removeListener(this.listener);
    }

    @Override
    public boolean isLiveUpdateEnabled() {
        return this.liveUpdatesEnabled;
    }

    @Override
    public int getRowBatchSize() {
        return this.rowBatchSize;
    }

    private final ListenableFuture<Unit> fetchAndDisplayTableData() {
        SqliteResultSet sqliteResultSet = this.resultSet;
        if (sqliteResultSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
            sqliteResultSet = null;
        }
        ListenableFuture fetchTableDataFuture = FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.transformAsync(sqliteResultSet.getColumns(), (Executor)this.edtExecutor, arg_0 -> TableController.fetchAndDisplayTableData$lambda$0(this, arg_0)), (Disposable)this);
        ListenableFuture<Unit> futureCatching = this.handleFetchRowsError((ListenableFuture<Unit>)fetchTableDataFuture);
        ListenableFuture future2 = FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.finallySync(futureCatching, (Executor)this.edtExecutor, () -> TableController.fetchAndDisplayTableData$lambda$1(this)), (Disposable)this);
        ListenableFuture listenableFuture = Futures.transform((ListenableFuture)future2, (Function)Functions.constant((Object)Unit.INSTANCE), (Executor)MoreExecutors.directExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"transform(...)");
        return listenableFuture;
    }

    private final ListenableFuture<Unit> updateDataAndButtons() {
        this.view.setFetchPreviousRowsButtonState(false);
        this.view.setFetchNextRowsButtonState(false);
        return FutureUtils.transform((ListenableFuture)FutureUtils.transformAsync(this.fetchAndDisplayRows(), (Executor)this.taskExecutor, arg_0 -> TableController.updateDataAndButtons$lambda$0(this, arg_0)), (Executor)this.edtExecutor, arg_0 -> TableController.updateDataAndButtons$lambda$1(this, arg_0));
    }

    private final ListenableFuture<Unit> updateDataAndButtonsWithLoadingScreens() {
        this.view.startTableLoading();
        ListenableFuture<Unit> updateDataFuture = this.updateDataAndButtons();
        ListenableFuture future2 = FutureUtils.finallySync(updateDataFuture, (Executor)this.edtExecutor, () -> TableController.updateDataAndButtonsWithLoadingScreens$lambda$0(this));
        return this.handleFetchRowsError((ListenableFuture<Unit>)future2);
    }

    private final ListenableFuture<Unit> fetchAndDisplayRows() {
        SqliteResultSet sqliteResultSet = this.resultSet;
        if (sqliteResultSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
            sqliteResultSet = null;
        }
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.transform(sqliteResultSet.getRowBatch(this.rowOffset, this.rowBatchSize), (Executor)this.edtExecutor, arg_0 -> TableController.fetchAndDisplayRows$lambda$0(this, arg_0)), (Disposable)this);
    }

    private final List<RowDiffOperation.UpdateCell> performRowsDiff(SqliteRow oldRow, SqliteRow newRow, int rowIndex) {
        List cellUpdates = new ArrayList();
        int n = ((Collection)oldRow.getValues()).size();
        for (int colIndex = 0; colIndex < n; ++colIndex) {
            if (Intrinsics.areEqual((Object)oldRow.getValues().get(colIndex), (Object)newRow.getValues().get(colIndex))) continue;
            cellUpdates.add(new RowDiffOperation.UpdateCell(newRow.getValues().get(colIndex), rowIndex, colIndex));
        }
        return cellUpdates;
    }

    private final ListenableFuture<Unit> handleFetchRowsError(ListenableFuture<Unit> future2) {
        FutureUtils.addCallback(future2, (Executor)this.edtExecutor, TableController::handleFetchRowsError$lambda$0, arg_0 -> TableController.handleFetchRowsError$lambda$1(this, arg_0));
        return future2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEditable() {
        if (this.tableSupplier.invoke() == null) return false;
        if (this.liveUpdatesEnabled) return false;
        SqliteTable sqliteTable = (SqliteTable)this.tableSupplier.invoke();
        if (sqliteTable != null ? sqliteTable.isView() : false) return false;
        if (!(this.databaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ViewColumn> toViewColumns(List<ResultSetSqliteColumn> $this$toViewColumns, SqliteTable table2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toViewColumns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultSetSqliteColumn resultSetSqliteColumn = (ResultSetSqliteColumn)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.toViewColumn((ResultSetSqliteColumn)it, table2));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List toViewColumns$default(TableController tableController2, List list2, SqliteTable sqliteTable, int n, Object object) {
        if ((n & 1) != 0) {
            sqliteTable = null;
        }
        return tableController2.toViewColumns(list2, sqliteTable);
    }

    private final ViewColumn toViewColumn(ResultSetSqliteColumn $this$toViewColumn, SqliteTable table2) {
        boolean bl;
        boolean bl2;
        SqliteColumn sqliteColumn;
        Object object = table2;
        if (object != null && (object = ((SqliteTable)object).getColumns()) != null) {
            Object v1;
            block7: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SqliteColumn it = (SqliteColumn)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$toViewColumn.getName())) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            sqliteColumn = v1;
        } else {
            sqliteColumn = null;
        }
        SqliteColumn schemaColumn = sqliteColumn;
        String string = $this$toViewColumn.getName();
        SqliteColumn sqliteColumn2 = schemaColumn;
        if (sqliteColumn2 != null) {
            bl2 = sqliteColumn2.getInPrimaryKey();
        } else {
            Boolean bl4 = $this$toViewColumn.getInPrimaryKey();
            bl2 = bl4 != null ? bl4 : false;
        }
        SqliteColumn sqliteColumn3 = schemaColumn;
        if (sqliteColumn3 != null) {
            bl = sqliteColumn3.isNullable();
        } else {
            Boolean bl5 = $this$toViewColumn.isNullable();
            bl = bl5 != null ? bl5 : true;
        }
        return new ViewColumn(string, bl2, bl);
    }

    static /* synthetic */ ViewColumn toViewColumn$default(TableController tableController2, ResultSetSqliteColumn resultSetSqliteColumn, SqliteTable sqliteTable, int n, Object object) {
        if ((n & 1) != 0) {
            sqliteTable = null;
        }
        return tableController2.toViewColumn(resultSetSqliteColumn, sqliteTable);
    }

    private static final ListenableFuture setUp$lambda$0(TableController this$0, SqliteResultSet newResultSet) {
        Intrinsics.checkNotNullParameter((Object)newResultSet, (String)"newResultSet");
        this$0.view.setEditable(this$0.isEditable());
        this$0.view.showPageSizeValue(this$0.rowBatchSize);
        this$0.view.setLiveUpdatesEnabled(this$0.liveUpdatesEnabled);
        this$0.view.addListener(this$0.listener);
        this$0.resultSet = newResultSet;
        Disposer.register((Disposable)this$0, (Disposable)newResultSet);
        return this$0.fetchAndDisplayTableData();
    }

    /*
     * WARNING - void declaration
     */
    private static final ListenableFuture fetchAndDisplayTableData$lambda$0(TableController this$0, List columns2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        if (this$0.isDisposed) {
            throw new ProcessCanceledException();
        }
        if (!Intrinsics.areEqual((Object)columns2, this$0.currentCols)) {
            this$0.currentRows = CollectionsKt.emptyList();
        }
        this$0.currentCols = columns2;
        SqliteTable table2 = (SqliteTable)this$0.tableSupplier.invoke();
        Iterable iterable = columns2;
        TableController tableController2 = this$0;
        TableView tableView = this$0.view;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object object;
            ResultSetSqliteColumn it = (ResultSetSqliteColumn)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (object = table2) != null && (object = ((SqliteTable)object).getRowIdName()) != null ? ((RowIdName)((Object)object)).getStringName() : null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        tableView.showTableColumns(tableController2.toViewColumns(list2, table2));
        this$0.view.setEditable(this$0.isEditable());
        return this$0.updateDataAndButtons();
    }

    private static final Unit fetchAndDisplayTableData$lambda$1(TableController this$0) {
        this$0.view.stopTableLoading();
        return Unit.INSTANCE;
    }

    private static final ListenableFuture updateDataAndButtons$lambda$0(TableController this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SqliteResultSet sqliteResultSet = this$0.resultSet;
        if (sqliteResultSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
            sqliteResultSet = null;
        }
        return sqliteResultSet.getTotalRowCount();
    }

    private static final Unit updateDataAndButtons$lambda$1(TableController this$0, int rowCount) {
        this$0.view.setFetchPreviousRowsButtonState(this$0.rowOffset > 0);
        this$0.view.setFetchNextRowsButtonState(this$0.rowOffset + this$0.rowBatchSize < rowCount);
        return Unit.INSTANCE;
    }

    private static final Unit updateDataAndButtonsWithLoadingScreens$lambda$0(TableController this$0) {
        if (this$0.isDisposed) {
            throw new ProcessCanceledException();
        }
        this$0.view.stopTableLoading();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit fetchAndDisplayRows$lambda$0(TableController this$0, SqliteQueryResult result2) {
        List<RowDiffOperation.UpdateCell> rowCellUpdates;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        List rowDiffOperations = new ArrayList();
        List<SqliteRow> newRows = result2.getRows();
        int n = Math.min(this$0.currentRows.size(), newRows.size());
        for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
            rowCellUpdates = this$0.performRowsDiff(this$0.currentRows.get(rowIndex), newRows.get(rowIndex), rowIndex);
            rowDiffOperations.addAll((Collection)rowCellUpdates);
        }
        if (this$0.currentRows.size() < newRows.size()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable rowIndex = CollectionsKt.drop((Iterable)newRows, (int)this$0.currentRows.size());
            List list2 = rowDiffOperations;
            boolean $i$f$map = false;
            rowCellUpdates = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqliteRow sqliteRow = (SqliteRow)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new RowDiffOperation.AddRow((SqliteRow)it));
            }
            list2.addAll((List)destination$iv$iv);
        } else if (this$0.currentRows.size() > newRows.size()) {
            rowDiffOperations.add(new RowDiffOperation.RemoveLastRows(newRows.size()));
        }
        this$0.view.updateIsForcedBanner(result2.isForced());
        this$0.view.setRowOffset(this$0.rowOffset);
        this$0.view.updateRows(rowDiffOperations);
        this$0.view.setEditable(this$0.isEditable());
        this$0.currentRows = newRows;
        return Unit.INSTANCE;
    }

    private static final Unit handleFetchRowsError$lambda$0(Unit it) {
        return Unit.INSTANCE;
    }

    private static final Unit handleFetchRowsError$lambda$1(TableController this$0, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this$0.isDisposed) {
            return Unit.INSTANCE;
        }
        this$0.view.resetView();
        if (!(error instanceof CancellationException) && !(error instanceof AppInspectionConnectionException)) {
            this$0.view.reportError("Error retrieving data from table.", error);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/sqlite/controllers/TableController$TableViewListenerImpl;", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView$Listener;", "<init>", "(Lcom/android/tools/idea/sqlite/controllers/TableController;)V", "toggleOrderByColumnInvoked", "", "viewColumn", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "cancelRunningStatementInvoked", "rowCountChanged", "rowCount", "", "loadPreviousRowsInvoked", "loadNextRowsInvoked", "loadFirstRowsInvoked", "loadLastRowsInvoked", "refreshDataInvoked", "toggleLiveUpdatesInvoked", "showExportToFileDialogInvoked", "updateCellInvoked", "targetRowIndex", "", "targetColumn", "newValue", "Lcom/android/tools/idea/sqlite/model/SqliteValue;", "app-inspection.inspectors.database"})
    private final class TableViewListenerImpl
    implements TableView.Listener {
        @Override
        public void toggleOrderByColumnInvoked(@NotNull ViewColumn viewColumn) {
            Intrinsics.checkNotNullParameter((Object)viewColumn, (String)"viewColumn");
            TableController.this.orderBy = TableController.this.orderBy.nextState(viewColumn.getName());
            SqliteResultSet sqliteResultSet = TableController.this.resultSet;
            if (sqliteResultSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
                sqliteResultSet = null;
            }
            Disposer.dispose((Disposable)sqliteResultSet);
            TableController.this.view.startTableLoading();
            FutureUtils.transform((ListenableFuture)FutureUtils.transform(TableController.this.databaseRepository.selectOrdered(TableController.this.databaseId, TableController.this.sqliteStatement, TableController.this.orderBy), (Executor)TableController.this.edtExecutor, arg_0 -> TableViewListenerImpl.toggleOrderByColumnInvoked$lambda$0(TableController.this, arg_0)), (Executor)TableController.this.edtExecutor, arg_0 -> TableViewListenerImpl.toggleOrderByColumnInvoked$lambda$1(TableController.this, arg_0));
        }

        @Override
        public void cancelRunningStatementInvoked() {
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState;
            SqliteDatabaseId sqliteDatabaseId = TableController.this.databaseId;
            if (sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_OFFLINE;
            } else if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_ONLINE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState2 = connectivityState;
            TableController.this.databaseInspectorAnalyticsTracker.trackStatementExecutionCanceled(connectivityState2, AppInspectionEvent.DatabaseInspectorEvent.StatementContext.UNKNOWN_STATEMENT_CONTEXT);
            TableController.this.getCloseTabInvoked().invoke();
        }

        @Override
        public void rowCountChanged(@NotNull String rowCount) {
            Intrinsics.checkNotNullParameter((Object)rowCount, (String)"rowCount");
            String errorMessage = "Row count must be a positive integer.";
            try {
                int intRowCount = Integer.parseInt(rowCount);
                if (intRowCount <= 0) {
                    TableController.this.view.reportError(errorMessage, null);
                    return;
                }
                TableController.this.rowBatchSize = intRowCount;
                TableController.this.updateDataAndButtonsWithLoadingScreens();
            }
            catch (NumberFormatException e) {
                TableController.this.view.reportError(errorMessage, null);
            }
        }

        @Override
        public void loadPreviousRowsInvoked() {
            Comparable comparable = ComparatorUtil.max((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(TableController.this.rowOffset - TableController.this.rowBatchSize));
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"max(...)");
            TableController.this.rowOffset = ((Number)((Object)comparable)).intValue();
            TableController.this.updateDataAndButtonsWithLoadingScreens();
        }

        @Override
        public void loadNextRowsInvoked() {
            TableController.this.rowOffset = TableController.this.rowOffset + TableController.this.rowBatchSize;
            TableController.this.updateDataAndButtonsWithLoadingScreens();
        }

        @Override
        public void loadFirstRowsInvoked() {
            TableController.this.rowOffset = 0;
            TableController.this.updateDataAndButtonsWithLoadingScreens();
        }

        @Override
        public void loadLastRowsInvoked() {
            SqliteResultSet sqliteResultSet = TableController.this.resultSet;
            if (sqliteResultSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
                sqliteResultSet = null;
            }
            FutureUtils.transformAsync(sqliteResultSet.getTotalRowCount(), (Executor)TableController.this.edtExecutor, arg_0 -> TableViewListenerImpl.loadLastRowsInvoked$lambda$0(TableController.this, arg_0));
        }

        @Override
        public void refreshDataInvoked() {
            TableController.this.databaseInspectorAnalyticsTracker.trackTargetRefreshed(AppInspectionEvent.DatabaseInspectorEvent.TargetType.TABLE_TARGET);
            TableController.this.refreshData();
        }

        @Override
        public void toggleLiveUpdatesInvoked() {
            TableController.this.liveUpdatesEnabled = !TableController.this.liveUpdatesEnabled;
            TableController.this.view.setEditable(TableController.this.isEditable());
            if (TableController.this.liveUpdatesEnabled) {
                TableController.this.notifyDataMightBeStale();
            }
            TableController.this.databaseInspectorAnalyticsTracker.trackLiveUpdatedToggled(TableController.this.liveUpdatesEnabled);
        }

        @Override
        public void showExportToFileDialogInvoked() {
            ExportDialogParams exportDialogParams;
            SqliteTable sqliteTable = (SqliteTable)TableController.this.tableSupplier.invoke();
            String tableName = sqliteTable != null ? sqliteTable.getName() : null;
            if (tableName != null) {
                exportDialogParams = new ExportDialogParams.ExportTableDialogParams(TableController.this.databaseId, tableName, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.TABLE_CONTENTS_EXPORT_BUTTON);
            } else if (ModelKt.isQueryStatement(TableController.this.sqliteStatement)) {
                exportDialogParams = new ExportDialogParams.ExportQueryResultsDialogParams(TableController.this.databaseId, TableController.this.sqliteStatement, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.QUERY_RESULTS_EXPORT_BUTTON);
            } else {
                return;
            }
            ExportDialogParams exportScenario = exportDialogParams;
            TableController.this.showExportDialog.invoke((Object)exportScenario);
        }

        @Override
        public void updateCellInvoked(int targetRowIndex, @NotNull ViewColumn targetColumn, @NotNull SqliteValue newValue) {
            Intrinsics.checkNotNullParameter((Object)targetColumn, (String)"targetColumn");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            SqliteTable targetTable = (SqliteTable)TableController.this.tableSupplier.invoke();
            if (targetTable == null) {
                TableController.this.view.reportError("Can't update. Table not found.", null);
                return;
            }
            TableController.this.view.startTableLoading();
            SqliteRow targetRow = (SqliteRow)TableController.this.currentRows.get(targetRowIndex);
            FutureUtils.addCallback(TableController.this.databaseRepository.updateTable(TableController.this.databaseId, targetTable, targetRow, targetColumn.getName(), newValue), (Executor)TableController.this.edtExecutor, (FutureCallback)((FutureCallback)new FutureCallback<Unit>(TableController.this){
                final /* synthetic */ TableController this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess(Unit result2) {
                    TableController.access$getDatabaseInspectorAnalyticsTracker$p(this.this$0).trackTableCellEdited();
                    this.this$0.refreshData();
                }

                public void onFailure(Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    TableController.access$getView$p(this.this$0).revertLastTableCellEdit();
                    TableController.access$getView$p(this.this$0).stopTableLoading();
                    TableController.access$getView$p(this.this$0).reportError("Can't execute update: ", t);
                }
            }));
        }

        private static final ListenableFuture toggleOrderByColumnInvoked$lambda$0(TableController this$0, SqliteResultSet newResultSet) {
            Intrinsics.checkNotNullParameter((Object)newResultSet, (String)"newResultSet");
            if (this$0.isDisposed) {
                Disposer.dispose((Disposable)newResultSet);
                throw new ProcessCanceledException();
            }
            this$0.resultSet = newResultSet;
            Disposer.register((Disposable)this$0, (Disposable)newResultSet);
            this$0.rowOffset = 0;
            return this$0.fetchAndDisplayTableData();
        }

        private static final Unit toggleOrderByColumnInvoked$lambda$1(TableController this$0, ListenableFuture it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.view.setColumnSortIndicator(this$0.orderBy);
            return Unit.INSTANCE;
        }

        private static final ListenableFuture loadLastRowsInvoked$lambda$0(TableController this$0, int rowCount) {
            this$0.rowOffset = rowCount / this$0.rowBatchSize * this$0.rowBatchSize;
            if (this$0.rowOffset == rowCount) {
                this$0.rowOffset = this$0.rowOffset - this$0.rowBatchSize;
            }
            return this$0.updateDataAndButtonsWithLoadingScreens();
        }
    }
}

