/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.serverflags;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.serverflags.ServerFlagValueData;
import com.android.tools.idea.serverflags.protos.Brand;
import com.android.tools.idea.serverflags.protos.FlagValue;
import com.android.tools.idea.serverflags.protos.OSType;
import com.android.tools.idea.serverflags.protos.ServerFlag;
import com.android.tools.idea.serverflags.protos.ServerFlagData;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\u0016\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0001*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001H\u0002\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\u0016\u001a\u00020\n*\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u001aH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002\u001a\n\u0010\u001d\u001a\u00020\u0014*\u00020\u001e\u00a8\u0006\u001f"}, d2={"getOverriddenFlags", "", "", "kotlin.jvm.PlatformType", "Lcom/android/tools/idea/serverflags/ServerFlagValueData;", "", "Lcom/android/tools/idea/serverflags/protos/ServerFlagData;", "overriddenFlags", "", "isEnabled", "", "osType", "Lcom/android/tools/idea/serverflags/protos/OSType;", "brand", "Lcom/android/tools/idea/serverflags/protos/Brand;", "getEnabledValue", "hashFunction", "Lkotlin/Function1;", "areAllValuesTheSameType", "flags", "Lcom/android/tools/idea/serverflags/protos/FlagValue;", "isOSEnabled", "isBrandEnabled", "getOsType", "osName", "getBrand", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;", "hash", "key", "toSingleFlagValue", "Lcom/android/tools/idea/serverflags/protos/ServerFlag;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nServerFlagInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerFlagInitializer.kt\ncom/android/tools/idea/serverflags/ServerFlagInitializerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionsUtils.kt\ncom/android/utils/CollectionsUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n774#2:212\n865#2,2:213\n1617#2,9:216\n1869#2:225\n1870#2:227\n1626#2:228\n1740#2,3:229\n47#3:215\n1#4:226\n*S KotlinDebug\n*F\n+ 1 ServerFlagInitializer.kt\ncom/android/tools/idea/serverflags/ServerFlagInitializerKt\n*L\n97#1:212\n97#1:213,2\n98#1:216,9\n98#1:225\n98#1:227\n98#1:228\n153#1:229,3\n98#1:215\n98#1:226\n*E\n"})
public final class ServerFlagInitializerKt {
    /*
     * WARNING - void declaration
     */
    private static final Map<String, ServerFlagValueData> getOverriddenFlags(List<ServerFlagData> $this$getOverriddenFlags, Map<String, Integer> overriddenFlags) {
        void $this$mapNotNullTo$iv$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$getOverriddenFlags;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerFlagData it = (ServerFlagData)element$iv$iv;
            boolean bl = false;
            if (!overriddenFlags.containsKey(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$associateNotNull = false;
        Iterable $this$mapNotNull$iv$iv = $this$associateNotNull$iv;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filterTo22 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            block6: {
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it$iv = element$iv$iv$iv;
                boolean bl2 = false;
                ServerFlagData it = (ServerFlagData)it$iv;
                boolean bl3 = false;
                Integer n = overriddenFlags.get(it.getName());
                Intrinsics.checkNotNull((Object)n);
                int flagValueIndex = ((Number)n).intValue();
                if (it.hasMultiValueServerFlag()) {
                    FlagValue flagValue;
                    try {
                        flagValue = (FlagValue)it.getMultiValueServerFlag().getFlagValuesList().get(flagValueIndex);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Logger.getInstance((String)"ServerFlagInitializer").warn("Index " + flagValueIndex + " is out of bounds for flag " + it.getName());
                        pair = null;
                        break block6;
                    }
                    FlagValue flagValue2 = flagValue;
                    String string = it.getName();
                    Intrinsics.checkNotNull((Object)flagValue2);
                    pair = TuplesKt.to((Object)string, (Object)new ServerFlagValueData(flagValueIndex, flagValue2));
                } else {
                    Logger.getInstance((String)"ServerFlagInitializer").warn("Expected MultiValueServerFlag to be set for overridden flag " + it.getName());
                    pair = null;
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
    }

    private static final boolean isEnabled(ServerFlagData $this$isEnabled, OSType osType, Brand brand) {
        return ServerFlagInitializerKt.isOSEnabled($this$isEnabled, osType) && ServerFlagInitializerKt.isBrandEnabled($this$isEnabled, brand);
    }

    private static final ServerFlagValueData getEnabledValue(ServerFlagData $this$getEnabledValue, Function1<? super String, Integer> hashFunction) {
        String key = AnalyticsSettings.getUserId() + $this$getEnabledValue.getName();
        int hash = ((Number)hashFunction.invoke((Object)key)).intValue();
        if (!$this$getEnabledValue.hasMultiValueServerFlag()) {
            Logger.getInstance((String)"ServerFlagInitializer").warn("Server flag " + $this$getEnabledValue.getName() + " does not have MultiValueServerFlag field set.");
            return null;
        }
        List list2 = $this$getEnabledValue.getMultiValueServerFlag().getFlagValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFlagValuesList(...)");
        if (!ServerFlagInitializerKt.areAllValuesTheSameType(list2)) {
            Logger.getInstance((String)"ServerFlagInitializer").warn("Server flag " + $this$getEnabledValue.getName() + " have flag values of different types.");
            return null;
        }
        int acc = 0;
        List list3 = $this$getEnabledValue.getMultiValueServerFlag().getFlagValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getFlagValuesList(...)");
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)list3)) {
            if (acc <= hash && hash < acc + ((FlagValue)indexedValue.getValue()).getPercentEnabled()) {
                int n = indexedValue.getIndex();
                Object object = indexedValue.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                return new ServerFlagValueData(n, (FlagValue)object);
            }
            acc += ((FlagValue)indexedValue.getValue()).getPercentEnabled();
        }
        return null;
    }

    private static final boolean areAllValuesTheSameType(List<FlagValue> flags) {
        boolean bl;
        block4: {
            FlagValue flagValue = (FlagValue)CollectionsKt.firstOrNull(flags);
            if (flagValue == null) {
                return true;
            }
            FlagValue firstValue = flagValue;
            Iterable $this$all$iv = flags;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FlagValue it = (FlagValue)element$iv;
                    boolean bl2 = false;
                    if (it.getValuesCase() == firstValue.getValuesCase()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isOSEnabled(ServerFlagData $this$isOSEnabled, OSType osType) {
        return $this$isOSEnabled.getMultiValueServerFlag().getOsTypeCount() == 0 || $this$isOSEnabled.getMultiValueServerFlag().getOsTypeList().contains(osType);
    }

    private static final boolean isBrandEnabled(ServerFlagData $this$isBrandEnabled, Brand brand) {
        return $this$isBrandEnabled.getMultiValueServerFlag().getBrandCount() == 0 || $this$isBrandEnabled.getMultiValueServerFlag().getBrandList().contains(brand);
    }

    private static final OSType getOsType(String osName) {
        if (StringsKt.startsWith$default((String)osName, (String)"freebsd", (boolean)false, (int)2, null)) {
            return OSType.OS_TYPE_FREE_BSD;
        }
        return switch (osName) {
            case "linux" -> OSType.OS_TYPE_LINUX;
            case "chromium" -> OSType.OS_TYPE_CHROMIUM;
            case "windows" -> OSType.OS_TYPE_WIN;
            case "macosx" -> OSType.OS_TYPE_MAC;
            default -> OSType.OS_TYPE_UNKNOWN;
        };
    }

    private static final Brand getBrand(AndroidStudioEvent.IdeBrand brand) {
        return switch (WhenMappings.$EnumSwitchMapping$0[brand.ordinal()]) {
            case 1 -> Brand.BRAND_ANDROID_STUDIO;
            case 2 -> Brand.BRAND_ANDROID_STUDIO_WITH_BLAZE;
            default -> Brand.BRAND_UNKNOWN;
        };
    }

    private static final int hash(String key) {
        HashCode hash = Hashing.farmHashFingerprint64().hashString((CharSequence)key, Charsets.UTF_8);
        return (int)(Math.abs(hash.asLong()) % (long)100);
    }

    @NotNull
    public static final FlagValue toSingleFlagValue(@NotNull ServerFlag $this$toSingleFlagValue) {
        FlagValue.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$toSingleFlagValue, (String)"<this>");
        FlagValue.Builder $this$toSingleFlagValue_u24lambda_u240 = builder = FlagValue.newBuilder();
        boolean bl = false;
        $this$toSingleFlagValue_u24lambda_u240.setPercentEnabled($this$toSingleFlagValue.getPercentEnabled());
        ServerFlag.ValuesCase valuesCase = $this$toSingleFlagValue.getValuesCase();
        switch (valuesCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[valuesCase.ordinal()]) {
            case 1: {
                $this$toSingleFlagValue_u24lambda_u240.setIntValue($this$toSingleFlagValue.getIntValue());
                break;
            }
            case 2: {
                $this$toSingleFlagValue_u24lambda_u240.setFloatValue($this$toSingleFlagValue.getFloatValue());
                break;
            }
            case 3: {
                $this$toSingleFlagValue_u24lambda_u240.setStringValue($this$toSingleFlagValue.getStringValue());
                break;
            }
            case 4: {
                $this$toSingleFlagValue_u24lambda_u240.setBooleanValue($this$toSingleFlagValue.getBooleanValue());
                break;
            }
            case 5: {
                $this$toSingleFlagValue_u24lambda_u240.setProtoValue($this$toSingleFlagValue.getProtoValue());
                break;
            }
            default: {
                Logger.getInstance($this$toSingleFlagValue_u24lambda_u240.getClass()).warn("Unexpected server flag value type: " + $this$toSingleFlagValue.getValuesCase());
            }
        }
        FlagValue flagValue = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)flagValue, (String)"build(...)");
        return flagValue;
    }

    public static final /* synthetic */ OSType access$getOsType(String osName) {
        return ServerFlagInitializerKt.getOsType(osName);
    }

    public static final /* synthetic */ Brand access$getBrand(AndroidStudioEvent.IdeBrand brand) {
        return ServerFlagInitializerKt.getBrand(brand);
    }

    public static final /* synthetic */ Map access$getOverriddenFlags(List $receiver, Map overriddenFlags) {
        return ServerFlagInitializerKt.getOverriddenFlags($receiver, overriddenFlags);
    }

    public static final /* synthetic */ int access$hash(String key) {
        return ServerFlagInitializerKt.hash(key);
    }

    public static final /* synthetic */ boolean access$isEnabled(ServerFlagData $receiver, OSType osType, Brand brand) {
        return ServerFlagInitializerKt.isEnabled($receiver, osType, brand);
    }

    public static final /* synthetic */ ServerFlagValueData access$getEnabledValue(ServerFlagData $receiver, Function1 hashFunction) {
        return ServerFlagInitializerKt.getEnabledValue($receiver, (Function1<? super String, Integer>)hashFunction);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AndroidStudioEvent.IdeBrand.values().length];
            try {
                nArray[AndroidStudioEvent.IdeBrand.ANDROID_STUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidStudioEvent.IdeBrand.ANDROID_STUDIO_WITH_BLAZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ServerFlag.ValuesCase.values().length];
            try {
                nArray[ServerFlag.ValuesCase.INT_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.FLOAT_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.STRING_VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.BOOLEAN_VALUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.PROTO_VALUE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

