/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.annotations.concurrency.UiThread;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.wizard.FirstRunWizardModel;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.InstallComponentsProgressStep;
import com.android.tools.idea.welcome.wizard.InstallSummaryStep;
import com.android.tools.idea.welcome.wizard.SdkComponentsStep;
import com.android.tools.idea.welcome.wizard.deprecated.ConsolidatedProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.StudioWizardDialogBuilder;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JU\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072)\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tj\u0004\u0018\u0001`\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0005H\u0016JK\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\n2)\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tj\u0004\u0018\u0001`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JK\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\n2)\u0010\b\u001a%\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tj\u0004\u0018\u0001`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/sdk/wizard/SetupSdkApplicationService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "showSdkSetupWizard", "", "sdkPathString", "", "sdkUpdatedCallback", "Lkotlin/Function1;", "Ljava/io/File;", "Lkotlin/ParameterName;", "name", "sdkPath", "Lcom/android/tools/idea/sdk/wizard/SdkUpdatedCallback;", "sdkComponentInstaller", "Lcom/android/tools/idea/welcome/install/SdkComponentInstaller;", "tracker", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;", "useDeprecatedWizard", "", "dispose", "showOldWizard", "showNewWizard", "Companion", "DownloadingComponentsStep", "intellij.android.core"})
public final class SetupSdkApplicationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @UiThread
    public final void showSdkSetupWizard(@NotNull String sdkPathString, @Nullable Function1<? super File, Unit> sdkUpdatedCallback, @NotNull SdkComponentInstaller sdkComponentInstaller, @NotNull FirstRunWizardTracker tracker, boolean useDeprecatedWizard) {
        File file;
        Intrinsics.checkNotNullParameter((Object)sdkPathString, (String)"sdkPathString");
        Intrinsics.checkNotNullParameter((Object)sdkComponentInstaller, (String)"sdkComponentInstaller");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (StringUtil.isEmpty((String)sdkPathString)) {
            Object object = ReadAction.compute(SetupSdkApplicationService::showSdkSetupWizard$lambda$0);
            Intrinsics.checkNotNull((Object)object);
            file = (File)object;
        } else {
            file = new File(sdkPathString);
        }
        File sdkPath = file;
        tracker.trackWizardStarted();
        if (useDeprecatedWizard) {
            this.showOldWizard(sdkPath, sdkUpdatedCallback, sdkComponentInstaller, tracker);
        } else {
            this.showNewWizard(sdkPath, sdkUpdatedCallback, sdkComponentInstaller, tracker);
        }
    }

    public static /* synthetic */ void showSdkSetupWizard$default(SetupSdkApplicationService setupSdkApplicationService, String string, Function1 function1, SdkComponentInstaller sdkComponentInstaller, FirstRunWizardTracker firstRunWizardTracker, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            sdkComponentInstaller = new SdkComponentInstaller();
        }
        setupSdkApplicationService.showSdkSetupWizard(string, (Function1<? super File, Unit>)function1, sdkComponentInstaller, firstRunWizardTracker, bl);
    }

    public void dispose() {
    }

    private final void showOldWizard(File sdkPath, Function1<? super File, Unit> sdkUpdatedCallback, SdkComponentInstaller sdkComponentInstaller, FirstRunWizardTracker tracker) {
        DynamicWizardHost host = new DialogWrapperHost(null);
        DynamicWizard wizard2 = new DynamicWizard(host, tracker, sdkPath, sdkComponentInstaller, sdkUpdatedCallback){
            final /* synthetic */ FirstRunWizardTracker $tracker;
            final /* synthetic */ File $sdkPath;
            final /* synthetic */ SdkComponentInstaller $sdkComponentInstaller;
            final /* synthetic */ Function1<File, Unit> $sdkUpdatedCallback;
            {
                this.$tracker = $tracker;
                this.$sdkPath = $sdkPath;
                this.$sdkComponentInstaller = $sdkComponentInstaller;
                this.$sdkUpdatedCallback = $sdkUpdatedCallback;
                super(null, null, "SDK Setup", $host);
            }

            public void init() {
                Disposable disposable = this.myHost.getDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
                DynamicWizardHost dynamicWizardHost = this.myHost;
                Intrinsics.checkNotNullExpressionValue((Object)dynamicWizardHost, (String)"myHost");
                DownloadingComponentsStep progressStep2 = new DownloadingComponentsStep(disposable, dynamicWizardHost, this.$tracker);
                InstallComponentsPath path = new InstallComponentsPath(FirstRunWizardMode.MISSING_SDK, this.$sdkPath, progressStep2, this.$sdkComponentInstaller, false, this.$tracker);
                progressStep2.setInstallComponentsPath(path);
                this.addPath(path);
                this.addPath(new SingleStepPath(progressStep2));
                super.init();
            }

            public void performFinishingActions() {
                block1: {
                    ScopedStateStore.Key<String> key = WizardConstants.KEY_SDK_INSTALL_LOCATION;
                    Intrinsics.checkNotNullExpressionValue(key, (String)"KEY_SDK_INSTALL_LOCATION");
                    String stateSdkLocationPath = this.myState.get(key);
                    if (stateSdkLocationPath == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    File stateSdkLocation = new File(stateSdkLocationPath);
                    Function1<File, Unit> function1 = this.$sdkUpdatedCallback;
                    if (function1 == null) break block1;
                    function1.invoke((Object)stateSdkLocation);
                }
            }

            protected String getProgressTitle() {
                return "Setting up SDK...";
            }

            protected String getWizardActionDescription() {
                return "Setting up SDK...";
            }

            public void doCancelAction() {
                super.doCancelAction();
                this.$tracker.trackWizardFinished(SetupWizardEvent.CompletionStatus.CANCELED);
            }

            public void doFinishAction() {
                super.doFinishAction();
                this.$tracker.trackWizardFinished(SetupWizardEvent.CompletionStatus.FINISHED);
            }
        };
        wizard2.init();
        wizard2.show();
    }

    private final void showNewWizard(File sdkPath, Function1<? super File, Unit> sdkUpdatedCallback, SdkComponentInstaller sdkComponentInstaller, FirstRunWizardTracker tracker) {
        Path path = sdkPath.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        FirstRunWizardModel model = new FirstRunWizardModel(FirstRunWizardMode.MISSING_SDK, path, false, sdkComponentInstaller, tracker);
        Supplier<Collection<RemotePackage>> supplier = model.getPackagesToInstallSupplier();
        LicenseAgreementModel licenseAgreementModel = new LicenseAgreementModel(model.getSdkInstallLocationProperty());
        LicenseAgreementStep licenseAgreementStep2 = new LicenseAgreementStep(licenseAgreementModel, supplier, tracker){
            final /* synthetic */ FirstRunWizardTracker $tracker;
            {
                this.$tracker = $tracker;
                super($licenseAgreementModel, $supplier);
            }

            protected void onShowing() {
                super.onShowing();
                this.$tracker.trackStepShowing(SetupWizardEvent.WizardStep.WizardStepKind.LICENSE_AGREEMENT);
            }
        };
        InstallComponentsProgressStep progressStep2 = new InstallComponentsProgressStep(model, licenseAgreementModel, tracker){
            final /* synthetic */ FirstRunWizardModel $model;
            {
                this.$model = $model;
                super($model, $licenseAgreementModel, $tracker);
            }

            protected boolean shouldShow() {
                Path sdkInstallLocation = this.$model.getSdkInstallLocation();
                return sdkInstallLocation != null && SdkLocationUtils.isWritable(sdkInstallLocation);
            }
        };
        ModelWizard.Builder builder = new ModelWizard.Builder(new ModelWizardStep[0]);
        builder.addStep(new SdkComponentsStep(model, null, FirstRunWizardMode.MISSING_SDK, licenseAgreementStep2, tracker));
        builder.addStep(new InstallSummaryStep(model, supplier, tracker));
        builder.addStep(licenseAgreementStep2);
        builder.addStep(progressStep2);
        ModelWizard wizard2 = builder.build();
        wizard2.setCancelInterceptor(() -> SetupSdkApplicationService.showNewWizard$lambda$0(progressStep2));
        wizard2.addResultListener(new ModelWizard.WizardListener(tracker, model, sdkUpdatedCallback){
            final /* synthetic */ FirstRunWizardTracker $tracker;
            final /* synthetic */ FirstRunWizardModel $model;
            final /* synthetic */ Function1<File, Unit> $sdkUpdatedCallback;
            {
                this.$tracker = $tracker;
                this.$model = $model;
                this.$sdkUpdatedCallback = $sdkUpdatedCallback;
            }

            public void onWizardFinished(ModelWizard.WizardResult result2) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                    this.$tracker.trackWizardFinished(result2 == ModelWizard.WizardResult.FINISHED ? SetupWizardEvent.CompletionStatus.FINISHED : SetupWizardEvent.CompletionStatus.CANCELED);
                    if (!result2.isFinished()) {
                        return;
                    }
                    Path path = this.$model.getSdkInstallLocation();
                    File sdkLocation = path != null ? path.toFile() : null;
                    if (sdkLocation == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    Function1<File, Unit> function1 = this.$sdkUpdatedCallback;
                    if (function1 == null) break block2;
                    function1.invoke((Object)sdkLocation);
                }
            }
        });
        Intrinsics.checkNotNull((Object)wizard2);
        ModelWizardDialog dialog2 = new StudioWizardDialogBuilder(wizard2, "SDK Setup").setCancellationPolicy(ModelWizardDialog.CancellationPolicy.CAN_CANCEL_UNTIL_CAN_FINISH).build();
        dialog2.show();
    }

    private static final File showSdkSetupWizard$lambda$0() {
        return FirstRunWizardDefaults.getInitialSdkLocation(FirstRunWizardMode.MISSING_SDK);
    }

    private static final boolean showNewWizard$lambda$0(InstallComponentsProgressStep $progressStep) {
        if ($progressStep.isRunning()) {
            $progressStep.getProgressIndicator().cancel();
            return true;
        }
        return false;
    }

    @NotNull
    public static final SetupSdkApplicationService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/sdk/wizard/SetupSdkApplicationService$Companion;", "", "<init>", "()V", "instance", "Lcom/android/tools/idea/sdk/wizard/SetupSdkApplicationService;", "getInstance$annotations", "getInstance", "()Lcom/android/tools/idea/sdk/wizard/SetupSdkApplicationService;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SetupSdkApplicationService getInstance() {
            Object object = ApplicationManager.getApplication().getService(SetupSdkApplicationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SetupSdkApplicationService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/sdk/wizard/SetupSdkApplicationService$DownloadingComponentsStep;", "Lcom/android/tools/idea/welcome/wizard/deprecated/ConsolidatedProgressStep;", "disposable", "Lcom/intellij/openapi/Disposable;", "host", "Lcom/android/tools/idea/wizard/dynamic/DynamicWizardHost;", "tracker", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/wizard/dynamic/DynamicWizardHost;Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;)V", "myInstallComponentsPath", "Lcom/android/tools/idea/welcome/wizard/deprecated/InstallComponentsPath;", "setInstallComponentsPath", "", "installComponentsPath", "isStepVisible", "", "intellij.android.core"})
    private static final class DownloadingComponentsStep
    extends ConsolidatedProgressStep {
        @Nullable
        private InstallComponentsPath myInstallComponentsPath;

        public DownloadingComponentsStep(@NotNull Disposable disposable, @NotNull DynamicWizardHost host, @NotNull FirstRunWizardTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            super(disposable, host, tracker);
        }

        public final void setInstallComponentsPath(@NotNull InstallComponentsPath installComponentsPath) {
            Intrinsics.checkNotNullParameter((Object)installComponentsPath, (String)"installComponentsPath");
            this.setPaths(CollectionsKt.listOf((Object)installComponentsPath));
            this.myInstallComponentsPath = installComponentsPath;
        }

        @Override
        public boolean isStepVisible() {
            InstallComponentsPath installComponentsPath = this.myInstallComponentsPath;
            Intrinsics.checkNotNull((Object)installComponentsPath);
            return installComponentsPath.shouldDownloadingComponentsStepBeShown();
        }
    }
}

