/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.JdiBasedClassRedefiner;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.VirtualMachine;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;

public class DebuggerRedefiner
implements ClassRedefiner {
    private final Project project;
    private final int debuggerPort;
    private final boolean fallback;
    private ClassRedefiner.RedefineClassSupportState supportState = null;

    public DebuggerRedefiner(Project project, int debuggerPort, boolean fallback) {
        this.project = project;
        this.debuggerPort = debuggerPort;
        this.fallback = fallback;
    }

    public ClassRedefiner.RedefineClassSupportState canRedefineClass() throws DeployerException {
        if (this.supportState != null) {
            return this.supportState;
        }
        MultiProcessCommand commands = new MultiProcessCommand();
        final DebuggerSession debuggerSession = DebuggerRedefiner.getDebuggerSession(this.project, this.debuggerPort);
        if (debuggerSession == null) {
            throw DeployerException.noDebuggerSession((int)this.debuggerPort);
        }
        final AtomicReference result2 = new AtomicReference();
        DebuggerCommandImpl task2 = new DebuggerCommandImpl(){

            protected void action() {
                result2.set(DebuggerRedefiner.this.canRedefineClassInternal(debuggerSession));
            }
        };
        commands.addCommand(debuggerSession.getProcess(), task2);
        commands.run();
        task2.waitFor();
        this.supportState = (ClassRedefiner.RedefineClassSupportState)result2.get();
        return this.supportState;
    }

    private ClassRedefiner.RedefineClassSupportState canRedefineClassInternal(DebuggerSession debuggerSession) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess2 = debuggerSession.getProcess();
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess2.getVirtualMachineProxy();
        if (virtualMachineProxy.canRedefineClasses()) {
            return new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.FULL, null);
        }
        Collection allThreads = virtualMachineProxy.allThreads();
        for (ThreadReferenceProxyImpl thread : allThreads) {
            if (!thread.name().equals("main") || thread.isSuspended()) continue;
            return new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.MAIN_THREAD_RUNNING, "main");
        }
        for (ThreadReferenceProxyImpl thread : allThreads) {
            if (!thread.isAtBreakpoint()) continue;
            ClassRedefiner.RedefineClassSupportState state2 = new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.NEEDS_AGENT_SERVER, thread.name());
            return state2;
        }
        return new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.NONE, null);
    }

    public Deploy.SwapResponse redefine(final Deploy.SwapRequest request) throws DeployerException {
        MultiProcessCommand commands = new MultiProcessCommand();
        final DebuggerSession debuggerSession = DebuggerRedefiner.getDebuggerSession(this.project, this.debuggerPort);
        if (debuggerSession == null) {
            throw DeployerException.noDebuggerSession((int)this.debuggerPort);
        }
        final AtomicReference exception = new AtomicReference();
        DebuggerCommandImpl task2 = new DebuggerCommandImpl(){

            protected void action() {
                try {
                    DebuggerRedefiner.this.redefine(DebuggerRedefiner.this.project, debuggerSession, request);
                }
                catch (DeployerException e) {
                    exception.set(e);
                }
            }

            protected void commandCancelled() {
                debuggerSession.setModifiedClassesScanRequired(true);
            }
        };
        commands.addCommand(debuggerSession.getProcess(), task2);
        commands.run();
        task2.waitFor();
        if (exception.get() != null) {
            DeployerException e = (DeployerException)((Object)exception.get());
            if (this.fallback && e.getError() == DeployerException.Error.JDWP_REDEFINE_CLASSES_EXCEPTION) {
                return Deploy.SwapResponse.newBuilder().setStatus(Deploy.SwapResponse.Status.SWAP_FAILED_BUT_OVERLAY_UPDATED).build();
            }
            throw (DeployerException)((Object)exception.get());
        }
        return Deploy.SwapResponse.newBuilder().setStatus(Deploy.SwapResponse.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefine(Project project, DebuggerSession session2, Deploy.SwapRequest request) throws DeployerException {
        try {
            DebuggerRedefiner.disableBreakPoints(project, session2);
            VirtualMachine vm = session2.getProcess().getVirtualMachineProxy().getVirtualMachine();
            new JdiBasedClassRedefiner(vm, this.canRedefineClass()).redefine(request);
        }
        finally {
            DebuggerRedefiner.enableBreakPoints(project, session2);
        }
    }

    public Deploy.SwapResponse redefine(final Deploy.OverlaySwapRequest request) throws DeployerException {
        MultiProcessCommand commands = new MultiProcessCommand();
        final DebuggerSession debuggerSession = DebuggerRedefiner.getDebuggerSession(this.project, this.debuggerPort);
        if (debuggerSession == null) {
            throw DeployerException.noDebuggerSession((int)this.debuggerPort);
        }
        final AtomicReference exception = new AtomicReference();
        DebuggerCommandImpl task2 = new DebuggerCommandImpl(){

            protected void action() {
                try {
                    DebuggerRedefiner.this.redefine(DebuggerRedefiner.this.project, debuggerSession, request);
                }
                catch (DeployerException e) {
                    exception.set(e);
                }
            }

            protected void commandCancelled() {
                debuggerSession.setModifiedClassesScanRequired(true);
            }
        };
        commands.addCommand(debuggerSession.getProcess(), task2);
        commands.run();
        task2.waitFor();
        if (exception.get() != null) {
            if (this.fallback) {
                return Deploy.SwapResponse.newBuilder().setStatus(Deploy.SwapResponse.Status.SWAP_FAILED_BUT_OVERLAY_UPDATED).build();
            }
            throw (DeployerException)((Object)exception.get());
        }
        return Deploy.SwapResponse.newBuilder().setStatus(Deploy.SwapResponse.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefine(Project project, DebuggerSession session2, Deploy.OverlaySwapRequest request) throws DeployerException {
        try {
            DebuggerRedefiner.disableBreakPoints(project, session2);
            VirtualMachine vm = session2.getProcess().getVirtualMachineProxy().getVirtualMachine();
            ClassRedefiner.RedefineClassSupportState state2 = new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.FULL, null);
            new JdiBasedClassRedefiner(vm, state2).redefine(request);
        }
        finally {
            DebuggerRedefiner.enableBreakPoints(project, session2);
        }
    }

    public static DebuggerSession getDebuggerSession(Project project, int port) {
        Collection debuggerSessions = DebuggerManagerEx.getInstanceEx((Project)project).getSessions();
        for (DebuggerSession debuggerSession : debuggerSessions) {
            RemoteConnection s = debuggerSession.getProcess().getConnection();
            String address = s.getDebuggerAddress();
            int projectDebuggerPort = Integer.parseInt(address);
            if (port != projectDebuggerPort) continue;
            return debuggerSession;
        }
        return null;
    }

    public static boolean hasDebuggersAttached(Project project) {
        return !DebuggerManagerEx.getInstanceEx((Project)project).getSessions().isEmpty();
    }

    private static void disableBreakPoints(Project project, DebuggerSession debuggerSession) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess2 = debuggerSession.getProcess();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager();
        breakpointManager.disableBreakpoints(debugProcess2);
        StackCapturingLineBreakpoint.deleteAll((DebugProcessImpl)debugProcess2);
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess2.getVirtualMachineProxy();
        if (Registry.is((String)"debugger.resume.yourkit.threads")) {
            virtualMachineProxy.allThreads().stream().filter(ThreadReferenceProxyImpl::isResumeOnHotSwap).filter(ThreadReferenceProxyImpl::isSuspended).forEach(t -> IntStream.range(0, t.getSuspendCount()).forEach(i -> t.resume()));
        }
    }

    private static void enableBreakPoints(Project project, DebuggerSession debuggerSession) {
        JavaExecutionStack stack;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess2 = debuggerSession.getProcess();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager();
        debugProcess2.onHotSwapFinished();
        DebuggerContextImpl context = debuggerSession.getContextManager().getContext();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        if (suspendContext != null && (stack = suspendContext.getActiveExecutionStack()) != null) {
            stack.initTopFrame();
        }
        Semaphore waitSemaphore = new Semaphore();
        waitSemaphore.down();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                if (!project.isDisposed()) {
                    debugProcess2.getRequestsManager().clearWarnings();
                    debuggerSession.refresh(false);
                    XDebugSession session2 = debuggerSession.getXDebugSession();
                    if (session2 != null) {
                        session2.rebuildViews();
                    }
                }
            }
            finally {
                waitSemaphore.up();
            }
        });
        waitSemaphore.waitFor();
        if (!project.isDisposed()) {
            breakpointManager.enableBreakpoints(debugProcess2);
            StackCapturingLineBreakpoint.createAll((DebugProcessImpl)debugProcess2);
        }
    }
}

