/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.backup.BackupManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.RunConfigSection;
import com.android.tools.idea.run.activity.launch.DeepLinkLaunch;
import com.android.tools.idea.run.activity.launch.DefaultActivityLaunch;
import com.android.tools.idea.run.activity.launch.LaunchOption;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.activity.launch.LaunchOptionState;
import com.android.tools.idea.run.activity.launch.NoLaunch;
import com.android.tools.idea.run.editor.DynamicFeaturesParameters;
import com.android.tools.idea.run.editor.InstallOption;
import com.android.tools.idea.run.editor.InstantAppDeprecatedPanel;
import com.android.tools.idea.run.editor.LaunchConfigurableWrapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationRunParameters<T extends AndroidRunConfiguration>
implements ConfigurationSpecificEditor<T>,
ActionListener {
    private JPanel myPanel;
    private ComboBox myDeployOptionCombo;
    private LabeledComponent<ComboBox> myCustomArtifactLabeledComponent;
    private final ComboBox myArtifactCombo;
    private LabeledComponent<JBTextField> myPmOptionsLabeledComponent;
    private ComboBox myLaunchOptionCombo;
    private ConfigurableCardPanel myLaunchOptionsCardPanel;
    private LabeledComponent<JBTextField> myAmOptionsLabeledComponent;
    private JComponent myDynamicFeaturesParametersComponent;
    private JBCheckBox myInstantAppDeployCheckBox;
    private JPanel myInstantAppDeployCheckBoxWarning;
    private JBCheckBox myAllUsersCheckbox;
    private JBCheckBox myAlwaysInstallWithPmCheckbox;
    private JBCheckBox myAssumeVerified;
    private JBCheckBox myClearAppStorageCheckbox;
    private JPanel myRestorePanelWrapper;
    private JCheckBox myCheckBox1;
    @Nullable
    private final RunConfigSection myRestoreRunConfigSection;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private Artifact myLastSelectedArtifact;
    private final ImmutableMap<String, LaunchConfigurableWrapper> myConfigurables;
    private DynamicFeaturesParameters myDynamicFeaturesParameters;

    public ApplicationRunParameters(Project project, ConfigurationModuleSelector moduleSelector2) {
        this.myProject = project;
        this.myModuleSelector = moduleSelector2;
        try {
            this.setupUI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myDeployOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(InstallOption.supportedValues()));
        this.myDeployOptionCombo.setRenderer((ListCellRenderer)((Object)new InstallOption.Renderer()));
        this.myDeployOptionCombo.addActionListener((ActionListener)this);
        this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
        this.myArtifactCombo = (ComboBox)this.myCustomArtifactLabeledComponent.getComponent();
        this.myArtifactCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 instanceof Artifact) {
                Artifact artifact = (Artifact)value2;
                label2.setText(artifact.getName());
                label2.setIcon(artifact.getArtifactType().getIcon());
            } else if (value2 instanceof String) {
                label2.setText("<html><font color='red'>" + String.valueOf(value2) + "</font></html>");
            }
        }));
        this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(this.getAndroidArtifacts().toArray()));
        this.myArtifactCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'pm install' command");
        this.myLaunchOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(AndroidRunConfiguration.LAUNCH_OPTIONS));
        this.myLaunchOptionCombo.setRenderer((ListCellRenderer)((Object)new LaunchOption.Renderer()));
        this.myLaunchOptionCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'am start' command");
        this.myInstantAppDeployCheckBox.addActionListener((ActionListener)this);
        LaunchOptionConfigurableContext context = new LaunchOptionConfigurableContext(){

            @Override
            @Nullable
            public Module getModule() {
                Module selectedModule = ApplicationRunParameters.this.myModuleSelector.getModule();
                if (selectedModule == null) {
                    return null;
                }
                Module mainModule = ProjectSystemUtil.getModuleSystem(selectedModule).getProductionAndroidModule();
                return mainModule == null ? null : mainModule;
            }
        };
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (LaunchOption<? extends LaunchOptionState> option : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            builder.put((Object)option.getId(), (Object)new LaunchConfigurableWrapper(project, context, option));
        }
        this.myConfigurables = builder.build();
        this.myLaunchOptionCombo.setSelectedItem((Object)DefaultActivityLaunch.INSTANCE);
        this.myInstantAppDeployCheckBox.setVisible(((Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get()).booleanValue());
        this.myAlwaysInstallWithPmCheckbox.setVisible(StudioFlags.OPTIMISTIC_INSTALL_SUPPORT_LEVEL.get() != StudioFlags.OptimisticInstallSupportLevel.DISABLED);
        this.myAssumeVerified.setVisible(((Boolean)StudioFlags.INSTALL_WITH_ASSUME_VERIFIED.get()).booleanValue());
        BackupManager backupManager = BackupManager.tryGetInstance(project);
        if (((Boolean)StudioFlags.BACKUP_ENABLED.get()).booleanValue() && backupManager != null) {
            this.myRestoreRunConfigSection = backupManager.getRestoreRunConfigSection(project);
            this.myRestorePanelWrapper.add(this.myRestoreRunConfigSection.getComponent(this), "Center");
        } else {
            this.myRestoreRunConfigSection = null;
        }
    }

    private void createUIComponents() {
        this.myDynamicFeaturesParameters = new DynamicFeaturesParameters();
        this.myDynamicFeaturesParametersComponent = this.myDynamicFeaturesParameters.getComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source2 = e.getSource();
        if (source2 == this.myDeployOptionCombo) {
            InstallOption option = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem());
            this.myCustomArtifactLabeledComponent.setVisible(option == InstallOption.CUSTOM_ARTIFACT);
            this.myPmOptionsLabeledComponent.setVisible(option != InstallOption.NOTHING);
            if (option == InstallOption.CUSTOM_ARTIFACT) {
                this.updateBuildArtifactBeforeRunSetting();
            }
        } else if (source2 == this.myArtifactCombo) {
            this.updateBuildArtifactBeforeRunSetting();
        } else if (source2 == this.myLaunchOptionCombo) {
            LaunchOption option = (LaunchOption)this.myLaunchOptionCombo.getSelectedItem();
            this.myAmOptionsLabeledComponent.setVisible(option != NoLaunch.INSTANCE);
            this.myLaunchOptionsCardPanel.select((Object)((Configurable)this.myConfigurables.get((Object)option.getId())), true);
        } else if (source2 == this.myInstantAppDeployCheckBox && this.myModuleSelector.getModule() != null) {
            boolean instantAppDeploy = this.myInstantAppDeployCheckBox.isSelected();
            this.myDynamicFeaturesParameters.updateBasedOnInstantState(this.myModuleSelector.getModule(), instantAppDeploy);
            if (this.myRestoreRunConfigSection != null) {
                this.myRestoreRunConfigSection.updateBasedOnInstantState(instantAppDeploy);
            }
        }
    }

    private void setupUI() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(17, 4, new Insets(0, 0, 0, 0), -1, -1));
        TitledSeparator titledSeparator1 = new TitledSeparator();
        titledSeparator1.setText("Installation Options");
        this.myPanel.add((Component)titledSeparator1, new GridConstraints(0, 0, 1, 4, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Deploy:");
        jBLabel1.setDisplayedMnemonic('D');
        jBLabel1.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)jBLabel1, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2, false));
        this.myDeployOptionCombo = new ComboBox();
        this.myPanel.add((Component)this.myDeployOptionCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, new Dimension(100, -1), null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(1, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myCustomArtifactLabeledComponent = new LabeledComponent();
        this.myCustomArtifactLabeledComponent.setComponentClass("com.intellij.openapi.ui.ComboBox");
        this.myCustomArtifactLabeledComponent.setLabelLocation("West");
        this.myCustomArtifactLabeledComponent.setText("&Artifact");
        this.myPanel.add((Component)this.myCustomArtifactLabeledComponent, new GridConstraints(2, 0, 1, 4, 0, 1, 3, 3, null, null, null, 2, false));
        this.myPanel.add((Component)this.myDynamicFeaturesParametersComponent, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2, false));
        this.myInstantAppDeployCheckBoxWarning = new InstantAppDeprecatedPanel();
        this.myPanel.add((Component)this.myInstantAppDeployCheckBoxWarning, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 3, null, null, null, 2, false));
        this.myAllUsersCheckbox = new JBCheckBox();
        this.myAllUsersCheckbox.setText("Install for all users (if already installed, will only update for existing users)");
        this.myPanel.add((Component)this.myAllUsersCheckbox, new GridConstraints(5, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2, false));
        this.myPmOptionsLabeledComponent = new LabeledComponent();
        this.myPmOptionsLabeledComponent.setComponentClass("com.intellij.ui.components.JBTextField");
        this.myPmOptionsLabeledComponent.setLabelLocation("West");
        this.myPmOptionsLabeledComponent.setText("&Install Flags");
        this.myPanel.add((Component)this.myPmOptionsLabeledComponent, new GridConstraints(9, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2, false));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Launch Options");
        this.myPanel.add((Component)titledSeparator2, new GridConstraints(10, 0, 1, 4, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Launch:");
        jBLabel2.setDisplayedMnemonic('L');
        jBLabel2.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)jBLabel2, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2, false));
        this.myLaunchOptionCombo = new ComboBox();
        this.myPanel.add((Component)this.myLaunchOptionCombo, new GridConstraints(12, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myPanel.add((Component)spacer2, new GridConstraints(12, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myLaunchOptionsCardPanel = new ConfigurableCardPanel();
        this.myPanel.add((Component)this.myLaunchOptionsCardPanel, new GridConstraints(13, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2, false));
        this.myAmOptionsLabeledComponent = new LabeledComponent();
        this.myAmOptionsLabeledComponent.setComponentClass("com.intellij.ui.components.JBTextField");
        this.myAmOptionsLabeledComponent.setLabelLocation("West");
        this.myAmOptionsLabeledComponent.setText("Launch &Flags");
        this.myPanel.add((Component)this.myAmOptionsLabeledComponent, new GridConstraints(14, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2, false));
        Spacer spacer3 = new Spacer();
        this.myPanel.add((Component)spacer3, new GridConstraints(15, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myInstantAppDeployCheckBox = new JBCheckBox();
        this.myInstantAppDeployCheckBox.setText("Deploy as instant app");
        this.myPanel.add((Component)this.myInstantAppDeployCheckBox, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myAlwaysInstallWithPmCheckbox = new JBCheckBox();
        this.myAlwaysInstallWithPmCheckbox.setText("Always install with package manager (disables deploy optimizations on Android 11 and later)");
        this.myPanel.add((Component)this.myAlwaysInstallWithPmCheckbox, new GridConstraints(6, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2, false));
        this.myAssumeVerified = new JBCheckBox();
        this.myAssumeVerified.setText("Skip bytecode verification for debuggable apps on Android 15 (SDK 35) and higher");
        this.myPanel.add((Component)this.myAssumeVerified, new GridConstraints(7, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2, false));
        this.myClearAppStorageCheckbox = new JBCheckBox();
        this.myClearAppStorageCheckbox.setText("Clear app storage before deployment");
        this.myPanel.add((Component)this.myClearAppStorageCheckbox, new GridConstraints(8, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2, false));
        this.myRestorePanelWrapper = new JPanel();
        this.myRestorePanelWrapper.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myRestorePanelWrapper, new GridConstraints(16, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
    }

    @NotNull
    private static InstallOption getDeployOption(boolean deploy, boolean deployFromBundle, @Nullable String artifactName) {
        Preconditions.checkArgument((!deployFromBundle || deploy ? 1 : 0) != 0);
        if (deploy) {
            if (deployFromBundle) {
                return StringUtil.isEmpty((String)artifactName) ? InstallOption.APK_FROM_BUNDLE : InstallOption.CUSTOM_ARTIFACT;
            }
            return StringUtil.isEmpty((String)artifactName) ? InstallOption.DEFAULT_APK : InstallOption.CUSTOM_ARTIFACT;
        }
        return InstallOption.NOTHING;
    }

    @Override
    public void resetFrom(@NotNull AndroidRunConfiguration configuration2) {
        InstallOption installOption = ApplicationRunParameters.getDeployOption(configuration2.DEPLOY, configuration2.DEPLOY_APK_FROM_BUNDLE, configuration2.ARTIFACT_NAME);
        this.myDeployOptionCombo.setSelectedItem((Object)installOption);
        this.myInstantAppDeployCheckBox.setSelected(this.myInstantAppDeployCheckBox.isEnabled() && configuration2.DEPLOY_AS_INSTANT);
        Module currentModule = this.myModuleSelector.getModule();
        if (currentModule != null) {
            this.myDynamicFeaturesParameters.updateBasedOnInstantState(currentModule, this.myInstantAppDeployCheckBox.isSelected());
        }
        if (installOption == InstallOption.CUSTOM_ARTIFACT) {
            String artifactName = StringUtil.notNullize((String)configuration2.ARTIFACT_NAME);
            ArrayList arrayList = Lists.newArrayList(this.getAndroidArtifacts());
            Artifact selectedArtifact = ApplicationRunParameters.findArtifactByName(arrayList, artifactName);
            if (selectedArtifact != null) {
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)selectedArtifact);
            } else {
                ArrayList items = Lists.newArrayList((Object[])arrayList.toArray());
                items.add(artifactName);
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)artifactName);
            }
        }
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).setText(configuration2.PM_INSTALL_OPTIONS);
        this.myAllUsersCheckbox.setSelected(configuration2.ALL_USERS);
        this.myAlwaysInstallWithPmCheckbox.setSelected(configuration2.ALWAYS_INSTALL_WITH_PM);
        this.myAssumeVerified.setSelected(configuration2.ALLOW_ASSUME_VERIFIED);
        this.myClearAppStorageCheckbox.setSelected(configuration2.CLEAR_APP_STORAGE);
        for (LaunchOption launchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            LaunchOptionState state2 = configuration2.getLaunchOptionState(launchOption.getId());
            assert (state2 != null) : "State is null for option: " + launchOption.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)launchOption.getId())).resetFrom(state2);
        }
        LaunchOption launchOption = ApplicationRunParameters.getLaunchOption(configuration2.MODE);
        this.myLaunchOptionCombo.setSelectedItem((Object)launchOption);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).setText(configuration2.ACTIVITY_EXTRA_FLAGS);
        this.myDynamicFeaturesParameters.setDisabledDynamicFeatures(configuration2.getDisabledDynamicFeatures());
        if (this.myRestoreRunConfigSection != null) {
            this.myRestoreRunConfigSection.resetFrom((RunConfiguration)configuration2);
        }
    }

    @Override
    public void applyTo(@NotNull AndroidRunConfiguration configuration2) {
        Iterator<LaunchOption<? extends LaunchOptionState>> item;
        InstallOption installOption = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem());
        configuration2.DEPLOY = installOption != InstallOption.NOTHING;
        configuration2.DEPLOY_APK_FROM_BUNDLE = installOption == InstallOption.APK_FROM_BUNDLE;
        configuration2.DEPLOY_AS_INSTANT = this.myInstantAppDeployCheckBox.isSelected();
        configuration2.ARTIFACT_NAME = "";
        if (installOption == InstallOption.CUSTOM_ARTIFACT && (item = ((ComboBox)this.myCustomArtifactLabeledComponent.getComponent()).getSelectedItem()) instanceof Artifact) {
            configuration2.ARTIFACT_NAME = ((Artifact)item).getName();
        }
        configuration2.PM_INSTALL_OPTIONS = StringUtil.notNullize((String)((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getText());
        configuration2.ALL_USERS = this.myAllUsersCheckbox.isSelected();
        configuration2.ALWAYS_INSTALL_WITH_PM = this.myAlwaysInstallWithPmCheckbox.isSelected();
        configuration2.ALLOW_ASSUME_VERIFIED = this.myAssumeVerified.isSelected();
        configuration2.CLEAR_APP_STORAGE = this.myClearAppStorageCheckbox.isSelected();
        for (LaunchOption<? extends LaunchOptionState> option : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            LaunchOptionState state2 = configuration2.getLaunchOptionState(option.getId());
            assert (state2 != null) : "State is null for option: " + option.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)option.getId())).applyTo(state2);
        }
        if (this.myInstantAppDeployCheckBox.isSelected()) {
            this.myInstantAppDeployCheckBoxWarning.setVisible(true);
        } else {
            this.myInstantAppDeployCheckBoxWarning.setVisible(false);
        }
        LaunchOption launchOption = (LaunchOption)this.myLaunchOptionCombo.getSelectedItem();
        configuration2.MODE = launchOption.getId();
        configuration2.ACTIVITY_EXTRA_FLAGS = StringUtil.notNullize((String)((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getText());
        configuration2.setDisabledDynamicFeatures(this.myDynamicFeaturesParameters.getDisabledDynamicFeatures());
        if (this.myRestoreRunConfigSection != null) {
            this.myRestoreRunConfigSection.applyTo((RunConfiguration)configuration2);
        } else {
            configuration2.RESTORE_ENABLED = false;
        }
    }

    @NotNull
    private static LaunchOption getLaunchOption(@Nullable String mode) {
        if (StringUtil.isEmpty((String)mode)) {
            mode = DefaultActivityLaunch.INSTANCE.getId();
        }
        for (LaunchOption<? extends LaunchOptionState> option : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            if (!option.getId().equals(mode)) continue;
            return option;
        }
        throw new IllegalStateException("Unexpected error determining launch mode");
    }

    @Override
    public Component getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    private void updateBuildArtifactBeforeRunSetting() {
        Artifact newArtifact = null;
        Object item = this.myArtifactCombo.getSelectedItem();
        if (item instanceof Artifact) {
            newArtifact = (Artifact)item;
        }
        if (Objects.equals(newArtifact, this.myLastSelectedArtifact)) {
            return;
        }
        if (this.myLastSelectedArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)this.myLastSelectedArtifact, (boolean)false);
        }
        if (newArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)newArtifact, (boolean)true);
        }
        if (this.myLastSelectedArtifact == null || newArtifact == null) {
            this.addOrRemoveMakeTask(newArtifact == null);
        }
        this.myLastSelectedArtifact = newArtifact;
    }

    private void addOrRemoveMakeTask(boolean add2) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel);
        ConfigurationSettingsEditorWrapper editor = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editor == null) {
            return;
        }
        SmartList makeTasks = new SmartList();
        for (BeforeRunTask task2 : editor.getStepsBeforeLaunch()) {
            if (!(task2 instanceof CompileStepBeforeRun.MakeBeforeRunTask) && !(task2 instanceof CompileStepBeforeRunNoErrorCheck.MakeBeforeRunTaskNoErrorCheck)) continue;
            makeTasks.add(task2);
        }
        if (add2) {
            if (makeTasks.isEmpty()) {
                editor.addBeforeLaunchStep((BeforeRunTask)new CompileStepBeforeRun.MakeBeforeRunTask());
            } else {
                for (BeforeRunTask task2 : makeTasks) {
                    task2.setEnabled(true);
                }
            }
        } else {
            for (BeforeRunTask task2 : makeTasks) {
                task2.setEnabled(false);
            }
        }
    }

    @NotNull
    private Collection<? extends Artifact> getAndroidArtifacts() {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        ArtifactType androidArtifactType = ArtifactType.findById((String)"apk");
        return artifactManager == null || androidArtifactType == null ? Collections.emptyList() : artifactManager.getArtifactsByType(androidArtifactType);
    }

    @Nullable
    private static Artifact findArtifactByName(@NotNull List<Artifact> artifacts, @NotNull String artifactName) {
        for (Artifact artifact : artifacts) {
            if (!artifactName.equals(artifact.getName())) continue;
            return artifact;
        }
        return null;
    }

    public void onModuleChanged() {
        boolean isInstantApp;
        Module currentModule = this.myModuleSelector.getModule();
        if (currentModule == null) {
            this.myInstantAppDeployCheckBox.setEnabled(false);
            this.myInstantAppDeployCheckBox.setSelected(false);
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)currentModule);
        AndroidModel model = AndroidModel.get(currentModule);
        boolean bl = isInstantApp = facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4;
        if (isInstantApp) {
            this.myLaunchOptionCombo.setSelectedItem((Object)DeepLinkLaunch.INSTANCE);
            this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
        } else {
            this.myInstantAppDeployCheckBox.setEnabled(model != null && model.isInstantAppCompatible());
            if (model == null || !model.isInstantAppCompatible()) {
                this.myInstantAppDeployCheckBox.setSelected(false);
            }
            this.myLaunchOptionCombo.setSelectedItem((Object)DefaultActivityLaunch.INSTANCE);
        }
        this.myDeployOptionCombo.setEnabled(!isInstantApp);
        this.myCustomArtifactLabeledComponent.setEnabled(!isInstantApp);
        this.myLaunchOptionCombo.setEnabled(!isInstantApp);
        this.myDynamicFeaturesParameters.setActiveModule(currentModule, model != null && model.isInstantAppCompatible() && (Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get() != false ? DynamicFeaturesParameters.AvailableDeployTypes.INSTANT_AND_INSTALLED : DynamicFeaturesParameters.AvailableDeployTypes.INSTALLED_ONLY);
    }
}

