/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.adtui.ui.ClickableLabel;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class AndroidProfilersPanel {
    private final Project myProject;
    private JPanel myDescription;
    private JTextPane myNativeMemoryRateProfilerDescription;
    private JCheckBox myAdvancedProfilingCheckBox;
    private ClickableLabel myAdvancedProfilingLabel;
    private JEditorPane myAdvancedProfilingDescription;
    private JCheckBox myStartupProfileCheckBox;
    private ClickableLabel myStartupProfileLabel;
    private LabeledComponent<JBTextField> myNativeMemoryProfilerSampleRate;
    private ComboBox<CpuProfilerConfig> myStartupCpuConfigsComboBox;
    private JTextPane myStartupCpuProfilerDescription;
    private JBRadioButton myCpuRecordingRadio;
    private JBRadioButton myMemoryRecordingRadio;

    public JComponent getComponent() {
        return this.myDescription;
    }

    public AndroidProfilersPanel(Project project, ProfilerState state2) {
        this.myProject = project;
        this.setupUI();
        this.addActionListenersToLabels();
        this.setUpStartupProfiling();
        this.resetFrom(state2);
    }

    void addActionListenersToLabels() {
        this.myAdvancedProfilingLabel.addActionListener(e -> {
            this.myAdvancedProfilingCheckBox.requestFocus();
            this.myAdvancedProfilingCheckBox.setSelected(!this.myAdvancedProfilingCheckBox.isSelected());
        });
        this.myStartupProfileLabel.addActionListener(e -> this.myStartupProfileCheckBox.setSelected(!this.myStartupProfileCheckBox.isSelected()));
    }

    private void setUpStartupProfiling() {
        this.myStartupProfileCheckBox.addItemListener(e -> {
            this.myCpuRecordingRadio.setEnabled(this.myStartupProfileCheckBox.isSelected());
            this.myMemoryRecordingRadio.setEnabled(this.myStartupProfileCheckBox.isSelected());
            this.myStartupCpuConfigsComboBox.setEnabled(this.myCpuRecordingRadio.isSelected() && this.myStartupProfileCheckBox.isSelected());
            this.myStartupProfileCheckBox.setSelected(this.myStartupProfileCheckBox.isSelected());
        });
        this.myCpuRecordingRadio.addItemListener(e -> {
            if (this.myCpuRecordingRadio.isSelected()) {
                this.myMemoryRecordingRadio.setSelected(false);
                this.myStartupCpuConfigsComboBox.setEnabled(this.myCpuRecordingRadio.isSelected());
            }
        });
        this.myMemoryRecordingRadio.addItemListener(e -> {
            if (this.myMemoryRecordingRadio.isSelected()) {
                this.myCpuRecordingRadio.setSelected(false);
                this.myStartupCpuConfigsComboBox.setEnabled(!this.myMemoryRecordingRadio.isSelected());
            }
        });
        this.myStartupCpuConfigsComboBox.setModel(new DefaultComboBoxModel<CpuProfilerConfig>(CpuProfilerConfigsState.getInstance(this.myProject).getConfigs().toArray(new CpuProfilerConfig[0])));
        this.myStartupCpuConfigsComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", CpuProfilerConfig::getName));
        this.myStartupCpuConfigsComboBox.setSelectedIndex(0);
    }

    public void resetFrom(ProfilerState state2) {
        boolean enabled = this.myAdvancedProfilingCheckBox.isEnabled();
        this.myAdvancedProfilingCheckBox.setSelected(enabled && state2.ADVANCED_PROFILING_ENABLED);
        ((JBTextField)this.myNativeMemoryProfilerSampleRate.getComponent()).setText(Integer.toString(state2.NATIVE_MEMORY_SAMPLE_RATE_BYTES));
        this.myNativeMemoryRateProfilerDescription.setBackground(this.myDescription.getBackground());
        this.myNativeMemoryRateProfilerDescription.setForeground(UIUtil.getContextHelpForeground());
        this.myNativeMemoryRateProfilerDescription.setFont((Font)JBFont.small());
        this.myStartupProfileCheckBox.setSelected(state2.STARTUP_PROFILING_ENABLED);
        this.myCpuRecordingRadio.setSelected(state2.STARTUP_CPU_PROFILING_ENABLED);
        this.myMemoryRecordingRadio.setSelected(state2.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED);
        this.myStartupCpuProfilerDescription.setBackground(this.myDescription.getBackground());
        this.myStartupCpuProfilerDescription.setForeground(UIUtil.getContextHelpForeground());
        this.myStartupCpuProfilerDescription.setFont((Font)JBFont.small());
        String name2 = state2.STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        CpuProfilerConfig config = CpuProfilerConfigsState.getInstance(this.myProject).getConfigByName(name2);
        if (config != null) {
            this.myStartupCpuConfigsComboBox.setSelectedItem((Object)config);
        }
    }

    public void applyTo(ProfilerState state2) {
        state2.ADVANCED_PROFILING_ENABLED = this.myAdvancedProfilingCheckBox.isSelected();
        state2.STARTUP_CPU_PROFILING_ENABLED = this.myCpuRecordingRadio.isSelected();
        assert (this.myStartupCpuConfigsComboBox.getSelectedItem() instanceof CpuProfilerConfig);
        state2.STARTUP_CPU_PROFILING_CONFIGURATION_NAME = ((CpuProfilerConfig)this.myStartupCpuConfigsComboBox.getSelectedItem()).getName();
        state2.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED = this.myMemoryRecordingRadio.isSelected();
        state2.STARTUP_PROFILING_ENABLED = this.myStartupProfileCheckBox.isSelected();
        try {
            state2.NATIVE_MEMORY_SAMPLE_RATE_BYTES = Math.max(1, Integer.parseInt(((JBTextField)this.myNativeMemoryProfilerSampleRate.getComponent()).getText()));
        }
        catch (NumberFormatException ex) {
            state2.NATIVE_MEMORY_SAMPLE_RATE_BYTES = 2048;
        }
    }

    private void createUIComponents() {
        this.myAdvancedProfilingDescription = SwingHelper.createHtmlViewer((boolean)true, null, (Color)UIUtil.getPanelBackground(), (Color)UIUtil.getContextHelpForeground());
        this.myAdvancedProfilingDescription.setFont((Font)JBFont.small());
        this.myAdvancedProfilingDescription.setText("<html>Adds support for network payloads, the event timeline, allocated object count and garbage collection events on devices running API level < 26. May slightly increase build time due to compile-time instrumentation. Has no effect on devices running API level >= 26. <a href=\"https://developer.android.com/r/studio-ui/profiler/support-for-older-devices\">Learn more</a></html>");
        this.myAdvancedProfilingDescription.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myDescription = new JPanel();
        this.myDescription.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(10, 10, 10, 10), -1, -1));
        this.myStartupProfileCheckBox = new JCheckBox();
        this.myStartupProfileCheckBox.setHorizontalAlignment(4);
        this.myStartupProfileCheckBox.setHorizontalTextPosition(4);
        this.myStartupProfileCheckBox.setIconTextGap(0);
        this.myStartupProfileCheckBox.setMargin(new Insets(1, 0, 0, 0));
        this.myStartupProfileCheckBox.setText("");
        this.myDescription.add((Component)this.myStartupProfileCheckBox, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myDescription.add((Component)spacer1, new GridConstraints(6, 0, 1, 4, 0, 2, 1, 4, null, null, null, 0, false));
        this.myAdvancedProfilingDescription.setEditable(false);
        Font myAdvancedProfilingDescriptionFont = this.getFont(null, -1, -1, this.myAdvancedProfilingDescription.getFont());
        if (myAdvancedProfilingDescriptionFont != null) {
            this.myAdvancedProfilingDescription.setFont(myAdvancedProfilingDescriptionFont);
        }
        this.myDescription.add((Component)this.myAdvancedProfilingDescription, new GridConstraints(6, 1, 1, 2, 0, 3, 4, 2, null, new Dimension(150, 50), null, 0, false));
        this.myStartupProfileLabel = new ClickableLabel();
        this.myStartupProfileLabel.setMargin(new Insets(2, 14, 0, 14));
        this.myStartupProfileLabel.setText("Start this recording on startup:");
        this.myDescription.add((Component)this.myStartupProfileLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 3, null, null, null, 0, false));
        this.myNativeMemoryRateProfilerDescription = new JTextPane();
        this.myNativeMemoryRateProfilerDescription.setAutoscrolls(false);
        this.myNativeMemoryRateProfilerDescription.setDoubleBuffered(false);
        this.myNativeMemoryRateProfilerDescription.setEditable(false);
        this.myNativeMemoryRateProfilerDescription.setEnabled(true);
        Font myNativeMemoryRateProfilerDescriptionFont = this.getFont(null, -1, -1, this.myNativeMemoryRateProfilerDescription.getFont());
        if (myNativeMemoryRateProfilerDescriptionFont != null) {
            this.myNativeMemoryRateProfilerDescription.setFont(myNativeMemoryRateProfilerDescriptionFont);
        }
        this.myNativeMemoryRateProfilerDescription.setMargin(new Insets(0, 3, 0, 3));
        this.myNativeMemoryRateProfilerDescription.setText("Native memory sampling rate. This value when set will remain for both startup and non-startup recordings.");
        this.myDescription.add((Component)this.myNativeMemoryRateProfilerDescription, new GridConstraints(1, 1, 1, 2, 0, 3, 1, 1, null, null, null, 0, false));
        this.myAdvancedProfilingCheckBox = new JCheckBox();
        this.myAdvancedProfilingCheckBox.setAlignmentX(1.0f);
        this.myAdvancedProfilingCheckBox.setHorizontalAlignment(4);
        this.myAdvancedProfilingCheckBox.setHorizontalTextPosition(4);
        this.myAdvancedProfilingCheckBox.setIconTextGap(0);
        this.myAdvancedProfilingCheckBox.setMargin(new Insets(1, 0, 0, 0));
        this.myAdvancedProfilingCheckBox.setText("");
        this.myDescription.add((Component)this.myAdvancedProfilingCheckBox, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null, 0, false));
        this.myAdvancedProfilingLabel = new ClickableLabel();
        this.myAdvancedProfilingLabel.setText("Enable additional support for older devices (API level < 26)");
        this.myDescription.add((Component)this.myAdvancedProfilingLabel, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myDescription.add((Component)panel1, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.myCpuRecordingRadio = new JBRadioButton();
        this.myCpuRecordingRadio.setEnabled(false);
        this.myCpuRecordingRadio.setText("CPU activity (Requires API level >= 26)");
        panel1.add((Component)this.myCpuRecordingRadio, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 3, null, null, null, 0, false));
        this.myMemoryRecordingRadio = new JBRadioButton();
        this.myMemoryRecordingRadio.setEnabled(false);
        this.myMemoryRecordingRadio.setMargin(new Insets(0, 0, 0, 0));
        this.myMemoryRecordingRadio.setText("Native memory activity (Requires API level >= 29)");
        panel1.add((Component)this.myMemoryRecordingRadio, new GridConstraints(2, 0, 1, 1, 8, 1, 3, 3, null, null, null, 0, false));
        this.myStartupCpuConfigsComboBox = new ComboBox();
        this.myStartupCpuConfigsComboBox.setEnabled(false);
        panel1.add((Component)this.myStartupCpuConfigsComboBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 3, null, new Dimension(350, -1), null, 0, false));
        this.myNativeMemoryProfilerSampleRate = new LabeledComponent();
        try {
            this.myNativeMemoryProfilerSampleRate.setComponentClass("com.intellij.ui.components.JBTextField");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myNativeMemoryProfilerSampleRate.setLabelInsets(new Insets(0, 6, 0, 0));
        this.myNativeMemoryProfilerSampleRate.setLabelLocation("West");
        this.myNativeMemoryProfilerSampleRate.setText("Native memory sampling interval (bytes)");
        this.myDescription.add((Component)this.myNativeMemoryProfilerSampleRate, new GridConstraints(0, 0, 1, 3, 9, 1, 3, 3, null, null, null, 0, false));
        this.myStartupCpuProfilerDescription = new JTextPane();
        this.myStartupCpuProfilerDescription.setAutoscrolls(false);
        this.myStartupCpuProfilerDescription.setDoubleBuffered(false);
        this.myStartupCpuProfilerDescription.setEditable(false);
        this.myStartupCpuProfilerDescription.setEnabled(true);
        Font myStartupCpuProfilerDescriptionFont = this.getFont(null, -1, -1, this.myStartupCpuProfilerDescription.getFont());
        if (myStartupCpuProfilerDescriptionFont != null) {
            this.myStartupCpuProfilerDescription.setFont(myStartupCpuProfilerDescriptionFont);
        }
        this.myStartupCpuProfilerDescription.setMargin(new Insets(0, 3, 0, 3));
        this.myStartupCpuProfilerDescription.setText("You must select Run > Profile from the main menu and deploy your app to a device");
        this.myDescription.add((Component)this.myStartupCpuProfilerDescription, new GridConstraints(3, 1, 1, 1, 0, 3, 1, 1, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }
}

