/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerConfigurable;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerContext;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.google.common.collect.Maps;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDebuggerPanel {
    private final AndroidDebuggerContext myAndroidDebuggerContext;
    private JPanel myPanel;
    private JComboBox<AndroidDebugger> myDebuggerType;
    private JPanel myOptionPanel;
    private JComponent myOptionComponent;
    private final Map<String, AndroidDebuggerConfigurable<AndroidDebuggerState>> myConfigurables = Maps.newHashMap();

    public AndroidDebuggerPanel(@NotNull RunConfiguration runConfiguration, @NotNull AndroidDebuggerContext androidDebuggerContext) {
        this.setupUI();
        this.myAndroidDebuggerContext = androidDebuggerContext;
        this.myDebuggerType.setModel((ComboBoxModel<AndroidDebugger>)new CollectionComboBoxModel(this.myAndroidDebuggerContext.getAndroidDebuggers()));
        this.myDebuggerType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AndroidDebugger androidDebugger = (AndroidDebugger)AndroidDebuggerPanel.this.myDebuggerType.getSelectedItem();
                if (androidDebugger != null) {
                    AndroidDebuggerPanel.this.switchDebugOption(androidDebugger);
                }
            }
        });
        this.myDebuggerType.setRenderer((ListCellRenderer<AndroidDebugger>)SimpleListCellRenderer.create((String)"", AndroidDebugger::getDisplayName));
        for (AndroidDebugger androidDebugger : this.myAndroidDebuggerContext.getAndroidDebuggers()) {
            AndroidDebuggerConfigurable configurable = androidDebugger.createConfigurable(runConfiguration);
            configurable.resetFrom(this.myAndroidDebuggerContext.getAndroidDebuggerState(androidDebugger.getId()));
            this.myConfigurables.put(androidDebugger.getId(), configurable);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void switchDebugOption(@NotNull AndroidDebugger<AndroidDebuggerState> androidDebugger) {
        if (this.myOptionComponent != null) {
            this.myOptionPanel.remove(this.myOptionComponent);
            this.myOptionComponent = null;
        }
        AndroidDebuggerConfigurable<AndroidDebuggerState> configurable = this.getConfigurable(androidDebugger);
        configurable.resetFrom((AndroidDebuggerState)this.myAndroidDebuggerContext.getAndroidDebuggerState(androidDebugger.getId()));
        this.myOptionComponent = configurable.getComponent();
        if (this.myOptionComponent != null) {
            this.myOptionPanel.add(this.myOptionComponent);
        }
    }

    public void resetFrom(@NotNull AndroidDebuggerContext androidDebuggerContext) {
        AndroidDebugger debugOption = androidDebuggerContext.getAndroidDebugger();
        if (debugOption != null) {
            this.myDebuggerType.setSelectedItem(debugOption);
            this.switchDebugOption(debugOption);
        }
    }

    public void applyTo(@NotNull AndroidDebuggerContext androidDebuggerContext) {
        AndroidDebugger androidDebugger = (AndroidDebugger)this.myDebuggerType.getSelectedItem();
        androidDebuggerContext.setDebuggerType(androidDebugger.getId());
        AndroidDebuggerConfigurable<AndroidDebuggerState> configurable = this.getConfigurable(androidDebugger);
        if (configurable != null) {
            configurable.applyTo((AndroidDebuggerState)androidDebuggerContext.getAndroidDebuggerState(androidDebugger.getId()));
        }
    }

    @Nullable
    AndroidDebuggerConfigurable<AndroidDebuggerState> getConfigurable(@NotNull AndroidDebugger<AndroidDebuggerState> androidDebugger) {
        return this.myConfigurables.get(androidDebugger.getId());
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myOptionPanel = new JPanel();
        this.myOptionPanel.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myOptionPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Debug type:");
        this.myPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDebuggerType = new JComboBox();
        this.myDebuggerType.setEditable(false);
        this.myDebuggerType.setEnabled(true);
        this.myPanel.add(this.myDebuggerType, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
    }
}

