/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.selector;

import com.android.tools.idea.run.deployment.selector.BootSnapshot;
import com.android.tools.idea.run.deployment.selector.DeploymentTarget;
import com.android.tools.idea.run.deployment.selector.DeploymentTargetDeviceKt;
import com.android.tools.idea.run.deployment.selector.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.selector.DevicesAndTargets;
import com.intellij.openapi.actionSystem.Presentation;
import icons.StudioIcons;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/run/deployment/selector/Updater;", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "devicesAndTargets", "Lcom/android/tools/idea/run/deployment/selector/DevicesAndTargets;", "<init>", "(Lcom/intellij/openapi/actionSystem/Presentation;Lcom/android/tools/idea/run/deployment/selector/DevicesAndTargets;)V", "update", "", "displayText", "", "Lcom/android/tools/idea/run/deployment/selector/DeploymentTarget;", "intellij.android.core"})
public final class Updater {
    @NotNull
    private final Presentation presentation;
    @NotNull
    private final DevicesAndTargets devicesAndTargets;

    public Updater(@NotNull Presentation presentation, @NotNull DevicesAndTargets devicesAndTargets) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)devicesAndTargets, (String)"devicesAndTargets");
        this.presentation = presentation;
        this.devicesAndTargets = devicesAndTargets;
    }

    public final void update() {
        if (this.devicesAndTargets.isMultipleSelectionMode()) {
            this.presentation.setIcon(StudioIcons.DeviceExplorer.MULTIPLE_DEVICES);
            this.presentation.putClientProperty(DeviceAndSnapshotComboBoxAction.LAUNCH_COMPATIBILITY_KEY, null);
            this.presentation.setText("Multiple Devices (" + this.devicesAndTargets.getSelectedTargets().size() + ")");
        } else {
            DeploymentTarget target2 = (DeploymentTarget)CollectionsKt.firstOrNull(this.devicesAndTargets.getSelectedTargets());
            if (target2 == null) {
                this.presentation.setIcon(null);
                this.presentation.setText("No Devices");
            } else {
                this.presentation.setIcon(target2.getDevice().getIcon());
                this.presentation.putClientProperty(DeviceAndSnapshotComboBoxAction.LAUNCH_COMPATIBILITY_KEY, (Object)target2.getDevice().getLaunchCompatibility());
                this.presentation.setText(this.displayText(target2), false);
            }
        }
    }

    private final String displayText(DeploymentTarget $this$displayText) {
        String disambiguatedName = DeploymentTargetDeviceKt.disambiguatedName($this$displayText.getDevice(), this.devicesAndTargets.getAllDevices());
        return $this$displayText.getBootOption() instanceof BootSnapshot ? disambiguatedName + " - " + ((BootSnapshot)$this$displayText.getBootOption()).getText() : disambiguatedName;
    }
}

