/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.LiveEditOutputBuilder;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.analysis.MethodUtilKt;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrAccessFlag;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrClass;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrField;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrMethod;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"logger", "Lcom/android/tools/idea/log/LogWrapper;", "debug", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "isWhenMapping", "", "clazz", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrClass;", "checkForInit", "", "irClass", "irMethod", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrMethod;", "throwOnFail", "isKeyMeta", "classFile", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "isNonPrivateInline", "method", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditOutputBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditOutputBuilder.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditOutputBuilderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,295:1\n1740#2,3:296\n*S KotlinDebug\n*F\n+ 1 LiveEditOutputBuilder.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditOutputBuilderKt\n*L\n268#1:296,3\n*E\n"})
public final class LiveEditOutputBuilderKt {
    @NotNull
    private static final LogWrapper logger = new LogWrapper(Logger.getInstance(LiveEditOutputBuilder.class));
    @NotNull
    private static final LiveEditLogger debug = new LiveEditLogger("LiveEditOutputBuilder");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isWhenMapping(IrClass clazz2) {
        IrField it;
        if (!StringsKt.endsWith$default((String)clazz2.getName(), (String)"$WhenMappings", (boolean)false, (int)2, null)) return false;
        Iterable $this$all$iv = clazz2.getFields();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (IrField)element$iv;
            boolean bl = false;
        } while (StringsKt.startsWith$default((String)it.getName(), (String)"$EnumSwitchMapping$", (boolean)false, (int)2, null));
        return false;
    }

    private static final void checkForInit(IrClass irClass, IrMethod irMethod, boolean throwOnFail) {
        if (Intrinsics.areEqual((Object)irMethod.getName(), (Object)"<init>")) {
            if (throwOnFail) {
                throw LiveEditUpdateException.Companion.unsupportedSourceModificationConstructor("in " + StringsKt.replace$default((String)irClass.getName(), (char)'/', (char)'.', (boolean)false, (int)4, null) + ", modified constructor " + irMethod.getReadableDesc());
            }
            logger.warning("Live Edit detected modified constructor " + irClass.getName() + irMethod.getDesc() + " in " + irClass.getSourceFile(), new Object[0]);
        }
        if (Intrinsics.areEqual((Object)irMethod.getName(), (Object)"<clinit>")) {
            if (throwOnFail) {
                throw LiveEditUpdateException.Companion.unsupportedSourceModificationClinit("in " + StringsKt.replace$default((String)irClass.getName(), (char)'/', (char)'.', (boolean)false, (int)4, null) + ", modified static initializer");
            }
            logger.warning("Live Edit detected modified static initializer block in class " + irClass.getName() + " of " + irClass.getSourceFile(), new Object[0]);
        }
    }

    private static final boolean isKeyMeta(OutputFile classFile) {
        return StringsKt.endsWith$default((String)classFile.getRelativePath(), (String)"$KeyMeta.class", (boolean)false, (int)2, null);
    }

    private static final boolean isNonPrivateInline(IrMethod method2) {
        return MethodUtilKt.isInline(method2) && !method2.getAccess().contains((Object)IrAccessFlag.PRIVATE);
    }

    public static final /* synthetic */ LiveEditLogger access$getDebug$p() {
        return debug;
    }

    public static final /* synthetic */ LogWrapper access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ boolean access$isWhenMapping(IrClass clazz2) {
        return LiveEditOutputBuilderKt.isWhenMapping(clazz2);
    }

    public static final /* synthetic */ boolean access$isNonPrivateInline(IrMethod method2) {
        return LiveEditOutputBuilderKt.isNonPrivateInline(method2);
    }

    public static final /* synthetic */ void access$checkForInit(IrClass irClass, IrMethod irMethod, boolean throwOnFail) {
        LiveEditOutputBuilderKt.checkForInit(irClass, irMethod, throwOnFail);
    }

    public static final /* synthetic */ boolean access$isKeyMeta(OutputFile classFile) {
        return LiveEditOutputBuilderKt.isKeyMeta(classFile);
    }
}

