/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration.execution;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.Activator;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.ComponentType;
import com.android.tools.idea.execution.common.AppRunSettings;
import com.android.tools.idea.execution.common.ApplicationDeployer;
import com.android.tools.idea.execution.common.ComponentLaunchOptions;
import com.android.tools.idea.execution.common.DeployOptions;
import com.android.tools.idea.projectsystem.ApplicationProjectContext;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.configuration.AndroidComplicationConfiguration;
import com.android.tools.idea.run.configuration.ComplicationTypeUtilsKt;
import com.android.tools.idea.run.configuration.ComplicationWatchFaceInfo;
import com.android.tools.idea.run.configuration.execution.AndroidComplicationConfigurationExecutorKt;
import com.android.tools.idea.run.configuration.execution.AndroidWearConfigurationExecutor;
import com.android.tools.idea.run.configuration.execution.ComplicationLaunchOptions;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.android.tools.idea.run.configuration.execution.RecordOutputReceiver;
import com.android.tools.idea.run.configuration.execution.SurfaceVersionException;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J2\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J!\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0000\u00a2\u0006\u0002\b)J \u0010*\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J,\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130,2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010-\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/run/configuration/execution/AndroidComplicationConfigurationExecutor;", "Lcom/android/tools/idea/run/configuration/execution/AndroidWearConfigurationExecutor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "deviceFutures", "Lcom/android/tools/idea/run/DeviceFutures;", "appRunSettings", "Lcom/android/tools/idea/execution/common/AppRunSettings;", "apkProvider", "Lcom/android/tools/idea/run/ApkProvider;", "applicationContext", "Lcom/android/tools/idea/projectsystem/ApplicationProjectContext;", "deployer", "Lcom/android/tools/idea/execution/common/ApplicationDeployer;", "<init>", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/android/tools/idea/run/DeviceFutures;Lcom/android/tools/idea/execution/common/AppRunSettings;Lcom/android/tools/idea/run/ApkProvider;Lcom/android/tools/idea/projectsystem/ApplicationProjectContext;Lcom/android/tools/idea/execution/common/ApplicationDeployer;)V", "complicationLaunchOptions", "Lcom/android/tools/idea/run/configuration/execution/ComplicationLaunchOptions;", "launch", "", "device", "Lcom/android/ddmlib/IDevice;", "app", "Lcom/android/tools/deployer/model/App;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "isDebug", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "setComplicationOnWatchFace", "slot", "Lcom/android/tools/idea/run/configuration/AndroidComplicationConfiguration$ChosenSlot;", "mode", "Lcom/android/tools/deployer/model/component/AppComponent$Mode;", "getComplicationSourceTypes", "", "", "apks", "", "Lcom/android/tools/idea/run/ApkInfo;", "getComplicationSourceTypes$intellij_android_core", "installWatchApp", "getStopCallback", "Lkotlin/Function1;", "applicationId", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidComplicationConfigurationExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidComplicationConfigurationExecutor.kt\ncom/android/tools/idea/run/configuration/execution/AndroidComplicationConfigurationExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1#2:201\n1869#3,2:202\n1761#3,3:204\n*S KotlinDebug\n*F\n+ 1 AndroidComplicationConfigurationExecutor.kt\ncom/android/tools/idea/run/configuration/execution/AndroidComplicationConfigurationExecutor\n*L\n99#1:202,2\n142#1:204,3\n*E\n"})
public final class AndroidComplicationConfigurationExecutor
extends AndroidWearConfigurationExecutor {
    @NotNull
    private final ComplicationLaunchOptions complicationLaunchOptions;

    public AndroidComplicationConfigurationExecutor(@NotNull ExecutionEnvironment environment, @NotNull DeviceFutures deviceFutures, @NotNull AppRunSettings appRunSettings2, @NotNull ApkProvider apkProvider, @NotNull ApplicationProjectContext applicationContext, @NotNull ApplicationDeployer deployer) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)deviceFutures, (String)"deviceFutures");
        Intrinsics.checkNotNullParameter((Object)appRunSettings2, (String)"appRunSettings");
        Intrinsics.checkNotNullParameter((Object)apkProvider, (String)"apkProvider");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)deployer, (String)"deployer");
        super(environment, deviceFutures, appRunSettings2, apkProvider, applicationContext, deployer);
        ComponentLaunchOptions componentLaunchOptions = appRunSettings2.getComponentLaunchOptions();
        Intrinsics.checkNotNull((Object)componentLaunchOptions, (String)"null cannot be cast to non-null type com.android.tools.idea.run.configuration.execution.ComplicationLaunchOptions");
        this.complicationLaunchOptions = (ComplicationLaunchOptions)componentLaunchOptions;
    }

    @Override
    @WorkerThread
    public void launch(@NotNull IDevice device2, @NotNull App app, @NotNull ConsoleView console, boolean isDebug, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        AppComponent.Mode mode = isDebug ? AppComponent.Mode.DEBUG : AppComponent.Mode.RUN;
        int version2 = ExecutionUtils.getWearDebugSurfaceVersion(device2, indicator);
        if (version2 < 2) {
            throw new SurfaceVersionException(2, version2, device2.isEmulator());
        }
        if (version2 < 3) {
            String string = AndroidBundle.message("android.run.configuration.debug.surface.warn", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ExecutionUtils.printlnError(console, string);
        }
        ProgressManager.checkCanceled();
        Collection<ApkInfo> collection2 = this.getApkProvider().getApks(device2);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getApks(...)");
        this.complicationLaunchOptions.verifyProviderTypes$intellij_android_core(ComplicationTypeUtilsKt.parseRawComplicationTypes(this.getComplicationSourceTypes$intellij_android_core(collection2)));
        ProgressManager.checkCanceled();
        this.installWatchApp(device2, console, indicator);
        if (isDebug) {
            AndroidComplicationConfiguration.ChosenSlot slot = (AndroidComplicationConfiguration.ChosenSlot)CollectionsKt.first(this.complicationLaunchOptions.getChosenSlots());
            boolean bl = false;
            this.setComplicationOnWatchFace(app, slot, AppComponent.Mode.RUN, indicator, device2);
            this.getStopCallback(console, this.getApplicationContext().getApplicationId(), false).invoke((Object)device2);
        }
        indicator.setText("Setting up complication...");
        Iterable $this$forEach$iv = this.complicationLaunchOptions.getChosenSlots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidComplicationConfiguration.ChosenSlot slot = (AndroidComplicationConfiguration.ChosenSlot)element$iv;
            boolean bl = false;
            this.setComplicationOnWatchFace(app, slot, mode, indicator, device2);
        }
        this.showWatchFace(device2, console, indicator);
    }

    private final void setComplicationOnWatchFace(App app, AndroidComplicationConfiguration.ChosenSlot slot, AppComponent.Mode mode, ProgressIndicator indicator, IDevice device2) {
        if (slot.getType() == null) {
            throw new ExecutionException("Slot type is not specified for slot(id: " + slot.getId() + ").");
        }
        RecordOutputReceiver receiver2 = new RecordOutputReceiver((Function0<Boolean>)((Function0)() -> AndroidComplicationConfigurationExecutor.setComplicationOnWatchFace$lambda$0(indicator)));
        String watchFaceInfo = this.complicationLaunchOptions.watchFaceInfo.getAppId() + " " + this.complicationLaunchOptions.watchFaceInfo.getWatchFaceFQName();
        try {
            Activator activator = this.getActivator$intellij_android_core(app);
            ComponentType componentType = this.complicationLaunchOptions.getComponentType();
            String string = this.complicationLaunchOptions.getComponentName();
            Intrinsics.checkNotNull((Object)string);
            activator.activate(componentType, string, watchFaceInfo + " " + slot.getId() + " " + slot.getType(), mode, (IShellOutputReceiver)receiver2, device2);
        }
        catch (DeployerException ex) {
            CharSequence charSequence;
            CharSequence charSequence2 = receiver2.getOutput();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = ex.getDetails();
            } else {
                charSequence = charSequence2;
            }
            Throwable throwable = ex;
            String string = "Error while launching complication, message: " + charSequence;
            throw new ExecutionException(string, throwable);
        }
    }

    @NotNull
    public final List<String> getComplicationSourceTypes$intellij_android_core(@NotNull Collection<ApkInfo> apks) {
        List list2;
        Intrinsics.checkNotNullParameter(apks, (String)"apks");
        try {
            String string = this.complicationLaunchOptions.getComponentName();
            Intrinsics.checkNotNull((Object)string);
            list2 = ComplicationTypeUtilsKt.getComplicationSourceTypes(apks, string);
        }
        catch (Exception exception) {
            Logger.getInstance(this.getClass()).warn((Throwable)exception);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final App installWatchApp(IDevice device2, ConsoleView console, ProgressIndicator indicator) {
        boolean bl;
        ApkInfo apkInfo;
        block3: {
            ComplicationWatchFaceInfo watchFaceInfo = this.complicationLaunchOptions.watchFaceInfo;
            apkInfo = new ApkInfo(new File(watchFaceInfo.getApk()), watchFaceInfo.getAppId(), null, 4, null);
            ExecutionUtils.println(console, "Installing test WatchFace...");
            indicator.setText("Installing test WatchFace");
            List list2 = this.getConfiguration().getBeforeRunTasks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBeforeRunTasks(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BeforeRunTask it = (BeforeRunTask)element$iv;
                    boolean bl2 = false;
                    if (!it.isEnabled()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean containsMakeBeforeRun = bl;
        App app = this.getApplicationDeployer().fullDeploy((IDevice)device2, (ApkInfo)apkInfo, (DeployOptions)this.getAppRunSettings().getDeployOptions(), (boolean)containsMakeBeforeRun, (ProgressIndicator)indicator).app;
        Intrinsics.checkNotNullExpressionValue((Object)app, (String)"app");
        return app;
    }

    @Override
    @NotNull
    protected Function1<IDevice, Unit> getStopCallback(@NotNull ConsoleView console, @NotNull String applicationId2, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        String string = this.complicationLaunchOptions.getComponentName();
        Intrinsics.checkNotNull((Object)string);
        String complicationComponentName = AppComponent.getFQEscapedName((String)applicationId2, (String)string);
        Intrinsics.checkNotNull((Object)complicationComponentName);
        return AndroidComplicationConfigurationExecutorKt.access$getStopComplicationCallback(complicationComponentName, console, isDebug);
    }

    private static final boolean setComplicationOnWatchFace$lambda$0(ProgressIndicator $indicator) {
        ProgressIndicator progressIndicator = $indicator;
        return progressIndicator != null ? progressIndicator.isCanceled() : false;
    }
}

