/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration.editors;

import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.configuration.AndroidDeclarativeWatchFaceConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/run/configuration/editors/AndroidDeclarativeWatchFaceConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/android/tools/idea/run/configuration/AndroidDeclarativeWatchFaceConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modulesComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "moduleSelector", "Lcom/intellij/execution/ui/ConfigurationModuleSelector;", "getModuleSelector$annotations", "()V", "getModuleSelector", "()Lcom/intellij/execution/ui/ConfigurationModuleSelector;", "resetEditorFrom", "", "configuration", "applyEditorTo", "createEditor", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.android.core"})
public final class AndroidDeclarativeWatchFaceConfigurationEditor
extends SettingsEditor<AndroidDeclarativeWatchFaceConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final ModulesComboBox modulesComboBox;
    @NotNull
    private final ConfigurationModuleSelector moduleSelector;

    public AndroidDeclarativeWatchFaceConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modulesComboBox = new ModulesComboBox();
        Project project2 = this.project;
        ModulesComboBox modulesComboBox = this.modulesComboBox;
        this.moduleSelector = new ConfigurationModuleSelector(project2, modulesComboBox){

            public boolean isModuleAccepted(Module module) {
                if (module == null || !super.isModuleAccepted(module)) {
                    return false;
                }
                boolean isHolderModule = Intrinsics.areEqual((Object)ProjectSystemUtil.getModuleSystem(module).getHolderModule(), (Object)module);
                if (!isHolderModule) {
                    return false;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
                if (androidFacet == null) {
                    return false;
                }
                AndroidFacet facet = androidFacet;
                return ProjectSystemUtil.getModuleSystem(facet).getType() == AndroidModuleSystem.Type.TYPE_APP;
            }
        };
        this.modulesComboBox.addActionListener(arg_0 -> AndroidDeclarativeWatchFaceConfigurationEditor._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final ConfigurationModuleSelector getModuleSelector() {
        return this.moduleSelector;
    }

    @VisibleForTesting
    public static /* synthetic */ void getModuleSelector$annotations() {
    }

    protected void resetEditorFrom(@NotNull AndroidDeclarativeWatchFaceConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.moduleSelector.reset((ModuleBasedConfiguration)configuration2);
        JComponent jComponent = this.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.DialogPanel");
        ((DialogPanel)jComponent).reset();
    }

    protected void applyEditorTo(@NotNull AndroidDeclarativeWatchFaceConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        JComponent jComponent = this.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.DialogPanel");
        ((DialogPanel)jComponent).apply();
        this.moduleSelector.applyTo((ModuleBasedConfiguration)configuration2);
    }

    @NotNull
    protected DialogPanel createEditor() {
        return BuilderKt.panel(arg_0 -> AndroidDeclarativeWatchFaceConfigurationEditor.createEditor$lambda$0(this, arg_0));
    }

    private static final void _init_$lambda$0(AndroidDeclarativeWatchFaceConfigurationEditor this$0, ActionEvent it) {
        Project project = this$0.project;
        String string = AndroidBundle.message("android.run.configuration.loading", new Object[0]);
        new Task.Modal(this$0, project, string){
            final /* synthetic */ AndroidDeclarativeWatchFaceConfigurationEditor this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        Module module = this.this$0.getModuleSelector().getModule();
                        if (module == null) break block2;
                        Project project = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        if (!DumbService.Companion.isDumb(project)) break block3;
                    }
                    return;
                }
            }

            public void onFinished() {
                block1: {
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (!ProjectSystemUtil.getProjectSystem(project).getSyncManager().isSyncInProgress()) break block1;
                    Container container = this.this$0.getComponent();
                    if (container != null && (container = container.getParent()) != null && (container = container.getParent()) != null) {
                        Container container2;
                        Container $this$onFinished_u24lambda_u240 = container2 = container;
                        boolean bl = false;
                        $this$onFinished_u24lambda_u240.removeAll();
                        $this$onFinished_u24lambda_u240.setLayout(new BorderLayout());
                        $this$onFinished_u24lambda_u240.add((Component)new JBPanelWithEmptyText().withEmptyText(AndroidBundle.message("android.run.configuration.synchronization.warning", new Object[0])));
                    }
                }
            }
        }.queue();
    }

    private static final Unit createEditor$lambda$0(AndroidDeclarativeWatchFaceConfigurationEditor this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AndroidDeclarativeWatchFaceConfigurationEditor.createEditor$lambda$0$0(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$0(AndroidDeclarativeWatchFaceConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = AndroidBundle.message("android.run.configuration.module.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        $this$row.cell((JComponent)this$0.modulesComboBox).align((Align)AlignX.FILL.INSTANCE).applyToComponent(AndroidDeclarativeWatchFaceConfigurationEditor::createEditor$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$0$0(ModulesComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMaximumSize(new Dimension(400, $this$applyToComponent.getMaximumSize().height));
        return Unit.INSTANCE;
    }
}

