/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity.launch;

import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.launch.DeepLinkLaunch;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurable;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.editor.DeepLinkChooserDialog;
import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidTreeClassChooserFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/run/activity/launch/DeepLinkConfigurable;", "Lcom/android/tools/idea/run/activity/launch/LaunchOptionConfigurable;", "Lcom/android/tools/idea/run/activity/launch/DeepLinkLaunch$State;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/android/tools/idea/run/activity/launch/LaunchOptionConfigurableContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/run/activity/launch/LaunchOptionConfigurableContext;)V", "deepLinkField", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Lcom/intellij/ui/components/JBTextField;", "activityField", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "createComponent", "resetFrom", "", "state", "applyTo", "intellij.android.core"})
public final class DeepLinkConfigurable
implements LaunchOptionConfigurable<DeepLinkLaunch.State> {
    @NotNull
    private final ComponentWithBrowseButton<JBTextField> deepLinkField;
    @NotNull
    private final ComponentWithBrowseButton<JBTextField> activityField;
    @NotNull
    private final DialogPanel panel;

    /*
     * WARNING - void declaration
     */
    public DeepLinkConfigurable(@NotNull Project project, @NotNull LaunchOptionConfigurableContext context) {
        void $this$activityField_u24lambda_u240;
        ComponentWithBrowseButton $this$deepLinkField_u24lambda_u240;
        ComponentWithBrowseButton componentWithBrowseButton;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ComponentWithBrowseButton componentWithBrowseButton2 = componentWithBrowseButton = new ComponentWithBrowseButton((JComponent)new JBTextField(), null);
        DeepLinkConfigurable deepLinkConfigurable = this;
        boolean bl = false;
        $this$deepLinkField_u24lambda_u240.addActionListener(arg_0 -> DeepLinkConfigurable.deepLinkField$lambda$0$0(project, context, $this$deepLinkField_u24lambda_u240, arg_0));
        ((JBTextField)$this$deepLinkField_u24lambda_u240.getChildComponent()).getEmptyText().setText("Specify URL declared in the manifest");
        deepLinkConfigurable.deepLinkField = componentWithBrowseButton;
        $this$deepLinkField_u24lambda_u240 = componentWithBrowseButton = new ComponentWithBrowseButton((JComponent)new JBTextField(), null);
        deepLinkConfigurable = this;
        boolean bl2 = false;
        $this$activityField_u24lambda_u240.addActionListener(arg_0 -> DeepLinkConfigurable.activityField$lambda$0$0(project, context, (ComponentWithBrowseButton)$this$activityField_u24lambda_u240, arg_0));
        deepLinkConfigurable.activityField = componentWithBrowseButton;
        this.panel = BuilderKt.panel(arg_0 -> DeepLinkConfigurable.panel$lambda$0(this, arg_0));
    }

    @NotNull
    public DialogPanel createComponent() {
        return this.panel;
    }

    @Override
    public void resetFrom(@NotNull DeepLinkLaunch.State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        ((JBTextField)this.deepLinkField.getChildComponent()).setText(StringUtil.notNullize((String)state2.DEEP_LINK));
        ((JBTextField)this.activityField.getChildComponent()).setText(StringUtil.notNullize((String)state2.ACTIVITY));
    }

    @Override
    public void applyTo(@NotNull DeepLinkLaunch.State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        state2.DEEP_LINK = StringUtil.notNullize((String)((JBTextField)this.deepLinkField.getChildComponent()).getText());
        state2.ACTIVITY = StringUtil.notNullize((String)((JBTextField)this.activityField.getChildComponent()).getText());
    }

    private static final void deepLinkField$lambda$0$0(Project $project, LaunchOptionConfigurableContext $context, ComponentWithBrowseButton $this_apply, ActionEvent it) {
        if (!$project.isInitialized()) {
            return;
        }
        Module module = $context.getModule();
        if (module == null) {
            Messages.showErrorDialog((Project)$project, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]), (String)"Deep Link Launcher");
            return;
        }
        DeepLinkChooserDialog dialog2 = new DeepLinkChooserDialog($project, module);
        dialog2.setTitle("Select URL");
        dialog2.show();
        String deepLinkSelected = dialog2.getSelectedDeepLink();
        CharSequence charSequence = deepLinkSelected;
        if (!(charSequence == null || charSequence.length() == 0)) {
            ((JBTextField)$this_apply.getChildComponent()).setText(deepLinkSelected);
        }
    }

    private static final void activityField$lambda$0$0(Project $project, LaunchOptionConfigurableContext $context, ComponentWithBrowseButton $this_apply, ActionEvent it) {
        if (!$project.isInitialized()) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$project);
        PsiClass activityBaseClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)$project));
        if (activityBaseClass == null) {
            Messages.showErrorDialog((Project)$project, (String)AndroidBundle.message("cant.find.activity.class.error", new Object[0]), (String)"Specific Activity Launcher");
            return;
        }
        Module module = $context.getModule();
        if (module == null) {
            Messages.showErrorDialog((Project)$project, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]), (String)"Specific Activity Launcher");
            return;
        }
        PsiClass initialSelection = facade.findClass(((JBTextField)$this_apply.getChildComponent()).getText(), module.getModuleWithDependenciesScope());
        TreeClassChooser chooser = (TreeClassChooser)AndroidTreeClassChooserFactory.INSTANCE.createInheritanceClassChooser($project, "Select Activity Class", module.getModuleWithDependenciesScope(), activityBaseClass, initialSelection, null);
        chooser.showDialog();
        PsiClass selClass = chooser.getSelected();
        if (selClass != null) {
            ((JBTextField)$this_apply.getChildComponent()).setText(ActivityLocatorUtils.getQualifiedActivityName(selClass));
        }
    }

    private static final Unit panel$lambda$0(DeepLinkConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DeepLinkConfigurable.panel$lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DeepLinkConfigurable.panel$lambda$0$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(DeepLinkConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("URL:");
        $this$row.cell((JComponent)this$0.deepLinkField).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1(DeepLinkConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("Activity (optional):");
        $this$row.cell((JComponent)this$0.activityField).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }
}

