/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.tools.idea.run.activity.manifest.NodeActivity;
import com.android.tools.manifest.parser.ManifestInfo;
import com.android.tools.manifest.parser.components.IntentFilter;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DefaultApkActivityLocator
extends ActivityLocator {
    private static final Logger LOG = Logger.getInstance(DefaultApkActivityLocator.class);
    private final ApkProvider myApkProvider;
    private final String myApplicationId;

    public DefaultApkActivityLocator(@NotNull ApkProvider apkProvider, @NotNull String applicationId2) {
        this.myApkProvider = apkProvider;
        this.myApplicationId = applicationId2;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device2) throws ActivityLocator.ActivityLocatorException {
        Collection<ApkInfo> apks;
        try {
            apks = this.myApkProvider.getApks(device2);
        }
        catch (Exception e) {
            throw new ActivityLocator.ActivityLocatorException("Unable to list apks", e);
        }
        if (apks.isEmpty()) {
            throw new ActivityLocator.ActivityLocatorException("No APKs provided. Unable to extract default activity");
        }
        String defaultActivity = DefaultApkActivityLocator.computeDefaultActivityFromApks(apks, this.myApplicationId);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        return defaultActivity;
    }

    private static String computeDefaultActivityFromApks(@NotNull Collection<ApkInfo> apks, @NotNull String applicationId2) {
        List filteredApks = apks.stream().filter(apk -> apk.getApplicationId().equals(applicationId2)).collect(Collectors.toUnmodifiableList());
        if (filteredApks.size() != 1) {
            StringBuilder errorMessage = new StringBuilder();
            if (filteredApks.isEmpty()) {
                errorMessage.append("No matching APK for application: " + applicationId2 + "\n");
            } else {
                errorMessage.append("Multiple APKs present for application: " + applicationId2 + "\n");
                errorMessage.append("Projects:\n");
                for (ApkInfo apkInfo : apks) {
                    errorMessage.append("  " + apkInfo.getApplicationId() + " containing :\n");
                    for (ApkFileUnit fileUnit : apkInfo.getFiles()) {
                        errorMessage.append("    " + String.valueOf(fileUnit.getApkFile()) + "\n");
                    }
                }
            }
            throw new IllegalStateException(errorMessage.toString());
        }
        ArrayList<NodeActivity> activities = new ArrayList<NodeActivity>();
        ApkInfo apkInfo = (ApkInfo)filteredApks.iterator().next();
        for (ApkFileUnit apkFileUnit : apkInfo.getFiles()) {
            File file = apkFileUnit.getApkFile();
            String ext = file.getName().toLowerCase(Locale.US);
            if (!ext.endsWith(".apk")) continue;
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
                if (manifestEntry == null) continue;
                InputStream input2 = zipFile.getInputStream(manifestEntry);
                try {
                    ManifestInfo manifest = ManifestInfo.parseBinaryFromStream((InputStream)input2);
                    activities.addAll(manifest.activities().stream().map(NodeActivity::new).collect(Collectors.toList()));
                }
                finally {
                    if (input2 == null) continue;
                    input2.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to parse '" + file.getName() + "' for default activity", (Throwable)e);
            }
        }
        String defaultActivityName = DefaultActivityLocator.computeDefaultActivity(activities);
        if (defaultActivityName == null) {
            StringBuilder errorMessage = new StringBuilder("Unable to find Default Activity in:\n");
            DefaultApkActivityLocator.printActivities(activities, errorMessage);
            LOG.info(errorMessage.toString());
        }
        return defaultActivityName;
    }

    private static void printActivities(List<NodeActivity> activities, StringBuilder message) {
        for (NodeActivity activity : activities) {
            message.append("  " + activity.getQualifiedName() + ":\n");
            for (IntentFilter intent : activity.getIntentFilters()) {
                for (String action2 : intent.getActions()) {
                    message.append("    " + action2 + "\n");
                }
                for (String category : intent.getCategories()) {
                    message.append("    " + category + "\n");
                }
            }
        }
    }
}

