/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.build.OutputFile;
import com.android.tools.idea.gradle.model.IdeAndroidArtifactOutput;
import com.android.tools.idea.gradle.model.IdeFilterData;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SplitOutputMatcher {
    public static List<IdeAndroidArtifactOutput> computeBestOutput(Collection<IdeAndroidArtifactOutput> outputs, Collection<String> variantAbiFilters, List<String> deviceAbis) {
        ArrayList<IdeAndroidArtifactOutput> matches = new ArrayList<IdeAndroidArtifactOutput>();
        for (IdeAndroidArtifactOutput variantOutput : outputs) {
            String abiFilter = SplitOutputMatcher.getFilter(variantOutput, OutputFile.ABI);
            if (abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(variantOutput);
        }
        if (matches.isEmpty()) {
            return ImmutableList.of();
        }
        IdeAndroidArtifactOutput match = (IdeAndroidArtifactOutput)Collections.max(matches, (splitOutput, splitOutput2) -> {
            int rc = splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            if (rc != 0) {
                return rc;
            }
            int abiOrder1 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput, deviceAbis);
            int abiOrder2 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput2, deviceAbis);
            return abiOrder1 - abiOrder2;
        });
        return SplitOutputMatcher.isMainApkCompatibleWithDevice(match, variantAbiFilters, deviceAbis) ? ImmutableList.of((Object)match) : ImmutableList.of();
    }

    private static int getAbiPreferenceOrder(IdeAndroidArtifactOutput variantOutput, List<String> deviceAbi) {
        String abiFilter = SplitOutputMatcher.getFilter(variantOutput, IdeAndroidArtifactOutput.ABI);
        if (Strings.isNullOrEmpty((String)abiFilter)) {
            return deviceAbi.size() - 1;
        }
        int match = deviceAbi.indexOf(abiFilter);
        if (match == 0) {
            match = deviceAbi.size();
        } else if (match > 0) {
            match = deviceAbi.size() - match - 1;
        }
        return match;
    }

    private static boolean isMainApkCompatibleWithDevice(IdeAndroidArtifactOutput mainOutputFile, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (SplitOutputMatcher.getFilter(mainOutputFile, IdeAndroidArtifactOutput.ABI) == null && variantAbiFilters != null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String getFilter(IdeAndroidArtifactOutput variantOutput, String filterType) {
        for (IdeFilterData filterData : variantOutput.getFilters()) {
            if (!filterData.getFilterType().equals(filterType)) continue;
            return filterData.getIdentifier();
        }
        return null;
    }
}

