/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class NonGradleApplicationIdProvider
implements ApplicationIdProvider {
    @NotNull
    private final AndroidFacet myFacet;

    public NonGradleApplicationIdProvider(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        return NonGradleApplicationIdProvider.computePackageName(this.myFacet);
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        return NonGradleApplicationIdProvider.computePackageName(this.myFacet);
    }

    @NotNull
    public static String computePackageName(@NotNull AndroidFacet facet) throws ApkProvisionException {
        if (facet.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            return facet.getProperties().CUSTOM_MANIFEST_PACKAGE;
        }
        String pkg = ProjectSystemUtil.getModuleSystem(facet).getPackageName();
        if (pkg == null || pkg.isEmpty()) {
            throw new ApkProvisionException("[" + facet.getModule().getName() + "] Unable to obtain main package from manifest.");
        }
        return pkg;
    }
}

