/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LaunchOptions {
    private final boolean myDeploy;
    private final boolean myOpenLogcatAutomatically;
    private final Map<String, Object> myExtraOptions;
    private final boolean myClearAppStorage;

    private LaunchOptions(boolean deploy, boolean openLogcatAutomatically, @NotNull Map<String, Object> extraOptions, boolean clearAppStorage) {
        this.myDeploy = deploy;
        this.myOpenLogcatAutomatically = openLogcatAutomatically;
        this.myExtraOptions = ImmutableMap.copyOf(extraOptions);
        this.myClearAppStorage = clearAppStorage;
    }

    public boolean isDeploy() {
        return this.myDeploy;
    }

    public boolean isClearAppStorage() {
        return this.myClearAppStorage;
    }

    public boolean isOpenLogcatAutomatically() {
        return this.myOpenLogcatAutomatically;
    }

    @Nullable
    public Object getExtraOption(@NotNull String key) {
        return this.myExtraOptions.get(key);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> myExtraOptions = new HashMap<String, Object>();
        private boolean myDeploy = true;
        private boolean myOpenLogcatAutomatically = false;
        private boolean myClearAppStorage = false;

        private Builder() {
        }

        @NotNull
        public LaunchOptions build() {
            return new LaunchOptions(this.myDeploy, this.myOpenLogcatAutomatically, this.myExtraOptions, this.myClearAppStorage);
        }

        @NotNull
        public Builder setDeploy(boolean deploy) {
            this.myDeploy = deploy;
            return this;
        }

        @NotNull
        public Builder setOpenLogcatAutomatically(boolean openLogcatAutomatically) {
            this.myOpenLogcatAutomatically = openLogcatAutomatically;
            return this;
        }

        @NotNull
        public Builder addExtraOptions(@NotNull Map<String, Object> extraOptions) {
            this.myExtraOptions.putAll(extraOptions);
            return this;
        }

        @NotNull
        public Builder setClearAppStorage(boolean clearAppStorage) {
            this.myClearAppStorage = clearAppStorage;
            return this;
        }
    }
}

