/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidConfigurationExecutor;
import com.android.tools.idea.execution.common.AndroidConfigurationExecutorRunProfileState;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.DeployableToDevice;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerContext;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.execution.common.debug.RunConfigurationWithDebugger;
import com.android.tools.idea.execution.common.stats.RunStats;
import com.android.tools.idea.execution.common.stats.RunStatsService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.AttachOnWaitForDebuggerMonitor;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.NativeDebugOnRemoteDeviceChecker;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.testartifacts.instrumented.AndroidRunConfigurationToken;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<AndroidRunConfigurationModule, Element>
implements PreferGradleMake,
RunConfigurationWithSuppressedDefaultRunAction,
RunConfigurationWithSuppressedDefaultDebugAction,
RunConfigurationWithDebugger {
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    private final ProfilerState myProfilerState;
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new AndroidDebuggerContext("Java");
    private final boolean myIsTestConfiguration;

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory2, String name2, boolean isTestConfiguration) {
        super(name2, (RunConfigurationModule)new AndroidRunConfigurationModule(project, isTestConfiguration), factory2);
        this.myIsTestConfiguration = isTestConfiguration;
        this.myProfilerState = new ProfilerState();
        this.getOptions().setAllowRunningInParallel(true);
        if (((Boolean)StudioFlags.ATTACH_ON_WAIT_FOR_DEBUGGER.get()).booleanValue()) {
            AttachOnWaitForDebuggerMonitor.getInstance(project);
        }
        this.putUserData(DeployableToDevice.getKEY(), this.getDeployTargetContext().getCurrentDeployTargetProvider().canDeployToLocalDevice());
    }

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory2, boolean isTestConfiguration) {
        this(project, factory2, null, isTestConfiguration);
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate(null);
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        switch (topError.getSeverity()) {
            case FATAL: {
                throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
            }
            case WARNING: {
                throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
            }
        }
    }

    public List<ValidationError> validate(@Nullable Executor executor) {
        return this.validate(executor, null);
    }

    public List<ValidationError> validate(@Nullable Executor executor, @Nullable Runnable quickFixCallback) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException(e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        if (this.isTestConfiguration()) {
            Module androidTestModule = AndroidRunConfigurationToken.getModuleForAndroidTestRunConfiguration(module);
            if (androidTestModule != null) {
                module = androidTestModule;
            }
        } else {
            module = AndroidRunConfigurationToken.getModuleForAndroidRunConfiguration(module);
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module.getName())));
        }
        int projectType = ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType();
        switch (projectType) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                Pair<Boolean, String> result2 = this.supportsRunningLibraryProjects(facet);
                if (((Boolean)result2.getFirst()).booleanValue()) break;
                errors.add(ValidationError.fatal((String)result2.getSecond()));
                break;
            }
            default: {
                errors.add(ValidationError.fatal(AndroidBundle.message("run.error.apk.not.valid", new Object[0])));
                return errors;
            }
        }
        if (AndroidPlatforms.getInstance(module) == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        errors.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet));
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider();
        if (applicationIdProvider == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("android.run.configuration.not.supported.applicationid", this.getName())));
        } else {
            try {
                String string = applicationIdProvider.getPackageName();
            }
            catch (ApkProvisionException e) {
                errors.add(ValidationError.fatal(AndroidBundle.message("android.run.configuration.not.supported.package", this.getName())));
            }
        }
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(this.getProject());
        errors.addAll(projectSystem.validateRunConfiguration((RunConfiguration)this, quickFixCallback));
        errors.addAll(this.checkConfiguration(facet));
        Object androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet, executor));
        }
        errors.addAll(this.myProfilerState.validate());
        return errors;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    public Collection<Module> getValidModules() {
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (AndroidFacet facet : ProjectSystemUtil.getAndroidFacets(this.getProject())) {
            result2.add(facet.getModule());
        }
        return result2;
    }

    @NotNull
    public abstract List<DeployTargetProvider> getApplicableDeployTargetProviders();

    protected void validateBeforeRun(@NotNull Executor executor, @NotNull DataContext dataContext) throws ExecutionException {
        DeployTarget deployTarget;
        List<ValidationError> errors = this.validate(executor);
        AndroidDebugger debugger = this.getAndroidDebuggerContext().getAndroidDebugger();
        if (executor instanceof DefaultDebugExecutor && debugger != null && (deployTarget = this.getDeployTarget()) != null) {
            List<AndroidDevice> devices2 = deployTarget.getAndroidDevices(this.getProject());
            NativeDebugOnRemoteDeviceChecker deviceChecker = new NativeDebugOnRemoteDeviceChecker(this.getProject());
            boolean ok2 = deviceChecker.showWarningIfNeeded(debugger, devices2);
            if (!ok2) {
                throw new ExecutionException("Native debug session on a remote device was aborted");
            }
        }
        ValidationUtil.promptAndQuickFixErrors(this.getProject(), dataContext, errors);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunStats stats = RunStatsService.get(this.getProject()).create();
        try {
            stats.start();
            RunProfileState state2 = this.doGetState(executor, env, stats);
            stats.markStateCreated();
            return state2;
        }
        catch (Throwable t) {
            stats.abort();
            throw t;
        }
    }

    @Nullable
    public RunProfileState doGetState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull RunStats stats) throws ExecutionException {
        Object error;
        this.validateBeforeRun(executor, Objects.requireNonNullElse(env.getDataContext(), DataContext.EMPTY_CONTEXT));
        Module module = ((AndroidRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null) : "Enforced by fatal validation check in checkConfiguration.";
        if (this.isTestConfiguration()) {
            Module androidTestModule = AndroidRunConfigurationToken.getModuleForAndroidTestRunConfiguration(module);
            if (androidTestModule != null) {
                module = androidTestModule;
            }
        } else {
            module = AndroidRunConfigurationToken.getModuleForAndroidRunConfiguration(module);
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        assert (facet != null) : "Enforced by fatal validation check in checkConfiguration.";
        stats.setDebuggable(LaunchUtils.canDebugApp(facet));
        stats.setExecutor(executor.getId());
        this.updateExtraRunStats(stats);
        boolean isDebugging = executor instanceof DefaultDebugExecutor;
        DeployTargetContext context = this.getDeployTargetContext();
        stats.setUserSelectedTarget(context.getCurrentDeployTargetProvider().requiresRuntimePrompt(facet.getModule().getProject()));
        DeployTarget deployTarget = this.getDeployTarget();
        if (deployTarget == null) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        DeployTargetState deployTargetState = context.getCurrentDeployTargetState();
        if (deployTarget.hasCustomRunProfileState(executor)) {
            return deployTarget.getRunProfileState(executor, env, deployTargetState);
        }
        DeviceFutures deviceFutures = deployTarget.launchDevices(this.getProject());
        stats.setLaunchedDevices(deviceFutures.getDevices().stream().anyMatch(device2 -> !device2.isRunning()));
        if (deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        if (isDebugging && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet, module.getName())) != null) {
            throw new ExecutionException((String)error);
        }
        env.putCopyableUserData(DeviceFutures.KEY, (Object)deviceFutures);
        env.putUserData(RunStats.KEY, (Object)stats);
        for (AndroidConfigurationExecutor.Provider provider : AndroidConfigurationExecutor.Provider.EP_NAME.getIterable()) {
            AndroidConfigurationExecutor providedExecutor = provider.createAndroidConfigurationExecutor(env);
            if (providedExecutor == null) continue;
            return new AndroidConfigurationExecutorRunProfileState(providedExecutor);
        }
        AndroidConfigurationExecutor configurationExecutor = this.getExecutor(env, facet, deviceFutures);
        return new AndroidConfigurationExecutorRunProfileState(configurationExecutor);
    }

    protected abstract AndroidConfigurationExecutor getExecutor(ExecutionEnvironment var1, AndroidFacet var2, DeviceFutures var3) throws ExecutionException;

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet, @NotNull String moduleName) {
        for (AndroidDevice androidDevice : deviceFutures.getDevices()) {
            if (androidDevice.isDebuggable() || LaunchUtils.canDebugApp(facet)) continue;
            IDevice device2 = androidDevice.getDdmlibDevice();
            String deviceName = device2 == null ? androidDevice.getName() : device2.getName();
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName, deviceName);
        }
        return null;
    }

    public boolean canRunOn(@NotNull ExecutionTarget target2) {
        return target2 instanceof AndroidExecutionTarget;
    }

    @Nullable
    protected DeployTarget getDeployTarget() {
        Project project;
        DeployTargetProvider currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider();
        return currentTargetProvider.requiresRuntimePrompt(project = this.getProject()) ? currentTargetProvider.showPrompt(project) : currentTargetProvider.getDeployTarget(project);
    }

    @Nullable
    public ApplicationIdProvider getApplicationIdProvider() {
        return ProjectSystemUtil.getProjectSystem(this.getProject()).getApplicationIdProvider((RunConfiguration)this);
    }

    @Nullable
    public final ApkProvider getApkProvider() {
        return ProjectSystemUtil.getProjectSystem(this.getProject()).getApkProvider((RunConfiguration)this);
    }

    public final boolean isTestConfiguration() {
        return this.myIsTestConfiguration;
    }

    public void updateExtraRunStats(RunStats runStats) {
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myDeployTargetContext.readExternal(element);
        this.myAndroidDebuggerContext.readExternal(element);
        Element profilersElement = element.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.myDeployTargetContext.writeExternal(element);
        this.myAndroidDebuggerContext.writeExternal(element);
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    public boolean isNativeLaunch() {
        AndroidDebugger androidDebugger = this.myAndroidDebuggerContext.getAndroidDebugger();
        if (androidDebugger == null) {
            return false;
        }
        return !androidDebugger.getId().equals("Java");
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        return this.myDeployTargetContext;
    }

    @Override
    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        return this.myAndroidDebuggerContext;
    }

    @NotNull
    public ProfilerState getProfilerState() {
        return this.myProfilerState;
    }
}

