/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.update;

import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.ForeignKeyBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.FtsOptionsBundle;
import com.android.tools.idea.room.migrations.json.IndexBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SchemaDiffUtil {
    public static boolean isFieldStructureTheSame(@NotNull FieldBundle oldField, @NotNull FieldBundle newField) {
        return oldField.isNonNull() == newField.isNonNull() && Objects.equals(oldField.getAffinity(), newField.getAffinity()) && Objects.equals(oldField.getDefaultValue(), newField.getDefaultValue());
    }

    public static boolean isTableStructureTheSame(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        if (!SchemaDiffUtil.isTableTypeTheSame(oldEntity, newEntity)) {
            return false;
        }
        if (!oldEntity.getPrimaryKey().isSchemaEqual(newEntity.getPrimaryKey())) {
            return false;
        }
        return SchemaDiffUtil.tablesHaveSameColumns(oldEntity, newEntity) && SchemaDiffUtil.tablesHaveSameForeignKeyConstraints(oldEntity, newEntity) && SchemaDiffUtil.tablesHaveSameIndices(oldEntity, newEntity);
    }

    public static boolean isTableTypeTheSame(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        return oldEntity instanceof FtsEntityBundle == newEntity instanceof FtsEntityBundle;
    }

    public static boolean tablesHaveSameColumns(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        Map<String, FieldBundle> oldEntityFields = oldEntity.getFieldsByColumnName();
        Map<String, FieldBundle> newEntityFields = newEntity.getFieldsByColumnName();
        ArrayList<FieldBundle> matchedFields = new ArrayList<FieldBundle>();
        if (oldEntityFields.size() != newEntityFields.size()) {
            return false;
        }
        for (Map.Entry<String, FieldBundle> oldFieldEntry : oldEntityFields.entrySet()) {
            FieldBundle newField = newEntityFields.get(oldFieldEntry.getKey());
            if (newField == null || !oldFieldEntry.getValue().isSchemaEqual(newField)) {
                return false;
            }
            matchedFields.add(newField);
        }
        return newEntityFields.values().size() == matchedFields.size();
    }

    public static boolean tablesHaveSameForeignKeyConstraints(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        List<ForeignKeyBundle> oldEntityForeignKeys = oldEntity.getForeignKeys();
        List<ForeignKeyBundle> newEntityForeignKeys = newEntity.getForeignKeys();
        ArrayList<ForeignKeyBundle> matchedKeys = new ArrayList<ForeignKeyBundle>();
        if (oldEntityForeignKeys.size() != newEntityForeignKeys.size()) {
            return false;
        }
        for (ForeignKeyBundle oldKey : oldEntityForeignKeys) {
            boolean foundMatchingNewKey = false;
            for (ForeignKeyBundle newKey : newEntityForeignKeys) {
                if (!oldKey.isSchemaEqual(newKey)) continue;
                foundMatchingNewKey = true;
                matchedKeys.add(newKey);
                break;
            }
            if (foundMatchingNewKey) continue;
            return false;
        }
        return newEntityForeignKeys.size() == matchedKeys.size();
    }

    public static boolean tablesHaveSameIndices(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        List<IndexBundle> oldEntityIndices = oldEntity.getIndices();
        Map<String, IndexBundle> newEntityIndies = newEntity.getIndices().stream().collect(Collectors.toMap(IndexBundle::getName, index -> index));
        ArrayList<IndexBundle> matchedIndices = new ArrayList<IndexBundle>();
        if (oldEntityIndices.size() != newEntityIndies.size()) {
            return false;
        }
        for (IndexBundle oldIndex : oldEntityIndices) {
            IndexBundle newIndex = newEntityIndies.get(oldIndex.getName());
            if (newIndex == null || !oldIndex.isSchemaEqual(newIndex)) {
                return false;
            }
            matchedIndices.add(newIndex);
        }
        return newEntityIndies.values().size() == matchedIndices.size();
    }

    public static boolean ftsTableNeedsExternalContentSource(@NotNull FtsEntityBundle ftsEntity) {
        String contentTable;
        FtsOptionsBundle ftsOptions = ftsEntity.getFtsOptions();
        return ftsOptions != null && (contentTable = ftsOptions.getContentTable()) != null && !contentTable.isEmpty();
    }
}

