/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInnerClassFinder
extends PsiElementFinder {
    public static final AndroidInnerClassFinder INSTANCE = new AndroidInnerClassFinder();

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] classes = this.findClasses(qualifiedName, scope);
        return classes.length == 0 ? null : classes[0];
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Project project = scope.getProject();
        if (project == null || !CommonAndroidUtil.getInstance().isAndroidProject(project)) {
            return PsiClass.EMPTY_ARRAY;
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot < 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        String shortName = qualifiedName.substring(lastDot + 1);
        String parentName = qualifiedName.substring(0, lastDot);
        if (shortName.isEmpty() || !parentName.endsWith(".R") && !parentName.endsWith(".Manifest")) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (PsiClass parentClass : JavaPsiFacade.getInstance((Project)project).findClasses(parentName, scope)) {
            if (!(parentClass instanceof AndroidLightClassBase)) continue;
            ContainerUtil.addIfNotNull((Collection)result2, (Object)parentClass.findInnerClassByName(shortName, false));
        }
        return result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(PsiClass.EMPTY_ARRAY);
    }
}

