/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.actions;

import com.android.tools.idea.rendering.actions.RenderLaggingModeKt;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0011\u0010\rR\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/rendering/actions/RenderLaggingMode;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "enabled", "", "value", "", "minWaitTimeMs", "setMinWaitTimeMs", "(I)V", "maxWaitTimeMs", "setMaxWaitTimeMs", "minSpaceTimeMs", "setMinSpaceTimeMs", "maxSpaceTimeMs", "setMaxSpaceTimeMs", "sleepLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "lagger", "Lkotlin/Function0;", "", "reschedule", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.android.core"})
public final class RenderLaggingMode
extends ToggleAction {
    @NotNull
    private final Logger LOG;
    private boolean enabled;
    private int minWaitTimeMs;
    private int maxWaitTimeMs;
    private int minSpaceTimeMs;
    private int maxSpaceTimeMs;
    @NotNull
    private final ReentrantReadWriteLock sleepLock;
    @NotNull
    private final Function0<Unit> lagger;

    public RenderLaggingMode() {
        super("Enable Layout Preview Lagging Mode");
        Logger logger = Logger.getInstance(RenderLaggingMode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.minWaitTimeMs = (int)TimeUnit.SECONDS.toMillis(2L);
        this.maxWaitTimeMs = (int)TimeUnit.SECONDS.toMillis(4L);
        this.minSpaceTimeMs = 500;
        this.maxSpaceTimeMs = (int)TimeUnit.SECONDS.toMillis(5L);
        this.sleepLock = new ReentrantReadWriteLock();
        this.lagger = () -> RenderLaggingMode.lagger$lambda$0(this);
    }

    private final void setMinWaitTimeMs(int value2) {
        this.minWaitTimeMs = RangesKt.coerceAtMost((int)value2, (int)this.maxWaitTimeMs);
    }

    private final void setMaxWaitTimeMs(int value2) {
        this.maxWaitTimeMs = RangesKt.coerceAtLeast((int)value2, (int)this.minWaitTimeMs);
    }

    private final void setMinSpaceTimeMs(int value2) {
        this.minSpaceTimeMs = RangesKt.coerceAtMost((int)value2, (int)this.maxSpaceTimeMs);
    }

    private final void setMaxSpaceTimeMs(int value2) {
        this.maxSpaceTimeMs = RangesKt.coerceAtLeast((int)value2, (int)this.minSpaceTimeMs);
    }

    private final void reschedule() {
        if (this.enabled) {
            long spaceTimeMs = Random.Default.nextLong((long)this.minSpaceTimeMs, (long)this.maxSpaceTimeMs);
            this.LOG.info("Request scheduled in " + spaceTimeMs + "ms");
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> RenderLaggingMode.reschedule$lambda$0(this.lagger), spaceTimeMs, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.enabled;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.enabled) {
            this.enabled = false;
            this.sleepLock.writeLock().unlock();
        } else {
            DialogBuilder builder = new DialogBuilder();
            builder.setCenterPanel((JComponent)BuilderKt.panel(arg_0 -> RenderLaggingMode.setSelected$lambda$0(this, arg_0)));
            builder.setOkOperation(() -> RenderLaggingMode.setSelected$lambda$1(this, builder));
            builder.show();
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit lagger$lambda$0(RenderLaggingMode this$0) {
        if (this$0.enabled) {
            RenderAsyncActionExecutor $this$lagger_u24lambda_u240_u240 = RenderService.getRenderAsyncActionExecutor();
            boolean bl = false;
            long waitTimeMs = Random.Default.nextLong((long)this$0.minWaitTimeMs, (long)this$0.maxWaitTimeMs);
            this$0.LOG.info("Waiting " + waitTimeMs + "ms");
            if (!this$0.sleepLock.readLock().tryLock(waitTimeMs, TimeUnit.MILLISECONDS)) {
                this$0.LOG.info("Waited " + waitTimeMs + "ms");
            }
            this$0.reschedule();
        }
        return Unit.INSTANCE;
    }

    private static final void reschedule$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit setSelected$lambda$0(RenderLaggingMode this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        RenderLaggingModeKt.access$spinnerParamMs($this$panel, "Min wait time", (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return RenderLaggingMode.access$getMinWaitTimeMs$p((RenderLaggingMode)((Object)this.receiver));
            }

            public void set(Object value2) {
                RenderLaggingMode.access$setMinWaitTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
            }
        });
        RenderLaggingModeKt.access$spinnerParamMs($this$panel, "Max wait time", (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return RenderLaggingMode.access$getMaxWaitTimeMs$p((RenderLaggingMode)((Object)this.receiver));
            }

            public void set(Object value2) {
                RenderLaggingMode.access$setMaxWaitTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
            }
        });
        RenderLaggingModeKt.access$spinnerParamMs($this$panel, "Min action space time", (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return RenderLaggingMode.access$getMinSpaceTimeMs$p((RenderLaggingMode)((Object)this.receiver));
            }

            public void set(Object value2) {
                RenderLaggingMode.access$setMinSpaceTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
            }
        });
        RenderLaggingModeKt.access$spinnerParamMs($this$panel, "Max action space time", (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return RenderLaggingMode.access$getMaxSpaceTimeMs$p((RenderLaggingMode)((Object)this.receiver));
            }

            public void set(Object value2) {
                RenderLaggingMode.access$setMaxSpaceTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
            }
        });
        return Unit.INSTANCE;
    }

    private static final void setSelected$lambda$1(RenderLaggingMode this$0, DialogBuilder $builder) {
        this$0.enabled = true;
        this$0.sleepLock.writeLock().lock();
        this$0.reschedule();
        $builder.getDialogWrapper().close(0);
    }

    public static final /* synthetic */ int access$getMinWaitTimeMs$p(RenderLaggingMode $this) {
        return $this.minWaitTimeMs;
    }

    public static final /* synthetic */ void access$setMinWaitTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMinWaitTimeMs(value2);
    }

    public static final /* synthetic */ int access$getMaxWaitTimeMs$p(RenderLaggingMode $this) {
        return $this.maxWaitTimeMs;
    }

    public static final /* synthetic */ void access$setMaxWaitTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMaxWaitTimeMs(value2);
    }

    public static final /* synthetic */ int access$getMinSpaceTimeMs$p(RenderLaggingMode $this) {
        return $this.minSpaceTimeMs;
    }

    public static final /* synthetic */ void access$setMinSpaceTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMinSpaceTimeMs(value2);
    }

    public static final /* synthetic */ int access$getMaxSpaceTimeMs$p(RenderLaggingMode $this) {
        return $this.maxSpaceTimeMs;
    }

    public static final /* synthetic */ void access$setMaxSpaceTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMaxSpaceTimeMs(value2);
    }
}

