/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.adtui.webp.WebpNativeLibHelper;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.security.RenderSecurityException;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.tools.rendering.security.RenderSecurityManagerDefaults;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/rendering/StudioRenderSecurityManager;", "Lcom/android/tools/rendering/security/RenderSecurityManager;", "sdkPath", "", "projectPath", "restrictReads", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "checkLink", "", "lib", "intellij.android.core"})
public final class StudioRenderSecurityManager
extends RenderSecurityManager {
    public StudioRenderSecurityManager(@Nullable String sdkPath, @Nullable String projectPath, boolean restrictReads) {
        super(sdkPath, projectPath, restrictReads, RenderSecurityManagerDefaults.getDefaultAllowedPaths(), RenderService::isRenderThread);
    }

    @Override
    public void checkLink(@NotNull String lib) {
        Intrinsics.checkNotNullParameter((Object)lib, (String)"lib");
        if (this.isRelevant() && (StringsKt.indexOf$default((CharSequence)lib, (char)'/', (int)0, (boolean)false, (int)6, null) != -1 || StringsKt.indexOf$default((CharSequence)lib, (char)'\\', (int)0, (boolean)false, (int)6, null) != -1)) {
            String string = System.getProperty("java.home");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            if (StringsKt.startsWith$default((String)lib, (String)string, (boolean)false, (int)2, null)) {
                return;
            }
            Path path = WebpNativeLibHelper.getLibLocation();
            if (Intrinsics.areEqual((Object)lib, (Object)(path != null ? ((Object)path).toString() : null))) {
                return;
            }
            RenderSecurityException renderSecurityException = RenderSecurityException.create("Link", lib);
            Intrinsics.checkNotNullExpressionValue((Object)renderSecurityException, (String)"create(...)");
            throw (Throwable)renderSecurityException;
        }
    }
}

