/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.AssetRepository;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.module.ModuleKeyManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.rendering.RenderMergedManifest;
import com.android.tools.idea.rendering.StudioEnvironmentContext;
import com.android.tools.idea.rendering.StudioModuleRenderContext;
import com.android.tools.idea.res.StudioAssetFileOpener;
import com.android.tools.idea.res.StudioResourceIdManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.module.ModuleDependencies;
import com.android.tools.module.ModuleKey;
import com.android.tools.rendering.api.RenderModelManifest;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.api.RenderModelModuleLoggingId;
import com.android.tools.rendering.classloading.ClassTransform;
import com.android.tools.rendering.classloading.ModuleClassLoaderManager;
import com.android.tools.res.AssetRepositoryBase;
import com.android.tools.res.ids.ResourceIdManager;
import com.android.tools.sdk.AndroidPlatform;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.uipreview.StudioModuleClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u0001:\u0001JB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020=H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\u0004\u0018\u00010-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u000201X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010>R\u0014\u0010?\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010/R\u0014\u0010A\u001a\u00020BX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010D\u00a8\u0006K"}, d2={"Lcom/android/tools/idea/rendering/AndroidFacetRenderModelModule;", "Lcom/android/tools/rendering/api/RenderModelModule;", "buildTarget", "Lcom/android/tools/idea/rendering/AndroidBuildTargetReference;", "<init>", "(Lcom/android/tools/idea/rendering/AndroidBuildTargetReference;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "getIdeaModule", "Lcom/intellij/openapi/module/Module;", "value", "Lcom/android/ide/common/rendering/api/AssetRepository;", "assetRepository", "getAssetRepository", "()Lcom/android/ide/common/rendering/api/AssetRepository;", "manifest", "Lcom/android/tools/rendering/api/RenderModelManifest;", "getManifest", "()Lcom/android/tools/rendering/api/RenderModelManifest;", "resourceRepositoryManager", "Lcom/android/tools/idea/res/StudioResourceRepositoryManager;", "getResourceRepositoryManager", "()Lcom/android/tools/idea/res/StudioResourceRepositoryManager;", "info", "Lcom/android/tools/module/AndroidModuleInfo;", "getInfo", "()Lcom/android/tools/module/AndroidModuleInfo;", "androidPlatform", "Lcom/android/tools/sdk/AndroidPlatform;", "getAndroidPlatform", "()Lcom/android/tools/sdk/AndroidPlatform;", "resourceIdManager", "Lcom/android/tools/res/ids/ResourceIdManager;", "getResourceIdManager", "()Lcom/android/tools/res/ids/ResourceIdManager;", "moduleKey", "Lcom/android/tools/module/ModuleKey;", "getModuleKey", "()Lcom/android/tools/module/ModuleKey;", "resourcePackage", "", "getResourcePackage", "()Ljava/lang/String;", "dependencies", "Lcom/android/tools/module/ModuleDependencies;", "getDependencies", "()Lcom/android/tools/module/ModuleDependencies;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "getParentDisposable", "()Lcom/intellij/openapi/util/CheckedDisposable;", "isDisposed", "", "()Z", "name", "getName", "environment", "Lcom/android/tools/idea/rendering/StudioEnvironmentContext;", "getEnvironment", "()Lcom/android/tools/idea/rendering/StudioEnvironmentContext;", "createModuleRenderContext", "Lcom/android/tools/idea/rendering/StudioModuleRenderContext;", "getClassLoaderProvider", "Lcom/android/tools/rendering/api/RenderModelModule$ClassLoaderProvider;", "privateClassLoader", "Companion", "intellij.android.core"})
public final class AndroidFacetRenderModelModule
implements RenderModelModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidBuildTargetReference buildTarget;
    @NotNull
    private final Logger LOG;
    @Nullable
    private AssetRepository assetRepository;
    @NotNull
    private final ModuleDependencies dependencies;
    @NotNull
    private final CheckedDisposable parentDisposable;
    @NotNull
    private final StudioEnvironmentContext environment;

    public AndroidFacetRenderModelModule(@NotNull AndroidBuildTargetReference buildTarget) {
        Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
        this.buildTarget = buildTarget;
        Logger logger = Logger.getInstance(AndroidFacetRenderModelModule.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.assetRepository = new AssetRepositoryBase(new StudioAssetFileOpener(this.getFacet()));
        this.dependencies = ProjectSystemUtil.getModuleSystem(this.getFacet()).getModuleDependencies();
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.parentDisposable = checkedDisposable;
        Disposer.register((Disposable)((Disposable)this.getParentDisposable()), () -> AndroidFacetRenderModelModule._init_$lambda$0(this));
        if (!Disposer.tryRegister((Disposable)((Disposable)this.getFacet()), (Disposable)((Disposable)this.getParentDisposable()))) {
            Disposer.dispose((Disposable)((Disposable)this.getParentDisposable()));
        }
        Module module = this.getFacet().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        this.environment = new StudioEnvironmentContext(module);
    }

    private final AndroidFacet getFacet() {
        return this.buildTarget.getFacet();
    }

    @Override
    @NotNull
    public Module getIdeaModule() {
        Module module = this.getFacet().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        return module;
    }

    @Override
    @Nullable
    public AssetRepository getAssetRepository() {
        return this.assetRepository;
    }

    @Override
    @Nullable
    public RenderModelManifest getManifest() {
        try {
            Callable<MergedManifestSnapshot> getManifestSnapshot = () -> AndroidFacetRenderModelModule._get_manifest_$lambda$0(this);
            MergedManifestSnapshot mergedManifestSnapshot = ApplicationKt.getApplication().isReadAccessAllowed() ? getManifestSnapshot.call() : (MergedManifestSnapshot)ReadAction.nonBlocking(getManifestSnapshot).executeSynchronously();
            Intrinsics.checkNotNull((Object)mergedManifestSnapshot);
            return new RenderMergedManifest(mergedManifestSnapshot);
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (TimeoutException e) {
            this.LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw cause;
            }
            if (cause instanceof MergedManifestException) {
                this.LOG.warn((Throwable)e);
            }
            this.LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    @NotNull
    public StudioResourceRepositoryManager getResourceRepositoryManager() {
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance(this.getFacet());
        Intrinsics.checkNotNullExpressionValue((Object)studioResourceRepositoryManager, (String)"getInstance(...)");
        return studioResourceRepositoryManager;
    }

    @Override
    @Nullable
    public AndroidModuleInfo getInfo() {
        return this.getFacet().isDisposed() ? null : StudioAndroidModuleInfo.getInstance(this.getFacet());
    }

    @Override
    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        Module module = this.getFacet().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        return AndroidPlatforms.getInstance(module);
    }

    @Override
    @NotNull
    public ResourceIdManager getResourceIdManager() {
        Module module = this.getFacet().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        return StudioResourceIdManager.Companion.get(module);
    }

    @Override
    @NotNull
    public ModuleKey getModuleKey() {
        Module module = this.getFacet().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        return ModuleKeyManager.INSTANCE.getKey(module);
    }

    @Override
    @Nullable
    public String getResourcePackage() {
        Module module = this.getFacet().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        return ProjectSystemUtil.getModuleSystem(module).getPackageName();
    }

    @Override
    @NotNull
    public ModuleDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getFacet().getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @NotNull
    public CheckedDisposable getParentDisposable() {
        return this.parentDisposable;
    }

    @Override
    public boolean isDisposed() {
        return this.getParentDisposable().isDisposed() || this.buildTarget.getBuildTarget().getModuleIfNotDisposed() == null;
    }

    @Override
    @NotNull
    public String getName() {
        return AndroidFacetRenderModelModule.Companion.nameFromFacet(this.getFacet());
    }

    @Override
    @NotNull
    public StudioEnvironmentContext getEnvironment() {
        return this.environment;
    }

    private final StudioModuleRenderContext createModuleRenderContext() {
        return StudioModuleRenderContext.Companion.forBuildTargetReference(this.buildTarget.getBuildTarget());
    }

    @Override
    @NotNull
    public RenderModelModule.ClassLoaderProvider getClassLoaderProvider(boolean privateClassLoader) {
        StudioModuleRenderContext moduleRenderContext = this.createModuleRenderContext();
        return (arg_0, arg_1, arg_2, arg_3) -> AndroidFacetRenderModelModule.getClassLoaderProvider$lambda$0(privateClassLoader, this, moduleRenderContext, arg_0, arg_1, arg_2, arg_3);
    }

    private static final MergedManifestSnapshot _get_manifest_$lambda$0(AndroidFacetRenderModelModule this$0) {
        Module module = this$0.getFacet().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        return (MergedManifestSnapshot)MergedManifestManager.Companion.getMergedManifest(module).get(1L, TimeUnit.SECONDS);
    }

    private static final void _init_$lambda$0(AndroidFacetRenderModelModule this$0) {
        this$0.assetRepository = null;
    }

    private static final ModuleClassLoaderManager.Reference getClassLoaderProvider$lambda$0(boolean $privateClassLoader, AndroidFacetRenderModelModule this$0, StudioModuleRenderContext $moduleRenderContext, ClassLoader parent, ClassTransform additionalProjectTransform, ClassTransform additionalNonProjectTransform, Runnable onNewModuleClassLoader) {
        ModuleClassLoaderManager.Reference<StudioModuleClassLoader> reference;
        Intrinsics.checkNotNullParameter((Object)additionalProjectTransform, (String)"additionalProjectTransform");
        Intrinsics.checkNotNullParameter((Object)additionalNonProjectTransform, (String)"additionalNonProjectTransform");
        Intrinsics.checkNotNullParameter((Object)onNewModuleClassLoader, (String)"onNewModuleClassLoader");
        if ($privateClassLoader) {
            ModuleClassLoaderManager.Reference<StudioModuleClassLoader> reference2;
            ModuleClassLoaderManager.Reference<StudioModuleClassLoader> it = reference2 = this$0.getEnvironment().getModuleClassLoaderManager().getPrivate(parent, $moduleRenderContext, additionalProjectTransform, additionalNonProjectTransform);
            boolean bl = false;
            onNewModuleClassLoader.run();
            reference = reference2;
        } else {
            reference = this$0.getEnvironment().getModuleClassLoaderManager().getShared(parent, $moduleRenderContext, additionalProjectTransform, additionalNonProjectTransform, onNewModuleClassLoader);
        }
        return reference;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/rendering/AndroidFacetRenderModelModule$Companion;", "", "<init>", "()V", "nameFromFacet", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "loggingId", "Lcom/android/tools/rendering/api/RenderModelModuleLoggingId;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String nameFromFacet(AndroidFacet facet) {
            String string = facet.getModule().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @NotNull
        public final RenderModelModuleLoggingId loggingId(@NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            return new RenderModelModuleLoggingId(facet){
                final /* synthetic */ AndroidFacet $facet;
                {
                    this.$facet = $facet;
                }

                public boolean isDisposed() {
                    return this.$facet.isDisposed() || this.$facet.getModule().isDisposed();
                }

                public String getName() {
                    return com.android.tools.idea.rendering.AndroidFacetRenderModelModule$Companion.access$nameFromFacet(AndroidFacetRenderModelModule.Companion, this.$facet);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

