/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.SyncDueMessage;
import com.android.tools.idea.gradle.project.sync.AutoSyncBehavior;
import com.android.tools.idea.gradle.project.sync.AutoSyncSettingStore;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvokerKt;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystemSyncManager;", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "requestSync", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncResult;", "reason", "Lcom/android/tools/idea/projectsystem/ProjectSystemSyncManager$SyncReason;", "shouldCancelAutoSync", "", "requestSyncProject", "isSyncInProgress", "isSyncNeeded", "getLastSyncResult", "intellij.android.projectSystem.gradle"})
public final class GradleProjectSystemSyncManager
implements ProjectSystemSyncManager {
    @NotNull
    private final Project project;

    public GradleProjectSystemSyncManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final ListenableFuture<ProjectSystemSyncManager.SyncResult> requestSync(Project project, ProjectSystemSyncManager.SyncReason reason) {
        MessageBusConnection messageBusConnection;
        GradleSyncStats.Trigger trigger = reason.getForStats();
        SettableFuture syncResult = SettableFuture.create();
        MessageBusConnection $this$requestSync_u24lambda_u240 = messageBusConnection = project.getMessageBus().connect((Disposable)project);
        boolean bl = false;
        $this$requestSync_u24lambda_u240.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)new ProjectSystemSyncManager.SyncResultListener($this$requestSync_u24lambda_u240, (SettableFuture<ProjectSystemSyncManager.SyncResult>)syncResult){
            final /* synthetic */ MessageBusConnection $this_apply;
            final /* synthetic */ SettableFuture<ProjectSystemSyncManager.SyncResult> $syncResult;
            {
                this.$this_apply = $receiver;
                this.$syncResult = $syncResult;
            }

            public void syncEnded(ProjectSystemSyncManager.SyncResult result2) {
                Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                this.$this_apply.disconnect();
                this.$syncResult.set((Object)((Object)result2));
            }
        });
        MessageBusConnection connection2 = messageBusConnection;
        try {
            GradleSyncInvokerKt.requestProjectSync$default(GradleSyncInvoker.Companion.getInstance(), project, trigger, null, 4, null);
        }
        catch (Throwable t) {
            if (!Disposer.isDisposed((Disposable)((Disposable)connection2))) {
                connection2.disconnect();
            }
            syncResult.setException(t);
        }
        Intrinsics.checkNotNull((Object)syncResult);
        return (ListenableFuture)syncResult;
    }

    private final boolean shouldCancelAutoSync(ProjectSystemSyncManager.SyncReason reason) {
        if (!((Boolean)StudioFlags.SHOW_GRADLE_AUTO_SYNC_SETTING_UI.get()).booleanValue()) {
            return false;
        }
        if (AutoSyncSettingStore.INSTANCE.getAutoSyncBehavior() == AutoSyncBehavior.Default) {
            return false;
        }
        Object[] objectArray = new GradleSyncStats.Trigger[]{GradleSyncStats.Trigger.TRIGGER_USER_REQUEST, GradleSyncStats.Trigger.TRIGGER_USER_STALE_CHANGES, GradleSyncStats.Trigger.TRIGGER_AGENT_REQUESTED};
        if (CollectionsKt.listOf((Object[])objectArray).contains(reason.getForStats())) {
            return false;
        }
        Object[] objectArray2 = new GradleSyncStats.Trigger[]{GradleSyncStats.Trigger.TRIGGER_AGP_VERSION_UPDATED, GradleSyncStats.Trigger.TRIGGER_AGP_VERSION_UPDATE_ROLLED_BACK};
        boolean isMigration = CollectionsKt.listOf((Object[])objectArray2).contains(reason.getForStats());
        return !isMigration;
    }

    @Override
    @NotNull
    public ListenableFuture<ProjectSystemSyncManager.SyncResult> requestSyncProject(@NotNull ProjectSystemSyncManager.SyncReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        SettableFuture syncResult = SettableFuture.create();
        boolean cancelAutoSync = this.shouldCancelAutoSync(reason);
        if (cancelAutoSync) {
            syncResult.set((Object)ProjectSystemSyncManager.SyncResult.SKIPPED_DUE_TO_AUTO_SYNC_DISABLED);
        } else if (this.isSyncInProgress()) {
            syncResult.setException((Throwable)new RuntimeException("A sync was requested while one is already in progress. Use ProjectSystemSyncManager.isSyncInProgress to detect this scenario."));
        } else if (this.project.isInitialized()) {
            syncResult.setFuture(this.requestSync(this.project, reason));
        } else {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(() -> GradleProjectSystemSyncManager.requestSyncProject$lambda$0(syncResult, this, reason));
        }
        if (cancelAutoSync) {
            SyncDueMessage.INSTANCE.maybeShow(this.project);
        }
        Intrinsics.checkNotNull((Object)syncResult);
        return (ListenableFuture)syncResult;
    }

    @Override
    public boolean isSyncInProgress() {
        return GradleSyncState.Companion.getInstance(this.project).isSyncInProgress();
    }

    @Override
    public boolean isSyncNeeded() {
        return GradleSyncState.Companion.getInstance(this.project).isSyncNeeded() != ThreeState.NO;
    }

    @Override
    @NotNull
    public ProjectSystemSyncManager.SyncResult getLastSyncResult() {
        return GradleSyncStateHolder.Companion.getInstance(this.project).getSyncResult();
    }

    private static final void requestSyncProject$lambda$0(SettableFuture $syncResult, GradleProjectSystemSyncManager this$0, ProjectSystemSyncManager.SyncReason $reason) {
        $syncResult.setFuture(this$0.requestSync(this$0.project, $reason));
    }
}

