/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.adtui.model.options.OptionsProvider;
import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.stdui.menu.CommonMenuItem;
import com.android.tools.adtui.stdui.menu.CommonPopupMenu;
import com.android.tools.adtui.ui.options.OptionsPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.config.PerfettoSystemTraceConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class CpuProfilingConfigurationsDialog
extends SingleConfigurableEditor {
    @NotNull
    private final CpuProfilerConfigModel myProfilerModel;
    @NotNull
    private Consumer<ProfilingConfiguration> myOnCloseCallback;
    private final int myDeviceLevel;

    public CpuProfilingConfigurationsDialog(@NotNull Project project, int deviceLevel, @NotNull CpuProfilerConfigModel model, @NotNull Consumer<ProfilingConfiguration> onCloseCallback, @NotNull FeatureTracker featureTracker, @NotNull IdeProfilerServices ideProfilerServices) {
        this(project, deviceLevel, model, onCloseCallback, new ProfilingConfigurable(project, model, deviceLevel, featureTracker, ideProfilerServices), !ideProfilerServices.getFeatureConfig().isTaskBasedUxEnabled());
    }

    public CpuProfilingConfigurationsDialog(@NotNull Project project, int deviceLevel, @NotNull CpuProfilerConfigModel model, @NotNull Consumer<ProfilingConfiguration> onCloseCallback, @NotNull ProfilingConfigurable profilingConfigurable, boolean showApplyButton) {
        super(project, (Configurable)profilingConfigurable, ShowSettingsUtilImpl.createDimensionKey((Configurable)profilingConfigurable), showApplyButton, DialogWrapper.IdeModalityType.IDE);
        this.myProfilerModel = model;
        this.myOnCloseCallback = onCloseCallback;
        this.myDeviceLevel = deviceLevel;
        this.setHorizontalStretch(1.3f);
    }

    @VisibleForTesting
    protected Action @NotNull [] createActions() {
        return super.createActions();
    }

    @Nullable
    private ProfilingConfiguration getSelectedConfiguration() {
        ProfilingConfigurable configurable = (ProfilingConfigurable)this.getConfigurable();
        return configurable.getSelectedConfiguration();
    }

    public void dispose() {
        ProfilingConfiguration selectedConfig = this.myProfilerModel.getProfilingConfiguration();
        if (this.getExitCode() == 0) {
            selectedConfig = this.getSelectedConfiguration();
        }
        super.dispose();
        boolean selectedConfigSupported = selectedConfig != null && selectedConfig.isDeviceLevelSupported(this.myDeviceLevel);
        this.myOnCloseCallback.accept((ProfilingConfiguration)(selectedConfigSupported ? selectedConfig : null));
    }

    public void doCancelAction() {
        ProfilingConfigurable configurable = (ProfilingConfigurable)this.getConfigurable();
        configurable.trackTaskBasedUxConfigMetric(false);
        super.doCancelAction();
    }

    protected void doOKAction() {
        ProfilingConfigurable configurable = (ProfilingConfigurable)this.getConfigurable();
        configurable.trackTaskBasedUxConfigMetric(configurable.isModified());
        super.doOKAction();
    }

    @VisibleForTesting
    static class ProfilingConfigurable
    implements Configurable {
        private static final String ADD = "Add";
        private static final String MOVE_DOWN = "Move Down";
        private static final String MOVE_UP = "Move Up";
        private static final String REMOVE = "Remove";
        private final JBSplitter mySplitter = new JBSplitter("ProfilingConfigurable.dividerProportion", 0.3f);
        @NotNull
        private final JList<ProfilingConfiguration> myConfigurations;
        @NotNull
        private final DefaultListModel<ProfilingConfiguration> myConfigurationsModel;
        private int myDefaultConfigurationsCount;
        private final Project myProject;
        private final FeatureTracker myFeatureTracker;
        private OptionsPanel myProfilersPanel;
        private CpuProfilerConfigModel myProfilerModel;
        private int myDeviceLevel;
        private boolean isTaskBasedUxEnabled;
        private final IdeProfilerServices myIdeProfilerServices;

        @VisibleForTesting
        DefaultListModel<ProfilingConfiguration> getConfigurationModel() {
            return this.myConfigurationsModel;
        }

        public ProfilingConfigurable(Project project, CpuProfilerConfigModel model, int deviceLevel, FeatureTracker featureTracker, IdeProfilerServices ideProfilerServices) {
            this.myProject = project;
            this.myFeatureTracker = featureTracker;
            this.myProfilerModel = model;
            this.myDeviceLevel = deviceLevel;
            this.myProfilersPanel = new OptionsPanel();
            this.myConfigurationsModel = new DefaultListModel();
            this.myConfigurations = new JBList(this.myConfigurationsModel);
            this.myIdeProfilerServices = ideProfilerServices;
            this.isTaskBasedUxEnabled = ideProfilerServices.getFeatureConfig().isTaskBasedUxEnabled();
            this.setUpConfigurationsList();
            this.selectConfiguration(this.myProfilerModel.getProfilingConfiguration());
        }

        @Nullable
        public String getHelpTopic() {
            return "org.jetbrains.android.r/studio-ui/cpu-recording-configurations-help-link.html";
        }

        private void setUpConfigurationsList() {
            this.myConfigurations.setSelectionMode(0);
            this.myConfigurations.setCellRenderer(new ProfilingConfigurationsListCellRenderer());
            this.myConfigurations.addListSelectionListener(e -> {
                int index = this.myConfigurations.getSelectedIndex();
                boolean isReadOnlyConfig = !this.isTaskBasedUxEnabled && index >= this.getCustomConfigurationCount();
                this.myProfilersPanel.setOption(index < 0 ? null : (OptionsProvider)this.myConfigurationsModel.get(index), isReadOnlyConfig, this.isTaskBasedUxEnabled);
            });
            if (this.isTaskBasedUxEnabled) {
                for (ProfilingConfiguration configuration2 : this.myProfilerModel.getTaskProfilingConfigurations()) {
                    if (!configuration2.isEditable()) continue;
                    this.myConfigurationsModel.addElement(configuration2);
                }
            } else {
                for (ProfilingConfiguration configuration3 : this.myProfilerModel.getCustomProfilingConfigurations()) {
                    this.myConfigurationsModel.addElement(configuration3);
                }
                for (ProfilingConfiguration configuration3 : this.myProfilerModel.getDefaultProfilingConfigurations()) {
                    this.myConfigurationsModel.addElement(configuration3);
                }
                this.myDefaultConfigurationsCount = this.myProfilerModel.getDefaultProfilingConfigurations().size();
            }
        }

        private int getCustomConfigurationCount() {
            return this.myConfigurationsModel.size() - this.myDefaultConfigurationsCount;
        }

        private void selectConfiguration(ProfilingConfiguration configuration2) {
            for (int i = 0; i < this.myConfigurationsModel.size(); ++i) {
                if (!configuration2.getName().equals(this.myConfigurationsModel.get(i).getName())) continue;
                this.myConfigurations.setSelectedIndex(i);
                return;
            }
        }

        public ProfilingConfiguration getSelectedConfiguration() {
            return this.myConfigurations.getSelectedValue();
        }

        private JComponent createLeftPanel() {
            MyAddAction addAction = new MyAddAction();
            MyRemoveAction removeAction = new MyRemoveAction();
            MyMoveAction moveUpAction = new MyMoveAction(MOVE_UP, -1, IconUtil.getMoveUpIcon());
            MyMoveAction moveDownAction = new MyMoveAction(MOVE_DOWN, 1, IconUtil.getMoveUpIcon());
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myConfigurations).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).setMinimumSize((Dimension)new JBDimension(200, 200)).setForcedDnD();
            if (!this.isTaskBasedUxEnabled) {
                toolbarDecorator.setMoveUpAction((AnActionButtonRunnable)moveUpAction).setMoveUpActionUpdater((AnActionButtonUpdater)moveUpAction).setMoveUpActionName(MOVE_UP).setMoveDownAction((AnActionButtonRunnable)moveDownAction).setMoveDownActionUpdater((AnActionButtonUpdater)moveDownAction).setMoveDownActionName(MOVE_DOWN).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction).setRemoveActionName(REMOVE).setAddAction((AnActionButtonRunnable)addAction).setAddActionUpdater((AnActionButtonUpdater)addAction).setAddActionName(ADD);
            } else {
                toolbarDecorator.disableRemoveAction().disableDownAction().disableUpAction().disableAddAction();
            }
            JPanel panel2 = toolbarDecorator.createPanel();
            if (!this.isTaskBasedUxEnabled) {
                addAction.setPopupParent(panel2);
                return panel2;
            }
            JPanel taskTitlePanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JPanel headerPanel2 = new JPanel(new BorderLayout());
            JLabel headerLabel = new JLabel("Tasks");
            headerLabel.setFont(headerLabel.getFont().deriveFont(1));
            headerPanel2.add(headerLabel);
            taskTitlePanel.add(headerPanel2);
            taskTitlePanel.add(panel2);
            return taskTitlePanel;
        }

        @Nls
        public String getDisplayName() {
            if (this.isTaskBasedUxEnabled) {
                return "Task Settings";
            }
            return "CPU Recording Configurations";
        }

        @Nullable
        public JComponent createComponent() {
            JPanel mainComponent = new JPanel(new BorderLayout());
            this.mySplitter.setFirstComponent(this.createLeftPanel());
            this.mySplitter.setHonorComponentsMinimumSize(true);
            this.mySplitter.setSecondComponent((JComponent)this.myProfilersPanel);
            mainComponent.add((Component)this.mySplitter, "Center");
            mainComponent.setPreferredSize(new Dimension(800, 600));
            return mainComponent;
        }

        public void apply() throws ConfigurationException {
            HashSet<String> configNames = new HashSet<String>();
            ArrayList<CpuProfilerConfig> configsToSave = new ArrayList<CpuProfilerConfig>();
            for (int i = 0; i < this.myConfigurationsModel.getSize(); ++i) {
                ProfilingConfiguration config = this.myConfigurationsModel.getElementAt(i);
                String configName = config.getName();
                if (StringUtil.isEmpty((String)configName)) {
                    throw new ConfigurationException("Empty configuration names are not allowed. Please rename or delete them before continuing.");
                }
                if (configNames.contains(configName)) {
                    throw new ConfigurationException("Configuration with name \"" + configName + "\" already exists.");
                }
                configNames.add(configName);
                if (ProfilingConfigurable.isDefaultConfig(config) && !this.isTaskBasedUxEnabled) continue;
                configsToSave.add(CpuProfilerConfigConverter.fromProfilingConfiguration(config));
            }
            if (this.isTaskBasedUxEnabled) {
                for (ProfilingConfiguration configuration2 : this.myProfilerModel.getTaskProfilingConfigurations()) {
                    if (configuration2.isEditable()) continue;
                    configsToSave.add(CpuProfilerConfigConverter.fromProfilingConfiguration(configuration2));
                }
                CpuProfilerConfigsState.getInstance(this.myProject).setTaskConfigs(configsToSave);
            } else {
                CpuProfilerConfigsState.getInstance(this.myProject).setUserConfigs(configsToSave);
            }
        }

        private boolean isTaskConfigChanged() {
            ArrayList<CpuProfilerConfig> latestConfigs = new ArrayList<CpuProfilerConfig>();
            for (int i = 0; i < this.myConfigurationsModel.getSize(); ++i) {
                latestConfigs.add(CpuProfilerConfigConverter.fromProfilingConfiguration(this.myConfigurationsModel.getElementAt(i)));
            }
            List<CpuProfilerConfig> existingConfigs = CpuProfilerConfigsState.getInstance(this.myProject).getSavedTaskConfigsIfPresentOrDefault();
            Map<String, List<CpuProfilerConfig>> existingConfigGrouped = existingConfigs.stream().collect(Collectors.groupingBy(CpuProfilerConfig::getName));
            Map<String, List<CpuProfilerConfig>> latestConfigGrouped = latestConfigs.stream().collect(Collectors.groupingBy(CpuProfilerConfig::getName));
            for (String configName : latestConfigGrouped.keySet()) {
                CpuProfilerConfig configBefore;
                CpuProfilerConfig configNow = latestConfigGrouped.get(configName).get(0);
                if (configNow.equals(configBefore = existingConfigGrouped.get(configName).get(0))) continue;
                return true;
            }
            return false;
        }

        public boolean isModified() {
            if (this.isTaskBasedUxEnabled) {
                return this.isTaskConfigChanged();
            }
            return true;
        }

        public void trackTaskBasedUxConfigMetric(boolean isConfigChanged) {
            if (this.isTaskBasedUxEnabled) {
                this.myIdeProfilerServices.getFeatureTracker().trackTaskSettingsOpened(isConfigChanged);
            }
        }

        private static boolean isDefaultConfig(@NotNull ProfilingConfiguration configuration2) {
            return CpuProfilerConfigsState.getDefaultConfigs().stream().anyMatch(c -> c.getName().equals(configuration2.getName()));
        }

        private class ProfilingConfigurationsListCellRenderer
        implements ListCellRenderer<ProfilingConfiguration> {
            private JLabel myLabel = new JLabel();

            public ProfilingConfigurationsListCellRenderer() {
                EmptyBorder marginLeft = new EmptyBorder(0, 10, 0, 0);
                this.myLabel.setBorder(marginLeft);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends ProfilingConfiguration> list2, ProfilingConfiguration value2, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setPreferredSize(new Dimension(panel2.getPreferredSize().width, 25));
                panel2.setBackground(list2.getBackground());
                Object cellText = value2.getName();
                if (!value2.isDeviceLevelSupported(ProfilingConfigurable.this.myDeviceLevel)) {
                    cellText = (String)cellText + String.format(Locale.US, " (API Level %d+)", value2.getRequiredDeviceLevel());
                }
                this.myLabel.setText((String)cellText);
                this.myLabel.setForeground((Color)(isSelected ? Gray._255 : JBColor.BLACK));
                if (isSelected) {
                    panel2.setBackground(ProfilerColors.CPU_PROFILING_CONFIGURATIONS_SELECTED);
                }
                panel2.add((Component)this.myLabel, "Center");
                return panel2;
            }
        }

        private class MyAddAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            @NotNull
            private final CommonPopupMenu myPopup;
            @NotNull
            private final List<CommonAction> myActions;
            private static final String UNNAMED = "Unnamed";
            private JComponent myPanel;

            private MyAddAction() {
                super("Add Configuration", "Add a new configuration", IconUtil.getAddIcon());
                this.myActions = new ArrayList<CommonAction>();
                this.myPopup = new CommonPopupMenu();
                this.myPopup.add((JMenuItem)this.buildPopupMenuItem(CpuProfilerConfig.Technology.SAMPLED_NATIVE.getName(), SimpleperfConfiguration::new));
                this.myPopup.add((JMenuItem)this.buildPopupMenuItemPerfetto(CpuProfilerConfig.Technology.SYSTEM_TRACE.getName()));
                this.myPopup.add((JMenuItem)this.buildPopupMenuItem(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA.getName(), ArtInstrumentedConfiguration::new));
                this.myPopup.add((JMenuItem)this.buildPopupMenuItem(CpuProfilerConfig.Technology.SAMPLED_JAVA.getName(), ArtSampledConfiguration::new));
            }

            private CommonMenuItem buildPopupMenuItemPerfetto(String name2) {
                CommonAction action2 = new CommonAction(name2, null);
                action2.setAction(() -> this.addConfiguration((ProfilingConfiguration)new PerfettoSystemTraceConfiguration(UNNAMED, ((Boolean)StudioFlags.PROFILER_TRACEBOX.get()).booleanValue())));
                return new CommonMenuItem(action2);
            }

            private CommonMenuItem buildPopupMenuItem(String name2, Function<String, ProfilingConfiguration> configurationConstructor) {
                CommonAction action2 = new CommonAction(name2, null);
                action2.setAction(() -> this.addConfiguration((ProfilingConfiguration)configurationConstructor.apply(UNNAMED)));
                return new CommonMenuItem(action2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
            }

            public void setPopupParent(JComponent panel2) {
                this.myPanel = panel2;
            }

            public void run(AnActionButton button) {
                this.myPopup.show((Component)this.myPanel, 0, 24);
            }

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return true;
            }

            private void addConfiguration(ProfilingConfiguration configuration2) {
                int lastConfigurationIndex = ProfilingConfigurable.this.getCustomConfigurationCount();
                ProfilingConfigurable.this.myConfigurationsModel.insertElementAt(configuration2, lastConfigurationIndex);
                ProfilingConfigurable.this.myConfigurations.setSelectedIndex(lastConfigurationIndex);
                ProfilingConfigurable.this.myFeatureTracker.trackCreateCustomProfilingConfig();
            }

            @NotNull
            private String getUniqueName(@NotNull String name2) {
                HashSet<String> names = new HashSet<String>();
                Enumeration<ProfilingConfiguration> configurations = ProfilingConfigurable.this.myConfigurationsModel.elements();
                while (configurations.hasMoreElements()) {
                    names.add(configurations.nextElement().getName());
                }
                String uniqueName = name2;
                int i = 1;
                while (names.contains(uniqueName)) {
                    uniqueName = String.format(Locale.US, "%s (%d)", name2, i++);
                }
                return uniqueName;
            }
        }

        private class MyRemoveAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            public MyRemoveAction() {
                super("Remove Configuration", "Remove the selected configuration", IconUtil.getRemoveIcon());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.removeSelectedConfiguration();
            }

            public void run(AnActionButton button) {
                this.removeSelectedConfiguration();
            }

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return this.nonDefaultSelectionExists();
            }

            private boolean nonDefaultSelectionExists() {
                int index = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                return ProfilingConfigurable.this.myConfigurations.getSelectedIndex() >= 0 && index < ProfilingConfigurable.this.getCustomConfigurationCount();
            }

            private void removeSelectedConfiguration() {
                if (this.nonDefaultSelectionExists()) {
                    int removedIndex = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                    ProfilingConfigurable.this.myConfigurationsModel.remove(removedIndex);
                    ProfilingConfigurable.this.myConfigurations.setSelectedIndex(removedIndex);
                }
            }
        }

        private class MyMoveAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            private int myMoveDownCount;

            public MyMoveAction(String actionText, int moveDownCount, Icon icon) {
                super(actionText, null, icon);
                this.myMoveDownCount = moveDownCount;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.moveSelectedElement();
            }

            public void run(AnActionButton button) {
                this.moveSelectedElement();
            }

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return this.validSelectionExists();
            }

            private void moveSelectedElement() {
                if (this.validSelectionExists()) {
                    int origin = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                    int dest = origin + this.myMoveDownCount;
                    ProfilingConfiguration temp = ProfilingConfigurable.this.myConfigurationsModel.get(origin);
                    ProfilingConfigurable.this.myConfigurationsModel.set(origin, ProfilingConfigurable.this.myConfigurationsModel.get(dest));
                    ProfilingConfigurable.this.myConfigurationsModel.set(dest, temp);
                    ProfilingConfigurable.this.myConfigurations.setSelectedIndex(dest);
                }
            }

            private boolean validSelectionExists() {
                if (ProfilingConfigurable.this.myConfigurations.getSelectedIndex() < 0) {
                    return false;
                }
                if (ProfilingConfigurable.this.myConfigurations.getSelectedIndex() >= ProfilingConfigurable.this.getCustomConfigurationCount()) {
                    return false;
                }
                return ProfilingConfigurable.this.myConfigurations.getSelectedIndex() + this.myMoveDownCount >= 0 && ProfilingConfigurable.this.myConfigurations.getSelectedIndex() + this.myMoveDownCount < ProfilingConfigurable.this.getCustomConfigurationCount();
            }
        }
    }
}

