/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.transport.DeployableFile;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u000bH\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager;", "Lcom/intellij/openapi/Disposable;", "ticker", "Lcom/google/common/base/Ticker;", "executorService", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lcom/google/common/base/Ticker;Ljava/util/concurrent/ExecutorService;)V", "process", "Ljava/lang/Process;", "disposed", "", "value", "", "daemonPort", "getDaemonPort", "()I", "processIsRunning", "makeSureDaemonIsRunning", "", "tracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "dispose", "Companion", "DaemonStatus", "TPDStdoutListener", "intellij.android.profilersAndroid"})
public final class TraceProcessorDaemonManager
implements Disposable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Ticker ticker;
    @NotNull
    private final ExecutorService executorService;
    @Nullable
    private Process process;
    private boolean disposed;
    private int daemonPort;
    @NotNull
    private static final Logger LOGGER;
    private static final long TPD_SPAWN_TIMEOUT;
    private static final Pattern SERVER_STARTED;
    @NotNull
    private static final String SERVER_PORT_BIND_FAILED = "Server failed to start. A port number wasn't bound.";
    @NotNull
    private static final Lazy<String> TPD_DEV_PATH$delegate;
    @NotNull
    private static final String TPD_RELEASE_PATH;
    @NotNull
    private static final Lazy<String> TPD_EXECUTABLE$delegate;
    @NotNull
    private static final DeployableFile TPD_BINARY;

    public TraceProcessorDaemonManager(@NotNull Ticker ticker, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.ticker = ticker;
        this.executorService = executorService;
    }

    public /* synthetic */ TraceProcessorDaemonManager(Ticker ticker, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor(...)");
            executorService = executorService2;
        }
        this(ticker, executorService);
    }

    public final int getDaemonPort() {
        return this.daemonPort;
    }

    @VisibleForTesting
    public final boolean processIsRunning() {
        Process process2 = this.process;
        return process2 != null ? process2.isAlive() : false;
    }

    public final synchronized void makeSureDaemonIsRunning(@NotNull FeatureTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (!this.processIsRunning() && !this.disposed) {
            Stopwatch spawnStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
            LOGGER.info("TPD Manager: Starting new instance of TPD");
            String[] stringArray = new String[]{TraceProcessorDaemonManager.Companion.getExecutablePath(), "--llvm_symbolizer_path", NativeSymbolizerKt.getLlvmSymbolizerPath()};
            Process newProcess = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
            TPDStdoutListener stdoutListener = new TPDStdoutListener(new BufferedReader(new InputStreamReader(newProcess.getInputStream())));
            this.executorService.execute(stdoutListener);
            stdoutListener.waitForStatusChangeOrTerminated(TPD_SPAWN_TIMEOUT);
            spawnStopwatch.stop();
            long timeToSpawnMs = spawnStopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (stdoutListener.getStatus() == DaemonStatus.RUNNING) {
                tracker.trackTraceProcessorDaemonSpawnAttempt(true, timeToSpawnMs);
                this.daemonPort = stdoutListener.getSelectedPort();
                this.process = newProcess;
                LOGGER.info("TPD Manager: TPD instance ready on port " + this.daemonPort + ".");
            } else {
                tracker.trackTraceProcessorDaemonSpawnAttempt(false, timeToSpawnMs);
                LOGGER.info("TPD Manager: Unable to start TPD instance.");
                Process process2 = newProcess;
                if (process2 != null && (process2 = process2.destroyForcibly()) != null) {
                    process2.waitFor();
                }
                throw new RuntimeException("Unable to start TPD instance.");
            }
        }
    }

    public synchronized void dispose() {
        block0: {
            this.disposed = true;
            Process process2 = this.process;
            if (process2 == null || (process2 = process2.destroyForcibly()) == null) break block0;
            process2.waitFor();
        }
    }

    private static final String TPD_DEV_PATH_delegate$lambda$0() {
        Object object;
        if (SystemInfo.isWindows) {
            object = "prebuilts/tools/common/trace-processor-daemon/windows";
        } else if (SystemInfo.isMac) {
            object = "prebuilts/tools/common/trace-processor-daemon/" + (SystemInfo.isAarch64 ? "darwin-arm64" : "darwin-x86_64");
        } else if (SystemInfo.isLinux) {
            object = "prebuilts/tools/common/trace-processor-daemon/linux";
        } else {
            LOGGER.warn("Unsupported platform for TPD. Using linux binary.");
            object = "prebuilts/tools/common/trace-processor-daemon/linux";
        }
        return object;
    }

    private static final String TPD_EXECUTABLE_delegate$lambda$0() {
        return SystemInfo.isWindows ? "trace_processor_daemon.exe" : "trace_processor_daemon";
    }

    static {
        Logger logger = Logger.getInstance(TraceProcessorDaemonManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
        TPD_SPAWN_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
        SERVER_STARTED = Pattern.compile("^Server listening on (?:127.0.0.1|localhost):(?<port>\\d+)\n*$");
        TPD_DEV_PATH$delegate = LazyKt.lazy(TraceProcessorDaemonManager::TPD_DEV_PATH_delegate$lambda$0);
        TPD_RELEASE_PATH = "plugins/android/resources/trace_processor_daemon";
        TPD_EXECUTABLE$delegate = LazyKt.lazy(TraceProcessorDaemonManager::TPD_EXECUTABLE_delegate$lambda$0);
        DeployableFile deployableFile = new DeployableFile.Builder(TraceProcessorDaemonManager.Companion.getTPD_EXECUTABLE()).setReleaseDir(TPD_RELEASE_PATH).setDevDir(TraceProcessorDaemonManager.Companion.getTPD_DEV_PATH()).setExecutable(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)deployableFile, (String)"build(...)");
        TPD_BINARY = deployableFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\rH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0015\u0010\u0010R\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TPD_SPAWN_TIMEOUT", "", "SERVER_STARTED", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SERVER_PORT_BIND_FAILED", "", "TPD_DEV_PATH", "getTPD_DEV_PATH", "()Ljava/lang/String;", "TPD_DEV_PATH$delegate", "Lkotlin/Lazy;", "TPD_RELEASE_PATH", "TPD_EXECUTABLE", "getTPD_EXECUTABLE", "TPD_EXECUTABLE$delegate", "TPD_BINARY", "Lcom/android/tools/idea/transport/DeployableFile;", "getExecutablePath", "intellij.android.profilersAndroid"})
    private static final class Companion {
        private Companion() {
        }

        private final String getTPD_DEV_PATH() {
            Lazy lazy = TPD_DEV_PATH$delegate;
            return (String)lazy.getValue();
        }

        private final String getTPD_EXECUTABLE() {
            Lazy lazy = TPD_EXECUTABLE$delegate;
            return (String)lazy.getValue();
        }

        private final String getExecutablePath() {
            String string = new File(TPD_BINARY.getDir(), TPD_BINARY.getFileName()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "", "<init>", "(Ljava/lang/String;I)V", "STARTING", "RUNNING", "FAILED", "END_OF_STREAM", "intellij.android.profilersAndroid"})
    public static final class DaemonStatus
    extends Enum<DaemonStatus> {
        public static final /* enum */ DaemonStatus STARTING = new DaemonStatus();
        public static final /* enum */ DaemonStatus RUNNING = new DaemonStatus();
        public static final /* enum */ DaemonStatus FAILED = new DaemonStatus();
        public static final /* enum */ DaemonStatus END_OF_STREAM = new DaemonStatus();
        private static final /* synthetic */ DaemonStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DaemonStatus[] values() {
            return (DaemonStatus[])$VALUES.clone();
        }

        public static DaemonStatus valueOf(String value2) {
            return Enum.valueOf(DaemonStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<DaemonStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = daemonStatusArray = new DaemonStatus[]{DaemonStatus.STARTING, DaemonStatus.RUNNING, DaemonStatus.FAILED, DaemonStatus.END_OF_STREAM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$TPDStdoutListener;", "Ljava/lang/Runnable;", "outputReader", "Ljava/io/BufferedReader;", "<init>", "(Ljava/io/BufferedReader;)V", "statusLock", "Ljava/lang/Object;", "newStatus", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "status", "getStatus", "()Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "setStatus", "(Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;)V", "value", "", "selectedPort", "getSelectedPort", "()I", "run", "", "waitUntilTerminated", "timeout", "", "waitForStatusChangeOrTerminated", "terminated", "", "intellij.android.profilersAndroid"})
    public static final class TPDStdoutListener
    implements Runnable {
        @NotNull
        private final BufferedReader outputReader;
        @NotNull
        private final Object statusLock;
        @NotNull
        private DaemonStatus status;
        private int selectedPort;

        public TPDStdoutListener(@NotNull BufferedReader outputReader) {
            Intrinsics.checkNotNullParameter((Object)outputReader, (String)"outputReader");
            this.outputReader = outputReader;
            this.statusLock = new Object();
            this.status = DaemonStatus.STARTING;
        }

        @NotNull
        public final DaemonStatus getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setStatus(DaemonStatus newStatus) {
            Object object = this.statusLock;
            synchronized (object) {
                boolean bl = false;
                LOGGER.debug("TPD Manager: Daemon status: " + newStatus);
                this.status = newStatus;
                this.statusLock.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }

        public final int getSelectedPort() {
            return this.selectedPort;
        }

        @Override
        public void run() {
            block3: {
                while (true) {
                    String line;
                    if ((line = this.outputReader.readLine()) == null) {
                        LOGGER.debug("TPD Manager: [TPD Log] EOF");
                        this.setStatus(DaemonStatus.END_OF_STREAM);
                        break block3;
                    }
                    LOGGER.debug("TPD Manager: [TPD Log] " + line);
                    Matcher serverOkMatcher = SERVER_STARTED.matcher(line);
                    if (serverOkMatcher.matches()) {
                        String string = serverOkMatcher.group("port");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                        this.selectedPort = Integer.parseInt(string);
                        this.setStatus(DaemonStatus.RUNNING);
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)line, (String)TraceProcessorDaemonManager.SERVER_PORT_BIND_FAILED, (boolean)false, (int)2, null)) break;
                }
                this.setStatus(DaemonStatus.FAILED);
            }
        }

        @VisibleForTesting
        public final void waitUntilTerminated(long timeout) {
            while (!this.terminated()) {
                this.waitForStatusChangeOrTerminated(timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitForStatusChangeOrTerminated(long timeout) {
            Object object = this.statusLock;
            synchronized (object) {
                boolean bl = false;
                if (!this.terminated()) {
                    this.statusLock.wait(timeout);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private final boolean terminated() {
            return this.status == DaemonStatus.END_OF_STREAM || this.status == DaemonStatus.FAILED;
        }
    }
}

