/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.commands;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidApiLevel;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.service.LogcatService;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.leakcanarylib.LeakCanaryParser;
import com.android.tools.leakcanarylib.data.Analysis;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.LeakCanary;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002J\"\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u001d2\b\b\u0002\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u0016H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010%\u001a\u00020&H\u0016J\b\u00105\u001a\u00020(H\u0002J\u0010\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u001d2\u0006\u00107\u001a\u000208H\u0002J\u0014\u0010:\u001a\u00020\u00162\n\u0010;\u001a\u00060\u001fj\u0002` H\u0002J\u0010\u0010<\u001a\u00020(2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010=\u001a\u00020\u001d2\u0006\u00107\u001a\u000208H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00060\u001fj\u0002` X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00060\u001fj\u0002` X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/profilers/commands/LeakCanaryLogcatCommandHandler;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "device", "Lcom/android/ddmlib/IDevice;", "transportStub", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "eventQueue", "Ljava/util/concurrent/BlockingDeque;", "Lcom/android/tools/profiler/proto/Common$Event;", "<init>", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;Ljava/util/concurrent/BlockingDeque;)V", "scopeJob", "Lkotlinx/coroutines/CompletableJob;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "logCollectionJob", "Lkotlinx/coroutines/Job;", "pid", "", "sessionId", "", "bytesRetainedText", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "startTimeNs", "TWO_SECONDS", "prevLogTimeStampOfPartialTrace", "inLastFrameOfPartialTrace", "", "capturedLogsForPartialTrace", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "inMetaSectionOfCompleteTrace", "isCapturingCompleteTrace", "capturedLogsForCompleteTrace", "shouldHandle", "command", "Lcom/android/tools/profiler/proto/Commands$Command;", "resetTrackingState", "", "startTrace", "stopTrace", "getCurrentTimestampInNs", "sendLeakCanaryAnalysisInfoEvent", "timestampNs", "isStarted", "stopStatus", "Lcom/android/tools/profiler/proto/LeakCanary$LeakCanaryAnalysisEnded$Status;", "sendLeakCanaryAnalysisEvent", "analysisData", "execute", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "readLeakLog", "detectAndHandleObjectRetainedAndAnalysis", "logcatMessage", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "detectAndHandleCompleteLeakTraces", "convertPartialToCompleteTrace", "leaktrace", "detectAndHandlePartialLeakTraces", "detectAndHandleHostAnalysisTrigger", "Companion", "intellij.android.profilersAndroid"})
@SourceDebugExtension(value={"SMAP\nLeakCanaryLogcatCommandHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanaryLogcatCommandHandler.kt\ncom/android/tools/idea/profilers/commands/LeakCanaryLogcatCommandHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n1869#2,2:385\n1869#2,2:387\n1869#2,2:389\n*S KotlinDebug\n*F\n+ 1 LeakCanaryLogcatCommandHandler.kt\ncom/android/tools/idea/profilers/commands/LeakCanaryLogcatCommandHandler\n*L\n238#1:385,2\n259#1:387,2\n340#1:389,2\n*E\n"})
public final class LeakCanaryLogcatCommandHandler
implements TransportProxy.ProxyCommandHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDevice device;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub transportStub;
    @NotNull
    private final BlockingDeque<Common.Event> eventQueue;
    @NotNull
    private final CompletableJob scopeJob;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job logCollectionJob;
    private int pid;
    private long sessionId;
    @NotNull
    private final String bytesRetainedText;
    @NotNull
    private final Logger logger;
    private long startTimeNs;
    private final long TWO_SECONDS;
    private long prevLogTimeStampOfPartialTrace;
    private boolean inLastFrameOfPartialTrace;
    @NotNull
    private StringBuilder capturedLogsForPartialTrace;
    private boolean inMetaSectionOfCompleteTrace;
    private boolean isCapturingCompleteTrace;
    @NotNull
    private StringBuilder capturedLogsForCompleteTrace;
    @NotNull
    private static final String LEAKCANARY_TAG = "LeakCanary";

    public LeakCanaryLogcatCommandHandler(@NotNull IDevice device2, @NotNull TransportServiceGrpc.TransportServiceBlockingStub transportStub, @NotNull BlockingDeque<Common.Event> eventQueue) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)transportStub, (String)"transportStub");
        Intrinsics.checkNotNullParameter(eventQueue, (String)"eventQueue");
        this.device = device2;
        this.transportStub = transportStub;
        this.eventQueue = eventQueue;
        this.scopeJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)this.scopeJob));
        this.bytesRetainedText = "bytes retained by leaking objects";
        Logger logger = Logger.getInstance(LeakCanaryLogcatCommandHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.TWO_SECONDS = TimeUnit.SECONDS.toSeconds(2L);
        this.capturedLogsForPartialTrace = new StringBuilder();
        this.capturedLogsForCompleteTrace = new StringBuilder();
    }

    @Override
    public boolean shouldHandle(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return command.getType() == Commands.Command.CommandType.START_LOGCAT_TRACKING || command.getType() == Commands.Command.CommandType.STOP_LOGCAT_TRACKING;
    }

    private final void resetTrackingState() {
        Job job2 = this.logCollectionJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.logCollectionJob = null;
        this.prevLogTimeStampOfPartialTrace = 0L;
        this.inLastFrameOfPartialTrace = false;
        this.capturedLogsForPartialTrace = new StringBuilder();
        this.inMetaSectionOfCompleteTrace = false;
        this.isCapturingCompleteTrace = false;
        this.capturedLogsForCompleteTrace = new StringBuilder();
    }

    private final void startTrace(Commands.Command command) {
        this.startTimeNs = this.getCurrentTimestampInNs();
        this.pid = command.getPid();
        this.sessionId = command.getSessionId();
        this.resetTrackingState();
        this.readLeakLog();
        LeakCanaryLogcatCommandHandler.sendLeakCanaryAnalysisInfoEvent$default(this, this.startTimeNs, true, null, 4, null);
    }

    private final void stopTrace(Commands.Command command) {
        long endTime = this.getCurrentTimestampInNs();
        this.resetTrackingState();
        this.sendLeakCanaryAnalysisInfoEvent(endTime, false, LeakCanary.LeakCanaryAnalysisEnded.Status.SUCCESS);
        this.addSessionEndedEvent(this.eventQueue, endTime, this.pid, command.getSessionId());
    }

    private final long getCurrentTimestampInNs() {
        return this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance()).getTimestampNs();
    }

    private final void sendLeakCanaryAnalysisInfoEvent(long timestampNs, boolean isStarted, LeakCanary.LeakCanaryAnalysisEnded.Status stopStatus) {
        LeakCanary.LeakCanaryAnalysisStatus leakCanaryAnalysisStatus;
        if (isStarted) {
            var6_4 = LeakCanary.LeakCanaryAnalysisStatus.newBuilder().setAnalysisStarted(LeakCanary.LeakCanaryAnalysisStarted.newBuilder().setTimestamp(timestampNs).build()).build();
            Intrinsics.checkNotNull((Object)var6_4);
            leakCanaryAnalysisStatus = var6_4;
        } else {
            var6_4 = LeakCanary.LeakCanaryAnalysisStatus.newBuilder().setAnalysisEnded(LeakCanary.LeakCanaryAnalysisEnded.newBuilder().setStartTimestamp(this.startTimeNs).setEndTimestamp(timestampNs).setStatus(stopStatus).build()).build();
            Intrinsics.checkNotNull((Object)var6_4);
            leakCanaryAnalysisStatus = var6_4;
        }
        LeakCanary.LeakCanaryAnalysisStatus infoEvent = leakCanaryAnalysisStatus;
        this.eventQueue.offer(Common.Event.newBuilder().setGroupId((long)this.pid).setPid(this.pid).setIsEnded(!isStarted).setKind(Common.Event.Kind.LEAKCANARY_ANALYSIS_STATUS).setLeakCanaryAnalysisStatus(infoEvent).setTimestamp(timestampNs).build());
    }

    static /* synthetic */ void sendLeakCanaryAnalysisInfoEvent$default(LeakCanaryLogcatCommandHandler leakCanaryLogcatCommandHandler, long l, boolean bl, LeakCanary.LeakCanaryAnalysisEnded.Status status2, int n, Object object) {
        if ((n & 4) != 0) {
            status2 = LeakCanary.LeakCanaryAnalysisEnded.Status.STATUS_UNSPECIFIED;
        }
        leakCanaryLogcatCommandHandler.sendLeakCanaryAnalysisInfoEvent(l, bl, status2);
    }

    private final void sendLeakCanaryAnalysisEvent(String analysisData) {
        try {
            Analysis analysis = new LeakCanaryParser().parseLogcatMessage(analysisData);
            LeakCanary.LeakCanaryAnalysisData leakCanaryEvent = LeakCanary.LeakCanaryAnalysisData.newBuilder().setData(String.valueOf(analysis)).build();
            this.eventQueue.offer(Common.Event.newBuilder().setGroupId((long)this.pid).setPid(this.pid).setKind(Common.Event.Kind.LEAKCANARY_ANALYSIS).setLeakcanaryAnalysis(leakCanaryEvent).setTimestamp(this.getCurrentTimestampInNs()).build());
        }
        catch (Exception e) {
            this.logger.info("Failed to parse LeakCanary report. Skipping event.", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public Transport.ExecuteResponse execute(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        switch (commandType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) {
            case 1: {
                this.startTrace(command);
                break;
            }
            case 2: {
                this.stopTrace(command);
            }
        }
        Transport.ExecuteResponse executeResponse = Transport.ExecuteResponse.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)executeResponse, (String)"build(...)");
        return executeResponse;
    }

    private final void readLeakLog() {
        Project project = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
        LogcatService logcatService = LogcatService.Companion.getInstance(project);
        this.logCollectionJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, logcatService, null){
            int label;
            final /* synthetic */ LeakCanaryLogcatCommandHandler this$0;
            final /* synthetic */ LogcatService $logcatService;
            {
                this.this$0 = $receiver;
                this.$logcatService = $logcatService;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        LeakCanaryLogcatCommandHandler.access$getLogger$p(this.this$0).info("Coroutine Started");
                        String string = LeakCanaryLogcatCommandHandler.access$getDevice$p(this.this$0).getSerialNumber();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSerialNumber(...)");
                        AndroidApiLevel androidApiLevel = LeakCanaryLogcatCommandHandler.access$getDevice$p(this.this$0).getVersion().getAndroidApiLevel();
                        Intrinsics.checkNotNullExpressionValue((Object)androidApiLevel, (String)"getAndroidApiLevel(...)");
                        this.label = 1;
                        Object object3 = LogcatService.readLogcat$default(this.$logcatService, string, androidApiLevel, null, 0, 4, null).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ LeakCanaryLogcatCommandHandler this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(List<LogcatMessage> logcatMessages, Continuation<? super Unit> $completion) {
                                void $this$forEach$iv;
                                Iterable iterable = logcatMessages;
                                LeakCanaryLogcatCommandHandler leakCanaryLogcatCommandHandler = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    LogcatMessage logcatMessage = (LogcatMessage)element$iv;
                                    boolean bl = false;
                                    boolean handled = LeakCanaryLogcatCommandHandler.access$detectAndHandleObjectRetainedAndAnalysis(leakCanaryLogcatCommandHandler, logcatMessage);
                                    if (!handled) {
                                        handled = LeakCanaryLogcatCommandHandler.access$detectAndHandleCompleteLeakTraces(leakCanaryLogcatCommandHandler, logcatMessage);
                                    }
                                    if (!handled) {
                                        handled = LeakCanaryLogcatCommandHandler.access$detectAndHandleHostAnalysisTrigger(leakCanaryLogcatCommandHandler, logcatMessage);
                                    }
                                    if (handled) continue;
                                    LeakCanaryLogcatCommandHandler.access$detectAndHandlePartialLeakTraces(leakCanaryLogcatCommandHandler, logcatMessage);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean detectAndHandleObjectRetainedAndAnalysis(LogcatMessage logcatMessage) {
        Regex retainedObjectsRegex = new Regex("Found (\\d+) objects retained");
        Regex analysisProgressRegex = new Regex("Analysis in progress, (\\d+)% done");
        boolean handled = false;
        if (!Intrinsics.areEqual((Object)logcatMessage.getHeader().getTag(), (Object)LEAKCANARY_TAG)) {
            return false;
        }
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)logcatMessage.getMessage(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (!retainedObjectsRegex.containsMatchIn((CharSequence)line) && !analysisProgressRegex.containsMatchIn((CharSequence)line)) continue;
            this.sendLeakCanaryAnalysisEvent(line);
            handled = true;
        }
        return handled;
    }

    private final boolean detectAndHandleCompleteLeakTraces(LogcatMessage logcatMessage) {
        String startPatternSuccess = "HEAP ANALYSIS RESULT";
        String startPatternFailure = "HEAP ANALYSIS FAILED";
        String separatingLine = "====================================";
        String metaSectionPattern = "METADATA";
        boolean handled = false;
        if (!Intrinsics.areEqual((Object)LEAKCANARY_TAG, (Object)logcatMessage.getHeader().getTag())) {
            return false;
        }
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)logcatMessage.getMessage(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)startPatternSuccess, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)startPatternFailure, (boolean)false, (int)2, null)) {
                this.isCapturingCompleteTrace = true;
                StringsKt.clear((StringBuilder)this.capturedLogsForCompleteTrace);
                this.capturedLogsForCompleteTrace.append(separatingLine).append('\n');
            }
            if (this.isCapturingCompleteTrace) {
                this.capturedLogsForCompleteTrace.append(line).append('\n');
            }
            if (this.isCapturingCompleteTrace && StringsKt.contains$default((CharSequence)line, (CharSequence)metaSectionPattern, (boolean)false, (int)2, null)) {
                this.inMetaSectionOfCompleteTrace = true;
            }
            if (!this.inMetaSectionOfCompleteTrace || !Intrinsics.areEqual((Object)separatingLine, (Object)line)) continue;
            this.isCapturingCompleteTrace = false;
            this.inMetaSectionOfCompleteTrace = false;
            String string = this.capturedLogsForCompleteTrace.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.sendLeakCanaryAnalysisEvent(string);
            StringsKt.clear((StringBuilder)this.capturedLogsForCompleteTrace);
            handled = true;
            StringsKt.clear((StringBuilder)this.capturedLogsForPartialTrace);
            this.inLastFrameOfPartialTrace = false;
        }
        return handled;
    }

    private final String convertPartialToCompleteTrace(StringBuilder leaktrace) {
        boolean isBytesAvailable = StringsKt.contains$default((CharSequence)leaktrace, (CharSequence)this.bytesRetainedText, (boolean)false, (int)2, null);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String string = leaktrace.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hashBytes = digest.digest(byArray);
        Intrinsics.checkNotNull((Object)hashBytes);
        String hashedSignature = ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, LeakCanaryLogcatCommandHandler::convertPartialToCompleteTrace$lambda$0, (int)30, null);
        return StringsKt.trimIndent((String)("====================================\nHEAP ANALYSIS RESULT\n====================================\n1 APPLICATION LEAKS\n\nReferences underlined with \"~~~\" are likely causes.\nLearn more at https://squ.re/leaks.\n" + (String)(!isBytesAvailable ? "\n0 bytes retained by leaking objects\nSignature: " + hashedSignature + "\n\u252c\u2500\u2500\u2500" : "") + "\n" + leaktrace + "\n====================================\n0 LIBRARY LEAKS\n\nA Library Leak is a leak caused by a known bug in 3rd party code that you do not have control over.\nSee https://square.github.io/leakcanary/fundamentals-how-leakcanary-works/#4-categorizing-leaks\n====================================\n0 UNREACHABLE OBJECTS\n\nAn unreachable object is still in memory but LeakCanary could not find a strong reference path\nfrom GC roots.\n====================================\nMETADATA\n\nPlease include this in bug reports and Stack Overflow questions.\nAnalysis duration: -1 ms\nHeap dump file path: -\nHeap dump timestamp: 0\nHeap dump duration: Unknown\n===================================="));
    }

    private final void detectAndHandlePartialLeakTraces(LogcatMessage logcatMessage) {
        String gcRootText = "GC Root";
        String lastFramePattern = "\u2570\u2192";
        String initialTabSpace = "  ";
        if (Intrinsics.areEqual((Object)logcatMessage.getHeader().getTag(), (Object)LEAKCANARY_TAG)) {
            this.prevLogTimeStampOfPartialTrace = logcatMessage.getHeader().getTimestamp().getEpochSecond();
            String[] stringArray = new String[]{"\n"};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)logcatMessage.getMessage(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                if (this.inLastFrameOfPartialTrace && !StringsKt.contains$default((CharSequence)line, (CharSequence)initialTabSpace, (boolean)false, (int)2, null)) {
                    this.sendLeakCanaryAnalysisEvent(this.convertPartialToCompleteTrace(this.capturedLogsForPartialTrace));
                    StringsKt.clear((StringBuilder)this.capturedLogsForPartialTrace);
                    this.inLastFrameOfPartialTrace = false;
                }
                if (((CharSequence)this.capturedLogsForPartialTrace).length() > 0) {
                    this.capturedLogsForPartialTrace.append(line).append('\n');
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)lastFramePattern, (boolean)false, (int)2, null)) {
                        this.inLastFrameOfPartialTrace = true;
                    }
                }
                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)this.bytesRetainedText, (boolean)false, (int)2, null) && (!StringsKt.contains$default((CharSequence)line, (CharSequence)gcRootText, (boolean)false, (int)2, null) || !(((CharSequence)this.capturedLogsForPartialTrace).length() == 0))) continue;
                StringsKt.clear((StringBuilder)this.capturedLogsForPartialTrace);
                this.inLastFrameOfPartialTrace = false;
                this.capturedLogsForPartialTrace.append(line).append('\n');
            }
        } else if (this.inLastFrameOfPartialTrace && logcatMessage.getHeader().getTimestamp().getEpochSecond() - this.prevLogTimeStampOfPartialTrace >= this.TWO_SECONDS) {
            this.sendLeakCanaryAnalysisEvent(this.convertPartialToCompleteTrace(this.capturedLogsForPartialTrace));
            StringsKt.clear((StringBuilder)this.capturedLogsForPartialTrace);
            this.inLastFrameOfPartialTrace = false;
        }
    }

    private final boolean detectAndHandleHostAnalysisTrigger(LogcatMessage logcatMessage) {
        String HOST_ANALYSIS_TRIGGER_STRING = "The heap dump will be collected and analyzed by the Android Studio";
        if (Intrinsics.areEqual((Object)LEAKCANARY_TAG, (Object)logcatMessage.getHeader().getTag()) && StringsKt.contains$default((CharSequence)logcatMessage.getMessage(), (CharSequence)HOST_ANALYSIS_TRIGGER_STRING, (boolean)false, (int)2, null)) {
            this.logger.info("Host analysis trigger detected.");
            this.eventQueue.offer(Common.Event.newBuilder().setGroupId((long)this.pid).setPid(this.pid).setKind(Common.Event.Kind.LEAKCANARY_HOST_ANALYSIS_TRIGGER).setTimestamp(this.getCurrentTimestampInNs()).build());
            return true;
        }
        return false;
    }

    private static final CharSequence convertPartialToCompleteTrace$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final /* synthetic */ Logger access$getLogger$p(LeakCanaryLogcatCommandHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ IDevice access$getDevice$p(LeakCanaryLogcatCommandHandler $this) {
        return $this.device;
    }

    public static final /* synthetic */ boolean access$detectAndHandleObjectRetainedAndAnalysis(LeakCanaryLogcatCommandHandler $this, LogcatMessage logcatMessage) {
        return $this.detectAndHandleObjectRetainedAndAnalysis(logcatMessage);
    }

    public static final /* synthetic */ boolean access$detectAndHandleCompleteLeakTraces(LeakCanaryLogcatCommandHandler $this, LogcatMessage logcatMessage) {
        return $this.detectAndHandleCompleteLeakTraces(logcatMessage);
    }

    public static final /* synthetic */ boolean access$detectAndHandleHostAnalysisTrigger(LeakCanaryLogcatCommandHandler $this, LogcatMessage logcatMessage) {
        return $this.detectAndHandleHostAnalysisTrigger(logcatMessage);
    }

    public static final /* synthetic */ void access$detectAndHandlePartialLeakTraces(LeakCanaryLogcatCommandHandler $this, LogcatMessage logcatMessage) {
        $this.detectAndHandlePartialLeakTraces(logcatMessage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/profilers/commands/LeakCanaryLogcatCommandHandler$Companion;", "", "<init>", "()V", "LEAKCANARY_TAG", "", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Commands.Command.CommandType.values().length];
            try {
                nArray[Commands.Command.CommandType.START_LOGCAT_TRACKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Commands.Command.CommandType.STOP_LOGCAT_TRACKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

