/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.adtui.stdui.ResizableImage;
import com.android.tools.idea.profilers.IntellijExportDialog;
import com.android.tools.idea.profilers.IntellijImportDialog;
import com.android.tools.idea.profilers.IntellijUiMessageHandler;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigurationsDialog;
import com.android.tools.inspectors.common.api.ide.IntellijContextMenuInstaller;
import com.android.tools.inspectors.common.api.ide.stacktrace.IntelliJStackTraceGroup;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.inspectors.common.ui.stacktrace.StackTraceGroup;
import com.android.tools.profilers.ExportDialog;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ImportDialog;
import com.android.tools.profilers.UiMessageHandler;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.config.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerComponents
implements IdeProfilerComponents {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myParentDisposable;
    @NotNull
    private final FeatureTracker myFeatureTracker;

    public IntellijProfilerComponents(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull FeatureTracker featureTracker) {
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
        this.myFeatureTracker = featureTracker;
    }

    @NotNull
    public LoadingPanel createLoadingPanel(final int delayMs) {
        return new LoadingPanel(){
            private final JBLoadingPanel myLoadingPanel;
            {
                this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)IntellijProfilerComponents.this.myProject, delayMs);
            }

            @NotNull
            public JComponent getComponent() {
                return this.myLoadingPanel;
            }

            public void setChildComponent(@Nullable Component comp) {
                this.myLoadingPanel.getContentPanel().removeAll();
                if (comp != null) {
                    this.myLoadingPanel.add(comp);
                }
            }

            public void setLoadingText(@NotNull String loadingText) {
                this.myLoadingPanel.setLoadingText(loadingText);
            }

            public void startLoading() {
                this.myLoadingPanel.startLoading();
            }

            public void stopLoading() {
                this.myLoadingPanel.stopLoading();
            }
        };
    }

    @NotNull
    public StackTraceGroup createStackGroup() {
        return new IntelliJStackTraceGroup(this.myProject, this.myParentDisposable);
    }

    @NotNull
    public ContextMenuInstaller createContextMenuInstaller() {
        return new IntellijContextMenuInstaller();
    }

    @NotNull
    public ExportDialog createExportDialog() {
        return new IntellijExportDialog(this.myProject);
    }

    @NotNull
    public ImportDialog createImportDialog() {
        return new IntellijImportDialog(this.myProject);
    }

    @NotNull
    public JComponent createResizableImageComponent(@NotNull BufferedImage image) {
        return new ResizableImage(image);
    }

    @NotNull
    public UiMessageHandler createUiMessageHandler() {
        return new IntellijUiMessageHandler();
    }

    public void openCpuProfilingConfigurationsDialog(@NotNull CpuProfilerConfigModel model, int deviceLevel, @NotNull Consumer<ProfilingConfiguration> dialogCallback, @NotNull IdeProfilerServices ideProfilerServices) {
        CpuProfilingConfigurationsDialog dialog2 = new CpuProfilingConfigurationsDialog(this.myProject, deviceLevel, model, dialogCallback, this.myFeatureTracker, ideProfilerServices);
        dialog2.show();
    }

    public void openTaskConfigurationsDialog(@NotNull CpuProfilerConfigModel model, @NotNull IdeProfilerServices ideProfilerServices) {
        model.setProfilingConfiguration((ProfilingConfiguration)new UnspecifiedConfiguration(""));
        this.openCpuProfilingConfigurationsDialog(model, 0, x -> {}, ideProfilerServices);
    }
}

