/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.BatchInvoker;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.Receiver;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListenerManager {
    private final List<ListenerPairing> myListeners = new ArrayList<ListenerPairing>();
    private final Map<Receiver<?>, InvalidationListener> myReceiverMapping = Maps.newHashMap();
    private final List<CompositeListener> myCompositeListeners = Lists.newArrayListWithExpectedSize((int)0);
    private final BatchInvoker myInvoker;

    public ListenerManager() {
        this.myInvoker = new BatchInvoker();
    }

    public ListenerManager(@NotNull BatchInvoker.Strategy invokeStrategy) {
        this.myInvoker = new BatchInvoker(invokeStrategy);
    }

    public void listen(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener2) {
        this.myListeners.add(new ListenerPairing(src, listener2));
    }

    public <T> void listen(@NotNull ObservableValue<T> src, @NotNull Receiver<T> receiver2) {
        InvalidationListener listenerWrapper = () -> receiver2.receive(src.get());
        this.myReceiverMapping.put(receiver2, listenerWrapper);
        this.listen(src, listenerWrapper);
    }

    public void listenAndFire(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener2) {
        this.listen(src, listener2);
        listener2.onInvalidated();
    }

    public <T> void listenAndFire(@NotNull ObservableValue<T> src, @NotNull Receiver<T> receiver2) {
        this.listen(src, receiver2);
        receiver2.receive(src.get());
    }

    @NotNull
    public CompositeListener listenAll(ObservableValue<?> ... values) {
        CompositeListener listener2 = new CompositeListener(values);
        this.myCompositeListeners.add(listener2);
        return listener2;
    }

    @NotNull
    public CompositeListener listenAll(@NotNull Collection<? extends ObservableValue<?>> values) {
        return this.listenAll((ObservableValue[])Iterables.toArray(values, ObservableValue.class));
    }

    public void release(@NotNull InvalidationListener listener2) {
        Iterator<ListenerPairing> i = this.myListeners.iterator();
        while (i.hasNext()) {
            ListenerPairing listenerPairing = i.next();
            if (listenerPairing.myListener != listener2) continue;
            listenerPairing.dispose();
            i.remove();
        }
    }

    public void release(@NotNull Receiver<?> receiver2) {
        InvalidationListener listenerWrapper = this.myReceiverMapping.get(receiver2);
        if (listenerWrapper == null) {
            return;
        }
        this.release(listenerWrapper);
    }

    public void release(@NotNull ObservableValue<?> observable2) {
        Iterator<ListenerPairing> i = this.myListeners.iterator();
        while (i.hasNext()) {
            ListenerPairing listenerPairing = i.next();
            if (listenerPairing.myObservable != observable2) continue;
            listenerPairing.dispose();
            i.remove();
        }
    }

    public void release(@NotNull Runnable listenAllRunnable) {
        Iterator<CompositeListener> iterator2 = this.myCompositeListeners.iterator();
        while (iterator2.hasNext()) {
            CompositeListener listener2 = iterator2.next();
            if (!listener2.ownsRunnable(listenAllRunnable)) continue;
            listener2.dispose();
            iterator2.remove();
        }
    }

    public void releaseAll() {
        for (ListenerPairing listenerPairing : this.myListeners) {
            listenerPairing.dispose();
        }
        this.myListeners.clear();
        for (CompositeListener compositeListener : this.myCompositeListeners) {
            compositeListener.dispose();
        }
        this.myCompositeListeners.clear();
    }

    private static class ListenerPairing {
        private final ObservableValue<?> myObservable;
        private final InvalidationListener myListener;

        public ListenerPairing(ObservableValue<?> src, InvalidationListener listener2) {
            this.myObservable = src;
            this.myListener = listener2;
            src.addListener(listener2);
        }

        public void dispose() {
            this.myObservable.removeListener(this.myListener);
        }
    }

    public final class CompositeListener
    implements InvalidationListener,
    Runnable {
        @NotNull
        private final ObservableValue<?>[] myValues;
        @Nullable
        private Runnable myOnAnyInvalidated;

        public CompositeListener(ObservableValue<?> ... values) {
            for (ObservableValue<?> value2 : this.myValues = values) {
                value2.addListener(this);
            }
        }

        public void dispose() {
            for (ObservableValue<?> value2 : this.myValues) {
                value2.removeListener(this);
            }
        }

        public void with(@NotNull Runnable onAnyInvalidated) {
            this.myOnAnyInvalidated = onAnyInvalidated;
        }

        public void withAndFire(@NotNull Runnable onAnyInvalidated) {
            this.with(onAnyInvalidated);
            this.run();
        }

        boolean ownsRunnable(@NotNull Runnable onAnyInvalidated) {
            return onAnyInvalidated.equals(this.myOnAnyInvalidated);
        }

        @Override
        public void onInvalidated() {
            ListenerManager.this.myInvoker.enqueue(this);
        }

        @Override
        public void run() {
            if (this.myOnAnyInvalidated != null) {
                this.myOnAnyInvalidated.run();
            }
        }
    }
}

