/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module.recipes.baselineProfilesModule.src;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"baselineProfileBenchmarksJava", "", "newModuleName", "className", "packageName", "targetPackageName", "useInstrumentationArgumentForAppId", "", "intellij.android.newProjectWizard"})
public final class BaselineProfileBenchmarksJavaKt {
    @NotNull
    public static final String baselineProfileBenchmarksJava(@NotNull String newModuleName, @NotNull String className, @NotNull String packageName, @NotNull String targetPackageName, boolean useInstrumentationArgumentForAppId) {
        Intrinsics.checkNotNullParameter((Object)newModuleName, (String)"newModuleName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        return "package " + packageName + ";\n\nimport androidx.benchmark.macro.BaselineProfileMode;\nimport androidx.benchmark.macro.CompilationMode;\nimport androidx.benchmark.macro.StartupMode;\nimport androidx.benchmark.macro.StartupTimingMetric;\nimport androidx.benchmark.macro.junit4.MacrobenchmarkRule;\nimport androidx.test.ext.junit.runners.AndroidJUnit4;\nimport androidx.test.filters.LargeTest;\n" + (useInstrumentationArgumentForAppId ? "import androidx.test.platform.app.InstrumentationRegistry;" : "") + "\nimport kotlin.Unit;\nimport org.junit.Rule;\nimport org.junit.Test;\nimport org.junit.runner.RunWith;\n\nimport java.util.Collections;\n\n/**\n * This test class benchmarks the speed of app startup.\n * Run this benchmark to verify how effective a Baseline Profile is.\n * It does this by comparing {@code CompilationMode.None}, which represents the app with no Baseline\n * Profiles optimizations, and {@code CompilationMode.Partial}, which uses Baseline Profiles.\n * <p>\n * Run this benchmark to see startup measurements and captured system traces for verifying\n * the effectiveness of your Baseline Profiles. You can run it directly from Android\n * Studio as an instrumentation test, or run all benchmarks for a variant, for example benchmarkRelease,\n * with this Gradle task:\n * <pre>\n * ./gradlew :" + newModuleName + ":connectedBenchmarkReleaseAndroidTest\n * </pre>\n * <p>\n * You should run the benchmarks on a physical device, not an Android emulator, because the\n * emulator doesn't represent real world performance and shares system resources with its host.\n * <p>\n * For more information, see the <a href=\"https://d.android.com/macrobenchmark#create-macrobenchmark\">Macrobenchmark documentation</a>\n * and the <a href=\"https://d.android.com/topic/performance/benchmarking/macrobenchmark-instrumentation-args\">instrumentation arguments documentation</a>.\n **/\n@RunWith(AndroidJUnit4.class)\n@LargeTest\npublic class " + className + " {\n\n    @Rule\n    public MacrobenchmarkRule rule = new MacrobenchmarkRule();\n\n    @Test\n    public void startupCompilationNone() {\n        benchmark(new CompilationMode.None());\n    }\n\n    @Test\n    public void startupCompilationBaselineProfiles() {\n        benchmark(new CompilationMode.Partial(BaselineProfileMode.Require));\n    }\n\n    private void benchmark(CompilationMode compilationMode) {\n        " + (String)(useInstrumentationArgumentForAppId ? "// The application id for the running build variant is read from the instrumentation arguments.\nString targetAppId = InstrumentationRegistry.getArguments().getString(\"targetAppId\");\nif (targetAppId == null) {\n    throw new RuntimeException(\"targetAppId not passed as instrumentation runner arg\");\n}" : "// This example works only with the variant with application id `" + targetPackageName + "`.") + "\n        rule.measureRepeated(\n            " + (String)(useInstrumentationArgumentForAppId ? "targetAppId" : "\"" + targetPackageName + "\"") + ",\n            Collections.singletonList(new StartupTimingMetric()),\n            compilationMode,\n            StartupMode.COLD,\n            10,\n            setupScope -> {\n                setupScope.pressHome();\n                return Unit.INSTANCE;\n            },\n            measureScope -> {\n                measureScope.startActivityAndWait();\n\n                // TODO Add interactions to wait for when your app is fully drawn.\n                // The app is fully drawn when Activity.reportFullyDrawn is called.\n                // For Jetpack Compose, you can use ReportDrawn, ReportDrawnWhen and ReportDrawnAfter\n                // from the AndroidX Activity library.\n\n                // Check the UiAutomator documentation for more information on how to\n                // interact with the app.\n                // https://d.android.com/training/testing/other-components/ui-automator\n                return Unit.INSTANCE;\n            }\n        );\n    }\n}\n\n";
    }
}

