/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactorUtilKt;
import com.android.tools.idea.npw.NpwUiUtilsKt;
import com.android.tools.idea.npw.model.NewAndroidModuleModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStepKt;
import com.android.tools.idea.npw.module.ConfigureModuleStep;
import com.android.tools.idea.npw.module.ModuleModel;
import com.android.tools.idea.npw.template.ChooseActivityTypeStep;
import com.android.tools.idea.npw.template.components.BytecodeLevelComboProvider;
import com.android.tools.idea.npw.validator.ProjectNameValidator;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.template.BytecodeLevel;
import com.android.tools.idea.wizard.template.FormFactor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/npw/module/ConfigureAndroidModuleStep;", "Lcom/android/tools/idea/npw/module/ConfigureModuleStep;", "Lcom/android/tools/idea/npw/model/NewAndroidModuleModel;", "model", "minSdkLevel", "", "basePackage", "", "title", "<init>", "(Lcom/android/tools/idea/npw/model/NewAndroidModuleModel;ILjava/lang/String;Ljava/lang/String;)V", "appName", "Ljavax/swing/JTextField;", "bytecodeCombo", "Ljavax/swing/JComboBox;", "Lcom/android/tools/idea/wizard/template/BytecodeLevel;", "createMainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createDependentSteps", "", "Lcom/android/tools/idea/wizard/model/ModelWizardStep;", "getPreferredFocusComponent", "Ljavax/swing/JComponent;", "intellij.android.newProjectWizard"})
@StabilityInferred(parameters=0)
public final class ConfigureAndroidModuleStep
extends ConfigureModuleStep<NewAndroidModuleModel> {
    @NotNull
    private final JTextField appName;
    @NotNull
    private final JComboBox<BytecodeLevel> bytecodeCombo;
    public static final int $stable = 8;

    public ConfigureAndroidModuleStep(@NotNull NewAndroidModuleModel model, int minSdkLevel, @Nullable String basePackage, @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        ModuleModel moduleModel = model;
        Object t = model.getFormFactor().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        super(moduleModel, FormFactorUtilKt.toWizardFormFactor((FormFactor)t), minSdkLevel, basePackage, title2, null, 32, null);
        this.appName = (JTextField)new JBTextField((String)model.getApplicationName().get());
        this.bytecodeCombo = (JComboBox)new BytecodeLevelComboProvider().createComponent();
        this.getBindings().bindTwoWay(new TextProperty(this.appName), model.getApplicationName());
        this.getBindings().bindTwoWay(new SelectedItemProperty(this.bytecodeCombo), (SettableValue)model.getBytecodeLevel());
        this.getValidatorPanel().registerValidator((ObservableValue)model.getApplicationName(), (Validator)new ProjectNameValidator(), new ObservableValue[0]);
    }

    @NotNull
    public DialogPanel createMainPanel() {
        JBPanel jBPanel = BuilderKt.panel(arg_0 -> ConfigureAndroidModuleStep.createMainPanel$lambda$0(this, arg_0)).withBorder(JBUI.Borders.empty((int)6));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        return (DialogPanel)jBPanel;
    }

    @Override
    @NotNull
    protected Collection<ModelWizardStep<?>> createDependentSteps() {
        Collection<ModelWizardStep<?>> commonSteps = super.createDependentSteps();
        Object m = this.getModel();
        Intrinsics.checkNotNullExpressionValue(m, (String)"getModel(...)");
        NewAndroidModuleModel newAndroidModuleModel = (NewAndroidModuleModel)m;
        Object[] objectArray = new Object[]{this.getFormFactor().getId()};
        String string = AndroidBundle.message("android.wizard.activity.add", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        RenderTemplateModel renderModel = RenderTemplateModel.Companion.fromModuleModel(newAndroidModuleModel, string);
        ChooseActivityTypeStep chooseActivityStep = ChooseActivityTypeStep.Factory.forNewModule(renderModel, this.getFormFactor(), ((NewAndroidModuleModel)this.getModel()).getAndroidSdkInfo());
        chooseActivityStep.setShouldShow(!((NewAndroidModuleModel)this.getModel()).isLibrary());
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)chooseActivityStep), (Iterable)commonSteps);
    }

    @Override
    @NotNull
    protected JComponent getPreferredFocusComponent() {
        return this.appName.isVisible() ? (JComponent)this.appName : (JComponent)this.getModuleName();
    }

    private static final Unit createMainPanel$lambda$0(ConfigureAndroidModuleStep this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        if (!((NewAndroidModuleModel)this$0.getModel()).isLibrary()) {
            $this$panel.row("Application name", arg_0 -> ConfigureAndroidModuleStep.createMainPanel$lambda$0$0(this$0, arg_0));
        }
        String string = AndroidBundle.message("android.wizard.module.help.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(NpwUiUtilsKt.contextLabel("Module name", string), arg_0 -> ConfigureAndroidModuleStep.createMainPanel$lambda$0$1(this$0, arg_0));
        $this$panel.row("Package name", arg_0 -> ConfigureAndroidModuleStep.createMainPanel$lambda$0$2(this$0, arg_0));
        $this$panel.row("Language", arg_0 -> ConfigureAndroidModuleStep.createMainPanel$lambda$0$3(this$0, arg_0));
        $this$panel.row("Minimum SDK", arg_0 -> ConfigureAndroidModuleStep.createMainPanel$lambda$0$4(this$0, arg_0));
        if (((Boolean)StudioFlags.NPW_SHOW_KTS_GRADLE_COMBO_BOX.get()).booleanValue()) {
            ConfigureAndroidModuleStepKt.generateBuildConfigurationLanguageRow($this$panel, this$0.getBuildConfigurationLanguageCombo());
        }
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$0(ConfigureAndroidModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.appName).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$1(ConfigureAndroidModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getModuleName()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$2(ConfigureAndroidModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getPackageName()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$3(ConfigureAndroidModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getLanguageCombo()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$4(ConfigureAndroidModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getApiLevelCombo()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }
}

