/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.dynamicapp.DeviceFeatureModel;
import com.android.tools.idea.npw.dynamicapp.ModuleDownloadDeviceFeature;
import com.android.tools.idea.npw.dynamicapp.ModuleDownloadDeviceFeatureListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.collections.ObservableList;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.expressions.bool.AndExpression;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ModuleDownloadConditions {
    private static final String myLinkUrl = "org.jetbrains.android.r/studio-ui/dynamic-delivery/conditional-delivery";
    public JPanel myRootPanel;
    private JPanel myDeviceFeaturesContainer;
    private LinkLabel<Void> myAddDeviceFeatureLinkLabel;
    private HyperlinkLabel myFeatureHelpLink;
    private ObservableList<DeviceFeatureModel> myModel;
    private ObservableValue<Boolean> myIsPanelActive;
    private Project myProject;
    private ValidatorPanel myValidatorPanel;

    public ModuleDownloadConditions() {
        this.setupUI();
        this.myDeviceFeaturesContainer.setLayout(new BoxLayout(this.myDeviceFeaturesContainer, 1));
        this.myAddDeviceFeatureLinkLabel.setIcon(null);
        this.myAddDeviceFeatureLinkLabel.setName("ModuleDownloadConditions.myAddDeviceFeatureLinkLabel");
        this.myDeviceFeaturesContainer.setName("ModuleDownloadConditions.myDeviceFeaturesContainer");
        this.myAddDeviceFeatureLinkLabel.setListener((LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel aSource, Void aLinkData) {
                ModuleDownloadConditions.this.addDeviceFeatureRow();
            }
        }, null);
        this.myFeatureHelpLink.setHyperlinkTarget(myLinkUrl);
        this.myFeatureHelpLink.setHtmlText("<html><a>Learn more</a> about supported conditions, such as device features and user country</html>");
    }

    public void init(@NotNull Project project, @NotNull ValidatorPanel validatorPanel2, @NotNull ObservableValue<Boolean> isPanelActive) {
        this.myProject = project;
        this.myValidatorPanel = validatorPanel2;
        this.myIsPanelActive = isPanelActive;
    }

    public void setModel(@NotNull ObservableList<DeviceFeatureModel> model) {
        this.myModel = model;
    }

    private void addDeviceFeatureRow() {
        if (this.myModel != null) {
            final DeviceFeatureModel deviceFeature = new DeviceFeatureModel();
            this.myModel.add(deviceFeature);
            final BoolValueProperty isFeatureActive = new BoolValueProperty(true);
            AndExpression isFeatureActiveExpression = new AndExpression((ObservableValue<Boolean>)isFeatureActive, this.myIsPanelActive);
            ModuleDownloadDeviceFeature deviceFeatureForm = new ModuleDownloadDeviceFeature(this.myProject, deviceFeature, isFeatureActiveExpression, this.myValidatorPanel);
            deviceFeatureForm.addListener(new ModuleDownloadDeviceFeatureListener(){

                @Override
                public void removeFeatureInvoked() {
                    isFeatureActive.set(false);
                    deviceFeature.deviceFeatureValue.clear();
                    ModuleDownloadConditions.this.removeDeviceFeatureRow(deviceFeature);
                }
            });
            this.myDeviceFeaturesContainer.add((Component)deviceFeatureForm.getComponent(), -1);
            this.myDeviceFeaturesContainer.revalidate();
            this.myDeviceFeaturesContainer.repaint();
        }
    }

    private void removeDeviceFeatureRow(@NotNull DeviceFeatureModel deviceFeatureModel) {
        int rowIndex = this.myModel.indexOf(deviceFeatureModel);
        if (rowIndex < 0) {
            return;
        }
        this.myModel.remove(rowIndex);
        this.myDeviceFeaturesContainer.remove(rowIndex);
        this.myDeviceFeaturesContainer.revalidate();
        this.myDeviceFeaturesContainer.repaint();
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.myDeviceFeaturesContainer = new JPanel();
        this.myDeviceFeaturesContainer.setLayout(new GridBagLayout());
        this.myRootPanel.add((Component)this.myDeviceFeaturesContainer, new GridConstraints(0, 0, 1, 4, 0, 3, 5, 3, null, null, null, 0, false));
        this.myAddDeviceFeatureLinkLabel = new LinkLabel();
        this.myAddDeviceFeatureLinkLabel.setText("+ device-feature");
        this.myRootPanel.add((Component)this.myAddDeviceFeatureLinkLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myRootPanel.add((Component)spacer1, new GridConstraints(4, 0, 1, 3, 0, 2, 1, 4, null, null, null, 0, false));
        this.myFeatureHelpLink = new HyperlinkLabel();
        this.myFeatureHelpLink.setText("");
        this.myRootPanel.add((Component)this.myFeatureHelpLink, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRootPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 16), null, 0, false));
    }

    public JComponent getRootComponent() {
        return this.myRootPanel;
    }
}

