/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.benchmark;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.adtui.device.FormFactor;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.NpwUiUtilsKt;
import com.android.tools.idea.npw.benchmark.BenchmarkModuleType;
import com.android.tools.idea.npw.benchmark.NewBenchmarkModuleModel;
import com.android.tools.idea.npw.model.AgpVersionSelector;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.module.AndroidApiLevelComboBox;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStepKt;
import com.android.tools.idea.npw.module.ConfigureModuleStep;
import com.android.tools.idea.npw.module.ModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.template.components.ModuleComboProvider;
import com.android.tools.idea.npw.validator.ModuleSelectedValidator;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u0017\u001a\u00020\u0016*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/npw/benchmark/ConfigureBenchmarkModuleStep;", "Lcom/android/tools/idea/npw/module/ConfigureModuleStep;", "Lcom/android/tools/idea/npw/benchmark/NewBenchmarkModuleModel;", "model", "<init>", "(Lcom/android/tools/idea/npw/benchmark/NewBenchmarkModuleModel;)V", "microbenchmarkRadioButton", "Ljavax/swing/JRadioButton;", "macrobenchmarkRadioButton", "benchmarkModuleType", "Lcom/android/tools/idea/observable/ui/SelectedRadioButtonProperty;", "Lcom/android/tools/idea/npw/benchmark/BenchmarkModuleType;", "targetModuleRow", "Lcom/intellij/ui/dsl/builder/Row;", "targetModuleCombo", "Ljavax/swing/JComboBox;", "Lcom/intellij/openapi/module/Module;", "createMainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPreferredFocusComponent", "Ljavax/swing/JTextField;", "onEntering", "", "selectAtLeastMinApiLevel", "Lcom/android/tools/idea/npw/module/AndroidApiLevelComboBox;", "minApiLevel", "", "intellij.android.newProjectWizard"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nConfigureBenchmarkModuleStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureBenchmarkModuleStep.kt\ncom/android/tools/idea/npw/benchmark/ConfigureBenchmarkModuleStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1869#2,2:196\n295#2,2:198\n1#3:200\n*S KotlinDebug\n*F\n+ 1 ConfigureBenchmarkModuleStep.kt\ncom/android/tools/idea/npw/benchmark/ConfigureBenchmarkModuleStep\n*L\n76#1:196,2\n190#1:198,2\n*E\n"})
public final class ConfigureBenchmarkModuleStep
extends ConfigureModuleStep<NewBenchmarkModuleModel> {
    @NotNull
    private final JRadioButton microbenchmarkRadioButton;
    @NotNull
    private final JRadioButton macrobenchmarkRadioButton;
    @NotNull
    private final SelectedRadioButtonProperty<BenchmarkModuleType> benchmarkModuleType;
    @Nullable
    private Row targetModuleRow;
    @NotNull
    private final JComboBox<Module> targetModuleCombo;
    public static final int $stable = 8;

    public ConfigureBenchmarkModuleStep(@NotNull NewBenchmarkModuleModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        ModuleModel moduleModel = model;
        String string = NewProjectModel.Companion.getSuggestedProjectPackage();
        String string2 = AndroidBundle.message("android.wizard.module.new.benchmark.module.app", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(moduleModel, FormFactor.MOBILE, 16, string, string2, null, 32, null);
        this.microbenchmarkRadioButton = new JRadioButton(BenchmarkModuleType.MICROBENCHMARK.getTitle());
        this.macrobenchmarkRadioButton = new JRadioButton(BenchmarkModuleType.MACROBENCHMARK.getTitle());
        JRadioButton[] jRadioButtonArray = new JRadioButton[]{this.macrobenchmarkRadioButton, this.microbenchmarkRadioButton};
        this.benchmarkModuleType = new SelectedRadioButtonProperty<BenchmarkModuleType>(BenchmarkModuleType.MACROBENCHMARK, BenchmarkModuleType.values(), jRadioButtonArray);
        this.targetModuleCombo = (JComboBox)new ModuleComboProvider().createComponent();
        List<Module> list2 = AndroidProjectInfo.getInstance(model.getProject()).getAllModulesOfProjectType(0);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllModulesOfProjectType(...)");
        List<Module> appModules = list2;
        ObservableValue[] $this$forEach$iv = (ObservableValue[])appModules;
        boolean $i$f$forEach232 = false;
        for (Object t : $this$forEach$iv) {
            Module it = (Module)t;
            boolean bl = false;
            this.targetModuleCombo.addItem(it);
        }
        if (!((Collection)appModules).isEmpty()) {
            model.getTargetModule().setValue((Module)CollectionsKt.first(appModules));
        }
        this.getBindings().bindTwoWay(this.benchmarkModuleType, model.getBenchmarkModuleType());
        this.getListeners().listenAndFire((ObservableValue)model.getBenchmarkModuleType(), () -> ConfigureBenchmarkModuleStep._init_$lambda$1(this, model));
        $this$forEach$iv = new ObservableValue[]{model.getBenchmarkModuleType()};
        this.getValidatorPanel().registerValidator((ObservableValue)model.getAndroidSdkInfo(), ValidatorKt.createValidator(arg_0 -> ConfigureBenchmarkModuleStep._init_$lambda$2(model, arg_0)), $this$forEach$iv);
        this.getBindings().bindTwoWay(new SelectedItemProperty(this.targetModuleCombo), (SettableValue)model.getTargetModule());
        ModuleSelectedValidator targetModuleValidator = new ModuleSelectedValidator();
        ObservableValue[] $i$f$forEach232 = new ObservableValue[]{model.getBenchmarkModuleType()};
        this.getValidatorPanel().registerValidator((ObservableValue)model.getTargetModule(), ValidatorKt.createValidator(arg_0 -> ConfigureBenchmarkModuleStep._init_$lambda$3(model, targetModuleValidator, arg_0)), $i$f$forEach232);
        AgpVersion minAgpVersion = AgpVersion.Companion.parse("7.0.0");
        ObservableValue[] observableValueArray = new ObservableValue[]{model.getBenchmarkModuleType()};
        this.getValidatorPanel().registerValidator((ObservableValue)model.getAgpVersionSelector(), ValidatorKt.createValidator(arg_0 -> ConfigureBenchmarkModuleStep._init_$lambda$4(model, minAgpVersion, arg_0)), observableValueArray);
    }

    @NotNull
    public DialogPanel createMainPanel() {
        JBPanel jBPanel = BuilderKt.panel(arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0(this, arg_0)).withBorder(JBUI.Borders.empty((int)6));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        return (DialogPanel)jBPanel;
    }

    @Override
    @NotNull
    protected JTextField getPreferredFocusComponent() {
        return this.getModuleName();
    }

    @Override
    protected void onEntering() {
        super.onEntering();
        if (((NewBenchmarkModuleModel)this.getModel()).getBenchmarkModuleType().get() == BenchmarkModuleType.MACROBENCHMARK) {
            this.selectAtLeastMinApiLevel(this.getApiLevelCombo(), 23);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void selectAtLeastMinApiLevel(AndroidApiLevelComboBox $this$selectAtLeastMinApiLevel, int minApiLevel) {
        block3: {
            Object v1;
            block2: {
                void $this$firstOrNull$iv;
                Object currentItem = $this$selectAtLeastMinApiLevel.getSelectedItem();
                if (!(currentItem instanceof AndroidVersionsInfo.VersionItem) || ((AndroidVersionsInfo.VersionItem)currentItem).getMinApiLevel() >= minApiLevel) break block3;
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)$this$selectAtLeastMinApiLevel.getItemCount());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    Object e = $this$selectAtLeastMinApiLevel.getItemAt(it);
                    Intrinsics.checkNotNull(e);
                    if (!(((AndroidVersionsInfo.VersionItem)e).getMinApiLevel() == minApiLevel)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            Integer n = v1;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                $this$selectAtLeastMinApiLevel.setSelectedIndex(it);
            }
        }
    }

    private static final void _init_$lambda$1(ConfigureBenchmarkModuleStep this$0, NewBenchmarkModuleModel $model) {
        block0: {
            Row row = this$0.targetModuleRow;
            if (row == null) break block0;
            row.visible($model.getBenchmarkModuleType().get() == BenchmarkModuleType.MACROBENCHMARK);
        }
    }

    private static final Validator.Result _init_$lambda$2(NewBenchmarkModuleModel $model, Optional value2) {
        return $model.getBenchmarkModuleType().get() == BenchmarkModuleType.MACROBENCHMARK && value2.isPresent() && ((AndroidVersionsInfo.VersionItem)value2.get()).getMinApiLevel() < 23 ? Validator.Result.Companion.fromNullableMessage("Macrobenchmark requires minimum SDK >= 23") : Validator.Result.OK;
    }

    private static final Validator.Result _init_$lambda$3(NewBenchmarkModuleModel $model, ModuleSelectedValidator $targetModuleValidator, Optional value2) {
        Validator.Result result2;
        if ($model.getBenchmarkModuleType().get() == BenchmarkModuleType.MACROBENCHMARK) {
            Intrinsics.checkNotNull((Object)value2);
            result2 = $targetModuleValidator.validate(value2);
        } else {
            result2 = Validator.Result.OK;
        }
        return result2;
    }

    private static final Validator.Result _init_$lambda$4(NewBenchmarkModuleModel $model, AgpVersion $minAgpVersion, AgpVersionSelector versionSelector) {
        Validator.Result result2;
        if ($model.getBenchmarkModuleType().get() == BenchmarkModuleType.MACROBENCHMARK && !versionSelector.willSelectAtLeast($minAgpVersion)) {
            Object[] objectArray = new Object[]{"7.0.0"};
            result2 = Validator.Result.Companion.fromNullableMessage(AndroidBundle.message("android.wizard.validate.module.needs.new.agp.macro.benchmark", objectArray));
        } else {
            result2 = Validator.Result.OK;
        }
        return result2;
    }

    private static final Unit createMainPanel$lambda$0(ConfigureBenchmarkModuleStep this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0$0(this$0, arg_0), (int)3, null);
        String string = AndroidBundle.message("android.wizard.module.help.benchmark.target.module", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.targetModuleRow = $this$panel.row(NpwUiUtilsKt.contextLabel("Target application", string), arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0$1(this$0, arg_0)).visible(this$0.benchmarkModuleType.get() == BenchmarkModuleType.MACROBENCHMARK);
        String string2 = AndroidBundle.message("android.wizard.module.help.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(NpwUiUtilsKt.contextLabel("Module name", string2), arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0$2(this$0, arg_0));
        $this$panel.row("Package name", arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0$3(this$0, arg_0));
        $this$panel.row("Language", arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0$4(this$0, arg_0));
        $this$panel.row("Minimum SDK", arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0$5(this$0, arg_0));
        if (((Boolean)StudioFlags.NPW_SHOW_KTS_GRADLE_COMBO_BOX.get()).booleanValue()) {
            ConfigureAndroidModuleStepKt.generateBuildConfigurationLanguageRow($this$panel, this$0.getBuildConfigurationLanguageCombo());
        }
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$0(ConfigureBenchmarkModuleStep this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        String string = AndroidBundle.message("android.wizard.module.help.benchmark.module.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$buttonsGroup.row(NpwUiUtilsKt.contextLabel("Benchmark module type", string), arg_0 -> ConfigureBenchmarkModuleStep.createMainPanel$lambda$0$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$0$0(ConfigureBenchmarkModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.macrobenchmarkRadioButton);
        $this$row.cell((JComponent)this$0.microbenchmarkRadioButton);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$1(ConfigureBenchmarkModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.targetModuleCombo).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$2(ConfigureBenchmarkModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getModuleName()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$3(ConfigureBenchmarkModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getPackageName()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$4(ConfigureBenchmarkModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getLanguageCombo()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$0$5(ConfigureBenchmarkModuleStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getApiLevelCombo()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }
}

