/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.WorkerThread;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.common.WrappedFlowLayout;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureAdaptiveIconPanel;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconPanel;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureTvBannerPanel;
import com.android.tools.idea.npw.assetstudio.ui.PreviewIconsPanel;
import com.android.tools.idea.npw.assetstudio.wizard.IconGenerationProcessor;
import com.android.tools.idea.npw.assetstudio.wizard.ImagePreviewPanel;
import com.android.tools.idea.npw.assetstudio.wizard.LauncherIconsPreviewPanel;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.npw.assetstudio.wizard.TvBannerPreviewPanel;
import com.android.tools.idea.npw.assetstudio.wizard.TvChannelPreviewPanel;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.wizard.ui.CheckeredBackgroundPanel;
import com.android.tools.module.AndroidModuleInfo;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ui.AnimatedIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateImageAssetPanel
extends JPanel
implements Disposable,
PersistentStateComponent<PersistentState> {
    private static final String OUTPUT_ICON_TYPE_PROPERTY = "outputIconType";
    @NotNull
    private final AndroidModulePaths myDefaultPaths;
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myBindings = new BindingsManager();
    @NotNull
    private final ListenerManager myListeners = new ListenerManager();
    private final Map<AndroidIconType, PreviewIconsPanel> myOutputPreviewPanels;
    private final ObjectProperty<AndroidIconType> myOutputIconType;
    private final StringProperty myOutputName = new StringValueProperty();
    private JPanel myRootPanel;
    private JComboBox<AndroidIconType> myIconTypeCombo;
    private JPanel myConfigureIconPanels;
    private final Map<AndroidIconType, ConfigureIconView> myConfigureIconViews = new TreeMap<AndroidIconType, ConfigureIconView>();
    private CheckeredBackgroundPanel myOutputPreviewPanel;
    private TitledSeparator myOutputPreviewLabel;
    private JBScrollPane myOutputPreviewScrollPane;
    private JSplitPane mySplitPane;
    private JCheckBox myShowGrid;
    private JCheckBox myShowSafeZone;
    private JComboBox<Density> myPreviewResolutionComboBox;
    private JPanel myPreviewPanel;
    private JPanel myIconTypePanel;
    private JPanel myPreviewTitlePanel;
    private JPanel myPreviewContentsPanel;
    private JPanel myOutputIconTypePanel;
    private final SelectedProperty myShowGridProperty;
    private final SelectedProperty myShowSafeZoneProperty;
    private final AbstractProperty<Density> myPreviewDensityProperty;
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private AndroidModulePaths myPaths;
    @NotNull
    private final File myResFolder;
    @NotNull
    private final IconGenerationProcessor myIconGenerationProcessor = new IconGenerationProcessor();
    @NotNull
    private final StringProperty myPreviewRenderingError = new StringValueProperty();
    @NotNull
    private final IdeResourceNameValidator myNameValidator = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE);
    @NotNull
    private final CheckedDisposable myDisposable = Disposer.newCheckedDisposable();
    @NotNull
    private final OptionalValueProperty<Boolean> myIconExists = new OptionalValueProperty();
    @Nullable
    private Future<?> myCheckingExistingIconFilesFuture;

    public GenerateImageAssetPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet, @NotNull AndroidModulePaths defaultPaths, @NotNull File resFolder, AndroidIconType ... supportedTypes) {
        super(new BorderLayout());
        this.setupUI();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), panel2 -> new LoadingDecorator(this, (JComponent)panel2, this, -1){

            protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text2, AnimatedIcon icon) {
                NonOpaquePanel panel2 = super.customizeLoadingLayer(parent, text2, icon);
                panel2.setOpaque(true);
                return panel2;
            }
        });
        this.myLoadingPanel.add((Component)this.myOutputPreviewPanel);
        this.myOutputPreviewScrollPane.getViewport().setView((Component)this.myLoadingPanel);
        this.myLoadingPanel.setLoadingText("Rendering preview images...");
        this.myLoadingPanel.startLoading();
        this.myPaths = this.myDefaultPaths = defaultPaths;
        this.myResFolder = resFolder;
        if (supportedTypes.length == 0) {
            supportedTypes = AndroidIconType.values();
        }
        DefaultComboBoxModel<AndroidIconType> supportedTypesModel = new DefaultComboBoxModel<AndroidIconType>(supportedTypes);
        this.myIconTypeCombo.setModel(supportedTypesModel);
        this.myIconTypeCombo.setVisible(supportedTypes.length > 1);
        this.myOutputIconType = ObjectProperty.wrap(new SelectedItemProperty(this.myIconTypeCombo));
        this.myOutputPreviewPanel.setName("PreviewIconsPanel");
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel, true, "Conversion Issues", "Encountered Issues:");
        this.myPreviewResolutionComboBox.setRenderer((ListCellRenderer<Density>)SimpleListCellRenderer.create((String)"", Density::getResourceValue));
        DefaultComboBoxModel<Density> densitiesModel = new DefaultComboBoxModel<Density>();
        densitiesModel.addElement(Density.MEDIUM);
        densitiesModel.addElement(Density.HIGH);
        densitiesModel.addElement(Density.XHIGH);
        densitiesModel.addElement(Density.XXHIGH);
        densitiesModel.addElement(Density.XXXHIGH);
        this.myPreviewResolutionComboBox.setModel(densitiesModel);
        this.myPreviewDensityProperty = ObjectProperty.wrap(new SelectedItemProperty(this.myPreviewResolutionComboBox));
        this.myShowGridProperty = new SelectedProperty(this.myShowGrid);
        this.myShowSafeZoneProperty = new SelectedProperty(this.myShowSafeZone);
        AndroidModuleInfo androidModuleInfo = StudioAndroidModuleInfo.getInstance(facet);
        int minSdkVersion2 = androidModuleInfo.getMinSdkVersion().getApiLevel();
        assert (this.myConfigureIconPanels.getLayout() instanceof CardLayout);
        VirtualFile targetFile = GenerateImageAssetPanel.findConfigDir(resFolder.toPath());
        if (targetFile == null) {
            throw new IllegalArgumentException("Resource folder" + String.valueOf(resFolder) + " is outside of project source roots");
        }
        DrawableRenderer renderer2 = new DrawableRenderer(facet, targetFile);
        Disposer.register((Disposable)this, (Disposable)renderer2);
        for (AndroidIconType iconType : supportedTypes) {
            JPanel view = switch (iconType) {
                default -> throw new MatchException(null, null);
                case AndroidIconType.LAUNCHER -> new ConfigureAdaptiveIconPanel(this, facet, iconType, this.myShowGridProperty, this.myShowSafeZoneProperty, this.myPreviewDensityProperty, this.myValidatorPanel, renderer2, (Boolean)StudioFlags.ENABLE_MONOCHROME_ICON_EDITOR_TAB.get());
                case AndroidIconType.TV_CHANNEL -> new ConfigureAdaptiveIconPanel(this, facet, iconType, this.myShowGridProperty, this.myShowSafeZoneProperty, this.myPreviewDensityProperty, this.myValidatorPanel, renderer2, false);
                case AndroidIconType.LAUNCHER_LEGACY, AndroidIconType.ACTIONBAR, AndroidIconType.NOTIFICATION -> new ConfigureIconPanel(this, facet, iconType, minSdkVersion2, this.myValidatorPanel, renderer2);
                case AndroidIconType.TV_BANNER -> new ConfigureTvBannerPanel(this, facet, this.myValidatorPanel, renderer2);
            };
            this.myConfigureIconViews.put(iconType, (ConfigureIconView)((Object)view));
            this.myConfigureIconPanels.add((Component)view.getRootComponent(), iconType.toString());
        }
        ImmutableMap.Builder previewPanelBuilder = ImmutableMap.builder();
        previewPanelBuilder.put((Object)AndroidIconType.LAUNCHER, (Object)new LauncherIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.LAUNCHER_LEGACY, (Object)new LauncherLegacyIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.ACTIONBAR, (Object)new ActionBarIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.NOTIFICATION, (Object)new NotificationIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.TV_BANNER, (Object)new TvBannerPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.TV_CHANNEL, (Object)new TvChannelPreviewPanel());
        this.myOutputPreviewPanels = previewPanelBuilder.build();
        WrappedFlowLayout previewLayout = new WrappedFlowLayout(3);
        previewLayout.setAlignOnBaseline(true);
        this.myOutputPreviewPanel.setLayout((LayoutManager)previewLayout);
        this.myOutputPreviewScrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                GenerateImageAssetPanel.this.myOutputPreviewPanel.revalidate();
            }
        });
        this.mySplitPane.setDividerLocation(this.mySplitPane.getLeftComponent().getPreferredSize().width);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myValidatorPanel);
        Disposer.register((Disposable)this, (Disposable)this.myDisposable);
        this.add((Component)this.myValidatorPanel);
    }

    @Nullable
    private static VirtualFile findConfigDir(@NotNull Path dir) {
        do {
            VirtualFile virtualFile;
            if ((virtualFile = VfsUtil.findFile((Path)dir, (boolean)false)) == null) continue;
            return virtualFile;
        } while ((dir = dir.getParent()) != null);
        return null;
    }

    private void initializeListenersAndBindings() {
        ActionListener onAssetModified = actionEvent -> this.renderIconPreviews();
        for (ConfigureIconView view : this.myConfigureIconViews.values()) {
            view.addAssetListener(onAssetModified);
        }
        Runnable updatePreview = () -> {
            ConfigureIconView iconView = this.getActiveIconView();
            this.myBindings.bind(this.myOutputName, iconView.outputName());
            this.myOutputPreviewLabel.setText("Preview");
            this.renderIconPreviews();
        };
        this.myListeners.listenAndFire(this.myOutputIconType, iconType -> {
            ((CardLayout)this.myConfigureIconPanels.getLayout()).show(this.myConfigureIconPanels, iconType.toString());
            updatePreview.run();
        });
        this.myListeners.listenAndFire(this.myShowGridProperty, selected -> updatePreview.run());
        this.myListeners.listenAndFire(this.myShowSafeZoneProperty, selected -> updatePreview.run());
        this.myListeners.listenAndFire(this.myPreviewDensityProperty, value2 -> updatePreview.run());
        this.myListeners.listenAndFire(this.myOutputName, name2 -> this.checkForExistingIconFiles());
        Expression<Boolean> isAdaptiveIconOutput = Expression.create(() -> GenerateImageAssetPanel.isAdaptiveIconType((AndroidIconType)((Object)((Object)this.myOutputIconType.get()))), this.myOutputIconType);
        this.myBindings.bind(new VisibleProperty(this.myShowSafeZone), isAdaptiveIconOutput);
        Expression<Boolean> isLauncherIconOutput = Expression.create(() -> this.myOutputIconType.get() == AndroidIconType.LAUNCHER, this.myOutputIconType);
        this.myBindings.bind(new VisibleProperty(this.myShowGrid), isLauncherIconOutput);
        this.myBindings.bind(new VisibleProperty(this.myPreviewResolutionComboBox), isLauncherIconOutput);
    }

    private void updateOutputPreviewPanel() {
        this.myOutputPreviewPanel.removeAll();
        PreviewIconsPanel iconsPanel = this.myOutputPreviewPanels.get(this.myOutputIconType.get());
        for (PreviewIconsPanel.IconPreviewInfo previewInfo : iconsPanel.getIconPreviewInfos()) {
            ImagePreviewPanel previewPanel = new ImagePreviewPanel();
            previewPanel.getComponent().setName("IconPanel");
            previewPanel.setLabelText(previewInfo.getLabel());
            previewPanel.setImage(previewInfo.getImage());
            previewPanel.setImageBackground(previewInfo.getImageBackground());
            previewPanel.setImageOpaque(previewInfo.isImageOpaque());
            if (!GenerateImageAssetPanel.isAdaptiveIconType((AndroidIconType)((Object)this.myOutputIconType.get()))) {
                previewPanel.setImageBorder(previewInfo.getImageBorder());
            }
            this.myOutputPreviewPanel.add(previewPanel.getComponent());
        }
        this.myOutputPreviewPanel.revalidate();
        this.myOutputPreviewPanel.repaint();
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mySplitPane = new JSplitPane();
        this.mySplitPane.setContinuousLayout(true);
        this.mySplitPane.setDividerSize(10);
        this.mySplitPane.setEnabled(true);
        this.myRootPanel.add((Component)this.mySplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        this.mySplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myIconTypePanel = new JPanel();
        this.myIconTypePanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mySplitPane.setLeftComponent(this.myIconTypePanel);
        this.myOutputIconTypePanel = new JPanel();
        this.myOutputIconTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconTypePanel.add((Component)this.myOutputIconTypePanel, new GridConstraints(0, 0, 1, 1, 1, 1, 1, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Icon type:");
        this.myOutputIconTypePanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null, 0, false));
        this.myIconTypeCombo = new JComboBox();
        this.myOutputIconTypePanel.add(this.myIconTypeCombo, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.myConfigureIconPanels = new JPanel();
        this.myConfigureIconPanels.setLayout(new CardLayout(0, 0));
        this.myIconTypePanel.add((Component)this.myConfigureIconPanels, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 3, new Dimension(430, -1), null, null, 0, false));
        this.myPreviewPanel = new JPanel();
        this.myPreviewPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 2, 0, 0), -1, -1));
        this.mySplitPane.setRightComponent(this.myPreviewPanel);
        this.myPreviewTitlePanel = new JPanel();
        this.myPreviewTitlePanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.myPreviewPanel.add((Component)this.myPreviewTitlePanel, new GridConstraints(0, 0, 1, 1, 2, 1, 3, 0, null, null, null, 0, false));
        this.myOutputPreviewLabel = new TitledSeparator();
        this.myOutputPreviewLabel.setText("Preview");
        this.myPreviewTitlePanel.add((Component)this.myOutputPreviewLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        this.myShowGrid = new JCheckBox();
        this.myShowGrid.setText("Show grid");
        this.myPreviewTitlePanel.add((Component)this.myShowGrid, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myShowSafeZone = new JCheckBox();
        this.myShowSafeZone.setText("Show safe zone");
        this.myPreviewTitlePanel.add((Component)this.myShowSafeZone, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myPreviewResolutionComboBox = new JComboBox();
        this.myPreviewTitlePanel.add(this.myPreviewResolutionComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myPreviewContentsPanel = new JPanel();
        this.myPreviewContentsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myPreviewPanel.add((Component)this.myPreviewContentsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myOutputPreviewScrollPane = new JBScrollPane();
        this.myOutputPreviewScrollPane.setHorizontalScrollBarPolicy(30);
        this.myPreviewContentsPanel.add((Component)this.myOutputPreviewScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myOutputPreviewPanel = new CheckeredBackgroundPanel();
        this.myOutputPreviewScrollPane.setViewportView((Component)this.myOutputPreviewPanel);
        jBLabel1.setLabelFor(this.myIconTypeCombo);
    }

    private static boolean isAdaptiveIconType(@NotNull AndroidIconType iconType) {
        return iconType == AndroidIconType.LAUNCHER || iconType == AndroidIconType.TV_CHANNEL;
    }

    @NotNull
    private ConfigureIconView getActiveIconView() {
        for (ConfigureIconView view : this.myConfigureIconViews.values()) {
            if (!view.getRootComponent().isVisible()) continue;
            return view;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " is configured incorrectly. Please report this error.");
    }

    private void initializeValidators() {
        this.myValidatorPanel.registerValidator((ObservableValue)this.myOutputName, outputName -> {
            String trimmedName = outputName.trim();
            if (trimmedName.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Icon name must be set");
            }
            if (!((Boolean)this.myIconExists.isPresent().get()).booleanValue()) {
                return new Validator.Result(Validator.Severity.LOADING, "Checking for existing icons...");
            }
            if (this.myIconExists.getValueOr(false).booleanValue()) {
                return new Validator.Result(Validator.Severity.WARNING, "An icon with the same name already exists and will be overwritten.");
            }
            return Validator.Result.OK;
        }, new ObservableValue[]{this.myIconExists});
        this.myValidatorPanel.registerValidator((ObservableValue)this.myOutputName, name2 -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText(name2.trim())), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myPreviewRenderingError, errorMessage -> {
            if (!errorMessage.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, errorMessage);
            }
            return Validator.Result.OK;
        }, new ObservableValue[0]);
    }

    public void setProjectPaths(@Nullable AndroidModulePaths projectPaths) {
        this.myPaths = projectPaths != null ? projectPaths : this.myDefaultPaths;
    }

    public void setOutputName(@NotNull String name2) {
        this.getActiveIconView().outputName().set(name2);
    }

    @NotNull
    public IconGenerator getIconGenerator() {
        return this.getActiveIconView().getIconGenerator();
    }

    @NotNull
    public ObservableBool canProceed() {
        return this.hasErrors().not().and(this.myIconExists.isPresent());
    }

    @NotNull
    private ObservableBool hasErrors() {
        return this.myValidatorPanel.hasErrors();
    }

    private void checkForExistingIconFiles() {
        String currentOutputName;
        this.myIconExists.set((Boolean)((Object)Optional.empty()));
        if (this.myCheckingExistingIconFilesFuture != null && !this.myCheckingExistingIconFilesFuture.isDone()) {
            this.myCheckingExistingIconFilesFuture.cancel(true);
        }
        if ((currentOutputName = (String)this.myOutputName.get()).isEmpty()) {
            return;
        }
        this.myCheckingExistingIconFilesFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean iconExists = this.iconExists();
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                if (this.myDisposable.isDisposed()) {
                    return;
                }
                if (!currentOutputName.equals(this.myOutputName.get())) {
                    return;
                }
                this.myIconExists.set((Boolean)((Object)Optional.of(iconExists)));
            });
        });
    }

    @Slow
    @WorkerThread
    private boolean iconExists() {
        Map<File, GeneratedIcon> pathImageMap = this.getIconGenerator().generateIconPlaceholders(this.myPaths, this.myResFolder);
        for (File path : pathImageMap.keySet()) {
            if (!path.exists()) continue;
            return true;
        }
        return false;
    }

    private void renderIconPreviews() {
        GenerateImageAssetPanel.invokeVeryLate(this::enqueueGenerateNotificationIcons, ModalityState.any(), o -> Disposer.isDisposed((Disposable)this));
    }

    private void enqueueGenerateNotificationIcons() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidIconType iconType = (AndroidIconType)((Object)this.myOutputIconType.get());
        IconGenerator iconGenerator = this.getActiveIconView().getIconGenerator();
        this.myIconGenerationProcessor.enqueue(iconGenerator, iconGeneratorResult -> {
            if (iconGeneratorResult == null) {
                return;
            }
            this.myLoadingPanel.stopLoading();
            this.myOutputPreviewPanels.get((Object)iconType).showPreviewImages((IconGeneratorResult)iconGeneratorResult);
            if (Objects.equals((Object)iconType, this.myOutputIconType.get())) {
                this.updateOutputPreviewPanel();
                Collection<String> errors = iconGeneratorResult.getErrors();
                String errorMessage = errors.isEmpty() ? "" : (errors.size() == 1 ? (String)Iterables.getOnlyElement(errors) : "Icon preview was rendered with errors");
                this.myPreviewRenderingError.set(errorMessage);
            }
        });
    }

    private static void invokeVeryLate(@NotNull Runnable runnable2, @NotNull ModalityState state2, @NotNull Condition<?> expired) {
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> application.invokeLater(runnable2, state2, expired), state2, expired);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state2 = new PersistentState();
        state2.set(OUTPUT_ICON_TYPE_PROPERTY, (AndroidIconType)((Object)this.myOutputIconType.get()), AndroidIconType.LAUNCHER);
        for (Map.Entry<AndroidIconType, ConfigureIconView> entry : this.myConfigureIconViews.entrySet()) {
            state2.setChild(AssetStudioUtils.toLowerCamelCase(entry.getKey()), (PersistentState)entry.getValue().getState());
        }
        return state2;
    }

    public void loadState(@NotNull PersistentState state2) {
        this.myOutputIconType.set(state2.get(OUTPUT_ICON_TYPE_PROPERTY, AndroidIconType.LAUNCHER));
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Map.Entry<AndroidIconType, ConfigureIconView> entry : this.myConfigureIconViews.entrySet()) {
                PersistentStateUtil.load((PersistentStateComponent<PersistentState>)((PersistentStateComponent)entry.getValue()), state2.getChild(AssetStudioUtils.toLowerCamelCase(entry.getKey())));
            }
        }, ModalityState.any());
    }

    private static class LauncherLegacyIconsPreviewPanel
    extends PreviewIconsPanel {
        LauncherLegacyIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }

        @Override
        public void showPreviewImages(@NotNull IconGeneratorResult iconGeneratorResult) {
            Collection<GeneratedIcon> generatedIcons = iconGeneratorResult.getIcons();
            List<Pair<String, BufferedImage>> list2 = generatedIcons.stream().filter(icon -> icon instanceof GeneratedImageIcon).map(icon -> (GeneratedImageIcon)icon).filter(icon -> icon.getDensity() != Density.NODPI).sorted(Comparator.comparingInt(icon -> -icon.getDensity().getDpiValue())).map(icon -> Pair.of((Object)icon.getDensity().getResourceValue(), (Object)icon.getImage())).collect(Collectors.toList());
            this.showPreviewImagesImpl(list2);
        }
    }

    private static class ActionBarIconsPreviewPanel
    extends PreviewIconsPanel {
        ActionBarIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }
    }

    private static class NotificationIconsPreviewPanel
    extends PreviewIconsPanel {
        NotificationIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.DARK);
        }
    }
}

